/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.apt;

import com.querydsl.apt.Configuration;
import com.querydsl.apt.VisitorConfig;
import com.querydsl.codegen.CodegenModule;
import com.querydsl.codegen.DefaultVariableNameFunction;
import com.querydsl.codegen.EmbeddableSerializer;
import com.querydsl.codegen.EntitySerializer;
import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.Filer;
import com.querydsl.codegen.GeneratedAnnotationResolver;
import com.querydsl.codegen.ProjectionSerializer;
import com.querydsl.codegen.QueryTypeFactory;
import com.querydsl.codegen.Serializer;
import com.querydsl.codegen.SerializerConfig;
import com.querydsl.codegen.SimpleSerializerConfig;
import com.querydsl.codegen.SupertypeSerializer;
import com.querydsl.codegen.TypeMappings;
import com.querydsl.codegen.utils.model.ClassType;
import com.querydsl.codegen.utils.model.Type;
import com.querydsl.core.annotations.Config;
import com.querydsl.core.annotations.QueryProjection;
import com.querydsl.core.annotations.QueryType;
import com.querydsl.core.types.Expression;
import com.querydsl.core.util.Annotations;
import com.querydsl.core.util.StringUtils;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultConfiguration
implements Configuration {
    private boolean unknownAsEmbedded;
    private final CodegenModule module;
    private final SerializerConfig defaultSerializerConfig;
    private final Map<String, SerializerConfig> packageToConfig = new HashMap<String, SerializerConfig>();
    protected final Class<? extends Annotation> entityAnn;
    @NotNull
    private final Set<String> excludedPackages;
    @NotNull
    private final Set<String> excludedClasses;
    @NotNull
    private final Set<String> includedPackages;
    @NotNull
    private final Set<String> includedClasses;
    @Nullable
    protected final Class<? extends Annotation> entitiesAnn;
    @Nullable
    protected final Class<? extends Annotation> superTypeAnn;
    @Nullable
    protected final Class<? extends Annotation> embeddedAnn;
    @Nullable
    protected final Class<? extends Annotation> embeddableAnn;
    @Nullable
    protected final Class<? extends Annotation> skipAnn;
    @Nullable
    protected Class<? extends Annotation> altEntityAnn;
    private final Set<Class<? extends Annotation>> entityAnnotations = new HashSet<Class<? extends Annotation>>();
    private final Map<String, SerializerConfig> typeToConfig = new HashMap<String, SerializerConfig>();
    private boolean useFields = true;
    private boolean useGetters = true;
    private boolean strictMode;
    private Function<EntityType, String> variableNameFunction;

    public DefaultConfiguration(ProcessingEnvironment processingEnvironment, RoundEnvironment roundEnv, Collection<String> keywords, @Nullable Class<? extends Annotation> entitiesAnn, Class<? extends Annotation> entityAnn, @Nullable Class<? extends Annotation> superTypeAnn, @Nullable Class<? extends Annotation> embeddableAnn, @Nullable Class<? extends Annotation> embeddedAnn, @Nullable Class<? extends Annotation> skipAnn) {
        this(processingEnvironment, roundEnv, processingEnvironment.getOptions(), keywords, entitiesAnn, entityAnn, superTypeAnn, embeddableAnn, embeddedAnn, skipAnn, new CodegenModule());
    }

    @Deprecated
    public DefaultConfiguration(RoundEnvironment roundEnv, Map<String, String> options, Collection<String> keywords, @Nullable Class<? extends Annotation> entitiesAnn, Class<? extends Annotation> entityAnn, @Nullable Class<? extends Annotation> superTypeAnn, @Nullable Class<? extends Annotation> embeddableAnn, @Nullable Class<? extends Annotation> embeddedAnn, @Nullable Class<? extends Annotation> skipAnn) {
        this(null, roundEnv, options, keywords, entitiesAnn, entityAnn, superTypeAnn, embeddableAnn, embeddedAnn, skipAnn, new CodegenModule());
    }

    @Deprecated
    public DefaultConfiguration(ProcessingEnvironment processingEnvironment, RoundEnvironment roundEnv, Collection<String> keywords, @Nullable Class<? extends Annotation> entitiesAnn, Class<? extends Annotation> entityAnn, @Nullable Class<? extends Annotation> superTypeAnn, @Nullable Class<? extends Annotation> embeddableAnn, @Nullable Class<? extends Annotation> embeddedAnn, @Nullable Class<? extends Annotation> skipAnn, CodegenModule codegenModule) {
        this(processingEnvironment, roundEnv, processingEnvironment.getOptions(), keywords, entitiesAnn, entityAnn, superTypeAnn, embeddableAnn, embeddedAnn, skipAnn, codegenModule);
    }

    public DefaultConfiguration(ProcessingEnvironment processingEnvironment, RoundEnvironment roundEnv, Map<String, String> options, Collection<String> keywords, @Nullable Class<? extends Annotation> entitiesAnn, Class<? extends Annotation> entityAnn, @Nullable Class<? extends Annotation> superTypeAnn, @Nullable Class<? extends Annotation> embeddableAnn, @Nullable Class<? extends Annotation> embeddedAnn, @Nullable Class<? extends Annotation> skipAnn, CodegenModule codegenModule) {
        List<String> classes;
        String classString;
        List<String> packages;
        String packageString;
        boolean bl;
        this.excludedClasses = new HashSet<String>();
        this.excludedPackages = new HashSet<String>();
        this.includedClasses = new HashSet<String>();
        this.includedPackages = new HashSet<String>();
        this.module = codegenModule;
        this.module.bind(ProcessingEnvironment.class, (Object)processingEnvironment);
        this.module.bind(RoundEnvironment.class, (Object)roundEnv);
        this.module.bind("keywords", keywords);
        this.entitiesAnn = entitiesAnn;
        this.entityAnn = entityAnn;
        this.superTypeAnn = superTypeAnn;
        this.embeddableAnn = embeddableAnn;
        this.embeddedAnn = embeddedAnn;
        this.skipAnn = skipAnn;
        this.entityAnnotations.add(entityAnn);
        if (superTypeAnn != null) {
            this.entityAnnotations.add(superTypeAnn);
        }
        if (embeddableAnn != null) {
            this.entityAnnotations.add(embeddableAnn);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Config.class)) {
            Config querydslConfig = element.getAnnotation(Config.class);
            SerializerConfig config = SimpleSerializerConfig.getConfig((Config)querydslConfig);
            if (element instanceof PackageElement) {
                PackageElement packageElement = (PackageElement)element;
                this.packageToConfig.put(packageElement.getQualifiedName().toString(), config);
                continue;
            }
            if (!(element instanceof TypeElement)) continue;
            TypeElement typeElement = (TypeElement)element;
            this.typeToConfig.put(typeElement.getQualifiedName().toString(), config);
        }
        boolean entityAccessors = false;
        boolean bl2 = false;
        boolean mapAccessors = false;
        boolean createDefaultVariable = true;
        if (options.containsKey("querydsl.entityAccessors")) {
            entityAccessors = Boolean.parseBoolean(options.get("querydsl.entityAccessors"));
        }
        if (options.containsKey("querydsl.listAccessors")) {
            bl = Boolean.parseBoolean(options.get("querydsl.listAccessors"));
        }
        if (options.containsKey("querydsl.mapAccessors")) {
            mapAccessors = Boolean.parseBoolean(options.get("querydsl.mapAccessors"));
        }
        if (options.containsKey("querydsl.createDefaultVariable")) {
            createDefaultVariable = Boolean.parseBoolean(options.get("querydsl.createDefaultVariable"));
        }
        if (options.containsKey("querydsl.packageSuffix")) {
            this.module.bind("packageSuffix", (Object)StringUtils.nullToEmpty((String)options.get("querydsl.packageSuffix")));
        }
        if (options.containsKey("querydsl.prefix")) {
            this.module.bind("prefix", (Object)StringUtils.nullToEmpty((String)options.get("querydsl.prefix")));
        }
        if (options.containsKey("querydsl.suffix")) {
            this.module.bind("suffix", (Object)StringUtils.nullToEmpty((String)options.get("querydsl.suffix")));
        }
        if (options.containsKey("querydsl.unknownAsEmbeddable")) {
            this.unknownAsEmbedded = Boolean.parseBoolean(options.get("querydsl.unknownAsEmbeddable"));
        }
        if (options.containsKey("querydsl.excludedPackages") && !StringUtils.isNullOrEmpty((String)(packageString = options.get("querydsl.excludedPackages")))) {
            packages = Arrays.asList(packageString.split(","));
            this.excludedPackages.addAll(packages);
        }
        if (options.containsKey("querydsl.excludedClasses") && !StringUtils.isNullOrEmpty((String)(classString = options.get("querydsl.excludedClasses")))) {
            classes = Arrays.asList(classString.split(","));
            this.excludedClasses.addAll(classes);
        }
        if (options.containsKey("querydsl.includedPackages") && !StringUtils.isNullOrEmpty((String)(packageString = options.get("querydsl.includedPackages")))) {
            packages = Arrays.asList(packageString.split(","));
            this.includedPackages.addAll(packages);
        }
        if (options.containsKey("querydsl.includedClasses") && !StringUtils.isNullOrEmpty((String)(classString = options.get("querydsl.includedClasses")))) {
            classes = Arrays.asList(classString.split(","));
            this.includedClasses.addAll(classes);
        }
        if (options.containsKey("querydsl.useFields")) {
            this.useFields = Boolean.parseBoolean(options.get("querydsl.useFields"));
        }
        if (options.containsKey("querydsl.useGetters")) {
            this.useGetters = Boolean.parseBoolean(options.get("querydsl.useGetters"));
        }
        if (options.containsKey("querydsl.variableNameFunctionClass")) {
            try {
                Class<?> variableNameFunctionClass = Class.forName(options.get("querydsl.variableNameFunctionClass"));
                this.variableNameFunction = (Function)variableNameFunctionClass.newInstance();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                this.variableNameFunction = DefaultVariableNameFunction.INSTANCE;
            }
        } else {
            this.variableNameFunction = DefaultVariableNameFunction.INSTANCE;
        }
        this.module.bind("variableNameFunction", this.variableNameFunction);
        this.module.loadExtensions();
        Class generatedAnnotationClass = GeneratedAnnotationResolver.resolve((String)options.get("querydsl.generatedAnnotationClass"));
        this.module.bindInstance("generatedAnnotationClass", generatedAnnotationClass);
        this.defaultSerializerConfig = new SimpleSerializerConfig(entityAccessors, bl, mapAccessors, createDefaultVariable, "");
    }

    @Override
    public void addExcludedClass(String className) {
        this.excludedClasses.add(className);
    }

    @Override
    public void addExcludedPackage(String packageName) {
        this.excludedPackages.add(packageName);
    }

    @Override
    public VisitorConfig getConfig(TypeElement e, List<? extends Element> elements) {
        if (this.useFields) {
            if (this.useGetters) {
                return VisitorConfig.ALL;
            }
            return VisitorConfig.FIELDS_ONLY;
        }
        if (this.useGetters) {
            return VisitorConfig.METHODS_ONLY;
        }
        return VisitorConfig.NONE;
    }

    @Override
    public Serializer getDTOSerializer() {
        return (Serializer)this.module.get(ProjectionSerializer.class);
    }

    @Override
    @Nullable
    public Class<? extends Annotation> getEntitiesAnnotation() {
        return this.entitiesAnn;
    }

    @Override
    @Nullable
    public Class<? extends Annotation> getEmbeddableAnnotation() {
        return this.embeddableAnn;
    }

    @Override
    public Serializer getEmbeddableSerializer() {
        return (Serializer)this.module.get(EmbeddableSerializer.class);
    }

    @Override
    public Class<? extends Annotation> getEntityAnnotation() {
        return this.entityAnn;
    }

    @Override
    public Class<? extends Annotation> getAlternativeEntityAnnotation() {
        return this.altEntityAnn;
    }

    public void setAlternativeEntityAnnotation(Class<? extends Annotation> ann) {
        this.altEntityAnn = ann;
        this.entityAnnotations.add(ann);
    }

    @Override
    @Nullable
    public Class<? extends Annotation> getEmbeddedAnnotation() {
        return this.embeddedAnn;
    }

    @Override
    public Set<Class<? extends Annotation>> getEntityAnnotations() {
        return this.entityAnnotations;
    }

    @Override
    public Serializer getEntitySerializer() {
        return (Serializer)this.module.get(EntitySerializer.class);
    }

    @Override
    public String getNamePrefix() {
        return (String)this.module.get(String.class, "prefix");
    }

    @Override
    public SerializerConfig getSerializerConfig(EntityType entityType) {
        if (this.typeToConfig.containsKey(entityType.getFullName())) {
            return this.typeToConfig.get(entityType.getFullName());
        }
        return this.packageToConfig.getOrDefault(entityType.getPackageName(), this.defaultSerializerConfig);
    }

    @Override
    @Nullable
    public Class<? extends Annotation> getSkipAnnotation() {
        return this.skipAnn;
    }

    @Override
    @Nullable
    public Class<? extends Annotation> getSuperTypeAnnotation() {
        return this.superTypeAnn;
    }

    @Override
    public Serializer getSupertypeSerializer() {
        return (Serializer)this.module.get(SupertypeSerializer.class);
    }

    @Override
    public void inspect(Element element, Annotations annotations) {
    }

    @Override
    public boolean isBlockedField(VariableElement field) {
        if (field.getAnnotation(QueryType.class) != null) {
            return false;
        }
        return field.getAnnotation(this.skipAnn) != null || field.getModifiers().contains((Object)Modifier.TRANSIENT) || field.getModifiers().contains((Object)Modifier.STATIC);
    }

    @Override
    public boolean isBlockedGetter(ExecutableElement getter) {
        if (getter.getAnnotation(QueryType.class) != null) {
            return false;
        }
        return getter.getAnnotation(this.skipAnn) != null || getter.getModifiers().contains((Object)Modifier.STATIC);
    }

    @Override
    public boolean isUseFields() {
        return this.useFields;
    }

    @Override
    public boolean isUseGetters() {
        return this.useGetters;
    }

    @Override
    public boolean isValidConstructor(ExecutableElement constructor) {
        return constructor.getModifiers().contains((Object)Modifier.PUBLIC) && constructor.getAnnotation(QueryProjection.class) != null && !constructor.getParameters().isEmpty();
    }

    @Override
    public boolean isValidField(VariableElement field) {
        if (field.getAnnotation(QueryType.class) != null) {
            return true;
        }
        return field.getAnnotation(this.skipAnn) == null && !field.getModifiers().contains((Object)Modifier.TRANSIENT) && !field.getModifiers().contains((Object)Modifier.STATIC);
    }

    @Override
    public boolean isValidGetter(ExecutableElement getter) {
        if (getter.getAnnotation(QueryType.class) != null) {
            return true;
        }
        return getter.getAnnotation(this.skipAnn) == null && !getter.getModifiers().contains((Object)Modifier.STATIC);
    }

    public void setNamePrefix(String namePrefix) {
        this.module.bind("prefix", (Object)namePrefix);
    }

    public void setUseFields(boolean b) {
        this.useFields = b;
    }

    public void setUseGetters(boolean b) {
        this.useGetters = b;
    }

    @Override
    public TypeMappings getTypeMappings() {
        return (TypeMappings)this.module.get(TypeMappings.class);
    }

    @Override
    public Collection<String> getKeywords() {
        return (Collection)this.module.get(Collection.class, "keywords");
    }

    @Override
    public String getNameSuffix() {
        return (String)this.module.get(String.class, "suffix");
    }

    public void setNameSuffix(String nameSuffix) {
        this.module.bind("suffix", (Object)nameSuffix);
    }

    public <T> void addCustomType(Class<T> type, Class<? extends Expression<T>> queryType) {
        ((TypeMappings)this.module.get(TypeMappings.class)).register((Type)new ClassType(type, new Type[0]), (Type)new ClassType(queryType, new Type[0]));
    }

    @Override
    public QueryTypeFactory getQueryTypeFactory() {
        return (QueryTypeFactory)this.module.get(QueryTypeFactory.class);
    }

    @Override
    public boolean isExcludedPackage(@NotNull String packageName) {
        if (!this.includedPackages.isEmpty()) {
            boolean included = false;
            for (String includedPackage : this.includedPackages) {
                if (!packageName.startsWith(includedPackage)) continue;
                included = true;
                break;
            }
            if (!included) {
                return true;
            }
        }
        if (!this.excludedPackages.isEmpty()) {
            for (String excludedPackage : this.excludedPackages) {
                if (!packageName.startsWith(excludedPackage)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isExcludedClass(@NotNull String className) {
        if (!this.includedClasses.isEmpty() && !this.includedClasses.contains(className)) {
            return true;
        }
        return this.excludedClasses.contains(className);
    }

    @Override
    public TypeMirror getRealType(ExecutableElement method) {
        return null;
    }

    @Override
    public TypeMirror getRealType(VariableElement field) {
        return null;
    }

    @Override
    public boolean isUnknownAsEmbedded() {
        return this.unknownAsEmbedded;
    }

    @Override
    public boolean isStrictMode() {
        return this.strictMode;
    }

    public void setStrictMode(boolean s) {
        this.strictMode = s;
    }

    public void setUnknownAsEmbedded(boolean unknownAsEmbedded) {
        this.unknownAsEmbedded = unknownAsEmbedded;
    }

    @Override
    public Function<EntityType, String> getVariableNameFunction() {
        return this.variableNameFunction;
    }

    @Override
    public Filer getFiler() {
        return (Filer)this.module.get(Filer.class);
    }
}

