/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.parser;

import com.orientechnologies.common.parser.OStringParser;
import java.util.Arrays;

public abstract class OBaseParser {
    public String parserText;
    public String parserTextUpperCase;
    private transient StringBuilder parserLastWord = new StringBuilder();
    private transient int parserCurrentPos = 0;
    private transient int parserPreviousPos = 0;
    private transient char parserLastSeparator = (char)32;

    protected abstract void throwSyntaxErrorException(String var1);

    public String getSyntax() {
        return "?";
    }

    protected String parserOptionalWord(boolean iUpperCase) {
        this.parserPreviousPos = this.parserCurrentPos;
        this.parserNextWord(iUpperCase);
        if (this.parserLastWord.length() == 0) {
            return null;
        }
        return this.parserLastWord.toString();
    }

    protected String parseOptionalWord(boolean iUpperCase, String ... iWords) {
        this.parserNextWord(iUpperCase);
        if (iWords.length > 0) {
            if (this.parserLastWord.length() == 0) {
                return null;
            }
            boolean found = false;
            for (String w : iWords) {
                if (!this.parserLastWord.toString().equals(w)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.throwSyntaxErrorException("Found unexpected keyword '" + this.parserLastWord + "' while it was expected '" + Arrays.toString(iWords) + "'");
            }
        }
        return this.parserLastWord.toString();
    }

    protected int parserGoBack() {
        this.parserCurrentPos = this.parserPreviousPos;
        return this.parserCurrentPos;
    }

    protected String parserRequiredWord(boolean iUpperCase) {
        return this.parserRequiredWord(iUpperCase, "Syntax error", null);
    }

    protected String parserRequiredWord(boolean iUpperCase, String iCustomMessage) {
        return this.parserRequiredWord(iUpperCase, iCustomMessage, null);
    }

    protected String parserRequiredWord(boolean iUpperCase, String iCustomMessage, String iSeparators) {
        if (iSeparators == null) {
            iSeparators = " ()=><,\r\n";
        }
        this.parserNextWord(iUpperCase, iSeparators);
        if (this.parserLastWord.length() == 0) {
            this.throwSyntaxErrorException(iCustomMessage);
        }
        return this.parserLastWord.toString();
    }

    protected void parserRequiredKeyword(String ... iWords) {
        this.parserNextWord(true, " \r\n,()");
        if (this.parserLastWord.length() == 0) {
            this.throwSyntaxErrorException("Cannot find expected keyword '" + Arrays.toString(iWords) + "'");
        }
        boolean found = false;
        for (String w : iWords) {
            if (!this.parserLastWord.toString().equals(w)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.throwSyntaxErrorException("Found unexpected keyword '" + this.parserLastWord + "' while it was expected '" + Arrays.toString(iWords) + "'");
        }
    }

    protected int parserNextChars(boolean iUpperCase, boolean iMandatory, String ... iCandidateWords) {
        this.parserPreviousPos = this.parserCurrentPos;
        this.parserSkipWhiteSpaces();
        this.parserLastWord.setLength(0);
        String[] processedWords = Arrays.copyOf(iCandidateWords, iCandidateWords.length);
        String text2Use = iUpperCase ? this.parserTextUpperCase : this.parserText;
        int max = text2Use.length();
        int i = 0;
        while (this.parserCurrentPos <= max) {
            String w;
            boolean separator;
            char ch = this.parserCurrentPos < max ? (char)text2Use.charAt(this.parserCurrentPos) : (char)'\n';
            boolean bl = separator = ch == ' ' || ch == '\r' || ch == '\n' || ch == '\t' || ch == '(';
            if (!separator) {
                this.parserLastWord.append(ch);
            }
            int candidatesWordsCount = 0;
            int candidatesWordsPos = -1;
            for (int c = 0; c < processedWords.length; ++c) {
                String w2 = processedWords[c];
                if (w2 == null) continue;
                int wordSize = w2.length();
                if (separator && wordSize > i || !separator && (i > wordSize - 1 || w2.charAt(i) != ch)) {
                    processedWords[c] = null;
                    continue;
                }
                if (++candidatesWordsCount != 1) continue;
                candidatesWordsPos = c;
            }
            if (candidatesWordsCount == 1 && (w = processedWords[candidatesWordsPos]).length() == i + (separator ? 0 : 1) && !Character.isLetter(ch)) {
                return candidatesWordsPos;
            }
            if (candidatesWordsCount == 0 || separator) break;
            ++this.parserCurrentPos;
            ++i;
        }
        if (iMandatory) {
            this.throwSyntaxErrorException("Found unexpected keyword '" + this.parserLastWord + "' while it was expected '" + Arrays.toString(iCandidateWords) + "'");
        }
        return -1;
    }

    protected boolean parserOptionalKeyword(String ... iWords) {
        this.parserNextWord(true, " \r\n,");
        if (this.parserLastWord.length() == 0) {
            return false;
        }
        boolean found = iWords.length == 0;
        for (String w : iWords) {
            if (!this.parserLastWord.toString().equals(w)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.throwSyntaxErrorException("Found unexpected keyword '" + this.parserLastWord + "' while it was expected '" + Arrays.toString(iWords) + "'");
        }
        return true;
    }

    protected boolean parserSkipWhiteSpaces() {
        if (this.parserCurrentPos == -1) {
            return false;
        }
        this.parserCurrentPos = OStringParser.jumpWhiteSpaces(this.parserText, this.parserCurrentPos, -1);
        return this.parserCurrentPos > -1;
    }

    protected boolean parserSetCurrentPosition(int iPosition) {
        this.parserCurrentPos = iPosition;
        if (this.parserCurrentPos >= this.parserText.length()) {
            this.parserCurrentPos = -1;
        }
        return this.parserCurrentPos > -1;
    }

    protected void parserSetEndOfText() {
        this.parserCurrentPos = -1;
    }

    protected boolean parserMoveCurrentPosition(int iOffset) {
        if (this.parserCurrentPos < 0) {
            return false;
        }
        return this.parserSetCurrentPosition(this.parserCurrentPos + iOffset);
    }

    protected void parserNextWord(boolean iForceUpperCase) {
        this.parserNextWord(iForceUpperCase, " =><(),\r\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parserNextWord(boolean iForceUpperCase, String iSeparatorChars) {
        String text2Use;
        this.parserPreviousPos = this.parserCurrentPos;
        this.parserLastWord.setLength(0);
        this.parserSkipWhiteSpaces();
        if (this.parserCurrentPos == -1) {
            return;
        }
        char stringBeginChar = ' ';
        String string = text2Use = iForceUpperCase ? this.parserTextUpperCase : this.parserText;
        while (this.parserCurrentPos < text2Use.length()) {
            char c = text2Use.charAt(this.parserCurrentPos);
            boolean found = false;
            for (int sepIndex = 0; sepIndex < iSeparatorChars.length(); ++sepIndex) {
                if (iSeparatorChars.charAt(sepIndex) != c) continue;
                found = true;
                break;
            }
            if (!found) break;
            ++this.parserCurrentPos;
        }
        try {
            int openParenthesis = 0;
            int openBraket = 0;
            int openGraph = 0;
            boolean escape = false;
            while (this.parserCurrentPos < text2Use.length()) {
                char c = text2Use.charAt(this.parserCurrentPos);
                if (!escape && c == '\\' && this.parserCurrentPos + 1 < text2Use.length()) {
                    char nextChar = text2Use.charAt(this.parserCurrentPos + 1);
                    if (nextChar == 'u') {
                        this.parserCurrentPos = OStringParser.readUnicode(text2Use, this.parserCurrentPos + 2, this.parserLastWord);
                    } else {
                        this.parserLastWord.append(c);
                        this.parserLastWord.append(nextChar);
                        ++this.parserCurrentPos;
                    }
                } else {
                    if (!(openBraket != 0 || openGraph != 0 || openParenthesis != 0 || escape || c != '\'' && c != '\"')) {
                        if (stringBeginChar != ' ') {
                            if (stringBeginChar == c) {
                                stringBeginChar = ' ';
                                this.parserLastWord.append(c);
                                ++this.parserCurrentPos;
                                break;
                            }
                        } else {
                            stringBeginChar = c;
                        }
                    } else if (stringBeginChar == ' ') {
                        if (openBraket == 0 && openGraph == 0 && openParenthesis == 0 && this.parserCheckSeparator(c, iSeparatorChars)) {
                            break;
                        }
                        if (c == '(') {
                            ++openParenthesis;
                        } else if (c == ')' && openParenthesis > 0) {
                            --openParenthesis;
                        } else if (c == '[') {
                            ++openBraket;
                        } else if (c == ']' && openBraket > 0) {
                            --openBraket;
                        } else if (c == '{') {
                            ++openGraph;
                        } else if (c == '}' && openGraph > 0) {
                            --openGraph;
                        }
                    }
                    this.parserLastWord.append(c);
                    if (escape) {
                        escape = false;
                    }
                }
                ++this.parserCurrentPos;
            }
        }
        finally {
            if (this.parserCurrentPos >= text2Use.length()) {
                this.parserCurrentPos = -1;
                this.parserLastSeparator = (char)32;
            }
        }
    }

    private boolean parserCheckSeparator(char c, String iSeparatorChars) {
        for (int sepIndex = 0; sepIndex < iSeparatorChars.length(); ++sepIndex) {
            if (iSeparatorChars.charAt(sepIndex) != c) continue;
            this.parserLastSeparator = c;
            return true;
        }
        return false;
    }

    public char parserGetLastSeparator() {
        return this.parserLastSeparator;
    }

    public void parserSetLastSeparator(char iSeparator) {
        this.parserLastSeparator = iSeparator;
    }

    public int parserGetPreviousPosition() {
        return this.parserPreviousPos;
    }

    public boolean parserIsEnded() {
        return this.parserCurrentPos == -1;
    }

    public int parserGetCurrentPosition() {
        return this.parserCurrentPos;
    }

    public char parserGetCurrentChar() {
        if (this.parserCurrentPos < 0) {
            return ' ';
        }
        return this.parserText.charAt(this.parserCurrentPos);
    }

    public String parserGetLastWord() {
        return this.parserLastWord.toString();
    }

    public static int nextWord(String iText, String iTextUpperCase, int ioCurrentPosition, StringBuilder ioWord, boolean iForceUpperCase) {
        return OBaseParser.nextWord(iText, iTextUpperCase, ioCurrentPosition, ioWord, iForceUpperCase, " =><(),");
    }

    public static int nextWord(String iText, String iTextUpperCase, int ioCurrentPosition, StringBuilder ioWord, boolean iForceUpperCase, String iSeparatorChars) {
        ioWord.setLength(0);
        ioCurrentPosition = OStringParser.jumpWhiteSpaces(iText, ioCurrentPosition, -1);
        if (ioCurrentPosition < 0) {
            return -1;
        }
        OBaseParser.getWordStatic(iForceUpperCase ? iTextUpperCase : iText, ioCurrentPosition, iSeparatorChars, ioWord);
        if (ioWord.length() > 0) {
            ioCurrentPosition += ioWord.length();
        }
        return ioCurrentPosition;
    }

    public static void getWordStatic(CharSequence iText, int iBeginIndex, String iSeparatorChars, StringBuilder ioBuffer) {
        char c;
        int i;
        ioBuffer.setLength(0);
        char stringBeginChar = ' ';
        for (i = iBeginIndex; i < iText.length(); ++i) {
            c = iText.charAt(i);
            boolean found = false;
            for (int sepIndex = 0; sepIndex < iSeparatorChars.length(); ++sepIndex) {
                if (iSeparatorChars.charAt(sepIndex) != c) continue;
                found = true;
                break;
            }
            if (!found) break;
            ++iBeginIndex;
        }
        for (i = iBeginIndex; i < iText.length(); ++i) {
            c = iText.charAt(i);
            if (c == '\'' || c == '\"') {
                if (stringBeginChar != ' ') {
                    if (stringBeginChar == c) {
                        stringBeginChar = ' ';
                    }
                } else {
                    stringBeginChar = c;
                }
            } else if (stringBeginChar == ' ') {
                for (int sepIndex = 0; sepIndex < iSeparatorChars.length(); ++sepIndex) {
                    if (iSeparatorChars.charAt(sepIndex) != c || ioBuffer.length() <= 0) continue;
                    return;
                }
            }
            ioBuffer.append(c);
        }
    }
}

