/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.directmemory.collections;

import com.orientechnologies.common.directmemory.ODirectMemory;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OBinaryTypeSerializer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ODirectMemoryHashMapBucket<K, V>
implements Iterable<Entry> {
    private final long[] hashCodes;
    private final long[] keyValuePairs;
    private ODirectMemoryHashMapBucket<K, V> nextBucket;
    private final ODirectMemory directMemory;
    private final OBinarySerializer<V> valueSerializer;
    private final int bucketSize;
    private int size;

    public ODirectMemoryHashMapBucket(ODirectMemory directMemory, int bucketSize, OBinarySerializer<V> valueSerializer) {
        this.directMemory = directMemory;
        this.valueSerializer = valueSerializer;
        this.bucketSize = bucketSize;
        this.hashCodes = new long[bucketSize];
        this.keyValuePairs = new long[bucketSize * 2];
    }

    public boolean put(byte[] serializedKey, long hashCode, V value) {
        FindResult<K, V> findResult = this.doFind(serializedKey, hashCode);
        if (findResult == null) {
            int keySize = OBinaryTypeSerializer.INSTANCE.getObjectSize(serializedKey);
            long keyPointer = this.directMemory.allocate(keySize);
            if (keyPointer == 0L) {
                throw new OutOfMemoryError("There is not enough memory to allocate");
            }
            OBinaryTypeSerializer.INSTANCE.serializeInDirectMemory(serializedKey, this.directMemory, keyPointer);
            int serializedValueSize = this.valueSerializer.getObjectSize(value);
            long valuePointer = this.directMemory.allocate(serializedValueSize);
            if (valuePointer == 0L) {
                this.directMemory.free(keyPointer);
                throw new OutOfMemoryError("There is not enough memory to allocate");
            }
            this.valueSerializer.serializeInDirectMemory(value, this.directMemory, valuePointer);
            if (this.size < this.bucketSize) {
                this.hashCodes[this.size] = hashCode;
                int index = this.size * 2;
                this.keyValuePairs[index++] = keyPointer;
                this.keyValuePairs[index] = valuePointer;
                ++this.size;
            } else {
                if (this.nextBucket == null) {
                    this.nextBucket = new ODirectMemoryHashMapBucket<K, V>(this.directMemory, this.bucketSize, this.valueSerializer);
                }
                super.add(keyPointer, hashCode, valuePointer);
            }
            return true;
        }
        int serializedValueSize = this.valueSerializer.getObjectSize(value);
        long newValuePointer = this.directMemory.allocate(serializedValueSize);
        if (newValuePointer == 0L) {
            throw new OutOfMemoryError("There is not enough memory to allocate");
        }
        this.directMemory.set(newValuePointer, value, this.valueSerializer);
        long[] foundKeyValuePairs = ((FindResult)findResult).foundBucket.keyValuePairs;
        int valueIndex = 2 * ((FindResult)findResult).foundIndex + 1;
        long oldValuePointer = foundKeyValuePairs[valueIndex];
        this.directMemory.free(oldValuePointer);
        foundKeyValuePairs[valueIndex] = newValuePointer;
        return false;
    }

    private void add(long keyPointer, long hashCode, long valuePointer) {
        if (this.size < this.bucketSize) {
            this.hashCodes[this.size] = hashCode;
            int index = this.size * 2;
            this.keyValuePairs[index++] = keyPointer;
            this.keyValuePairs[index] = valuePointer;
            ++this.size;
        } else {
            if (this.nextBucket == null) {
                this.nextBucket = new ODirectMemoryHashMapBucket<K, V>(this.directMemory, this.bucketSize, this.valueSerializer);
            }
            super.add(keyPointer, hashCode, valuePointer);
        }
    }

    public void add(byte[] serializedKey, long hashCode, byte[] serializedValue) {
        int keySize = OBinaryTypeSerializer.INSTANCE.getObjectSize(serializedKey);
        long keyPointer = this.directMemory.allocate(keySize);
        if (keyPointer == 0L) {
            throw new OutOfMemoryError("There is not enough memory to allocate");
        }
        OBinaryTypeSerializer.INSTANCE.serializeInDirectMemory(serializedKey, this.directMemory, keyPointer);
        long valuePointer = this.directMemory.allocate(serializedValue);
        if (valuePointer == 0L) {
            this.directMemory.free(keyPointer);
            throw new OutOfMemoryError("There is not enough memory to allocate");
        }
        if (this.size < this.bucketSize) {
            this.hashCodes[this.size] = hashCode;
            int index = this.size * 2;
            this.keyValuePairs[index++] = keyPointer;
            this.keyValuePairs[index] = valuePointer;
            ++this.size;
        } else {
            if (this.nextBucket == null) {
                this.nextBucket = new ODirectMemoryHashMapBucket<K, V>(this.directMemory, this.bucketSize, this.valueSerializer);
            }
            this.nextBucket.add(serializedKey, hashCode, serializedValue);
        }
    }

    public V find(byte[] serializedKey, long hashCode) {
        FindResult<K, V> findResult = this.doFind(serializedKey, hashCode);
        if (findResult == null) {
            return null;
        }
        long valuePointer = ((FindResult)findResult).foundBucket.keyValuePairs[((FindResult)findResult).foundIndex * 2 + 1];
        return this.directMemory.get(valuePointer, this.valueSerializer);
    }

    private FindResult<K, V> doFind(byte[] serializedKey, long hashCode) {
        ODirectMemoryHashMapBucket<K, V> currentBucket = this;
        while (currentBucket != null) {
            for (int i = 0; i < currentBucket.size; ++i) {
                long keyPointer;
                byte[] storedKey;
                if (currentBucket.hashCodes[i] != hashCode || !Arrays.equals(serializedKey, storedKey = this.directMemory.get(keyPointer = currentBucket.keyValuePairs[i * 2], OBinaryTypeSerializer.INSTANCE))) continue;
                return new FindResult(currentBucket, i);
            }
            currentBucket = currentBucket.nextBucket;
        }
        return null;
    }

    public V remove(byte[] serializedKey, long hashCode) {
        ODirectMemoryHashMapBucket<K, V> currentBucket = this;
        ODirectMemoryHashMapBucket<K, V> prevBucket = null;
        while (currentBucket != null) {
            for (int i = 0; i < currentBucket.size; ++i) {
                long keyPointer;
                byte[] storedKey;
                if (currentBucket.hashCodes[i] != hashCode || !Arrays.equals(serializedKey, storedKey = this.directMemory.get(keyPointer = currentBucket.keyValuePairs[i * 2], OBinaryTypeSerializer.INSTANCE))) continue;
                long valuePointer = currentBucket.keyValuePairs[i * 2 + 1];
                V removedValue = this.directMemory.get(valuePointer, this.valueSerializer);
                this.directMemory.free(keyPointer);
                this.directMemory.free(valuePointer);
                System.arraycopy(currentBucket.hashCodes, i + 1, currentBucket.hashCodes, i, currentBucket.size - (i + 1));
                System.arraycopy(currentBucket.keyValuePairs, (i + 1) * 2, currentBucket.keyValuePairs, i * 2, 2 * (currentBucket.size - (i + 1)));
                --currentBucket.size;
                if (currentBucket.size == 0 && prevBucket != null) {
                    prevBucket.nextBucket = currentBucket.nextBucket;
                }
                return removedValue;
            }
            prevBucket = currentBucket;
            currentBucket = currentBucket.nextBucket;
        }
        return null;
    }

    public void clear() {
        ODirectMemoryHashMapBucket<K, V> currentBucket = this;
        while (currentBucket != null) {
            for (int i = 0; i < currentBucket.size; ++i) {
                this.directMemory.free(currentBucket.keyValuePairs[i * 2]);
                this.directMemory.free(currentBucket.keyValuePairs[i * 2 + 1]);
            }
            currentBucket = currentBucket.nextBucket;
        }
        this.nextBucket = null;
        this.size = 0;
    }

    @Override
    public Iterator<Entry> iterator() {
        return new EntreeIterator();
    }

    private static final class FindResult<K, V> {
        private final ODirectMemoryHashMapBucket<K, V> foundBucket;
        private final int foundIndex;

        private FindResult(ODirectMemoryHashMapBucket<K, V> foundBucket, int foundIndex) {
            this.foundBucket = foundBucket;
            this.foundIndex = foundIndex;
        }
    }

    private class EntreeIterator
    implements Iterator<Entry> {
        private ODirectMemoryHashMapBucket<K, V> currentBucket;
        private int currentIndex;

        private EntreeIterator() {
            this.currentBucket = ODirectMemoryHashMapBucket.this;
            this.currentIndex = 0;
        }

        @Override
        public boolean hasNext() {
            return this.currentBucket != null && (this.currentBucket.nextBucket != null || this.currentIndex < this.currentBucket.size);
        }

        @Override
        public Entry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int index = this.currentIndex * 2;
            long keyPointer = this.currentBucket.keyValuePairs[index++];
            long valuePointer = this.currentBucket.keyValuePairs[index];
            long hashCode = this.currentBucket.hashCodes[this.currentIndex];
            ++this.currentIndex;
            if (this.currentIndex >= this.currentBucket.size) {
                this.currentBucket = this.currentBucket.nextBucket;
                this.currentIndex = 0;
            }
            return new Entry(hashCode, ODirectMemoryHashMapBucket.this.directMemory.get(keyPointer, OBinaryTypeSerializer.INSTANCE), ODirectMemoryHashMapBucket.this.directMemory.get(valuePointer, ODirectMemoryHashMapBucket.this.valueSerializer.getObjectSizeInDirectMemory(ODirectMemoryHashMapBucket.this.directMemory, valuePointer)));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove operation is unsupported.");
        }
    }

    public static final class Entry {
        public final long hashCode;
        public final byte[] key;
        public final byte[] value;

        public Entry(long hashCode, byte[] key, byte[] value) {
            this.hashCode = hashCode;
            this.key = key;
            this.value = value;
        }
    }
}

