/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.directmemory;

import com.orientechnologies.common.directmemory.ODirectMemory;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.Unsafe;

public class OUnsafeMemory
implements ODirectMemory {
    public static final OUnsafeMemory INSTANCE;
    protected static final Unsafe unsafe;
    private static final boolean unaligned;
    private static final long UNSAFE_COPY_THRESHOLD = 0x100000L;

    @Override
    public long allocate(byte[] bytes) {
        long pointer = unsafe.allocateMemory(bytes.length);
        this.set(pointer, bytes, 0, bytes.length);
        return pointer;
    }

    @Override
    public long allocate(long size) {
        return unsafe.allocateMemory(size);
    }

    @Override
    public void free(long pointer) {
        unsafe.freeMemory(pointer);
    }

    @Override
    public byte[] get(long pointer, int length) {
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = unsafe.getByte(pointer++);
        }
        return result;
    }

    @Override
    public void get(long pointer, byte[] array, int arrayOffset, int length) {
        pointer += (long)arrayOffset;
        for (int i = arrayOffset; i < length + arrayOffset; ++i) {
            array[i] = unsafe.getByte(pointer++);
        }
    }

    @Override
    public void set(long pointer, byte[] content, int arrayOffset, int length) {
        for (int i = arrayOffset; i < length + arrayOffset; ++i) {
            unsafe.putByte(pointer++, content[i]);
        }
    }

    @Override
    public <T> T get(long pointer, OBinarySerializer<T> serializer) {
        return serializer.deserializeFromDirectMemory(this, pointer);
    }

    @Override
    public <T> void set(long pointer, T data, OBinarySerializer<T> serializer) {
        serializer.serializeInDirectMemory(data, this, pointer);
    }

    @Override
    public int getInt(long pointer) {
        if (unaligned) {
            return unsafe.getInt(pointer);
        }
        return (0xFF & unsafe.getByte(pointer++)) << 24 | (0xFF & unsafe.getByte(pointer++)) << 16 | (0xFF & unsafe.getByte(pointer++)) << 8 | 0xFF & unsafe.getByte(pointer);
    }

    @Override
    public void setInt(long pointer, int value) {
        if (unaligned) {
            unsafe.putInt(pointer, value);
        } else {
            unsafe.putByte(pointer++, (byte)(value >>> 24));
            unsafe.putByte(pointer++, (byte)(value >>> 16));
            unsafe.putByte(pointer++, (byte)(value >>> 8));
            unsafe.putByte(pointer, (byte)value);
        }
    }

    @Override
    public void setShort(long pointer, short value) {
        if (unaligned) {
            unsafe.putShort(pointer, value);
        } else {
            unsafe.putByte(pointer++, (byte)(value >>> 8));
            unsafe.putByte(pointer, (byte)value);
        }
    }

    @Override
    public short getShort(long pointer) {
        if (unaligned) {
            return unsafe.getShort(pointer);
        }
        return (short)(unsafe.getByte(pointer++) << 8 | unsafe.getByte(pointer) & 0xFF);
    }

    @Override
    public void setChar(long pointer, char value) {
        if (unaligned) {
            unsafe.putChar(pointer, value);
        } else {
            unsafe.putByte(pointer++, (byte)(value >>> 8));
            unsafe.putByte(pointer, (byte)value);
        }
    }

    @Override
    public char getChar(long pointer) {
        if (unaligned) {
            return unsafe.getChar(pointer);
        }
        return (char)(unsafe.getByte(pointer++) << 8 | unsafe.getByte(pointer) & 0xFF);
    }

    @Override
    public long getLong(long pointer) {
        if (unaligned) {
            return unsafe.getLong(pointer);
        }
        return (0xFFL & (long)unsafe.getByte(pointer++)) << 56 | (0xFFL & (long)unsafe.getByte(pointer++)) << 48 | (0xFFL & (long)unsafe.getByte(pointer++)) << 40 | (0xFFL & (long)unsafe.getByte(pointer++)) << 32 | (0xFFL & (long)unsafe.getByte(pointer++)) << 24 | (0xFFL & (long)unsafe.getByte(pointer++)) << 16 | (0xFFL & (long)unsafe.getByte(pointer++)) << 8 | 0xFFL & (long)unsafe.getByte(pointer);
    }

    @Override
    public void setLong(long pointer, long value) {
        if (unaligned) {
            unsafe.putLong(pointer, value);
        } else {
            unsafe.putByte(pointer++, (byte)(value >>> 56));
            unsafe.putByte(pointer++, (byte)(value >>> 48));
            unsafe.putByte(pointer++, (byte)(value >>> 40));
            unsafe.putByte(pointer++, (byte)(value >>> 32));
            unsafe.putByte(pointer++, (byte)(value >>> 24));
            unsafe.putByte(pointer++, (byte)(value >>> 16));
            unsafe.putByte(pointer++, (byte)(value >>> 8));
            unsafe.putByte(pointer, (byte)value);
        }
    }

    @Override
    public byte getByte(long pointer) {
        return unsafe.getByte(pointer);
    }

    @Override
    public void setByte(long pointer, byte value) {
        unsafe.putByte(pointer, value);
    }

    @Override
    public void copyData(long srcPointer, long destPointer, long len) {
        while (len > 0L) {
            long size = len > 0x100000L ? 0x100000L : len;
            unsafe.copyMemory(srcPointer, destPointer, size);
            len -= size;
            srcPointer += size;
            destPointer += size;
        }
    }

    static {
        OUnsafeMemory futureInstance;
        unsafe = (Unsafe)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Field f = Unsafe.class.getDeclaredField("theUnsafe");
                    f.setAccessible(true);
                    return f.get(null);
                }
                catch (NoSuchFieldException e) {
                    throw new Error();
                }
                catch (IllegalAccessException e) {
                    throw new Error();
                }
            }
        });
        try {
            unsafe.getClass().getDeclaredMethod("copyMemory", Object.class, Long.TYPE, Object.class, Long.TYPE, Long.TYPE);
            Class<?> unsafeMemoryJava7 = OUnsafeMemory.class.getClassLoader().loadClass("com.orientechnologies.common.directmemory.OUnsafeMemoryJava7");
            futureInstance = (OUnsafeMemory)unsafeMemoryJava7.newInstance();
        }
        catch (Exception e) {
            futureInstance = new OUnsafeMemory();
        }
        INSTANCE = futureInstance;
        String arch = System.getProperty("os.arch");
        unaligned = arch.equals("i386") || arch.equals("x86") || arch.equals("amd64") || arch.equals("x86_64");
    }
}

