/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.profiler;

import com.orientechnologies.common.concur.resource.OSharedResourceAbstract;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfilerData;
import com.orientechnologies.common.profiler.OProfilerMBean;
import com.orientechnologies.common.util.OPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

public class OProfiler
extends OSharedResourceAbstract
implements OProfilerMBean {
    protected long recordingFrom = -1L;
    protected Map<String, OProfilerHookValue> hooks = new ConcurrentHashMap<String, OProfilerHookValue>();
    protected Date lastReset = new Date();
    protected ConcurrentHashMap<String, String> dictionary = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, METRIC_TYPE> types = new ConcurrentHashMap();
    protected OProfilerData realTime = new OProfilerData();
    protected OProfilerData lastSnapshot;
    protected List<OProfilerData> snapshots = new ArrayList<OProfilerData>();
    protected List<OProfilerData> summaries = new ArrayList<OProfilerData>();
    protected int elapsedToCreateSnapshot = 0;
    protected int maxSnapshots = 0;
    protected int maxSummaries = 0;
    protected static final Timer timer = new Timer(true);
    protected TimerTask archiverTask;

    public OProfiler() {
    }

    public OProfiler(int iElapsedToCreateSnapshot, int iMaxSnapshot, int iMaxSumaries) {
        this.elapsedToCreateSnapshot = iElapsedToCreateSnapshot;
        this.maxSnapshots = iMaxSnapshot;
        this.maxSummaries = iMaxSumaries;
    }

    public void configure(String iConfiguration) {
        if (iConfiguration == null || iConfiguration.length() == 0) {
            return;
        }
        String[] parts = iConfiguration.split(",");
        this.elapsedToCreateSnapshot = Integer.parseInt(parts[0].trim());
        this.maxSnapshots = Integer.parseInt(parts[1].trim());
        this.maxSummaries = Integer.parseInt(parts[2].trim());
        if (this.isRecording()) {
            this.stopRecording();
        }
        this.startRecording();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void memoryUsageLow(long iFreeMemory, long iFreeMemoryPercentage) {
        List<OProfilerData> list = this.snapshots;
        synchronized (list) {
            this.snapshots.clear();
        }
        list = this.summaries;
        synchronized (list) {
            this.summaries.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.stopRecording();
        this.hooks.clear();
        List<OProfilerData> list = this.snapshots;
        synchronized (list) {
            this.snapshots.clear();
        }
        list = this.summaries;
        synchronized (list) {
            this.summaries.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startRecording() {
        if (this.recordingFrom > -1L) {
            return;
        }
        this.acquireExclusiveLock();
        try {
            OLogManager.instance().info((Object)this, "Profiler is recording metrics with configuration: %d,%d,%d", this.elapsedToCreateSnapshot, this.maxSnapshots, this.maxSummaries);
            if (this.elapsedToCreateSnapshot > 0) {
                this.lastSnapshot = new OProfilerData();
                if (this.archiverTask != null) {
                    this.archiverTask.cancel();
                }
                this.archiverTask = new TimerTask(){

                    @Override
                    public void run() {
                        OProfiler.this.createSnapshot();
                    }
                };
                timer.schedule(this.archiverTask, this.elapsedToCreateSnapshot * 1000, (long)(this.elapsedToCreateSnapshot * 1000));
            }
            this.recordingFrom = System.currentTimeMillis();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopRecording() {
        if (this.recordingFrom == -1L) {
            return;
        }
        this.acquireExclusiveLock();
        try {
            OLogManager.instance().config(this, "Profiler has stopped recording metrics", new Object[0]);
            this.lastSnapshot = null;
            this.realTime.clear();
            this.dictionary.clear();
            this.types.clear();
            if (this.archiverTask != null) {
                this.archiverTask.cancel();
            }
            this.recordingFrom = -1L;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public boolean isRecording() {
        return this.recordingFrom > -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSnapshot() {
        if (this.lastSnapshot == null) {
            return;
        }
        Map<String, Object> hookValuesSnapshots = this.archiveHooks();
        this.acquireExclusiveLock();
        try {
            List<OProfilerData> list = this.snapshots;
            synchronized (list) {
                this.lastSnapshot.setHookValues(hookValuesSnapshots);
                this.lastSnapshot.endRecording();
                this.snapshots.add(this.lastSnapshot);
                this.lastSnapshot = new OProfilerData();
                if (this.snapshots.size() >= this.maxSnapshots && this.maxSnapshots > 0) {
                    List<OProfilerData> list2 = this.summaries;
                    synchronized (list2) {
                        OProfilerData summary = new OProfilerData();
                        for (OProfilerData a : this.snapshots) {
                            summary.mergeWith(a);
                        }
                        this.summaries.add(summary);
                        if (this.summaries.size() > this.maxSummaries) {
                            this.summaries.remove(0);
                        }
                    }
                    this.snapshots.clear();
                }
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void updateCounter(String iName, String iDescription, long iPlus) {
        this.updateCounter(iName, iDescription, iPlus, iName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCounter(String iName, String iDescription, long iPlus, String iMetadata) {
        if (iName == null || this.recordingFrom < 0L) {
            return;
        }
        this.updateMetadata(iMetadata, iDescription, METRIC_TYPE.COUNTER);
        this.acquireSharedLock();
        try {
            if (this.lastSnapshot != null) {
                this.lastSnapshot.updateCounter(iName, iPlus);
            }
            this.realTime.updateCounter(iName, iPlus);
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCounter(String iStatName) {
        if (iStatName == null || this.recordingFrom < 0L) {
            return -1L;
        }
        this.acquireSharedLock();
        try {
            long l = this.realTime.getCounter(iStatName);
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toJSON(String iQuery, String iPar1, String iPar2) {
        StringBuilder buffer = new StringBuilder();
        Map<String, Object> hookValuesSnapshots = null;
        if (iQuery.equals("realtime")) {
            hookValuesSnapshots = this.archiveHooks();
        }
        buffer.append("{ \"" + iQuery + "\":");
        this.acquireSharedLock();
        try {
            if (iQuery.equals("realtime")) {
                this.realTime.setHookValues(hookValuesSnapshots);
                this.realTime.toJSON(buffer, iPar1);
            } else if (iQuery.equals("last")) {
                if (this.lastSnapshot != null) {
                    this.lastSnapshot.toJSON(buffer, iPar1);
                }
            } else {
                if (iPar1 == null || iPar2 == null) {
                    throw new IllegalArgumentException("Invalid range format. Use: <from> <to>, where * means any");
                }
                long from = iPar1.equals("*") ? 0L : Long.parseLong(iPar1);
                long to = iPar2.equals("*") ? Long.MAX_VALUE : Long.parseLong(iPar2);
                boolean firstItem = true;
                buffer.append("[");
                if (iQuery.equals("archive")) {
                    for (int i = 0; i < this.snapshots.size(); ++i) {
                        OProfilerData a = this.snapshots.get(i);
                        if (!a.isInRange(from, to)) continue;
                        if (firstItem) {
                            firstItem = false;
                        } else {
                            buffer.append(',');
                        }
                        a.toJSON(buffer, null);
                    }
                } else if (iQuery.equals("summary")) {
                    for (int i = 0; i < this.summaries.size(); ++i) {
                        OProfilerData a = this.summaries.get(i);
                        if (!a.isInRange(from, to)) continue;
                        if (firstItem) {
                            firstItem = false;
                        } else {
                            buffer.append(',');
                        }
                        a.toJSON(buffer, iPar1);
                    }
                } else {
                    throw new IllegalArgumentException("Invalid archive query: use realtime|last|archive|summary");
                }
                buffer.append("]");
            }
            buffer.append("}");
        }
        finally {
            this.releaseSharedLock();
        }
        return buffer.toString();
    }

    public Map<String, OPair<String, METRIC_TYPE>> getMetadata() {
        HashMap<String, OPair<String, METRIC_TYPE>> metadata = new HashMap<String, OPair<String, METRIC_TYPE>>();
        for (Map.Entry<String, String> entry : this.dictionary.entrySet()) {
            metadata.put(entry.getKey(), new OPair<Comparable, METRIC_TYPE>((Comparable)((Object)entry.getValue()), this.types.get(entry.getKey())));
        }
        return metadata;
    }

    public String metadataToJSON() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{ \"metadata\": {\n  ");
        boolean first = true;
        for (Map.Entry<String, String> entry : this.dictionary.entrySet()) {
            String key = entry.getKey();
            if (first) {
                first = false;
            } else {
                buffer.append(",\n  ");
            }
            buffer.append('\"');
            buffer.append(key);
            buffer.append("\":{\"description\":\"");
            buffer.append(entry.getValue());
            buffer.append("\",\"type\":\"");
            buffer.append((Object)this.types.get(key));
            buffer.append("\"}");
        }
        buffer.append("} }");
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String dump() {
        float maxMem = (float)Runtime.getRuntime().maxMemory() / 1000000.0f;
        float totMem = (float)Runtime.getRuntime().totalMemory() / 1000000.0f;
        float freeMem = maxMem - totMem;
        long now = System.currentTimeMillis();
        this.acquireSharedLock();
        try {
            StringBuilder buffer = new StringBuilder();
            buffer.append("\nOrientDB profiler dump of ");
            buffer.append(new Date(now));
            buffer.append(" after ");
            buffer.append((now - this.recordingFrom) / 1000L);
            buffer.append(" secs of profiling");
            buffer.append(String.format("\nFree memory: %2.2fMb (%2.2f%%) - Total memory: %2.2fMb - Max memory: %2.2fMb - CPUs: %d", Float.valueOf(freeMem), Float.valueOf(freeMem * 100.0f / maxMem), Float.valueOf(totMem), Float.valueOf(maxMem), Runtime.getRuntime().availableProcessors()));
            buffer.append("\n");
            buffer.append(this.dumpHookValues());
            buffer.append("\n");
            buffer.append(this.dumpCounters());
            buffer.append("\n\n");
            buffer.append(this.dumpStats());
            buffer.append("\n\n");
            buffer.append(this.dumpChronos());
            String string = buffer.toString();
            return string;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public long startChrono() {
        if (this.recordingFrom < 0L) {
            return -1L;
        }
        return System.currentTimeMillis();
    }

    @Override
    public long stopChrono(String iName, String iDescription, long iStartTime) {
        return this.stopChrono(iName, iDescription, iStartTime, iName, null);
    }

    public long stopChrono(String iName, String iDescription, long iStartTime, String iDictionaryName) {
        return this.stopChrono(iName, iDescription, iStartTime, iDictionaryName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long stopChrono(String iName, String iDescription, long iStartTime, String iDictionaryName, String iPayload) {
        if (this.recordingFrom < 0L) {
            return -1L;
        }
        this.updateMetadata(iDictionaryName, iDescription, METRIC_TYPE.CHRONO);
        this.acquireSharedLock();
        try {
            if (this.lastSnapshot != null) {
                this.lastSnapshot.stopChrono(iName, iStartTime, iPayload);
            }
            long l = this.realTime.stopChrono(iName, iStartTime, iPayload);
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long updateStat(String iName, String iDescription, long iValue) {
        if (this.recordingFrom < 0L) {
            return -1L;
        }
        this.updateMetadata(iName, iDescription, METRIC_TYPE.STAT);
        this.acquireSharedLock();
        try {
            if (this.lastSnapshot != null) {
                this.lastSnapshot.updateStat(iName, iValue);
            }
            long l = this.realTime.updateStat(iName, iValue);
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String dumpCounters() {
        if (this.recordingFrom < 0L) {
            return "Counters: <no recording>";
        }
        this.acquireSharedLock();
        try {
            String string = this.realTime.dumpCounters();
            return string;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String dumpChronos() {
        this.acquireSharedLock();
        try {
            String string = this.realTime.dumpChronos();
            return string;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpStats() {
        this.acquireSharedLock();
        try {
            String string = this.realTime.dumpStats();
            return string;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpHookValues() {
        if (this.recordingFrom < 0L) {
            return "HookValues: <no recording>";
        }
        StringBuilder buffer = new StringBuilder();
        this.acquireSharedLock();
        try {
            if (this.hooks.size() == 0) {
                String string = "";
                return string;
            }
            buffer.append("HOOK VALUES:");
            buffer.append(String.format("\n%50s +-------------------------------------------------------------------+", ""));
            buffer.append(String.format("\n%50s | Value                                                             |", "Name"));
            buffer.append(String.format("\n%50s +-------------------------------------------------------------------+", ""));
            ArrayList<String> names = new ArrayList<String>(this.hooks.keySet());
            Collections.sort(names);
            for (String k : names) {
                OProfilerHookValue v = this.hooks.get(k);
                if (v == null) continue;
                Object hookValue = v.getValue();
                buffer.append(String.format("\n%-50s | %-65s |", k, hookValue != null ? hookValue.toString() : "null"));
            }
        }
        finally {
            this.releaseSharedLock();
        }
        buffer.append(String.format("\n%50s +-------------------------------------------------------------------+", ""));
        return buffer.toString();
    }

    public Object getHookValue(String iName) {
        OProfilerHookValue v = this.hooks.get(iName);
        return v != null ? v.getValue() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getCountersAsString() {
        this.acquireSharedLock();
        try {
            String[] stringArray = this.realTime.getCountersAsString();
            return stringArray;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getChronosAsString() {
        this.acquireSharedLock();
        try {
            String[] stringArray = this.realTime.getChronosAsString();
            return stringArray;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getStatsAsString() {
        this.acquireSharedLock();
        try {
            String[] stringArray = this.realTime.getStatsAsString();
            return stringArray;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Date getLastReset() {
        return this.lastReset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCounters() {
        this.acquireSharedLock();
        try {
            List<String> list = this.realTime.getCounters();
            return list;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OProfilerData.OProfilerEntry getStat(String iStatName) {
        this.acquireSharedLock();
        try {
            OProfilerData.OProfilerEntry oProfilerEntry = this.realTime.getStat(iStatName);
            return oProfilerEntry;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OProfilerData.OProfilerEntry getChrono(String iChronoName) {
        this.acquireSharedLock();
        try {
            OProfilerData.OProfilerEntry oProfilerEntry = this.realTime.getChrono(iChronoName);
            return oProfilerEntry;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public void registerHookValue(String iName, String iDescription, METRIC_TYPE iType, OProfilerHookValue iHookValue) {
        this.registerHookValue(iName, iDescription, iType, iHookValue, iName);
    }

    public void registerHookValue(String iName, String iDescription, METRIC_TYPE iType, OProfilerHookValue iHookValue, String iMetadataName) {
        this.unregisterHookValue(iName);
        this.updateMetadata(iMetadataName, iDescription, iType);
        this.hooks.put(iName, iHookValue);
    }

    public void unregisterHookValue(String iName) {
        if (this.recordingFrom < 0L) {
            return;
        }
        this.hooks.remove(iName);
    }

    public void setAutoDump(int iSeconds) {
        if (iSeconds > 0) {
            int ms = iSeconds * 1000;
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    System.out.println(OProfiler.this.dump());
                }
            }, ms, (long)ms);
        }
    }

    protected Map<String, Object> archiveHooks() {
        if (!this.isRecording()) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, OProfilerHookValue> v : this.hooks.entrySet()) {
            result.put(v.getKey(), v.getValue().getValue());
        }
        return result;
    }

    protected void updateMetadata(String iName, String iDescription, METRIC_TYPE iType) {
        if (iDescription != null && this.dictionary.putIfAbsent(iName, iDescription) == null) {
            this.types.put(iName, iType);
        }
    }

    public static interface OProfilerHookValue {
        public Object getValue();
    }

    public static enum METRIC_TYPE {
        CHRONO,
        COUNTER,
        STAT,
        SIZE,
        ENABLED,
        TEXT;

    }
}

