/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.directmemory.collections;

import com.orientechnologies.common.directmemory.ODirectMemory;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import java.util.AbstractList;
import java.util.List;
import java.util.RandomAccess;

public class ODirectMemoryList<E>
extends AbstractList<E>
implements List<E>,
RandomAccess {
    private final ODirectMemory memory;
    private final OBinarySerializer<E> serializer;
    private int size;
    private int elementData;

    public ODirectMemoryList(int initialCapacity, ODirectMemory memory, OBinarySerializer<E> serializer) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.memory = memory;
        this.serializer = serializer;
        this.elementData = this.allocateSpace(initialCapacity);
    }

    public ODirectMemoryList(ODirectMemory memory, OBinarySerializer<E> serializer) {
        this(16, memory, serializer);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.getData(this.elementData, i) != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!o.equals(this.getData(this.elementData, i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.getData(this.elementData, i) != null) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!o.equals(this.getData(this.elementData, i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public E get(int index) {
        this.rangeCheck(index);
        return this.getData(this.elementData, index);
    }

    @Override
    public E set(int index, E element) {
        this.rangeCheck(index);
        E oldValue = this.getData(this.elementData, index);
        this.setData(this.elementData, index, element);
        return oldValue;
    }

    @Override
    public boolean add(E e) {
        this.ensureCapacity(this.size + 1);
        this.setData(this.elementData, this.size++, e);
        return true;
    }

    @Override
    public E remove(int index) {
        if (this.size == 0) {
            return null;
        }
        this.rangeCheck(index);
        E oldValue = this.getData(this.elementData, index);
        this.doRemove(index);
        return oldValue;
    }

    private void doRemove(int index) {
        ++this.modCount;
        this.setData(this.elementData, index, null);
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            this.copyData(this.elementData, index + 1, index, numMoved);
        }
        --this.size;
        this.clearData(this.elementData, this.size);
    }

    @Override
    public boolean remove(Object o) {
        if (this.size == 0) {
            return false;
        }
        if (o == null) {
            for (int index = 0; index < this.size; ++index) {
                if (this.getData(this.elementData, index) != null) continue;
                this.doRemove(index);
                return true;
            }
        } else {
            for (int index = 0; index < this.size; ++index) {
                if (!o.equals(this.getData(this.elementData, index))) continue;
                this.doRemove(index);
                return true;
            }
        }
        return false;
    }

    @Override
    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.setData(this.elementData, i, null);
        }
        this.size = 0;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        int numMoved = this.size - toIndex;
        for (int i = fromIndex; i < toIndex; ++i) {
            this.setData(this.elementData, i, null);
        }
        this.copyData(this.elementData, fromIndex, toIndex, numMoved);
        int newSize = this.size - (toIndex - fromIndex);
        while (this.size != newSize) {
            this.clearData(this.elementData, --this.size);
        }
    }

    private void ensureCapacity(int minCapacity) {
        ++this.modCount;
        int oldCapacity = this.memory.getInt(this.elementData, 0);
        if (minCapacity > oldCapacity) {
            int oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = this.allocateSpace(newCapacity);
            this.copyData(oldData, 0, this.elementData, 0, oldCapacity);
        }
    }

    private void copyData(int ptr, int fromIndex, int toIndex, int len) {
        int fromOffset = fromIndex * 4 + 4;
        int toOffset = toIndex * 4 + 4;
        this.memory.copyData(ptr, fromOffset, ptr, toOffset, len * 4);
    }

    private void copyData(int fromPtr, int fromIndex, int toPtr, int toIndex, int len) {
        int fromOffset = fromIndex * 4 + 4;
        int toOffset = toIndex * 4 + 4;
        this.memory.copyData(fromPtr, fromOffset, toPtr, toOffset, len * 4);
    }

    private void rangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    private E getData(int ptr, int index) {
        int offset = index * 4 + 4;
        int dataPtr = this.memory.getInt(ptr, offset);
        if (dataPtr == -1) {
            return null;
        }
        return this.memory.get(dataPtr, 0, this.serializer);
    }

    private void setData(int ptr, int index, E data) {
        int dataPtr;
        if (data != null) {
            dataPtr = this.memory.allocate(this.serializer.getObjectSize(data));
            if (dataPtr == -1) {
                throw new IllegalStateException("There is no enough memory to allocate for item " + data);
            }
            this.memory.set(dataPtr, 0, data, this.serializer);
        } else {
            dataPtr = -1;
        }
        int offset = index * 4 + 4;
        int oldPtr = this.memory.getInt(ptr, offset);
        if (oldPtr != -1) {
            this.memory.free(oldPtr);
        }
        this.memory.setInt(ptr, offset, dataPtr);
    }

    private void clearData(int ptr, int index) {
        int offset = index * 4 + 4;
        this.memory.setInt(ptr, offset, -1);
    }

    private int allocateSpace(int capacity) {
        int size = capacity * 4 + 4;
        int ptr = this.memory.allocate(size);
        if (ptr == -1) {
            throw new IllegalStateException("There is no enough memory to allocate for capacity = " + capacity);
        }
        int pos = 4;
        for (int i = 0; i < capacity; ++i) {
            this.memory.setInt(ptr, pos, -1);
            pos += 4;
        }
        this.memory.setInt(ptr, 0, capacity);
        return ptr;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.clear();
        this.memory.free(this.elementData);
    }
}

