/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.lock;

import com.orientechnologies.common.concur.lock.OLockException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class OLockManager<RESOURCE_TYPE, REQUESTER_TYPE> {
    private static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    protected long acquireTimeout;
    protected final ConcurrentHashMap<RESOURCE_TYPE, CountableLock> map;
    private final boolean enabled;
    private final int shift;
    private final int mask;
    private final Object[] locks;

    public OLockManager(boolean iEnabled, int iAcquireTimeout) {
        this(iEnabled, iAcquireTimeout, OLockManager.defaultConcurrency());
    }

    public OLockManager(boolean iEnabled, int iAcquireTimeout, int concurrencyLevel) {
        int cL = 1;
        int sh = 0;
        while (cL < concurrencyLevel) {
            cL <<= 1;
            ++sh;
        }
        this.shift = 32 - sh;
        this.mask = cL - 1;
        this.map = new ConcurrentHashMap(cL);
        this.locks = new Object[cL];
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i] = new Object();
        }
        this.acquireTimeout = iAcquireTimeout;
        this.enabled = iEnabled;
    }

    public void acquireLock(REQUESTER_TYPE iRequester, RESOURCE_TYPE iResourceId, LOCK iLockType) {
        this.acquireLock(iRequester, iResourceId, iLockType, this.acquireTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireLock(REQUESTER_TYPE iRequester, RESOURCE_TYPE iResourceId, LOCK iLockType, long iTimeout) {
        block18: {
            CountableLock lock;
            Object internalLock;
            if (!this.enabled) {
                return;
            }
            Object object = internalLock = this.internalLock(iResourceId);
            synchronized (object) {
                lock = this.map.get(iResourceId);
                if (lock == null) {
                    CountableLock newLock = new CountableLock(iTimeout > 0L);
                    lock = this.map.putIfAbsent(this.getImmutableResourceId(iResourceId), newLock);
                    if (lock == null) {
                        lock = newLock;
                    }
                }
                ++lock.countLocks;
            }
            try {
                if (iTimeout <= 0L) {
                    if (iLockType == LOCK.SHARED) {
                        lock.readLock().lock();
                    } else {
                        lock.writeLock().lock();
                    }
                    break block18;
                }
                try {
                    if (iLockType == LOCK.SHARED ? !lock.readLock().tryLock(iTimeout, TimeUnit.MILLISECONDS) : !lock.writeLock().tryLock(iTimeout, TimeUnit.MILLISECONDS)) {
                        throw new OLockException("Timeout on acquiring resource '" + iResourceId + "' because is locked from another thread");
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new OLockException("Thread interrupted while waiting for resource '" + iResourceId + "'");
                }
            }
            catch (RuntimeException e) {
                Object object2 = internalLock;
                synchronized (object2) {
                    --lock.countLocks;
                    if (lock.countLocks == 0) {
                        this.map.remove(iResourceId);
                    }
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(REQUESTER_TYPE iRequester, RESOURCE_TYPE iResourceId, LOCK iLockType) throws OLockException {
        CountableLock lock;
        Object internalLock;
        if (!this.enabled) {
            return;
        }
        Object object = internalLock = this.internalLock(iResourceId);
        synchronized (object) {
            lock = this.map.get(iResourceId);
            if (lock == null) {
                throw new OLockException("Error on releasing a non acquired lock by the requester '" + iRequester + "' against the resource: '" + iResourceId + "'");
            }
            --lock.countLocks;
            if (lock.countLocks == 0) {
                this.map.remove(iResourceId);
            }
        }
        if (iLockType == LOCK.SHARED) {
            lock.readLock().unlock();
        } else {
            lock.writeLock().unlock();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public int getCountCurrentLocks() {
        return this.map.size();
    }

    protected RESOURCE_TYPE getImmutableResourceId(RESOURCE_TYPE iResourceId) {
        return iResourceId;
    }

    private Object internalLock(RESOURCE_TYPE iResourceId) {
        int hashCode = iResourceId.hashCode();
        int index = hashCode >>> this.shift & this.mask;
        return this.locks[index];
    }

    private static int defaultConcurrency() {
        return Runtime.getRuntime().availableProcessors() > 16 ? Runtime.getRuntime().availableProcessors() : 16;
    }

    protected static class CountableLock
    extends ReentrantReadWriteLock {
        protected int countLocks = 0;

        public CountableLock(boolean iFair) {
            super(false);
        }
    }

    public static enum LOCK {
        SHARED,
        EXCLUSIVE;

    }
}

