/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.collection;

import com.orientechnologies.common.collection.AbstractEntryIterator;
import com.orientechnologies.common.collection.OAlwaysGreaterKey;
import com.orientechnologies.common.collection.OAlwaysLessKey;
import com.orientechnologies.common.collection.OCompositeKey;
import com.orientechnologies.common.collection.OLazyIterator;
import com.orientechnologies.common.collection.OMVRBTreeEntry;
import com.orientechnologies.common.collection.OMVRBTreeEntryPosition;
import com.orientechnologies.common.collection.OMVRBTreeSet;
import com.orientechnologies.common.collection.ONavigableMap;
import com.orientechnologies.common.collection.ONavigableSet;
import com.orientechnologies.common.collection.OSimpleImmutableEntry;
import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.log.OLogManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public abstract class OMVRBTree<K, V>
extends AbstractMap<K, V>
implements ONavigableMap<K, V>,
Cloneable,
Serializable {
    private static final OAlwaysLessKey ALWAYS_LESS_KEY = new OAlwaysLessKey();
    private static final OAlwaysGreaterKey ALWAYS_GREATER_KEY = new OAlwaysGreaterKey();
    boolean pageItemFound = false;
    protected int pageItemComparator = 0;
    protected int pageIndex = -1;
    protected float pageLoadFactor = 0.7f;
    protected final Comparator<? super K> comparator;
    protected transient OMVRBTreeEntry<K, V> root = null;
    transient int modCount = 0;
    protected transient boolean runtimeCheckEnabled = false;
    protected transient boolean debug = false;
    protected Object lastSearchKey;
    protected OMVRBTreeEntry<K, V> lastSearchNode;
    protected boolean lastSearchFound = false;
    protected int lastSearchIndex = -1;
    protected int keySize = 1;
    private transient EntrySet entrySet = null;
    private transient KeySet<K> navigableKeySet = null;
    private transient ONavigableMap<K, V> descendingMap = null;
    public static final boolean RED = false;
    public static final boolean BLACK = true;

    public OMVRBTree() {
        this(1);
    }

    public OMVRBTree(int keySize) {
        this.comparator = ODefaultComparator.INSTANCE;
        this.init();
        this.keySize = keySize;
    }

    public OMVRBTree(Comparator<? super K> iComparator) {
        this.init();
        this.comparator = iComparator;
    }

    public OMVRBTree(Map<? extends K, ? extends V> m) {
        this.comparator = ODefaultComparator.INSTANCE;
        this.init();
        this.putAll(m);
    }

    public OMVRBTree(SortedMap<K, ? extends V> m) {
        this.init();
        this.comparator = m.comparator();
        try {
            this.buildFromSorted(m.size(), m.entrySet().iterator(), null, null);
        }
        catch (IOException cannotHappen) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    protected abstract OMVRBTreeEntry<K, V> createEntry(K var1, V var2);

    protected abstract OMVRBTreeEntry<K, V> createEntry(OMVRBTreeEntry<K, V> var1);

    public int getNodes() {
        int counter = -1;
        OMVRBTreeEntry<K, V> entry = this.getFirstEntry();
        while (entry != null) {
            entry = OMVRBTree.successor(entry);
            ++counter;
        }
        return counter;
    }

    protected abstract void setSize(int var1);

    public abstract int getDefaultPageSize();

    @Override
    public boolean containsKey(Object key) {
        return this.getEntry(key, PartialSearchMode.NONE) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        OMVRBTreeEntry<K, V> e = this.getFirstEntry();
        while (e != null) {
            if (OMVRBTree.valEquals(value, e.getValue())) {
                return true;
            }
            e = OMVRBTree.next(e);
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (this.size() == 0) {
            return null;
        }
        OMVRBTreeEntry<K, V> entry = null;
        OMVRBTreeEntry<K, V> node = this.getLastSearchNodeForSameKey(key);
        if (node != null) {
            if (this.lastSearchFound) {
                return node.getValue(this.lastSearchIndex);
            }
        } else {
            entry = this.getEntry(key, PartialSearchMode.NONE);
        }
        return entry == null ? null : (V)entry.getValue();
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    @Override
    public K firstKey() {
        return OMVRBTree.key(this.getFirstEntry());
    }

    @Override
    public K lastKey() {
        return OMVRBTree.key(this.getLastEntry());
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Comparator c;
        int mapSize = map.size();
        if (this.size() == 0 && mapSize != 0 && map instanceof SortedMap && ((c = ((SortedMap)map).comparator()) == this.comparator || c != null && c.equals(this.comparator))) {
            ++this.modCount;
            try {
                this.buildFromSorted(mapSize, map.entrySet().iterator(), null, null);
            }
            catch (IOException cannotHappen) {
            }
            catch (ClassNotFoundException cannotHappen) {
                // empty catch block
            }
            return;
        }
        super.putAll(map);
    }

    public final OMVRBTreeEntry<K, V> getEntry(Object key, PartialSearchMode partialSearchMode) {
        return this.getEntry(key, false, partialSearchMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final OMVRBTreeEntry<K, V> getEntry(Object key, boolean iGetContainer, PartialSearchMode partialSearchMode) {
        Object k;
        if (key == null) {
            return this.setLastSearchNode(null, null);
        }
        this.pageItemFound = false;
        if (this.size() == 0) {
            this.pageIndex = 0;
            return iGetContainer ? this.root : null;
        }
        if (this.keySize == 1) {
            k = key;
        } else if (((OCompositeKey)key).getKeys().size() == this.keySize) {
            k = key;
        } else if (partialSearchMode.equals((Object)PartialSearchMode.NONE)) {
            k = key;
        } else {
            OCompositeKey fullKey = new OCompositeKey((Comparable)key);
            int itemsToAdd = this.keySize - fullKey.getKeys().size();
            Comparable<Comparable<?>> keyItem = partialSearchMode.equals((Object)PartialSearchMode.HIGHEST_BOUNDARY) ? ALWAYS_GREATER_KEY : ALWAYS_LESS_KEY;
            for (int i = 0; i < itemsToAdd; ++i) {
                fullKey.addKey(keyItem);
            }
            k = fullKey;
        }
        OMVRBTreeEntry<Object, V> p = this.getBestEntryPoint(k);
        this.checkTreeStructure(p);
        if (p == null) {
            return this.setLastSearchNode(key, null);
        }
        OMVRBTreeEntry<Object, V> lastNode = p;
        OMVRBTreeEntry<Object, V> prevNode = null;
        int beginKey = -1;
        try {
            while (p != null && p.getSize() > 0) {
                OMVRBTreeEntry<Object, V> oMVRBTreeEntry;
                OMVRBTreeEntry<Object, V> tmpNode;
                this.searchNodeCallback();
                lastNode = p;
                beginKey = this.compare(k, p.getFirstKey());
                if (beginKey == 0) {
                    this.pageIndex = 0;
                    this.pageItemFound = true;
                    this.pageItemComparator = 0;
                    OMVRBTreeEntry<Object, V> oMVRBTreeEntry2 = this.setLastSearchNode(key, p);
                    return oMVRBTreeEntry2;
                }
                this.pageItemComparator = this.compare(k, p.getLastKey());
                if (beginKey < 0) {
                    OMVRBTreeEntry<Object, V> tmpNode2;
                    if (this.pageItemComparator < 0 && (tmpNode2 = OMVRBTree.predecessor(p)) != null && tmpNode2 != prevNode) {
                        prevNode = p;
                        p = tmpNode2;
                        continue;
                    }
                } else if (beginKey > 0 && this.pageItemComparator > 0 && (tmpNode = OMVRBTree.successor(p)) != null && tmpNode != prevNode) {
                    prevNode = p;
                    p = tmpNode;
                    continue;
                }
                V value = lastNode.search(k);
                if (key instanceof OCompositeKey) {
                    OCompositeKey compositeKey = (OCompositeKey)key;
                    if (value != null && compositeKey.getKeys().size() == this.keySize) {
                        OMVRBTreeEntry<Object, V> oMVRBTreeEntry3 = this.setLastSearchNode(key, lastNode);
                        return oMVRBTreeEntry3;
                    }
                    if (partialSearchMode.equals((Object)PartialSearchMode.NONE)) {
                        if (value != null || iGetContainer) {
                            OMVRBTreeEntry<Object, V> oMVRBTreeEntry4 = lastNode;
                            return oMVRBTreeEntry4;
                        }
                        OMVRBTreeEntry<K, V> oMVRBTreeEntry5 = null;
                        return oMVRBTreeEntry5;
                    }
                    if (partialSearchMode.equals((Object)PartialSearchMode.HIGHEST_BOUNDARY)) {
                        OMVRBTreeEntry<Object, V> oMVRBTreeEntry6 = this.adjustHighestPartialSearchResult(iGetContainer, lastNode, compositeKey);
                        return oMVRBTreeEntry6;
                    }
                    if (partialSearchMode.equals((Object)PartialSearchMode.LOWEST_BOUNDARY)) {
                        OMVRBTreeEntry<Object, V> oMVRBTreeEntry7 = this.adjustLowestPartialSearchResult(iGetContainer, lastNode, compositeKey);
                        return oMVRBTreeEntry7;
                    }
                }
                if (value != null) {
                    this.setLastSearchNode(key, lastNode);
                }
                if (value != null || iGetContainer) {
                    oMVRBTreeEntry = lastNode;
                    return oMVRBTreeEntry;
                }
                oMVRBTreeEntry = null;
                return oMVRBTreeEntry;
            }
        }
        finally {
            this.checkTreeStructure(p);
        }
        return this.setLastSearchNode(key, null);
    }

    private OMVRBTreeEntry<K, V> adjustHighestPartialSearchResult(boolean iGetContainer, OMVRBTreeEntry<K, V> lastNode, OCompositeKey compositeKey) {
        int oldPageIndex = this.pageIndex;
        OMVRBTreeEntry<K, V> prevNd = OMVRBTree.previous(lastNode);
        if (prevNd == null) {
            this.pageIndex = oldPageIndex;
            this.pageItemFound = false;
            if (iGetContainer) {
                return lastNode;
            }
            return null;
        }
        this.pageItemComparator = this.compare(prevNd.getKey(), compositeKey);
        if (this.pageItemComparator == 0) {
            this.pageItemFound = true;
            return prevNd;
        }
        if (this.pageItemComparator > 1) {
            this.pageItemFound = false;
            if (iGetContainer) {
                return prevNd;
            }
            return null;
        }
        this.pageIndex = oldPageIndex;
        this.pageItemFound = false;
        if (iGetContainer) {
            return lastNode;
        }
        return null;
    }

    private OMVRBTreeEntry<K, V> adjustLowestPartialSearchResult(boolean iGetContainer, OMVRBTreeEntry<K, V> lastNode, OCompositeKey compositeKey) {
        int oldPageIndex = this.pageIndex;
        OMVRBTreeEntry<K, V> oldNode = lastNode;
        if (this.pageIndex >= lastNode.getSize() && (lastNode = OMVRBTree.next(lastNode)) == null) {
            lastNode = oldNode;
            this.pageIndex = oldPageIndex;
            this.pageItemFound = false;
            if (iGetContainer) {
                return lastNode;
            }
            return null;
        }
        this.pageItemComparator = this.compare(lastNode.getKey(), compositeKey);
        if (this.pageItemComparator == 0) {
            this.pageItemFound = true;
            return lastNode;
        }
        this.pageItemFound = false;
        if (iGetContainer) {
            return lastNode;
        }
        return null;
    }

    protected OMVRBTreeEntry<K, V> getBestEntryPoint(K key) {
        return this.root;
    }

    public OMVRBTreeEntry<K, V> getCeilingEntry(K key, PartialSearchMode partialSearchMode) {
        OMVRBTreeEntry<K, V> p = this.getEntry(key, true, partialSearchMode);
        if (p == null) {
            return null;
        }
        if (this.pageItemFound) {
            return p;
        }
        if (this.pageIndex < p.getSize()) {
            if (key instanceof OCompositeKey) {
                return this.adjustSearchResult((OCompositeKey)key, partialSearchMode, p);
            }
            return p;
        }
        return null;
    }

    public OMVRBTreeEntry<K, V> getFloorEntry(K key, PartialSearchMode partialSearchMode) {
        OMVRBTreeEntry<K, V> p = this.getEntry(key, true, partialSearchMode);
        if (p == null) {
            return null;
        }
        if (this.pageItemFound) {
            return p;
        }
        OMVRBTreeEntry<K, V> adjacentEntry = OMVRBTree.previous(p);
        if (adjacentEntry == null) {
            return null;
        }
        if (key instanceof OCompositeKey) {
            return this.adjustSearchResult((OCompositeKey)key, partialSearchMode, adjacentEntry);
        }
        return adjacentEntry;
    }

    private OMVRBTreeEntry<K, V> adjustSearchResult(OCompositeKey key, PartialSearchMode partialSearchMode, OMVRBTreeEntry<K, V> foundEntry) {
        if (partialSearchMode.equals((Object)PartialSearchMode.NONE)) {
            return foundEntry;
        }
        OCompositeKey keyToSearch = key;
        OCompositeKey foundKey = (OCompositeKey)foundEntry.getKey();
        if (keyToSearch.getKeys().size() < this.keySize) {
            OCompositeKey borderKey = new OCompositeKey();
            OCompositeKey keyToCompare = new OCompositeKey();
            List<Object> keyItems = foundKey.getKeys();
            for (int i = 0; i < this.keySize - 1; ++i) {
                Object keyItem = keyItems.get(i);
                borderKey.addKey(keyItem);
                if (i >= keyToSearch.getKeys().size()) continue;
                keyToCompare.addKey(keyItem);
            }
            if (partialSearchMode.equals((Object)PartialSearchMode.HIGHEST_BOUNDARY)) {
                borderKey.addKey(ALWAYS_GREATER_KEY);
            } else {
                borderKey.addKey(ALWAYS_LESS_KEY);
            }
            OMVRBTreeEntry<K, V> adjustedNode = this.getEntry(borderKey, true, PartialSearchMode.NONE);
            if (partialSearchMode.equals((Object)PartialSearchMode.HIGHEST_BOUNDARY)) {
                return this.adjustHighestPartialSearchResult(false, adjustedNode, keyToCompare);
            }
            return this.adjustLowestPartialSearchResult(false, adjustedNode, keyToCompare);
        }
        return foundEntry;
    }

    public OMVRBTreeEntry<K, V> getHigherEntry(K key) {
        OMVRBTreeEntry<K, V> p = this.getEntry(key, true, PartialSearchMode.HIGHEST_BOUNDARY);
        if (p == null) {
            return null;
        }
        if (this.pageItemFound) {
            return OMVRBTree.next(p);
        }
        if (this.pageIndex < p.getSize()) {
            return p;
        }
        return null;
    }

    public OMVRBTreeEntry<K, V> getLowerEntry(K key) {
        OMVRBTreeEntry<K, V> p = this.getEntry(key, true, PartialSearchMode.LOWEST_BOUNDARY);
        if (p == null) {
            return null;
        }
        return OMVRBTree.previous(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        OMVRBTreeEntry<K, V> parentNode = null;
        try {
            if (this.root == null) {
                this.root = this.createEntry(key, value);
                this.root.setColor(true);
                this.setSize(1);
                ++this.modCount;
                V v = null;
                return v;
            }
            parentNode = this.getLastSearchNodeForSameKey(key);
            if (parentNode != null && this.lastSearchFound) {
                this.pageIndex = this.lastSearchIndex;
                ++this.modCount;
                V v = parentNode.setValue(value);
                return v;
            }
            parentNode = this.getEntry(key, true, PartialSearchMode.NONE);
            if (this.pageItemFound) {
                ++this.modCount;
                V v = parentNode.setValue(value);
                return v;
            }
            this.setLastSearchNode(null, null);
            if (parentNode == null) {
                parentNode = this.root;
                this.pageIndex = 0;
            }
            if (parentNode.getFreeSpace() > 0) {
                parentNode.insert(this.pageIndex, key, value);
            } else {
                OMVRBTreeEntry<K, V> newNode = this.createEntry(parentNode);
                if (this.pageIndex < parentNode.getPageSplitItems()) {
                    parentNode.insert(this.pageIndex, key, value);
                } else {
                    newNode.insert(this.pageIndex - parentNode.getPageSplitItems(), key, value);
                }
                OMVRBTreeEntry<K, V> node = parentNode.getRight();
                OMVRBTreeEntry<K, V> prevNode = parentNode;
                int cmp = 0;
                if (this.comparator != null) {
                    while (node != null) {
                        cmp = this.comparator.compare(newNode.getFirstKey(), node.getFirstKey());
                        if (cmp < 0) {
                            prevNode = node;
                            node = node.getLeft();
                            continue;
                        }
                        if (cmp > 0) {
                            prevNode = node;
                            node = node.getRight();
                            continue;
                        }
                        throw new IllegalStateException("Duplicated keys were found in OMVRBTree.");
                    }
                } else {
                    while (node != null) {
                        cmp = this.compare(newNode.getFirstKey(), node.getFirstKey());
                        if (cmp < 0) {
                            prevNode = node;
                            node = node.getLeft();
                            continue;
                        }
                        if (cmp > 0) {
                            prevNode = node;
                            node = node.getRight();
                            continue;
                        }
                        throw new IllegalStateException("Duplicated keys were found in OMVRBTree.");
                    }
                }
                if (prevNode == parentNode) {
                    parentNode.setRight(newNode);
                } else if (cmp < 0) {
                    prevNode.setLeft(newNode);
                } else if (cmp > 0) {
                    prevNode.setRight(newNode);
                } else {
                    throw new IllegalStateException("Duplicated keys were found in OMVRBTree.");
                }
                this.fixAfterInsertion(newNode);
            }
            ++this.modCount;
            this.setSizeDelta(1);
        }
        finally {
            this.checkTreeStructure(parentNode);
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        OMVRBTreeEntry<K, V> p = this.getEntry(key, PartialSearchMode.NONE);
        this.setLastSearchNode(null, null);
        if (p == null) {
            return null;
        }
        V oldValue = p.getValue();
        this.deleteEntry(p);
        return oldValue;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.setSize(0);
        this.setLastSearchNode(null, null);
        this.setRoot(null);
    }

    @Override
    public Object clone() {
        OMVRBTree clone = null;
        try {
            clone = (OMVRBTree)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone.pageIndex = this.pageIndex;
        clone.pageItemFound = this.pageItemFound;
        clone.pageLoadFactor = this.pageLoadFactor;
        clone.root = null;
        clone.setSize(0);
        clone.modCount = 0;
        clone.entrySet = null;
        clone.navigableKeySet = null;
        clone.descendingMap = null;
        try {
            clone.buildFromSorted(this.size(), this.entrySet().iterator(), null, null);
        }
        catch (IOException cannotHappen) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clone;
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        return OMVRBTree.exportEntry(this.getFirstEntry());
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        return OMVRBTree.exportEntry(this.getLastEntry());
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        OMVRBTreeEntry<K, V> p = this.getFirstEntry();
        Map.Entry<K, V> result = OMVRBTree.exportEntry(p);
        if (p != null) {
            this.deleteEntry(p);
        }
        return result;
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        OMVRBTreeEntry<K, V> p = this.getLastEntry();
        Map.Entry<K, V> result = OMVRBTree.exportEntry(p);
        if (p != null) {
            this.deleteEntry(p);
        }
        return result;
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        return OMVRBTree.exportEntry(this.getLowerEntry(key));
    }

    @Override
    public K lowerKey(K key) {
        return OMVRBTree.keyOrNull(this.getLowerEntry(key));
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        return OMVRBTree.exportEntry(this.getFloorEntry(key, PartialSearchMode.NONE));
    }

    @Override
    public K floorKey(K key) {
        return OMVRBTree.keyOrNull(this.getFloorEntry(key, PartialSearchMode.NONE));
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        return OMVRBTree.exportEntry(this.getCeilingEntry(key, PartialSearchMode.NONE));
    }

    @Override
    public K ceilingKey(K key) {
        return OMVRBTree.keyOrNull(this.getCeilingEntry(key, PartialSearchMode.NONE));
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        return OMVRBTree.exportEntry(this.getHigherEntry(key));
    }

    @Override
    public K higherKey(K key) {
        return OMVRBTree.keyOrNull(this.getHigherEntry(key));
    }

    @Override
    public Set<K> keySet() {
        return this.navigableKeySet();
    }

    @Override
    public ONavigableSet<K> navigableKeySet() {
        KeySet<K> nks = this.navigableKeySet;
        return nks != null ? nks : (this.navigableKeySet = new KeySet(this));
    }

    @Override
    public ONavigableSet<K> descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    @Override
    public Collection<V> values() {
        Values vs = new Values();
        return vs != null ? vs : null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    @Override
    public ONavigableMap<K, V> descendingMap() {
        ONavigableMap<K, V> km = this.descendingMap;
        return km != null ? km : (this.descendingMap = new DescendingSubMap(this, true, null, true, true, null, true));
    }

    @Override
    public ONavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return new AscendingSubMap(this, false, fromKey, fromInclusive, false, toKey, toInclusive);
    }

    @Override
    public ONavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        return new AscendingSubMap(this, true, null, true, false, toKey, inclusive);
    }

    @Override
    public ONavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        return new AscendingSubMap(this, false, fromKey, inclusive, true, null, true);
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        return this.subMap(fromKey, true, toKey, false);
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        return this.headMap(toKey, false);
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        return this.tailMap(fromKey, true);
    }

    OLazyIterator<K> keyIterator() {
        return new KeyIterator(this.getFirstEntry());
    }

    OLazyIterator<K> descendingKeyIterator() {
        return new DescendingKeyIterator(this.getLastEntry());
    }

    final int compare(Object k1, Object k2) {
        return this.comparator == null ? ((Comparable)k1).compareTo(k2) : this.comparator.compare(k1, k2);
    }

    static final boolean valEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    static <K, V> Map.Entry<K, V> exportEntry(OMVRBTreeEntry<K, V> omvrbTreeEntryPosition) {
        return omvrbTreeEntryPosition == null ? null : new OSimpleImmutableEntry<K, V>(omvrbTreeEntryPosition);
    }

    static <K, V> Map.Entry<K, V> exportEntry(OMVRBTreeEntryPosition<K, V> omvrbTreeEntryPosition) {
        return omvrbTreeEntryPosition == null ? null : new OSimpleImmutableEntry(omvrbTreeEntryPosition.entry);
    }

    static <K, V> K keyOrNull(OMVRBTreeEntry<K, V> e) {
        return e == null ? null : (K)e.getKey();
    }

    static <K, V> K keyOrNull(OMVRBTreeEntryPosition<K, V> e) {
        return e == null ? null : (K)e.getKey();
    }

    static <K> K key(OMVRBTreeEntry<K, ?> e) {
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e.getKey();
    }

    protected OMVRBTreeEntry<K, V> getFirstEntry() {
        OMVRBTreeEntry<K, V> p = this.root;
        if (p != null) {
            if (p.getSize() > 0) {
                this.pageIndex = 0;
            }
            while (p.getLeft() != null) {
                p = p.getLeft();
            }
        }
        return p;
    }

    protected OMVRBTreeEntry<K, V> getLastEntry() {
        OMVRBTreeEntry<K, V> p = this.root;
        if (p != null) {
            while (p.getRight() != null) {
                p = p.getRight();
            }
        }
        if (p != null) {
            this.pageIndex = p.getSize() - 1;
        }
        return p;
    }

    public static <K, V> OMVRBTreeEntry<K, V> successor(OMVRBTreeEntryPosition<K, V> t) {
        t.entry.getTree().setPageIndex(t.position);
        return OMVRBTree.successor(t.entry);
    }

    public static <K, V> OMVRBTreeEntry<K, V> successor(OMVRBTreeEntry<K, V> t) {
        if (t == null) {
            return null;
        }
        OMVRBTreeEntry<K, V> p = null;
        if (t.getRight() != null) {
            p = t.getRight();
            while (p.getLeft() != null) {
                p = p.getLeft();
            }
        } else {
            OMVRBTreeEntry<K, V> ch = t;
            for (p = t.getParent(); p != null && ch == p.getRight(); p = p.getParent()) {
                ch = p;
            }
        }
        return p;
    }

    public static <K, V> OMVRBTreeEntry<K, V> next(OMVRBTreeEntryPosition<K, V> t) {
        t.entry.getTree().setPageIndex(t.position);
        return OMVRBTree.next(t.entry);
    }

    public static <K, V> OMVRBTreeEntry<K, V> next(OMVRBTreeEntry<K, V> t) {
        OMVRBTreeEntry<K, V> succ;
        if (t == null) {
            return null;
        }
        if (t.tree.pageIndex < t.getSize() - 1) {
            succ = t;
            ++t.tree.pageIndex;
        } else {
            succ = OMVRBTree.successor(t);
            t.tree.pageIndex = 0;
        }
        return succ;
    }

    public static <K, V> OMVRBTreeEntry<K, V> predecessor(OMVRBTreeEntryPosition<K, V> t) {
        t.entry.getTree().setPageIndex(t.position);
        return OMVRBTree.predecessor(t.entry);
    }

    public static <K, V> OMVRBTreeEntry<K, V> predecessor(OMVRBTreeEntry<K, V> t) {
        OMVRBTreeEntry<K, V> p;
        if (t == null) {
            return null;
        }
        if (t.getLeft() != null) {
            OMVRBTreeEntry<K, V> p2 = t.getLeft();
            while (p2.getRight() != null) {
                p2 = p2.getRight();
            }
            return p2;
        }
        OMVRBTreeEntry<K, V> ch = t;
        for (p = t.getParent(); p != null && ch == p.getLeft(); p = p.getParent()) {
            ch = p;
        }
        return p;
    }

    public static <K, V> OMVRBTreeEntry<K, V> previous(OMVRBTreeEntryPosition<K, V> t) {
        t.entry.getTree().setPageIndex(t.position);
        return OMVRBTree.previous(t.entry);
    }

    public static <K, V> OMVRBTreeEntry<K, V> previous(OMVRBTreeEntry<K, V> t) {
        OMVRBTreeEntry<K, V> prev;
        if (t == null) {
            return null;
        }
        int index = t.getTree().getPageIndex();
        if (index <= 0) {
            prev = OMVRBTree.predecessor(t);
            t.tree.pageIndex = prev != null ? prev.getSize() - 1 : 0;
        } else {
            prev = t;
            t.tree.pageIndex = index - 1;
        }
        return prev;
    }

    private static <K, V> boolean colorOf(OMVRBTreeEntry<K, V> p) {
        return p == null ? true : p.getColor();
    }

    private static <K, V> OMVRBTreeEntry<K, V> parentOf(OMVRBTreeEntry<K, V> p) {
        return p == null ? null : p.getParent();
    }

    private static <K, V> void setColor(OMVRBTreeEntry<K, V> p, boolean c) {
        if (p != null) {
            p.setColor(c);
        }
    }

    private static <K, V> OMVRBTreeEntry<K, V> leftOf(OMVRBTreeEntry<K, V> p) {
        return p == null ? null : p.getLeft();
    }

    private static <K, V> OMVRBTreeEntry<K, V> rightOf(OMVRBTreeEntry<K, V> p) {
        return p == null ? null : p.getRight();
    }

    protected void rotateLeft(OMVRBTreeEntry<K, V> p) {
        if (p != null) {
            OMVRBTreeEntry<K, V> r = p.getRight();
            p.setRight(r.getLeft());
            if (r.getLeft() != null) {
                r.getLeft().setParent(p);
            }
            r.setParent(p.getParent());
            if (p.getParent() == null) {
                this.setRoot(r);
            } else if (p.getParent().getLeft() == p) {
                p.getParent().setLeft(r);
            } else {
                p.getParent().setRight(r);
            }
            p.setParent(r);
            r.setLeft(p);
        }
    }

    protected void setRoot(OMVRBTreeEntry<K, V> iRoot) {
        this.root = iRoot;
    }

    protected void rotateRight(OMVRBTreeEntry<K, V> p) {
        if (p != null) {
            OMVRBTreeEntry<K, V> l = p.getLeft();
            p.setLeft(l.getRight());
            if (l.getRight() != null) {
                l.getRight().setParent(p);
            }
            l.setParent(p.getParent());
            if (p.getParent() == null) {
                this.setRoot(l);
            } else if (p.getParent().getRight() == p) {
                p.getParent().setRight(l);
            } else {
                p.getParent().setLeft(l);
            }
            l.setRight(p);
            p.setParent(l);
        }
    }

    private OMVRBTreeEntry<K, V> grandparent(OMVRBTreeEntry<K, V> n) {
        return OMVRBTree.parentOf(OMVRBTree.parentOf(n));
    }

    private OMVRBTreeEntry<K, V> uncle(OMVRBTreeEntry<K, V> n) {
        if (OMVRBTree.parentOf(n) == OMVRBTree.leftOf(this.grandparent(n))) {
            return OMVRBTree.rightOf(this.grandparent(n));
        }
        return OMVRBTree.leftOf(this.grandparent(n));
    }

    private void fixAfterInsertion(OMVRBTreeEntry<K, V> n) {
        if (OMVRBTree.parentOf(n) == null) {
            OMVRBTree.setColor(n, true);
        } else {
            this.insert_case2(n);
        }
    }

    private void insert_case2(OMVRBTreeEntry<K, V> n) {
        if (OMVRBTree.colorOf(OMVRBTree.parentOf(n))) {
            return;
        }
        this.insert_case3(n);
    }

    private void insert_case3(OMVRBTreeEntry<K, V> n) {
        if (this.uncle(n) != null && !OMVRBTree.colorOf(this.uncle(n))) {
            OMVRBTree.setColor(OMVRBTree.parentOf(n), true);
            OMVRBTree.setColor(this.uncle(n), true);
            OMVRBTree.setColor(this.grandparent(n), false);
            this.fixAfterInsertion(this.grandparent(n));
        } else {
            this.insert_case4(n);
        }
    }

    private void insert_case4(OMVRBTreeEntry<K, V> n) {
        if (n == OMVRBTree.rightOf(OMVRBTree.parentOf(n)) && OMVRBTree.parentOf(n) == OMVRBTree.leftOf(this.grandparent(n))) {
            this.rotateLeft(OMVRBTree.parentOf(n));
            n = OMVRBTree.leftOf(n);
        } else if (n == OMVRBTree.leftOf(OMVRBTree.parentOf(n)) && OMVRBTree.parentOf(n) == OMVRBTree.rightOf(this.grandparent(n))) {
            this.rotateRight(OMVRBTree.parentOf(n));
            n = OMVRBTree.rightOf(n);
        }
        this.insert_case5(n);
    }

    private void insert_case5(OMVRBTreeEntry<K, V> n) {
        OMVRBTree.setColor(OMVRBTree.parentOf(n), true);
        OMVRBTree.setColor(this.grandparent(n), false);
        if (n == OMVRBTree.leftOf(OMVRBTree.parentOf(n)) && OMVRBTree.parentOf(n) == OMVRBTree.leftOf(this.grandparent(n))) {
            this.rotateRight(this.grandparent(n));
        } else {
            this.rotateLeft(this.grandparent(n));
        }
    }

    OMVRBTreeEntry<K, V> deleteEntry(OMVRBTreeEntry<K, V> p) {
        this.setSizeDelta(-1);
        ++this.modCount;
        if (this.pageIndex > -1) {
            p.remove();
            if (p.getSize() > 0) {
                return p;
            }
        }
        OMVRBTreeEntry<K, V> next = OMVRBTree.successor(p);
        this.removeNode(p);
        return next;
    }

    protected OMVRBTreeEntry<K, V> removeNode(OMVRBTreeEntry<K, V> p) {
        OMVRBTreeEntry<K, V> replacement;
        ++this.modCount;
        if (p.getLeft() != null && p.getRight() != null) {
            OMVRBTreeEntry<K, V> s = OMVRBTree.next(p);
            p.copyFrom(s);
            p = s;
        }
        OMVRBTreeEntry<K, V> oMVRBTreeEntry = replacement = p.getLeft() != null ? p.getLeft() : p.getRight();
        if (replacement != null) {
            replacement.setParent(p.getParent());
            if (p.getParent() == null) {
                this.setRoot(replacement);
            } else if (p == p.getParent().getLeft()) {
                p.getParent().setLeft(replacement);
            } else {
                p.getParent().setRight(replacement);
            }
            p.setLeft(null);
            p.setRight(null);
            p.setParent(null);
            if (p.getColor()) {
                this.fixAfterDeletion(replacement);
            }
        } else if (p.getParent() == null) {
            this.clear();
        } else {
            if (p.getColor()) {
                this.fixAfterDeletion(p);
            }
            if (p.getParent() != null) {
                if (p == p.getParent().getLeft()) {
                    p.getParent().setLeft(null);
                } else if (p == p.getParent().getRight()) {
                    p.getParent().setRight(null);
                }
                p.setParent(null);
            }
        }
        return p;
    }

    private void fixAfterDeletion(OMVRBTreeEntry<K, V> x) {
        while (x != this.root && OMVRBTree.colorOf(x)) {
            OMVRBTreeEntry<K, V> sib;
            if (x == OMVRBTree.leftOf(OMVRBTree.parentOf(x))) {
                sib = OMVRBTree.rightOf(OMVRBTree.parentOf(x));
                if (!OMVRBTree.colorOf(sib)) {
                    OMVRBTree.setColor(sib, true);
                    OMVRBTree.setColor(OMVRBTree.parentOf(x), false);
                    this.rotateLeft(OMVRBTree.parentOf(x));
                    sib = OMVRBTree.rightOf(OMVRBTree.parentOf(x));
                }
                if (OMVRBTree.colorOf(OMVRBTree.leftOf(sib)) && OMVRBTree.colorOf(OMVRBTree.rightOf(sib))) {
                    OMVRBTree.setColor(sib, false);
                    x = OMVRBTree.parentOf(x);
                    continue;
                }
                if (OMVRBTree.colorOf(OMVRBTree.rightOf(sib))) {
                    OMVRBTree.setColor(OMVRBTree.leftOf(sib), true);
                    OMVRBTree.setColor(sib, false);
                    this.rotateRight(sib);
                    sib = OMVRBTree.rightOf(OMVRBTree.parentOf(x));
                }
                OMVRBTree.setColor(sib, OMVRBTree.colorOf(OMVRBTree.parentOf(x)));
                OMVRBTree.setColor(OMVRBTree.parentOf(x), true);
                OMVRBTree.setColor(OMVRBTree.rightOf(sib), true);
                this.rotateLeft(OMVRBTree.parentOf(x));
                x = this.root;
                continue;
            }
            sib = OMVRBTree.leftOf(OMVRBTree.parentOf(x));
            if (!OMVRBTree.colorOf(sib)) {
                OMVRBTree.setColor(sib, true);
                OMVRBTree.setColor(OMVRBTree.parentOf(x), false);
                this.rotateRight(OMVRBTree.parentOf(x));
                sib = OMVRBTree.leftOf(OMVRBTree.parentOf(x));
            }
            if (x != null && OMVRBTree.colorOf(OMVRBTree.rightOf(sib)) && OMVRBTree.colorOf(OMVRBTree.leftOf(sib))) {
                OMVRBTree.setColor(sib, false);
                x = OMVRBTree.parentOf(x);
                continue;
            }
            if (OMVRBTree.colorOf(OMVRBTree.leftOf(sib))) {
                OMVRBTree.setColor(OMVRBTree.rightOf(sib), true);
                OMVRBTree.setColor(sib, false);
                this.rotateLeft(sib);
                sib = OMVRBTree.leftOf(OMVRBTree.parentOf(x));
            }
            OMVRBTree.setColor(sib, OMVRBTree.colorOf(OMVRBTree.parentOf(x)));
            OMVRBTree.setColor(OMVRBTree.parentOf(x), true);
            OMVRBTree.setColor(OMVRBTree.leftOf(sib), true);
            this.rotateRight(OMVRBTree.parentOf(x));
            x = this.root;
        }
        OMVRBTree.setColor(x, true);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size());
        for (Map.Entry<K, V> e : this.entrySet()) {
            s.writeObject(e.getKey());
            s.writeObject(e.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.setSize(s.readInt());
        this.buildFromSorted(this.size(), null, s, null);
    }

    void readOTreeSet(int iSize, ObjectInputStream s, V defaultVal) throws IOException, ClassNotFoundException {
        this.buildFromSorted(iSize, null, s, defaultVal);
    }

    void addAllForOTreeSet(SortedSet<? extends K> set, V defaultVal) {
        try {
            this.buildFromSorted(set.size(), set.iterator(), null, defaultVal);
        }
        catch (IOException cannotHappen) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void buildFromSorted(int size, Iterator<?> it, ObjectInputStream str, V defaultVal) throws IOException, ClassNotFoundException {
        this.setSize(size);
        this.root = this.buildFromSorted(0, 0, size - 1, OMVRBTree.computeRedLevel(size), it, str, defaultVal);
    }

    private final OMVRBTreeEntry<K, V> buildFromSorted(int level, int lo, int hi, int redLevel, Iterator<?> it, ObjectInputStream str, V defaultVal) throws IOException, ClassNotFoundException {
        V value;
        Object key;
        if (hi < lo) {
            return null;
        }
        int mid = (lo + hi) / 2;
        OMVRBTreeEntry<Object, V> left = null;
        if (lo < mid) {
            left = this.buildFromSorted(level + 1, lo, mid - 1, redLevel, it, str, defaultVal);
        }
        if (it != null) {
            if (defaultVal == null) {
                OMVRBTreeEntry entry = (OMVRBTreeEntry)it.next();
                key = entry.getKey();
                value = entry.getValue();
            } else {
                key = it.next();
                value = defaultVal;
            }
        } else {
            key = str.readObject();
            value = defaultVal != null ? defaultVal : str.readObject();
        }
        OMVRBTreeEntry<Object, V> middle = this.createEntry(key, value);
        if (level == redLevel) {
            middle.setColor(false);
        }
        if (left != null) {
            middle.setLeft(left);
            left.setParent(middle);
        }
        if (mid < hi) {
            OMVRBTreeEntry<Object, V> right = this.buildFromSorted(level + 1, mid + 1, hi, redLevel, it, str, defaultVal);
            middle.setRight(right);
            right.setParent(middle);
        }
        return middle;
    }

    private static int computeRedLevel(int sz) {
        int level = 0;
        int m = sz - 1;
        while (m >= 0) {
            ++level;
            m = m / 2 - 1;
        }
        return level;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(int iPageIndex) {
        this.pageIndex = iPageIndex;
    }

    private void init() {
    }

    public OMVRBTreeEntry<K, V> getRoot() {
        return this.root;
    }

    protected void printInMemoryStructure(OMVRBTreeEntry<K, V> iRootNode) {
        this.printInMemoryNode("root", iRootNode, 0);
    }

    private void printInMemoryNode(String iLabel, OMVRBTreeEntry<K, V> iNode, int iLevel) {
        if (iNode == null) {
            return;
        }
        for (int i = 0; i < iLevel; ++i) {
            System.out.print(' ');
        }
        System.out.println(iLabel + ": " + iNode.toString() + " (" + (iNode.getColor() ? "B" : "R") + ")");
        this.printInMemoryNode(++iLevel + ".left", iNode.getLeftInMemory(), iLevel);
        this.printInMemoryNode(iLevel + ".right", iNode.getRightInMemory(), iLevel);
    }

    public void checkTreeStructure(OMVRBTreeEntry<K, V> iRootNode) {
        if (!this.runtimeCheckEnabled || iRootNode == null) {
            return;
        }
        int currPageIndex = this.pageIndex;
        OMVRBTreeEntry<K, V> prevNode = null;
        int i = 0;
        for (OMVRBTreeEntry<K, V> e = iRootNode.getFirstInMemory(); e != null; e = e.getNextInMemory()) {
            if (e.getSize() == 0) {
                OLogManager.instance().error((Object)this, "[OMVRBTree.checkTreeStructure] Node %s has 0 items\n", e);
            }
            if (prevNode != null) {
                if (prevNode.getTree() == null) {
                    OLogManager.instance().error((Object)this, "[OMVRBTree.checkTreeStructure] Freed record %d found in memory\n", i);
                }
                if (this.compare(e.getFirstKey(), e.getLastKey()) > 0) {
                    OLogManager.instance().error((Object)this, "[OMVRBTree.checkTreeStructure] begin key is > than last key\n", e.getFirstKey(), e.getLastKey());
                    this.printInMemoryStructure(iRootNode);
                }
                if (this.compare(e.getFirstKey(), prevNode.getLastKey()) < 0) {
                    OLogManager.instance().error((Object)this, "[OMVRBTree.checkTreeStructure] Node %s starts with a key minor than the last key of the previous node %s\n", e, prevNode);
                    this.printInMemoryStructure(e.getParentInMemory() != null ? e.getParentInMemory() : e);
                }
            }
            if (e.getLeftInMemory() != null && e.getLeftInMemory() == e) {
                OLogManager.instance().error((Object)this, "[OMVRBTree.checkTreeStructure] Node %s has left that points to itself!\n", e);
                this.printInMemoryStructure(iRootNode);
            }
            if (e.getRightInMemory() != null && e.getRightInMemory() == e) {
                OLogManager.instance().error((Object)this, "[OMVRBTree.checkTreeStructure] Node %s has right that points to itself!\n", e);
                this.printInMemoryStructure(iRootNode);
            }
            if (e.getLeftInMemory() != null && e.getLeftInMemory() == e.getRightInMemory()) {
                OLogManager.instance().error((Object)this, "[OMVRBTree.checkTreeStructure] Node %s has left and right equals!\n", e);
                this.printInMemoryStructure(iRootNode);
            }
            if (e.getParentInMemory() != null && e.getParentInMemory().getRightInMemory() != e && e.getParentInMemory().getLeftInMemory() != e) {
                OLogManager.instance().error((Object)this, "[OMVRBTree.checkTreeStructure] Node %s is the children of node %s but the cross-reference is missed!\n", e, e.getParentInMemory());
                this.printInMemoryStructure(iRootNode);
            }
            prevNode = e;
            ++i;
        }
        this.pageIndex = currPageIndex;
    }

    public boolean isRuntimeCheckEnabled() {
        return this.runtimeCheckEnabled;
    }

    public void setChecks(boolean checks) {
        this.runtimeCheckEnabled = checks;
    }

    public void setRuntimeCheckEnabled(boolean runtimeCheckEnabled) {
        this.runtimeCheckEnabled = runtimeCheckEnabled;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    protected OMVRBTreeEntry<K, V> getLastSearchNodeForSameKey(Object key) {
        if (key != null && this.lastSearchKey != null) {
            if (key instanceof OCompositeKey) {
                return key.equals(this.lastSearchKey) ? this.lastSearchNode : null;
            }
            if (this.comparator != null) {
                return this.comparator.compare(key, this.lastSearchKey) == 0 ? this.lastSearchNode : null;
            }
            try {
                return ((Comparable)key).compareTo(this.lastSearchKey) == 0 ? this.lastSearchNode : null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected OMVRBTreeEntry<K, V> setLastSearchNode(Object iKey, OMVRBTreeEntry<K, V> iNode) {
        this.lastSearchKey = iKey;
        this.lastSearchNode = iNode;
        this.lastSearchFound = iNode != null ? iNode.tree.pageItemFound : false;
        this.lastSearchIndex = iNode != null ? iNode.tree.pageIndex : -1;
        return iNode;
    }

    protected void searchNodeCallback() {
    }

    protected void setSizeDelta(int iDelta) {
        this.setSize(this.size() + iDelta);
    }

    static final class DescendingSubMap<K, V>
    extends NavigableSubMap<K, V> {
        private static final long serialVersionUID = 912986545866120460L;
        private final Comparator<? super K> reverseComparator;

        DescendingSubMap(OMVRBTree<K, V> m, boolean fromStart, K lo, boolean loInclusive, boolean toEnd, K hi, boolean hiInclusive) {
            super(m, fromStart, lo, loInclusive, toEnd, hi, hiInclusive);
            this.reverseComparator = Collections.reverseOrder(this.m.comparator);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.reverseComparator;
        }

        @Override
        public ONavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            if (!this.inRange(fromKey, fromInclusive)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            if (!this.inRange(toKey, toInclusive)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new DescendingSubMap<K, V>(this.m, false, toKey, toInclusive, false, fromKey, fromInclusive);
        }

        @Override
        public ONavigableMap<K, V> headMap(K toKey, boolean inclusive) {
            if (!this.inRange(toKey, inclusive)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new DescendingSubMap<Object, V>(this.m, false, toKey, inclusive, this.toEnd, this.hi, this.hiInclusive);
        }

        @Override
        public ONavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
            if (!this.inRange(fromKey, inclusive)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            return new DescendingSubMap<Object, V>(this.m, this.fromStart, this.lo, this.loInclusive, false, fromKey, inclusive);
        }

        @Override
        public ONavigableMap<K, V> descendingMap() {
            AscendingSubMap mv = this.descendingMapView;
            return mv != null ? mv : (this.descendingMapView = new AscendingSubMap(this.m, this.fromStart, this.lo, this.loInclusive, this.toEnd, this.hi, this.hiInclusive));
        }

        @Override
        OLazyIterator<K> keyIterator() {
            return new NavigableSubMap.DescendingSubMapKeyIterator(this.absHighest(), this.absLowFence());
        }

        @Override
        OLazyIterator<K> descendingKeyIterator() {
            return new NavigableSubMap.SubMapKeyIterator(this.absLowest(), this.absHighFence());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            NavigableSubMap.EntrySetView es = this.entrySetView;
            return es != null ? es : new DescendingEntrySetView();
        }

        @Override
        OMVRBTreeEntry<K, V> subLowest() {
            return this.absHighest().entry;
        }

        @Override
        OMVRBTreeEntry<K, V> subHighest() {
            return this.absLowest().entry;
        }

        @Override
        OMVRBTreeEntry<K, V> subCeiling(K key) {
            return this.absFloor(key).entry;
        }

        @Override
        OMVRBTreeEntry<K, V> subHigher(K key) {
            return this.absLower(key).entry;
        }

        @Override
        OMVRBTreeEntry<K, V> subFloor(K key) {
            return this.absCeiling(key).entry;
        }

        @Override
        OMVRBTreeEntry<K, V> subLower(K key) {
            return this.absHigher(key).entry;
        }

        final class DescendingEntrySetView
        extends NavigableSubMap.EntrySetView {
            DescendingEntrySetView() {
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new NavigableSubMap.DescendingSubMapEntryIterator(DescendingSubMap.this.absHighest(), DescendingSubMap.this.absLowFence());
            }
        }
    }

    static final class AscendingSubMap<K, V>
    extends NavigableSubMap<K, V> {
        private static final long serialVersionUID = 912986545866124060L;

        AscendingSubMap(OMVRBTree<K, V> m, boolean fromStart, K lo, boolean loInclusive, boolean toEnd, K hi, boolean hiInclusive) {
            super(m, fromStart, lo, loInclusive, toEnd, hi, hiInclusive);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.m.comparator();
        }

        @Override
        public ONavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            if (!this.inRange(fromKey, fromInclusive)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            if (!this.inRange(toKey, toInclusive)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new AscendingSubMap<K, V>(this.m, false, fromKey, fromInclusive, false, toKey, toInclusive);
        }

        @Override
        public ONavigableMap<K, V> headMap(K toKey, boolean inclusive) {
            if (!this.inRange(toKey, inclusive)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new AscendingSubMap<Object, V>(this.m, this.fromStart, this.lo, this.loInclusive, false, toKey, inclusive);
        }

        @Override
        public ONavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
            if (!this.inRange(fromKey, inclusive)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            return new AscendingSubMap<Object, V>(this.m, false, fromKey, inclusive, this.toEnd, this.hi, this.hiInclusive);
        }

        @Override
        public ONavigableMap<K, V> descendingMap() {
            DescendingSubMap mv = this.descendingMapView;
            return mv != null ? mv : (this.descendingMapView = new DescendingSubMap(this.m, this.fromStart, this.lo, this.loInclusive, this.toEnd, this.hi, this.hiInclusive));
        }

        @Override
        OLazyIterator<K> keyIterator() {
            return new NavigableSubMap.SubMapKeyIterator(this.absLowest(), this.absHighFence());
        }

        @Override
        OLazyIterator<K> descendingKeyIterator() {
            return new NavigableSubMap.DescendingSubMapKeyIterator(this.absHighest(), this.absLowFence());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            NavigableSubMap.EntrySetView es = this.entrySetView;
            return es != null ? es : new AscendingEntrySetView();
        }

        @Override
        OMVRBTreeEntry<K, V> subLowest() {
            return this.absLowest().entry;
        }

        @Override
        OMVRBTreeEntry<K, V> subHighest() {
            return this.absHighest().entry;
        }

        @Override
        OMVRBTreeEntry<K, V> subCeiling(K key) {
            return this.absCeiling(key).entry;
        }

        @Override
        OMVRBTreeEntry<K, V> subHigher(K key) {
            return this.absHigher(key).entry;
        }

        @Override
        OMVRBTreeEntry<K, V> subFloor(K key) {
            return this.absFloor(key).entry;
        }

        @Override
        OMVRBTreeEntry<K, V> subLower(K key) {
            return this.absLower(key).entry;
        }

        final class AscendingEntrySetView
        extends NavigableSubMap.EntrySetView {
            AscendingEntrySetView() {
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new NavigableSubMap.SubMapEntryIterator(AscendingSubMap.this.absLowest(), AscendingSubMap.this.absHighFence());
            }
        }
    }

    static abstract class NavigableSubMap<K, V>
    extends AbstractMap<K, V>
    implements ONavigableMap<K, V>,
    Serializable {
        final OMVRBTree<K, V> m;
        final K lo;
        final K hi;
        final boolean fromStart;
        final boolean toEnd;
        final boolean loInclusive;
        final boolean hiInclusive;
        transient ONavigableMap<K, V> descendingMapView = null;
        transient EntrySetView entrySetView = null;
        transient KeySet<K> navigableKeySetView = null;

        NavigableSubMap(OMVRBTree<K, V> m, boolean fromStart, K lo, boolean loInclusive, boolean toEnd, K hi, boolean hiInclusive) {
            if (!fromStart && !toEnd) {
                if (m.compare(lo, hi) > 0) {
                    throw new IllegalArgumentException("fromKey > toKey");
                }
            } else {
                if (!fromStart) {
                    m.compare(lo, lo);
                }
                if (!toEnd) {
                    m.compare(hi, hi);
                }
            }
            this.m = m;
            this.fromStart = fromStart;
            this.lo = lo;
            this.loInclusive = loInclusive;
            this.toEnd = toEnd;
            this.hi = hi;
            this.hiInclusive = hiInclusive;
        }

        final boolean tooLow(Object key) {
            int c;
            return !this.fromStart && ((c = this.m.compare(key, this.lo)) < 0 || c == 0 && !this.loInclusive);
        }

        final boolean tooHigh(Object key) {
            int c;
            return !this.toEnd && ((c = this.m.compare(key, this.hi)) > 0 || c == 0 && !this.hiInclusive);
        }

        final boolean inRange(Object key) {
            return !this.tooLow(key) && !this.tooHigh(key);
        }

        final boolean inClosedRange(Object key) {
            return !(!this.fromStart && this.m.compare(key, this.lo) < 0 || !this.toEnd && this.m.compare(this.hi, key) < 0);
        }

        final boolean inRange(Object key, boolean inclusive) {
            return inclusive ? this.inRange(key) : this.inClosedRange(key);
        }

        final OMVRBTreeEntryPosition<K, V> absLowest() {
            OMVRBTreeEntry<K, V> e = this.fromStart ? this.m.getFirstEntry() : (this.loInclusive ? this.m.getCeilingEntry(this.lo, PartialSearchMode.LOWEST_BOUNDARY) : this.m.getHigherEntry(this.lo));
            return e == null || this.tooHigh(e.getKey()) ? null : new OMVRBTreeEntryPosition<K, V>(e);
        }

        final OMVRBTreeEntryPosition<K, V> absHighest() {
            OMVRBTreeEntry<K, V> e = this.toEnd ? this.m.getLastEntry() : (this.hiInclusive ? this.m.getFloorEntry(this.hi, PartialSearchMode.HIGHEST_BOUNDARY) : this.m.getLowerEntry(this.hi));
            return e == null || this.tooLow(e.getKey()) ? null : new OMVRBTreeEntryPosition<K, V>(e);
        }

        final OMVRBTreeEntryPosition<K, V> absCeiling(K key) {
            if (this.tooLow(key)) {
                return this.absLowest();
            }
            OMVRBTreeEntry<K, V> e = this.m.getCeilingEntry(key, PartialSearchMode.NONE);
            return e == null || this.tooHigh(e.getKey()) ? null : new OMVRBTreeEntryPosition<K, V>(e);
        }

        final OMVRBTreeEntryPosition<K, V> absHigher(K key) {
            if (this.tooLow(key)) {
                return this.absLowest();
            }
            OMVRBTreeEntry<K, V> e = this.m.getHigherEntry(key);
            return e == null || this.tooHigh(e.getKey()) ? null : new OMVRBTreeEntryPosition<K, V>(e);
        }

        final OMVRBTreeEntryPosition<K, V> absFloor(K key) {
            if (this.tooHigh(key)) {
                return this.absHighest();
            }
            OMVRBTreeEntry<K, V> e = this.m.getFloorEntry(key, PartialSearchMode.NONE);
            return e == null || this.tooLow(e.getKey()) ? null : new OMVRBTreeEntryPosition<K, V>(e);
        }

        final OMVRBTreeEntryPosition<K, V> absLower(K key) {
            if (this.tooHigh(key)) {
                return this.absHighest();
            }
            OMVRBTreeEntry<K, V> e = this.m.getLowerEntry(key);
            return e == null || this.tooLow(e.getKey()) ? null : new OMVRBTreeEntryPosition<K, V>(e);
        }

        final OMVRBTreeEntryPosition<K, V> absHighFence() {
            return this.toEnd ? null : new OMVRBTreeEntryPosition<K, V>(this.hiInclusive ? this.m.getHigherEntry(this.hi) : this.m.getCeilingEntry(this.hi, PartialSearchMode.LOWEST_BOUNDARY));
        }

        final OMVRBTreeEntryPosition<K, V> absLowFence() {
            return this.fromStart ? null : new OMVRBTreeEntryPosition<K, V>(this.loInclusive ? this.m.getLowerEntry(this.lo) : this.m.getFloorEntry(this.lo, PartialSearchMode.HIGHEST_BOUNDARY));
        }

        abstract OMVRBTreeEntry<K, V> subLowest();

        abstract OMVRBTreeEntry<K, V> subHighest();

        abstract OMVRBTreeEntry<K, V> subCeiling(K var1);

        abstract OMVRBTreeEntry<K, V> subHigher(K var1);

        abstract OMVRBTreeEntry<K, V> subFloor(K var1);

        abstract OMVRBTreeEntry<K, V> subLower(K var1);

        abstract OLazyIterator<K> keyIterator();

        abstract OLazyIterator<K> descendingKeyIterator();

        @Override
        public boolean isEmpty() {
            return this.fromStart && this.toEnd ? this.m.isEmpty() : this.entrySet().isEmpty();
        }

        @Override
        public int size() {
            return this.fromStart && this.toEnd ? this.m.size() : this.entrySet().size();
        }

        @Override
        public final boolean containsKey(Object key) {
            return this.inRange(key) && this.m.containsKey(key);
        }

        @Override
        public final V put(K key, V value) {
            if (!this.inRange(key)) {
                throw new IllegalArgumentException("key out of range");
            }
            return this.m.put(key, value);
        }

        @Override
        public final V get(Object key) {
            return !this.inRange(key) ? null : (V)this.m.get(key);
        }

        @Override
        public final V remove(Object key) {
            return !this.inRange(key) ? null : (V)this.m.remove(key);
        }

        @Override
        public final Map.Entry<K, V> ceilingEntry(K key) {
            return OMVRBTree.exportEntry(this.subCeiling(key));
        }

        @Override
        public final K ceilingKey(K key) {
            return OMVRBTree.keyOrNull(this.subCeiling(key));
        }

        @Override
        public final Map.Entry<K, V> higherEntry(K key) {
            return OMVRBTree.exportEntry(this.subHigher(key));
        }

        @Override
        public final K higherKey(K key) {
            return OMVRBTree.keyOrNull(this.subHigher(key));
        }

        @Override
        public final Map.Entry<K, V> floorEntry(K key) {
            return OMVRBTree.exportEntry(this.subFloor(key));
        }

        @Override
        public final K floorKey(K key) {
            return OMVRBTree.keyOrNull(this.subFloor(key));
        }

        @Override
        public final Map.Entry<K, V> lowerEntry(K key) {
            return OMVRBTree.exportEntry(this.subLower(key));
        }

        @Override
        public final K lowerKey(K key) {
            return OMVRBTree.keyOrNull(this.subLower(key));
        }

        @Override
        public final K firstKey() {
            return OMVRBTree.key(this.subLowest());
        }

        @Override
        public final K lastKey() {
            return OMVRBTree.key(this.subHighest());
        }

        @Override
        public final Map.Entry<K, V> firstEntry() {
            return OMVRBTree.exportEntry(this.subLowest());
        }

        @Override
        public final Map.Entry<K, V> lastEntry() {
            return OMVRBTree.exportEntry(this.subHighest());
        }

        @Override
        public final Map.Entry<K, V> pollFirstEntry() {
            OMVRBTreeEntry<K, V> e = this.subLowest();
            Map.Entry<K, V> result = OMVRBTree.exportEntry(e);
            if (e != null) {
                this.m.deleteEntry(e);
            }
            return result;
        }

        @Override
        public final Map.Entry<K, V> pollLastEntry() {
            OMVRBTreeEntry<K, V> e = this.subHighest();
            Map.Entry<K, V> result = OMVRBTree.exportEntry(e);
            if (e != null) {
                this.m.deleteEntry(e);
            }
            return result;
        }

        @Override
        public final ONavigableSet<K> navigableKeySet() {
            KeySet<K> nksv = this.navigableKeySetView;
            return nksv != null ? nksv : (this.navigableKeySetView = new KeySet(this));
        }

        @Override
        public final Set<K> keySet() {
            return this.navigableKeySet();
        }

        @Override
        public ONavigableSet<K> descendingKeySet() {
            return this.descendingMap().navigableKeySet();
        }

        @Override
        public final SortedMap<K, V> subMap(K fromKey, K toKey) {
            return this.subMap(fromKey, true, toKey, false);
        }

        @Override
        public final SortedMap<K, V> headMap(K toKey) {
            return this.headMap(toKey, false);
        }

        @Override
        public final SortedMap<K, V> tailMap(K fromKey) {
            return this.tailMap(fromKey, true);
        }

        final class DescendingSubMapKeyIterator
        extends SubMapIterator<K> {
            DescendingSubMapKeyIterator(OMVRBTreeEntryPosition<K, V> last, OMVRBTreeEntryPosition<K, V> fence) {
                super(last, fence);
            }

            @Override
            public K next() {
                return this.prevEntry().getKey();
            }

            @Override
            public void remove() {
                this.removeDescending();
            }
        }

        final class DescendingSubMapEntryIterator
        extends SubMapIterator<Map.Entry<K, V>> {
            DescendingSubMapEntryIterator(OMVRBTreeEntryPosition<K, V> last, OMVRBTreeEntryPosition<K, V> fence) {
                super(last, fence);
            }

            @Override
            public Map.Entry<K, V> next() {
                Map.Entry e = OMVRBTree.exportEntry(this.next);
                this.prevEntry();
                return e;
            }

            @Override
            public void remove() {
                this.removeDescending();
            }
        }

        final class SubMapKeyIterator
        extends SubMapIterator<K> {
            SubMapKeyIterator(OMVRBTreeEntryPosition<K, V> first, OMVRBTreeEntryPosition<K, V> fence) {
                super(first, fence);
            }

            @Override
            public K next() {
                return this.nextEntry().getKey();
            }

            @Override
            public void remove() {
                this.removeAscending();
            }
        }

        final class SubMapEntryIterator
        extends SubMapIterator<Map.Entry<K, V>> {
            SubMapEntryIterator(OMVRBTreeEntryPosition<K, V> first, OMVRBTreeEntryPosition<K, V> fence) {
                super(first, fence);
            }

            @Override
            public Map.Entry<K, V> next() {
                Map.Entry e = OMVRBTree.exportEntry(this.next);
                this.nextEntry();
                return e;
            }

            @Override
            public void remove() {
                this.removeAscending();
            }
        }

        abstract class SubMapIterator<T>
        implements OLazyIterator<T> {
            OMVRBTreeEntryPosition<K, V> lastReturned;
            OMVRBTreeEntryPosition<K, V> next;
            final K fenceKey;
            int expectedModCount;

            SubMapIterator(OMVRBTreeEntryPosition<K, V> first, OMVRBTreeEntryPosition<K, V> fence) {
                this.expectedModCount = NavigableSubMap.this.m.modCount;
                this.lastReturned = null;
                this.next = first;
                this.fenceKey = fence == null ? null : fence.getKey();
            }

            @Override
            public final boolean hasNext() {
                if (this.next != null) {
                    Object k = this.next.getKey();
                    return k != this.fenceKey && !k.equals(this.fenceKey);
                }
                return false;
            }

            final OMVRBTreeEntryPosition<K, V> nextEntry() {
                OMVRBTreeEntryPosition e = this.next != null ? new OMVRBTreeEntryPosition(this.next) : null;
                if (e == null || e.entry == null) {
                    throw new NoSuchElementException();
                }
                Object k = e.getKey();
                if (k == this.fenceKey || k.equals(this.fenceKey)) {
                    throw new NoSuchElementException();
                }
                if (NavigableSubMap.this.m.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                this.next.assign(OMVRBTree.next(e));
                this.lastReturned = e;
                return e;
            }

            final OMVRBTreeEntryPosition<K, V> prevEntry() {
                OMVRBTreeEntryPosition e = this.next != null ? new OMVRBTreeEntryPosition(this.next) : null;
                if (e == null || e.entry == null) {
                    throw new NoSuchElementException();
                }
                Object k = e.getKey();
                if (k == this.fenceKey || k.equals(this.fenceKey)) {
                    throw new NoSuchElementException();
                }
                if (NavigableSubMap.this.m.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                this.next.assign(OMVRBTree.previous(e));
                this.lastReturned = e;
                return e;
            }

            @Override
            public final T update(T iValue) {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                if (NavigableSubMap.this.m.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                return this.lastReturned.entry.setValue(iValue);
            }

            final void removeAscending() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                if (NavigableSubMap.this.m.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.lastReturned.entry.getLeft() != null && this.lastReturned.entry.getRight() != null) {
                    this.next = this.lastReturned;
                }
                NavigableSubMap.this.m.deleteEntry(this.lastReturned.entry);
                this.lastReturned = null;
                this.expectedModCount = NavigableSubMap.this.m.modCount;
            }

            final void removeDescending() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                if (NavigableSubMap.this.m.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                NavigableSubMap.this.m.deleteEntry(this.lastReturned.entry);
                this.lastReturned = null;
                this.expectedModCount = NavigableSubMap.this.m.modCount;
            }
        }

        abstract class EntrySetView
        extends AbstractSet<Map.Entry<K, V>> {
            private transient int size = -1;
            private transient int sizeModCount;

            EntrySetView() {
            }

            @Override
            public int size() {
                if (NavigableSubMap.this.fromStart && NavigableSubMap.this.toEnd) {
                    return NavigableSubMap.this.m.size();
                }
                if (this.size == -1 || this.sizeModCount != NavigableSubMap.this.m.modCount) {
                    this.sizeModCount = NavigableSubMap.this.m.modCount;
                    this.size = 0;
                    Iterator i = this.iterator();
                    while (i.hasNext()) {
                        ++this.size;
                        i.next();
                    }
                }
                return this.size;
            }

            @Override
            public boolean isEmpty() {
                OMVRBTreeEntryPosition n = NavigableSubMap.this.absLowest();
                return n == null || NavigableSubMap.this.tooHigh(n.getKey());
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof OMVRBTreeEntry)) {
                    return false;
                }
                OMVRBTreeEntry entry = (OMVRBTreeEntry)o;
                Object key = entry.getKey();
                if (!NavigableSubMap.this.inRange(key)) {
                    return false;
                }
                Object nodeValue = NavigableSubMap.this.m.get(key);
                return nodeValue != null && OMVRBTree.valEquals(nodeValue, entry.getValue());
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof OMVRBTreeEntry)) {
                    return false;
                }
                OMVRBTreeEntry entry = (OMVRBTreeEntry)o;
                Object key = entry.getKey();
                if (!NavigableSubMap.this.inRange(key)) {
                    return false;
                }
                OMVRBTreeEntry node = NavigableSubMap.this.m.getEntry(key, PartialSearchMode.NONE);
                if (node != null && OMVRBTree.valEquals(node.getValue(), entry.getValue())) {
                    NavigableSubMap.this.m.deleteEntry(node);
                    return true;
                }
                return false;
            }
        }
    }

    final class DescendingKeyIterator
    extends AbstractEntryIterator<K, V, K> {
        DescendingKeyIterator(OMVRBTreeEntry<K, V> first) {
            super(first);
        }

        @Override
        public K next() {
            return this.prevEntry().getKey();
        }
    }

    final class KeyIterator
    extends AbstractEntryIterator<K, V, K> {
        KeyIterator(OMVRBTreeEntry<K, V> first) {
            super(first);
        }

        @Override
        public K next() {
            return this.nextKey();
        }
    }

    final class ValueInverseIterator
    extends AbstractEntryIterator<K, V, V> {
        ValueInverseIterator(OMVRBTreeEntry<K, V> last) {
            super(last);
            if (last != null) {
                this.pageIndex = last.getTree().getPageIndex() + 1;
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasPrevious();
        }

        @Override
        public V next() {
            return this.prevValue();
        }
    }

    final class ValueIterator
    extends AbstractEntryIterator<K, V, V> {
        ValueIterator(OMVRBTreeEntry<K, V> first) {
            super(first);
        }

        @Override
        public V next() {
            return this.nextValue();
        }
    }

    final class InverseEntryIterator
    extends AbstractEntryIterator<K, V, Map.Entry<K, V>> {
        InverseEntryIterator(OMVRBTreeEntry<K, V> last) {
            super(last);
            if (last != null) {
                this.pageIndex = last.getTree().getPageIndex() + 1;
            }
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.prevEntry();
        }
    }

    final class EntryIterator
    extends AbstractEntryIterator<K, V, Map.Entry<K, V>> {
        EntryIterator(OMVRBTreeEntry<K, V> first) {
            super(first);
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    static final class KeySet<E>
    extends AbstractSet<E>
    implements ONavigableSet<E> {
        private final ONavigableMap<E, Object> m;

        KeySet(ONavigableMap<E, Object> map) {
            this.m = map;
        }

        @Override
        public OLazyIterator<E> iterator() {
            if (this.m instanceof OMVRBTree) {
                return ((OMVRBTree)this.m).keyIterator();
            }
            return ((NavigableSubMap)this.m).keyIterator();
        }

        @Override
        public OLazyIterator<E> descendingIterator() {
            if (this.m instanceof OMVRBTree) {
                return ((OMVRBTree)this.m).descendingKeyIterator();
            }
            return ((NavigableSubMap)this.m).descendingKeyIterator();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.m.containsKey(o);
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public E lower(E e) {
            return this.m.lowerKey(e);
        }

        @Override
        public E floor(E e) {
            return this.m.floorKey(e);
        }

        @Override
        public E ceiling(E e) {
            return this.m.ceilingKey(e);
        }

        @Override
        public E higher(E e) {
            return this.m.higherKey(e);
        }

        @Override
        public E first() {
            return (E)this.m.firstKey();
        }

        @Override
        public E last() {
            return (E)this.m.lastKey();
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.m.comparator();
        }

        @Override
        public E pollFirst() {
            Map.Entry<E, Object> e = this.m.pollFirstEntry();
            return e == null ? null : (E)e.getKey();
        }

        @Override
        public E pollLast() {
            Map.Entry<E, Object> e = this.m.pollLastEntry();
            return e == null ? null : (E)e.getKey();
        }

        @Override
        public boolean remove(Object o) {
            int oldSize = this.size();
            this.m.remove(o);
            return this.size() != oldSize;
        }

        @Override
        public ONavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
            return new OMVRBTreeSet<E>(this.m.subMap(fromElement, fromInclusive, toElement, toInclusive));
        }

        @Override
        public ONavigableSet<E> headSet(E toElement, boolean inclusive) {
            return new OMVRBTreeSet<E>(this.m.headMap(toElement, inclusive));
        }

        @Override
        public ONavigableSet<E> tailSet(E fromElement, boolean inclusive) {
            return new OMVRBTreeSet<E>(this.m.tailMap(fromElement, inclusive));
        }

        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            return this.subSet(fromElement, true, toElement, false);
        }

        @Override
        public SortedSet<E> headSet(E toElement) {
            return this.headSet(toElement, false);
        }

        @Override
        public SortedSet<E> tailSet(E fromElement) {
            return this.tailSet(fromElement, true);
        }

        @Override
        public ONavigableSet<E> descendingSet() {
            return new OMVRBTreeSet<E>(this.m.descendingMap());
        }
    }

    public class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(OMVRBTree.this.getFirstEntry());
        }

        public Iterator<Map.Entry<K, V>> inverseIterator() {
            return new InverseEntryIterator(OMVRBTree.this.getLastEntry());
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            OMVRBTreeEntry entry = (OMVRBTreeEntry)o;
            Object value = entry.getValue();
            Object p = OMVRBTree.this.get(entry.getKey());
            return p != null && OMVRBTree.valEquals(p, value);
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            OMVRBTreeEntry entry = (OMVRBTreeEntry)o;
            Object value = entry.getValue();
            OMVRBTreeEntry p = OMVRBTree.this.getEntry(entry.getKey(), PartialSearchMode.NONE);
            if (p != null && OMVRBTree.valEquals(p.getValue(), value)) {
                OMVRBTree.this.deleteEntry(p);
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return OMVRBTree.this.size();
        }

        @Override
        public void clear() {
            OMVRBTree.this.clear();
        }
    }

    public class Values
    extends AbstractCollection<V> {
        @Override
        public Iterator<V> iterator() {
            return new ValueIterator(OMVRBTree.this.getFirstEntry());
        }

        public Iterator<V> inverseIterator() {
            return new ValueInverseIterator(OMVRBTree.this.getLastEntry());
        }

        @Override
        public int size() {
            return OMVRBTree.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return OMVRBTree.this.containsValue(o);
        }

        @Override
        public boolean remove(Object o) {
            OMVRBTreeEntry e = OMVRBTree.this.getFirstEntry();
            while (e != null) {
                if (OMVRBTree.valEquals(e.getValue(), o)) {
                    OMVRBTree.this.deleteEntry(e);
                    return true;
                }
                e = OMVRBTree.next(e);
            }
            return false;
        }

        @Override
        public void clear() {
            OMVRBTree.this.clear();
        }
    }

    public static enum PartialSearchMode {
        NONE,
        HIGHEST_BOUNDARY,
        LOWEST_BOUNDARY;

    }
}

