/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage;

import com.microsoft.azure.storage.BatchSubResponse;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.core.Utility;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BatchException
extends StorageException {
    private final Map<?, ?> successfulResponses;
    private final Map<?, StorageException> exceptions;

    BatchException(Map<?, ?> successfulResponses, Map<?, BatchSubResponse> failedResponses, OperationContext opContext) {
        super("Batch exception", "One ore more requests in a batch operation failed", null);
        HashMap exceptions = new HashMap(failedResponses.size());
        for (Map.Entry<?, BatchSubResponse> response : failedResponses.entrySet()) {
            StringBuilder builder = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(response.getValue().getBody(), StandardCharsets.UTF_8));){
                int character;
                while ((character = ((Reader)reader).read()) != -1) {
                    builder.append((char)character);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            StorageException exception = new StorageException(response.getValue().getStatusMessage(), builder.toString(), response.getValue().getStatusCode(), null, null);
            Utility.logHttpError(exception, opContext);
            exceptions.put(response.getKey(), exception);
        }
        this.successfulResponses = Collections.unmodifiableMap(successfulResponses);
        this.exceptions = Collections.unmodifiableMap(exceptions);
    }

    public Map<?, ?> getSuccessfulResponses() {
        return this.successfulResponses;
    }

    public Map<?, StorageException> getExceptions() {
        return this.exceptions;
    }
}

