/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.jbig2.decoder.mmr;

import com.levigo.jbig2.Bitmap;
import com.levigo.jbig2.decoder.mmr.MMRConstants;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.stream.ImageInputStream;

public class MMRDecompressor {
    private int width;
    private int height;
    private static final int FIRST_LEVEL_TABLE_SIZE = 8;
    private static final int FIRST_LEVEL_TABLE_MASK = 255;
    private static final int SECOND_LEVEL_TABLE_SIZE = 5;
    private static final int SECOND_LEVEL_TABLE_MASK = 31;
    private static Code[] whiteTable = null;
    private static Code[] blackTable = null;
    private static Code[] modeTable = null;
    private RunData data;

    private static final synchronized void initTables() {
        if (null == whiteTable) {
            whiteTable = MMRDecompressor.createLittleEndianTable(MMRConstants.WhiteCodes);
            blackTable = MMRDecompressor.createLittleEndianTable(MMRConstants.BlackCodes);
            modeTable = MMRDecompressor.createLittleEndianTable(MMRConstants.ModeCodes);
        }
    }

    private final int uncompress2D(RunData runData, int[] nArray, int n, int[] nArray2, int n2) {
        Code code;
        int n3;
        block26: {
            int n4 = 0;
            n3 = 0;
            int n5 = 0;
            boolean bl = true;
            code = null;
            int n6 = n2;
            nArray[n + 1] = n6;
            nArray[n] = n6;
            int n7 = n2 + 1;
            nArray[n + 3] = n7;
            nArray[n + 2] = n7;
            try {
                block13: while (n5 < n2) {
                    code = runData.uncompressGetCode(MMRDecompressor.modeTable);
                    if (code == null) {
                        ++runData.offset;
                        break;
                    }
                    runData.offset += code.bitLength;
                    switch (code.runLength) {
                        case 2: {
                            n5 = nArray[n4];
                            break;
                        }
                        case 3: {
                            n5 = nArray[n4] + 1;
                            break;
                        }
                        case 6: {
                            n5 = nArray[n4] - 1;
                            break;
                        }
                        case 1: {
                            int n8 = 1;
                            while (n8 > 0) {
                                code = runData.uncompressGetCode(bl ? MMRDecompressor.whiteTable : MMRDecompressor.blackTable);
                                if (code == null) break block26;
                                runData.offset += code.bitLength;
                                if (code.runLength < 64) {
                                    if (code.runLength < 0) {
                                        nArray2[n3++] = n5;
                                        code = null;
                                        break block26;
                                    }
                                    nArray2[n3++] = n5 += code.runLength;
                                    break;
                                }
                                n5 += code.runLength;
                            }
                            n8 = n5;
                            int n9 = 1;
                            while (n9 > 0) {
                                code = runData.uncompressGetCode(!bl ? MMRDecompressor.whiteTable : MMRDecompressor.blackTable);
                                if (code == null) break block26;
                                runData.offset += code.bitLength;
                                if (code.runLength < 64) {
                                    if (code.runLength < 0) {
                                        nArray2[n3++] = n5;
                                        break block26;
                                    }
                                    if ((n5 += code.runLength) >= n2 && n5 == n8) break;
                                    nArray2[n3++] = n5;
                                    break;
                                }
                                n5 += code.runLength;
                            }
                            while (n5 < n2 && nArray[n4] <= n5) {
                                n4 += 2;
                            }
                            continue block13;
                        }
                        case 0: {
                            int n10 = ++n4;
                            ++n4;
                            n5 = nArray[n10];
                            continue block13;
                        }
                        case 4: {
                            n5 = nArray[n4] + 2;
                            break;
                        }
                        case 7: {
                            n5 = nArray[n4] - 2;
                            break;
                        }
                        case 5: {
                            n5 = nArray[n4] + 3;
                            break;
                        }
                        case 8: {
                            n5 = nArray[n4] - 3;
                            break;
                        }
                        default: {
                            int n9;
                            System.err.println("Should not happen!");
                            if (runData.offset == 12 && code.runLength == -1) {
                                runData.offset = 0;
                                this.uncompress1D(runData, nArray, n2);
                                ++runData.offset;
                                this.uncompress1D(runData, nArray2, n2);
                                n9 = this.uncompress1D(runData, nArray, n2);
                                ++runData.offset;
                                return n9;
                            }
                            n5 = n2;
                            continue block13;
                        }
                    }
                    if (n5 > n2) continue;
                    bl = !bl;
                    nArray2[n3++] = n5;
                    n4 = n4 > 0 ? --n4 : ++n4;
                    while (n5 < n2 && nArray[n4] <= n5) {
                        n4 += 2;
                    }
                }
            }
            catch (Throwable throwable) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("whiteRun           = ");
                stringBuffer.append(bl);
                stringBuffer.append("\n");
                stringBuffer.append("code               = ");
                stringBuffer.append(code);
                stringBuffer.append("\n");
                stringBuffer.append("refOffset          = ");
                stringBuffer.append(n4);
                stringBuffer.append("\n");
                stringBuffer.append("curOffset          = ");
                stringBuffer.append(n3);
                stringBuffer.append("\n");
                stringBuffer.append("bitPos             = ");
                stringBuffer.append(n5);
                stringBuffer.append("\n");
                stringBuffer.append("runData.offset = ");
                stringBuffer.append(runData.offset);
                stringBuffer.append(" ( byte:");
                stringBuffer.append(runData.offset / 8);
                stringBuffer.append(", bit:");
                stringBuffer.append(runData.offset & 7);
                stringBuffer.append(" )");
                System.out.println(stringBuffer.toString());
                return -3;
            }
        }
        if (nArray2[n3] != n2) {
            nArray2[n3] = n2;
        }
        if (code == null) {
            return -1;
        }
        return n3;
    }

    public MMRDecompressor(int n, int n2, ImageInputStream imageInputStream) {
        this.width = n;
        this.height = n2;
        this.data = new RunData(imageInputStream);
        MMRDecompressor.initTables();
    }

    public Bitmap uncompress() {
        Bitmap bitmap = new Bitmap(this.width, this.height);
        int[] nArray = new int[this.width + 5];
        int[] nArray2 = new int[this.width + 5];
        nArray2[0] = this.width;
        int n = 1;
        int n2 = 0;
        for (int i = 0; i < this.height && (n2 = this.uncompress2D(this.data, nArray2, n, nArray, this.width)) != -3; ++i) {
            if (n2 > 0) {
                this.fillBitmap(bitmap, i, nArray, n2);
            }
            int[] nArray3 = nArray2;
            nArray2 = nArray;
            nArray = nArray3;
            n = n2;
        }
        this.detectAndSkipEOL();
        this.data.align();
        return bitmap;
    }

    private void detectAndSkipEOL() {
        Code code;
        while (null != (code = this.data.uncompressGetCode(MMRDecompressor.modeTable)) && code.runLength == -1) {
            this.data.offset += code.bitLength;
        }
    }

    private void fillBitmap(Bitmap bitmap, int n, int[] nArray, int n2) {
        int n3 = 0;
        int n4 = bitmap.getByteIndex(0, n);
        byte by = 0;
        for (int i = 0; i < n2; ++i) {
            int n5 = nArray[i];
            int n6 = (i & 1) == 0 ? 0 : 1;
            while (n3 < n5) {
                by = (byte)(by << 1 | n6);
                if ((++n3 & 7) != 0) continue;
                bitmap.setByte(n4++, by);
                by = 0;
            }
        }
        if ((n3 & 7) != 0) {
            by = (byte)(by << 8 - (n3 & 7));
            bitmap.setByte(n4, by);
        }
    }

    private final int uncompress1D(RunData runData, int[] nArray, int n) {
        boolean bl = true;
        Code code = null;
        int n2 = 0;
        block0: for (int i = 0; i < n; i += code.runLength) {
            do {
                code = bl ? runData.uncompressGetCode(MMRDecompressor.whiteTable) : runData.uncompressGetCode(MMRDecompressor.blackTable);
                runData.offset += code.bitLength;
                if (code.runLength < 0) break block0;
            } while (code.runLength >= 64);
            bl = !bl;
            nArray[n2++] = i;
        }
        if (nArray[n2] != n) {
            nArray[n2] = n;
        }
        return code != null && code.runLength != -1 ? n2 : -1;
    }

    private static Code[] createLittleEndianTable(int[][] nArray) {
        Code[] codeArray = new Code[256];
        for (int i = 0; i < nArray.length; ++i) {
            int n;
            int n2;
            int n3;
            Code code = new Code(nArray[i]);
            if (code.bitLength <= 8) {
                n3 = 8 - code.bitLength;
                int n4 = code.codeWord << n3;
                for (n2 = (1 << n3) - 1; n2 >= 0; --n2) {
                    n = n4 | n2;
                    codeArray[n] = code;
                }
                continue;
            }
            n3 = code.codeWord >>> code.bitLength - 8;
            if (codeArray[n3] == null) {
                Code code2 = new Code(new int[3]);
                code2.subTable = new Code[32];
                codeArray[n3] = code2;
            }
            if (code.bitLength <= 13) {
                Code[] codeArray2 = codeArray[n3].subTable;
                n2 = 13 - code.bitLength;
                n = code.codeWord << n2 & 0x1F;
                for (int j = (1 << n2) - 1; j >= 0; --j) {
                    codeArray2[n | j] = code;
                }
                continue;
            }
            throw new IllegalArgumentException("Code table overflow in MMRDecompressor");
        }
        return codeArray;
    }

    private static final class Code {
        Code[] subTable = null;
        final int bitLength;
        final int codeWord;
        final int runLength;

        Code(int[] nArray) {
            this.bitLength = nArray[0];
            this.codeWord = nArray[1];
            this.runLength = nArray[2];
        }

        public String toString() {
            return this.bitLength + "/" + this.codeWord + "/" + this.runLength;
        }

        public boolean equals(Object object) {
            return object instanceof Code && ((Code)object).bitLength == this.bitLength && ((Code)object).codeWord == this.codeWord && ((Code)object).runLength == this.runLength;
        }
    }

    private final class RunData {
        private static final int MAX_RUN_DATA_BUFFER = 131072;
        private static final int MIN_RUN_DATA_BUFFER = 3;
        private static final int CODE_OFFSET = 24;
        ImageInputStream stream;
        int offset;
        int lastOffset = 0;
        int lastCode = 0;
        byte[] buffer;
        int bufferBase;
        int bufferTop;

        RunData(ImageInputStream imageInputStream) {
            this.stream = imageInputStream;
            this.offset = 0;
            this.lastOffset = 1;
            try {
                long l = imageInputStream.length();
                l = Math.min(Math.max(3L, l), 131072L);
                this.buffer = new byte[(int)l];
                this.fillBuffer(0);
            }
            catch (IOException iOException) {
                this.buffer = new byte[10];
                iOException.printStackTrace();
            }
        }

        private final Code uncompressGetCode(Code[] codeArray) {
            return this.uncompressGetCodeLittleEndian(codeArray);
        }

        private final Code uncompressGetCodeLittleEndian(Code[] codeArray) {
            int n = this.uncompressGetNextCodeLittleEndian() & 0xFFFFFF;
            Code code = codeArray[n >> 16];
            if (null != code && null != code.subTable) {
                code = code.subTable[n >> 11 & 0x1F];
            }
            return code;
        }

        private final int uncompressGetNextCodeLittleEndian() {
            try {
                int n = this.offset - this.lastOffset;
                if (n < 0 || n > 24) {
                    int n2 = (this.offset >> 3) - this.bufferBase;
                    if (n2 >= this.bufferTop) {
                        this.fillBuffer(n2 += this.bufferBase);
                        n2 -= this.bufferBase;
                    }
                    this.lastCode = (this.buffer[n2] & 0xFF) << 16 | (this.buffer[n2 + 1] & 0xFF) << 8 | this.buffer[n2 + 2] & 0xFF;
                    int n3 = this.offset & 7;
                    this.lastCode <<= n3;
                } else {
                    int n4 = this.lastOffset & 7;
                    int n5 = 7 - n4;
                    if (n <= n5) {
                        this.lastCode <<= n;
                    } else {
                        int n6 = (this.lastOffset >> 3) + 3 - this.bufferBase;
                        if (n6 >= this.bufferTop) {
                            this.fillBuffer(n6 += this.bufferBase);
                            n6 -= this.bufferBase;
                        }
                        n4 = 8 - n4;
                        do {
                            this.lastCode <<= n4;
                            this.lastCode |= this.buffer[n6] & 0xFF;
                            ++n6;
                        } while ((n -= (n4 = 8)) >= 8);
                        this.lastCode <<= n;
                    }
                }
                this.lastOffset = this.offset;
                return this.lastCode;
            }
            catch (IOException iOException) {
                throw new ArrayIndexOutOfBoundsException("Corrupted RLE data caused by an IOException while reading raw data: " + iOException.toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fillBuffer(int n) throws IOException {
            this.bufferBase = n;
            ImageInputStream imageInputStream = this.stream;
            synchronized (imageInputStream) {
                try {
                    this.stream.seek(n);
                    this.bufferTop = this.stream.read(this.buffer);
                }
                catch (EOFException eOFException) {
                    this.bufferTop = -1;
                }
                if (this.bufferTop > -1 && this.bufferTop < 3) {
                    int n2 = 0;
                    while (this.bufferTop < 3) {
                        try {
                            n2 = this.stream.read();
                        }
                        catch (EOFException eOFException) {
                            n2 = -1;
                        }
                        this.buffer[this.bufferTop++] = n2 == -1 ? (byte)0 : (byte)(n2 & 0xFF);
                    }
                }
            }
            this.bufferTop -= 3;
            if (this.bufferTop < 0) {
                Arrays.fill(this.buffer, (byte)0);
                this.bufferTop = this.buffer.length - 3;
            }
        }

        private void align() {
            this.offset = this.offset + 7 >> 3 << 3;
        }
    }
}

