/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.read.converter;

import com.jerolba.carpet.impl.read.converter.InstantRead;
import java.time.Instant;
import java.util.function.Consumer;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.LogicalTypeAnnotation;

public class InstantConverter
extends PrimitiveConverter {
    private final Consumer<Object> consumer;
    private final InstantRead.LongToInstant mapper;
    private Instant[] dict = null;

    public InstantConverter(Consumer<Object> consumer, LogicalTypeAnnotation.TimeUnit timeUnit) {
        this.consumer = consumer;
        this.mapper = switch (timeUnit) {
            default -> throw new IncompatibleClassChangeError();
            case LogicalTypeAnnotation.TimeUnit.MILLIS -> InstantRead::instantFromMillisFromEpoch;
            case LogicalTypeAnnotation.TimeUnit.MICROS -> InstantRead::instantFromMicrosFromEpoch;
            case LogicalTypeAnnotation.TimeUnit.NANOS -> InstantRead::instantFromNanosFromEpoch;
        };
    }

    public void addLong(long timeToEpoch) {
        this.consumer.accept(this.mapper.map(timeToEpoch));
    }

    public void addValueFromDictionary(int dictionaryId) {
        this.consumer.accept(this.dict[dictionaryId]);
    }

    public boolean hasDictionarySupport() {
        return true;
    }

    public void setDictionary(Dictionary dictionary) {
        int maxId = dictionary.getMaxId();
        this.dict = new Instant[maxId + 1];
        for (int i = 0; i <= maxId; ++i) {
            this.dict[i] = this.mapper.map(dictionary.decodeToLong(i));
        }
    }
}

