/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.migrate;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.graph.query.SimpleQueryHandler;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.graph.GraphBase2;
import com.hp.hpl.jena.tdb.migrate.GraphOps;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.Collection;
import java.util.Iterator;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.iterator.IteratorConcat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphUnionRead
extends GraphBase2 {
    private final DatasetGraph dataset;
    private final Collection<Node> graphs;

    public GraphUnionRead(DatasetGraph dsg, Collection<Node> graphs) {
        this.dataset = dsg;
        this.graphs = graphs;
    }

    public QueryHandler queryHandler() {
        return new SimpleQueryHandler((Graph)this);
    }

    protected PrefixMapping createPrefixMapping() {
        PrefixMappingImpl pmap = new PrefixMappingImpl();
        for (Node gn : this.graphs) {
            if (!gn.isURI()) continue;
            Graph g = this.dataset.getGraph(gn);
            PrefixMapping pmapNamedGraph = g.getPrefixMapping();
            pmap.setNsPrefixes(pmapNamedGraph);
        }
        return pmap;
    }

    protected ExtendedIterator<Triple> graphBaseFind(TripleMatch m) {
        IteratorConcat iter = new IteratorConcat();
        for (Node gn : this.graphs) {
            if (!GraphOps.containsGraph(this.dataset, gn)) continue;
            ExtendedIterator eIter = GraphOps.getGraph(this.dataset, gn).find(m);
            iter.add((Iterator)eIter);
        }
        return WrappedIterator.create((Iterator)Iter.distinct((Iterator)iter));
    }
}

