/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.lib;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.base.objectfile.ObjectFile;
import com.hp.hpl.jena.tdb.base.objectfile.StringFile;
import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.lib.NodeFmtLib;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.nodetable.Nodec;
import com.hp.hpl.jena.tdb.nodetable.NodecSSE;
import com.hp.hpl.jena.tdb.store.Hash;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.store.NodeType;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.iterator.Transform;
import org.openjena.atlas.lib.Bytes;
import org.openjena.atlas.lib.Pool;
import org.openjena.atlas.lib.PoolBase;
import org.openjena.atlas.lib.PoolSync;
import org.openjena.atlas.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeLib {
    private static Nodec nodec = new NodecSSE();
    private static final char MarkerChar = '_';
    private static final char[] invalidIRIChars = new char[]{'_', ' '};
    private static int InitialPoolSize = 5;
    private static Pool<MessageDigest> digesters = PoolSync.create((Pool)new PoolBase());

    public static long encodeStore(Node node, StringFile file) {
        return NodeLib.encodeStore(node, file.getByteBufferFile());
    }

    public static Node fetchDecode(long id, StringFile file) {
        return NodeLib.fetchDecode(id, file.getByteBufferFile());
    }

    public static long encodeStore(Node node, ObjectFile file) {
        int maxSize = nodec.maxSize(node);
        ByteBuffer bb = file.allocWrite(maxSize);
        int len = nodec.encode(node, bb, null);
        long x = file.completeWrite(bb);
        return x;
    }

    public static Node fetchDecode(long id, ObjectFile file) {
        ByteBuffer bb = file.read(id);
        return NodeLib.decode(bb);
    }

    public static ByteBuffer encode(Node node) {
        int maxSize = nodec.maxSize(node);
        ByteBuffer bb = ByteBuffer.allocate(maxSize);
        int len = nodec.encode(node, bb, null);
        bb.limit(len);
        bb.position(0);
        return bb;
    }

    public static Node decode(ByteBuffer bb) {
        bb.position(0);
        Node n = nodec.decode(bb, null);
        return n;
    }

    public static Hash hash(Node n) {
        Hash h = new Hash(16);
        NodeLib.setHash(h, n);
        return h;
    }

    public static void setHash(Hash h, Node n) {
        NodeType nt = NodeType.lookup(n);
        switch (nt) {
            case URI: {
                NodeLib.hash(h, n.getURI(), null, null, nt);
                return;
            }
            case BNODE: {
                NodeLib.hash(h, n.getBlankNodeLabel(), null, null, nt);
                return;
            }
            case LITERAL: {
                NodeLib.hash(h, n.getLiteralLexicalForm(), n.getLiteralLanguage(), n.getLiteralDatatypeURI(), nt);
                return;
            }
            case OTHER: {
                throw new TDBException("Attempt to hash something strange: " + n);
            }
        }
        throw new TDBException("NodeType broken: " + n);
    }

    private static MessageDigest allocDigest() {
        try {
            MessageDigest disgest = (MessageDigest)digesters.get();
            if (disgest == null) {
                disgest = MessageDigest.getInstance("MD5");
            }
            return disgest;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void deallocDigest(MessageDigest digest) {
        digest.reset();
        digesters.put((Object)digest);
    }

    private static void hash(Hash h, String lex, String lang, String datatype, NodeType nodeType) {
        if (datatype == null) {
            datatype = "";
        }
        if (lang == null) {
            lang = "";
        }
        String toHash = lex + "|" + lang + "|" + datatype + "|" + nodeType.getName();
        try {
            MessageDigest digest = NodeLib.allocDigest();
            digest.update(Bytes.string2bytes((String)toHash));
            if (h.getLen() == 16) {
                digest.digest(h.getBytes(), 0, 16);
            } else {
                byte[] b = digest.digest();
                System.arraycopy(b, 0, h.getBytes(), 0, h.getLen());
            }
            NodeLib.deallocDigest(digest);
            return;
        }
        catch (DigestException ex) {
            Log.fatal(NodeLib.class, (String)"DigestException", (Throwable)ex);
            return;
        }
    }

    public static NodeId getNodeId(Record r, int idx) {
        return NodeId.create(Bytes.getLong((byte[])r.getKey(), (int)idx));
    }

    public static Node termOrAny(Node node) {
        if (node == null || node.isVariable()) {
            return Node.ANY;
        }
        return node;
    }

    public static String format(String sep, Node[] nodes) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < nodes.length; ++i) {
            if (i != 0) {
                b.append(sep);
            }
            b.append(NodeFmtLib.serialize(nodes[i]));
        }
        return b.toString();
    }

    public static Iterator<Node> nodes(final NodeTable nodeTable, Iterator<NodeId> iter) {
        return Iter.map(iter, (Transform)new Transform<NodeId, Node>(){

            public Node convert(NodeId item) {
                return nodeTable.getNodeForNodeId(item);
            }
        });
    }

    static {
        try {
            for (int i = 0; i < InitialPoolSize; ++i) {
                digesters.put((Object)MessageDigest.getInstance("MD5"));
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }
}

