/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.bplustree;

import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockMgrFactory;
import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.base.recordfile.RecordBufferPage;
import com.hp.hpl.jena.tdb.base.recordfile.RecordBufferPageMgr;
import com.hp.hpl.jena.tdb.index.RangeIndex;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreeNode;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreeNodeMgr;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreeRecordsMgr;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTreeParams;
import com.hp.hpl.jena.tdb.sys.Session;
import java.util.Iterator;
import org.openjena.atlas.io.IndentedWriter;
import org.openjena.atlas.iterator.Iter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPlusTree
implements Iterable<Record>,
RangeIndex,
Session {
    private static Logger log = LoggerFactory.getLogger(BPlusTree.class);
    private long sessionCounter = 0L;
    private int rootIdx;
    BPTreeNode root;
    private BPTreeNodeMgr nodeManager;
    private BPTreeRecordsMgr recordsMgr;
    private BPlusTreeParams bpTreeParams;

    public static BPlusTree attach(BPlusTreeParams params, BlockMgr blkMgrNodes, BlockMgr blkMgrLeaves) {
        BPlusTree bpt = new BPlusTree(params, blkMgrNodes, blkMgrLeaves);
        bpt.attach();
        return bpt;
    }

    public static BPlusTree makeMem(int order, int minRecords, int keyLength, int valueLength) {
        return BPlusTree.makeMem(null, order, minRecords, keyLength, valueLength);
    }

    public static BPlusTree makeMem(String name, int order, int minRecords, int keyLength, int valueLength) {
        BPlusTreeParams params = new BPlusTreeParams(order, keyLength, valueLength);
        int maxRecords = 2 * minRecords;
        int blkSize = RecordBufferPage.calcBlockSize(params.getRecordFactory(), maxRecords);
        BlockMgr mgr1 = BlockMgrFactory.createMem(name + "(nodes)", params.getBlockSize());
        BlockMgr mgr2 = BlockMgrFactory.createMem(name + "(records)", blkSize);
        BPlusTree bpTree = BPlusTree.attach(params, mgr1, mgr2);
        return bpTree;
    }

    public static BPlusTree dummy(BPlusTreeParams params, BlockMgr blkMgrNodes, BlockMgr blkMgrLeaves) {
        return new BPlusTree(params, blkMgrNodes, blkMgrLeaves);
    }

    private BPlusTree(BPlusTreeParams params) {
        this.bpTreeParams = params;
    }

    BPlusTree(int N, int recordLength, BlockMgr blkMgrNodes, BlockMgr blkMgrLeaves) {
        this(new BPlusTreeParams(N, recordLength, 0), blkMgrNodes, blkMgrLeaves);
    }

    BPlusTree(BPlusTreeParams params, BlockMgr blkMgrNodes, BlockMgr blkMgrLeaves) {
        this.bpTreeParams = params;
        this.nodeManager = new BPTreeNodeMgr(this, blkMgrNodes);
        RecordBufferPageMgr recordPageMgr = new RecordBufferPageMgr(params.getRecordFactory(), blkMgrLeaves);
        this.recordsMgr = new BPTreeRecordsMgr(this, recordPageMgr);
    }

    void attach() {
        if (this.nodeManager.valid(0)) {
            this.nodeManager.startRead();
            this.root = this.nodeManager.getRoot(this.rootIdx);
            this.rootIdx = this.root.getId();
            this.sessionCounter = 0L;
            this.nodeManager.finishRead();
        } else {
            this.startUpdateBlkMgr();
            this.root = this.nodeManager.createEmptyBPT();
            this.rootIdx = this.root.getId();
            if (this.rootIdx != 0) {
                throw new InternalError();
            }
            this.sessionCounter = 0L;
            if (BPlusTreeParams.CheckingNode) {
                this.root.checkNodeDeep();
            }
            this.finishUpdateBlkMgr();
        }
    }

    public BPlusTreeParams getParams() {
        return this.bpTreeParams;
    }

    public BPTreeNodeMgr getNodeManager() {
        return this.nodeManager;
    }

    public BPTreeRecordsMgr getRecordsMgr() {
        return this.recordsMgr;
    }

    @Override
    public RecordFactory getRecordFactory() {
        return this.bpTreeParams.recordFactory;
    }

    @Override
    public Record find(Record record) {
        this.startReadBlkMgr();
        BPTreeNode root = this.getRoot();
        Record v = root.search(record);
        this.releaseRoot(root);
        this.finishReadBlkMgr();
        return v;
    }

    private BPTreeNode getRoot() {
        return this.root;
    }

    private void releaseRoot(BPTreeNode root) {
        if (root != this.root) {
            log.warn("Root is not root!");
        }
    }

    @Override
    public boolean contains(Record record) {
        this.startReadBlkMgr();
        BPTreeNode root = this.getRoot();
        Record r = root.search(record);
        this.releaseRoot(root);
        this.finishReadBlkMgr();
        return r != null;
    }

    @Override
    public Record minKey() {
        this.startReadBlkMgr();
        BPTreeNode root = this.getRoot();
        Record r = root.minRecord();
        this.releaseRoot(root);
        this.finishReadBlkMgr();
        return r;
    }

    @Override
    public Record maxKey() {
        this.startReadBlkMgr();
        BPTreeNode root = this.getRoot();
        Record r = root.maxRecord();
        this.releaseRoot(root);
        this.finishReadBlkMgr();
        return r;
    }

    @Override
    public boolean add(Record record) {
        return this.addAndReturnOld(record) == null;
    }

    public Record addAndReturnOld(Record record) {
        this.startUpdateBlkMgr();
        BPTreeNode root = this.getRoot();
        Record r = root.insert(record);
        if (r == null) {
            ++this.sessionCounter;
        }
        if (BPlusTreeParams.CheckingTree) {
            root.checkNodeDeep();
        }
        this.releaseRoot(root);
        this.finishUpdateBlkMgr();
        return r;
    }

    @Override
    public boolean delete(Record record) {
        return this.deleteAndReturnOld(record) != null;
    }

    public Record deleteAndReturnOld(Record record) {
        this.startUpdateBlkMgr();
        BPTreeNode root = this.getRoot();
        Record r = root.delete(record);
        if (r != null) {
            --this.sessionCounter;
        }
        if (BPlusTreeParams.CheckingTree) {
            root.checkNodeDeep();
        }
        this.releaseRoot(root);
        this.finishUpdateBlkMgr();
        return r;
    }

    @Override
    public Iterator<Record> iterator() {
        this.startReadBlkMgr();
        BPTreeNode root = this.getRoot();
        Iterator<Record> iter = root.iterator();
        this.releaseRoot(root);
        this.finishReadBlkMgr();
        return iter;
    }

    @Override
    public Iterator<Record> iterator(Record fromRec, Record toRec) {
        this.startReadBlkMgr();
        BPTreeNode root = this.getRoot();
        Iterator<Record> iter = root.iterator(fromRec, toRec);
        this.releaseRoot(root);
        this.finishReadBlkMgr();
        return iter;
    }

    @Override
    public void startRead() {
    }

    @Override
    public void finishRead() {
    }

    @Override
    public void startUpdate() {
    }

    @Override
    public void finishUpdate() {
    }

    private void startReadBlkMgr() {
        this.nodeManager.startRead();
        this.recordsMgr.startRead();
    }

    private void finishReadBlkMgr() {
        this.nodeManager.finishRead();
        this.recordsMgr.finishRead();
    }

    private void startUpdateBlkMgr() {
        this.nodeManager.startUpdate();
        this.recordsMgr.startUpdate();
    }

    private void finishUpdateBlkMgr() {
        this.nodeManager.finishUpdate();
        this.recordsMgr.finishUpdate();
    }

    @Override
    public boolean isEmpty() {
        this.startReadBlkMgr();
        BPTreeNode root = this.getRoot();
        boolean b = !root.hasAnyKeys();
        this.releaseRoot(root);
        this.finishReadBlkMgr();
        return b;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("RangeIndex(" + Utils.classShortName(this.getClass()) + ").clear");
    }

    public void sync() {
        if (this.nodeManager.getBlockMgr() != null) {
            this.nodeManager.getBlockMgr().sync();
        }
        if (this.recordsMgr.getBlockMgr() != null) {
            this.recordsMgr.getBlockMgr().sync();
        }
    }

    @Override
    public void close() {
        if (this.nodeManager.getBlockMgr() != null) {
            this.nodeManager.getBlockMgr().close();
        }
        if (this.recordsMgr.getBlockMgr() != null) {
            this.recordsMgr.getBlockMgr().close();
        }
    }

    @Override
    public long sessionTripleCount() {
        return this.sessionCounter;
    }

    @Override
    public long size() {
        Iterator<Record> iter = this.iterator();
        return Iter.count(iter);
    }

    long sizeByCounting() {
        return this.root.size();
    }

    @Override
    public void check() {
        this.root.checkNodeDeep();
    }

    public void dump() {
        this.root.dump();
    }

    public void dump(IndentedWriter out) {
        this.root.dump(out);
    }
}

