/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.recordfile;

import com.hp.hpl.jena.tdb.base.StorageException;
import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.base.recordfile.RecordBufferPage;
import com.hp.hpl.jena.tdb.base.recordfile.RecordBufferPageMgr;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openjena.atlas.lib.Alg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RecordRangeIterator
implements Iterator<Record> {
    private RecordBufferPage currentPage;
    private RecordBufferPageMgr pageMgr;
    private int currentIdx;
    private Record slot = null;
    private final Record maxRec;
    private final Record minRec;
    private long countRecords = 0L;
    private long countBlocks = 0L;

    public static Iterator<Record> iterator(RecordBufferPage page, Record fromRec, Record toRec) {
        return new RecordRangeIterator(page, fromRec, toRec);
    }

    public static Iterator<Record> iterator(RecordBufferPage page) {
        return new RecordRangeIterator(page, null, null);
    }

    public RecordRangeIterator(RecordBufferPage page, Record fromRec, Record toRec) {
        this.currentPage = page;
        this.currentIdx = 0;
        this.pageMgr = page.getPageMgr();
        this.minRec = fromRec;
        this.maxRec = toRec;
        if (toRec != null && fromRec != null && Record.keyLE(toRec, fromRec)) {
            this.currentPage = null;
            return;
        }
        if (fromRec != null) {
            this.currentIdx = page.getRecordBuffer().find(fromRec);
            if (this.currentIdx < 0) {
                this.currentIdx = Alg.decodeIndex((int)this.currentIdx);
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (this.slot != null) {
            return true;
        }
        if (this.currentPage == null) {
            return false;
        }
        while (this.currentIdx >= this.currentPage.getCount()) {
            Record r2;
            int link = this.currentPage.getLink();
            if (link < 0) {
                this.finish();
                return false;
            }
            RecordBufferPage nextPage = this.pageMgr.get(link);
            Record r1 = this.currentPage.getRecordBuffer().getHigh();
            if (Record.keyGE(r1, r2 = nextPage.getRecordBuffer().getLow())) {
                throw new StorageException("RecordRangeIterator: records not strictly increasing: " + r1 + " // " + r2);
            }
            this.currentPage = nextPage;
            ++this.countBlocks;
            this.currentIdx = 0;
        }
        this.slot = this.currentPage.getRecordBuffer().get(this.currentIdx);
        ++this.currentIdx;
        if (this.maxRec != null && Record.keyGE(this.slot, this.maxRec)) {
            this.finish();
            return false;
        }
        if (this.slot == null) {
            return false;
        }
        ++this.countRecords;
        return true;
    }

    private void finish() {
        this.currentPage = null;
        this.currentIdx = -99;
        this.slot = null;
    }

    @Override
    public Record next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Record x = this.slot;
        this.slot = null;
        return x;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public long getCountRecords() {
        return this.countRecords;
    }

    public long getCountBlocks() {
        return this.countBlocks;
    }
}

