/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.recordfile;

import com.hp.hpl.jena.tdb.base.block.BlockConverter;
import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockType;
import com.hp.hpl.jena.tdb.base.record.RecordException;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.base.recordfile.RecordBufferPage;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RecordBufferPageMgr
extends BlockConverter<RecordBufferPage> {
    public RecordBufferPageMgr(RecordFactory factory, BlockMgr blockMgr) {
        super(null, blockMgr);
        Block2RecordBufferPage conv = new Block2RecordBufferPage(factory, this);
        super.setConverter(conv);
    }

    public RecordBufferPage create(int x) {
        RecordBufferPage rbp = (RecordBufferPage)super.create(x, BlockType.RECORD_BLOCK);
        rbp.setId(x);
        return rbp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecordBufferPage get(int id) {
        RecordBufferPageMgr recordBufferPageMgr = this;
        synchronized (recordBufferPageMgr) {
            RecordBufferPage rbp = (RecordBufferPage)super.get(id);
            rbp.setPageMgr(this);
            return rbp;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Block2RecordBufferPage
    implements BlockConverter.Converter<RecordBufferPage> {
        private RecordFactory factory;
        private RecordBufferPageMgr pageMgr;

        Block2RecordBufferPage(RecordFactory factory, RecordBufferPageMgr pageMgr) {
            this.factory = factory;
            this.pageMgr = pageMgr;
        }

        @Override
        public RecordBufferPage createFromByteBuffer(ByteBuffer bb, BlockType blkType) {
            if (blkType != BlockType.RECORD_BLOCK) {
                throw new RecordException("Not RECORD_BLOCK: " + (Object)((Object)blkType));
            }
            RecordBufferPage rb = new RecordBufferPage(-1, -1, bb, this.factory, this.pageMgr, 0);
            return rb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RecordBufferPage fromByteBuffer(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            synchronized (byteBuffer2) {
                int count = byteBuffer.getInt(0);
                int linkId = byteBuffer.getInt(4);
                RecordBufferPage rb = new RecordBufferPage(-1, linkId, byteBuffer, this.factory, this.pageMgr, count);
                return rb;
            }
        }

        @Override
        public ByteBuffer toByteBuffer(RecordBufferPage rbp) {
            int count = rbp.getRecordBuffer().size();
            rbp.setCount(count);
            rbp.getBackingByteBuffer().putInt(0, rbp.getCount());
            rbp.getBackingByteBuffer().putInt(4, rbp.getLink());
            return rbp.getBackingByteBuffer();
        }
    }
}

