/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.block;

import com.hp.hpl.jena.tdb.base.block.BlockException;
import com.hp.hpl.jena.tdb.base.block.BlockMgrBase;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicLong;
import org.openjena.atlas.lib.FileOps;
import org.openjena.atlas.logging.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BlockMgrFile
extends BlockMgrBase {
    private static Logger log = LoggerFactory.getLogger(BlockMgrFile.class);
    protected String filename;
    protected String label;
    protected FileChannel channel;
    protected RandomAccessFile out;
    protected long numFileBlocks = -1L;
    protected AtomicLong seq = new AtomicLong();
    protected boolean isEmpty = false;

    public BlockMgrFile(String filename, int blockSize) {
        super(blockSize);
        try {
            this.filename = filename;
            this.label = FileOps.basename((String)filename);
            this.out = new RandomAccessFile(filename, "rw");
            long filesize = this.out.length();
            this.isEmpty = filesize == 0L;
            long longBlockSize = blockSize;
            this.numFileBlocks = filesize / longBlockSize;
            if (this.numFileBlocks > Integer.MAX_VALUE) {
                log.warn(String.format("File size (%d) exceeds tested block number limits (%d)", filesize, blockSize));
            }
            if (filesize % longBlockSize != 0L) {
                throw new BlockException(String.format("File size (%d) not a multiple of blocksize (%d)", filesize, blockSize));
            }
            this.channel = this.out.getChannel();
            if (this.channel.size() == 0L) {
                this.isEmpty = true;
            }
        }
        catch (IOException ex) {
            throw new BlockException("Failed to create BlockMgrFile", ex);
        }
    }

    public final boolean isEmpty() {
        return this.isEmpty;
    }

    protected final void putNotification(int id, ByteBuffer block) {
        this.isEmpty = false;
    }

    public final synchronized int allocateId() {
        this.checkIfClosed();
        int id = (int)this.numFileBlocks;
        ++this.numFileBlocks;
        return id;
    }

    public final synchronized boolean valid(int id) {
        if ((long)id >= this.numFileBlocks) {
            return false;
        }
        return id >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void check(int id) {
        if (id < 0 || (long)id >= this.numFileBlocks) {
            BlockMgrFile blockMgrFile = this;
            synchronized (blockMgrFile) {
                if (id < 0 || (long)id >= this.numFileBlocks) {
                    throw new BlockException(String.format("BlockMgrFile: Bounds exception: %s: (%d,%d)", this.filename, id, this.numFileBlocks));
                }
            }
        }
    }

    protected final void check(int id, ByteBuffer bb) {
        this.check(id);
        if (bb.capacity() != this.blockSize) {
            throw new BlockException(String.format("BlockMgrFile: Wrong size block.  Expected=%d : actual=%d", this.blockSize, bb.capacity()));
        }
        if (bb.order() != SystemTDB.NetworkOrder) {
            throw new BlockException("BlockMgrFile: Wrong byte order");
        }
    }

    protected void force() {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("force");
        }
        try {
            this.channel.force(false);
        }
        catch (IOException ex) {
            throw new BlockException("Channel.force failed", ex);
        }
    }

    public final boolean isClosed() {
        return this.channel == null;
    }

    protected final void checkIfClosed() {
        if (this.isClosed()) {
            Log.fatal((Object)this, (String)"Block manager has been closed");
        }
    }

    protected abstract void _close();

    public final void close() {
        this._close();
        if (this.out != null) {
            try {
                this.force();
                this.channel.close();
                this.out.close();
                this.channel = null;
                this.out = null;
            }
            catch (IOException ex) {
                throw new BlockException(ex);
            }
        }
    }
}

