/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.assembler;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.assemblers.AssemblerGroup;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.tdb.assembler.DatasetAssemblerTDB;
import com.hp.hpl.jena.tdb.assembler.NodeTableAssembler;
import com.hp.hpl.jena.tdb.assembler.TDBGraphAssembler;
import com.hp.hpl.jena.tdb.assembler.Vocab;

public class VocabTDB {
    private static final String NS = "http://jena.hpl.hp.com/2008/tdb#";
    public static final Resource tDatasetTDB = Vocab.type("http://jena.hpl.hp.com/2008/tdb#", "DatasetTDB");
    public static final Resource tGraphTDB = Vocab.type("http://jena.hpl.hp.com/2008/tdb#", "GraphTDB");
    public static final Resource tGraphBDB = Vocab.type("http://jena.hpl.hp.com/2008/tdb#", "GraphBDB");
    public static final Resource tNodeTable = Vocab.type("http://jena.hpl.hp.com/2008/tdb#", "NodeTable");
    public static final Property pLocation = Vocab.property("http://jena.hpl.hp.com/2008/tdb#", "location");
    public static final Property pUnionDefaultGraph = Vocab.property("http://jena.hpl.hp.com/2008/tdb#", "unionDefaultGraph");
    public static final Property pIndex = Vocab.property("http://jena.hpl.hp.com/2008/tdb#", "index");
    public static final Property pGraphName1 = Vocab.property("http://jena.hpl.hp.com/2008/tdb#", "graphName");
    public static final Property pGraphName2 = Vocab.property("http://jena.hpl.hp.com/2008/tdb#", "namedGraph");
    public static final Property pDataset = Vocab.property("http://jena.hpl.hp.com/2008/tdb#", "dataset");
    public static final Property pNodes = Vocab.property("http://jena.hpl.hp.com/2008/tdb#", "nodes");
    public static final Property pDescription = Vocab.property(VocabTDB.getURI(), "description");
    public static final Property pFile = Vocab.property(VocabTDB.getURI(), "file");
    public static final Property pNodeIndex = Vocab.property(VocabTDB.getURI(), "nodeIndex");
    public static final Property pNodeData = Vocab.property(VocabTDB.getURI(), "nodeData");
    public static final Property pSetting = Vocab.property(VocabTDB.getURI(), "setting");
    public static final Property pName = Vocab.property(VocabTDB.getURI(), "name");
    public static final Property pValue = Vocab.property(VocabTDB.getURI(), "value");
    private static boolean initialized = false;

    public static String getURI() {
        return NS;
    }

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        VocabTDB.register(Assembler.general);
        initialized = true;
    }

    public static void register(AssemblerGroup g) {
        VocabTDB.assemblerClass(g, tDatasetTDB, (Assembler)new DatasetAssemblerTDB());
        VocabTDB.assemblerClass(g, tGraphTDB, new TDBGraphAssembler());
        VocabTDB.assemblerClass(g, tNodeTable, (Assembler)new NodeTableAssembler());
    }

    public static void assemblerClass(AssemblerGroup group, Resource r, Assembler a) {
        if (group == null) {
            group = Assembler.general;
        }
        group.implementWith(r, a);
    }

    static {
        VocabTDB.init();
    }
}

