/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.json.io.parserjavacc;

import org.openjena.atlas.io.IndentedWriter;
import org.openjena.atlas.json.io.JSONHandler;

public class JSONPrinter
implements JSONHandler {
    IndentedWriter out;

    public void startParse() {
        this.out = new IndentedWriter(System.out, true);
    }

    public void finishParse() {
        this.out.flush();
    }

    public void startObject() {
        this.out.println(">>Object");
        this.out.incIndent();
    }

    public void finishObject() {
        this.out.decIndent();
        this.out.println("<<Object");
    }

    public void startPair() {
        this.out.println(">Pair");
        this.out.incIndent();
    }

    public void keyPair() {
    }

    public void finishPair() {
        this.out.decIndent();
        this.out.println("<Pair");
    }

    public void startArray() {
        this.out.println(">>Array");
        this.out.incIndent();
    }

    public void element() {
    }

    public void finishArray() {
        this.out.decIndent();
        this.out.println("<<Array");
    }

    public void valueBoolean(boolean b) {
        this.out.println("Boolean: " + b);
    }

    public void valueDecimal(String image) {
        this.out.println("Decimal: " + image);
    }

    public void valueDouble(String image) {
        this.out.println("Double: " + image);
    }

    public void valueInteger(String image) {
        this.out.println("Integer: " + image);
    }

    public void valueNull() {
        this.out.println("Null");
    }

    public void valueString(String image) {
        this.out.println("String: " + image);
    }
}

