package com.hp.hpl.jena.sparql.vocabulary ;

/* CVS $Id: $ */
 
import com.hp.hpl.jena.rdf.model.*;
 
/**
 * Vocabulary definitions from test-update.n3 
 * @author Auto-generated by schemagen on 29 Oct 2010 17:36 
 */
public class TestManifestUpdate_11 {
    /** <p>The RDF model that holds the vocabulary terms</p> */
    private static Model m_model = ModelFactory.createDefaultModel();
    
    /** <p>The namespace of the vocabulary as a string</p> */
    public static final String NS = "http://www.w3.org/2009/sparql/tests/test-update#";
    
    /** <p>The namespace of the vocabulary as a string</p>
     *  @see #NS */
    public static String getURI() {return NS;}
    
    /** <p>The namespace of the vocabulary as a resource</p> */
    public static final Resource NAMESPACE = m_model.createResource( NS );
    
    /** <p>Optional: data for the update test (i.e. default graph in the graph store 
     *  prior or after the update, depending on whether used within mf:action or within 
     *  mf:result)</p>
     */
    public static final Property data = m_model.createProperty( "http://www.w3.org/2009/sparql/tests/test-update#data" );
    
    public static final Property graph = m_model.createProperty( "http://www.w3.org/2009/sparql/tests/test-update#graph" );
    
    /** <p>Optional: named-graph only data for the update test (i.e. named graph in the 
     *  graph store prior or after the update, depending on whether used within mf:action 
     *  or within mf:result)</p>
     */
    public static final Property graphData = m_model.createProperty( "http://www.w3.org/2009/sparql/tests/test-update#graphData" );
    
    /** <p>The update query to ask</p> */
    public static final Property request = m_model.createProperty( "http://www.w3.org/2009/sparql/tests/test-update#request" );
    
    /** <p>The class of all SPARQL 1.1 Update results</p> */
    public static final Resource Result = m_model.createResource( "http://www.w3.org/2009/sparql/tests/test-update#Result" );
    
    /** <p>The class of all SPARQL 1.1 Update evaluation tests</p> */
    public static final Resource UpdateEvaluationTest = m_model.createResource( "http://www.w3.org/2009/sparql/tests/test-update#UpdateEvaluationTest" );
    
    /** <p>test failure, cf. http://www.w3.org/TR/sparql11-protocol/#update-fault-messages</p> */
    public static final Resource graph_already_exists = m_model.createResource( "http://www.w3.org/2009/sparql/tests/test-update#graph-already-exists" );
    
    /** <p>test failure, cf. http://www.w3.org/TR/sparql11-protocol/#update-fault-messages</p> */
    public static final Resource graph_does_not_exist = m_model.createResource( "http://www.w3.org/2009/sparql/tests/test-update#graph-does-not-exist" );
    
    /** <p>test failure, cf. http://www.w3.org/TR/sparql11-protocol/#update-fault-messages</p> */
    public static final Resource malformed_update = m_model.createResource( "http://www.w3.org/2009/sparql/tests/test-update#malformed-update" );
    
    /** <p>test shall pass without failure</p> */
    public static final Resource success = m_model.createResource( "http://www.w3.org/2009/sparql/tests/test-update#success" );
    
    /** <p>test failure, cf. http://www.w3.org/TR/sparql11-protocol/#update-fault-messages</p> */
    public static final Resource update_request_refused = m_model.createResource( "http://www.w3.org/2009/sparql/tests/test-update#update-request-refused" );
    
}
