/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.business.services;

import com.herbocailleau.sgq.business.SgqBusinessException;
import com.herbocailleau.sgq.business.SgqService;
import com.herbocailleau.sgq.entities.SgqConfiguration;
import com.herbocailleau.sgq.entities.SgqConfigurationDAO;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;

public class ConfigurationService
extends SgqService {
    private static final Log log = LogFactory.getLog(ConfigurationService.class);
    public static final String NEXT_NON_BIO_BATCH_NUMBER_CONFIG = "nextNonBioBatchNumber";
    public static final String NEXT_BIO_BATCH_NUMBER_CONFIG = "nextBioBatchNumber";

    public int getNextNonBioBatchNumber() {
        int result;
        try {
            SgqConfigurationDAO configurationDAO = this.daoHelper.getSgqConfigurationDAO();
            Object sqgConfig = configurationDAO.findByKey(NEXT_NON_BIO_BATCH_NUMBER_CONFIG);
            result = sqgConfig != null ? Integer.parseInt(sqgConfig.getValue()) : this.config.getBatchRangeNonBioStart();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't read configuration", ex);
        }
        return result;
    }

    public void saveBatchLimit(int nextNonBioBatchNumber, int nextBioBatchNumber) {
        try {
            SgqConfigurationDAO configurationDAO = this.daoHelper.getSgqConfigurationDAO();
            Object sqgConfig = configurationDAO.findByKey(NEXT_NON_BIO_BATCH_NUMBER_CONFIG);
            if (sqgConfig == null) {
                sqgConfig = (SgqConfiguration)configurationDAO.create(new Object[0]);
                sqgConfig.setKey(NEXT_NON_BIO_BATCH_NUMBER_CONFIG);
            }
            sqgConfig.setValue(String.valueOf(nextNonBioBatchNumber));
            configurationDAO.update((TopiaEntity)sqgConfig);
            Object sqgBioConfig = configurationDAO.findByKey(NEXT_BIO_BATCH_NUMBER_CONFIG);
            if (sqgBioConfig == null) {
                sqgBioConfig = (SgqConfiguration)configurationDAO.create(new Object[0]);
                sqgBioConfig.setKey(NEXT_BIO_BATCH_NUMBER_CONFIG);
            }
            sqgBioConfig.setValue(String.valueOf(nextBioBatchNumber));
            configurationDAO.update((TopiaEntity)sqgBioConfig);
            this.daoHelper.commit();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't read configuration", ex);
        }
    }

    public int getNextBioBatchNumber() {
        int result;
        try {
            SgqConfigurationDAO configurationDAO = this.daoHelper.getSgqConfigurationDAO();
            Object sqgConfig = configurationDAO.findByKey(NEXT_BIO_BATCH_NUMBER_CONFIG);
            result = sqgConfig != null ? Integer.parseInt(sqgConfig.getValue()) : this.config.getBatchRangeBioStart();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't read configuration", ex);
        }
        return result;
    }

    public int getLastNonBioBatchNumber() {
        int result = this.config.getBatchRangeNonBioEnd();
        return result;
    }

    public int getLastBioBatchNumber() {
        int result = this.config.getBatchRangeBioEnd();
        return result;
    }

    public Map<String, String> getBackupDevices() {
        HashMap<String, String> result = new HashMap<String, String>();
        String listDevicesCommand = this.config.getBackupDevicesCommand();
        try {
            String[] lines;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
            CommandLine commandline = CommandLine.parse((String)listDevicesCommand);
            DefaultExecutor exec = new DefaultExecutor();
            PumpStreamHandler streamHandler = new PumpStreamHandler((OutputStream)outputStream, (OutputStream)errorStream);
            exec.setStreamHandler((ExecuteStreamHandler)streamHandler);
            exec.execute(commandline);
            String error = errorStream.toString();
            if (StringUtils.isNotBlank((CharSequence)error)) {
                throw new SgqBusinessException(error);
            }
            String output = outputStream.toString();
            for (String line : lines = output.split("\n")) {
                int indexOfTab = line.indexOf(9);
                if (indexOfTab <= 1) continue;
                String deviceId = line.substring(0, indexOfTab).trim();
                String size = line.substring(indexOfTab + 1).trim();
                result.put(deviceId, size);
            }
        }
        catch (IOException ex) {
            throw new SgqBusinessException(ex.getMessage(), ex);
        }
        return result;
    }

    public void saveBackupOnDevice(String deviceId, String notificationEmail) {
        String exportCommand = this.config.getBackupPerformCommand();
        exportCommand = exportCommand.replace("%d", deviceId);
        exportCommand = exportCommand.replace("%f", "sgq-backup-" + DateFormatUtils.format((Date)new Date(), (String)"ddMMyyyy") + ".sql");
        exportCommand = exportCommand.replace("%m", notificationEmail);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Executing script command : " + exportCommand));
        }
        try {
            CommandLine commandline = CommandLine.parse((String)exportCommand);
            DefaultExecutor exec = new DefaultExecutor();
            exec.execute(commandline);
        }
        catch (IOException ex) {
            throw new SgqBusinessException(ex.getMessage(), ex);
        }
    }
}

