package com.herbocailleau.sgq.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class PresentationAbstract extends TopiaEntityAbstract implements Presentation {

    /**
     * Nom de l'attribut en BD : quantity
     */
    protected double quantity;

    /**
     * Nom de l'attribut en BD : dmesd
     */
    protected Date dmesd;

    /**
     * Vrai si la presentation est celle d'origine crée pour l'import du lot. Contrairement aux presentations crées suite à un import étiquette.
     * Nom de l'attribut en BD : original
     */
    protected boolean original;

    /**
     * Nom de l'attribut en BD : batch
     */
    protected Batch batch;

    /**
     * Nom de l'attribut en BD : presentationCode
     */
    protected PresentationCode presentationCode;

    /**
     * Nom de l'attribut en BD : inventoryPlaces
     */
    protected Collection<Place> inventoryPlaces;

    private static final long serialVersionUID = 7005457395135558704L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_QUANTITY, double.class, quantity);
        visitor.visit(this, PROPERTY_DMESD, Date.class, dmesd);
        visitor.visit(this, PROPERTY_ORIGINAL, boolean.class, original);
        visitor.visit(this, PROPERTY_BATCH, Batch.class, batch);
        visitor.visit(this, PROPERTY_PRESENTATION_CODE, PresentationCode.class, presentationCode);
        visitor.visit(this, PROPERTY_INVENTORY_PLACES, Collection.class, Place.class, inventoryPlaces);
        visitor.end(this);
    }

    @Override
    public void setQuantity(double quantity) {
        double oldValue = this.quantity;
        fireOnPreWrite(PROPERTY_QUANTITY, oldValue, quantity);
        this.quantity = quantity;
        fireOnPostWrite(PROPERTY_QUANTITY, oldValue, quantity);
    }

    @Override
    public double getQuantity() {
        fireOnPreRead(PROPERTY_QUANTITY, quantity);
        double result = this.quantity;
        fireOnPostRead(PROPERTY_QUANTITY, quantity);
        return result;
    }

    @Override
    public void setDmesd(Date dmesd) {
        Date oldValue = this.dmesd;
        fireOnPreWrite(PROPERTY_DMESD, oldValue, dmesd);
        this.dmesd = dmesd;
        fireOnPostWrite(PROPERTY_DMESD, oldValue, dmesd);
    }

    @Override
    public Date getDmesd() {
        fireOnPreRead(PROPERTY_DMESD, dmesd);
        Date result = this.dmesd;
        fireOnPostRead(PROPERTY_DMESD, dmesd);
        return result;
    }

    @Override
    public void setOriginal(boolean original) {
        boolean oldValue = this.original;
        fireOnPreWrite(PROPERTY_ORIGINAL, oldValue, original);
        this.original = original;
        fireOnPostWrite(PROPERTY_ORIGINAL, oldValue, original);
    }

    @Override
    public boolean isOriginal() {
        fireOnPreRead(PROPERTY_ORIGINAL, original);
        boolean result = this.original;
        fireOnPostRead(PROPERTY_ORIGINAL, original);
        return result;
    }

    @Override
    public boolean getOriginal() {
        fireOnPreRead(PROPERTY_ORIGINAL, original);
        boolean result = this.original;
        fireOnPostRead(PROPERTY_ORIGINAL, original);
        return result;
    }

    @Override
    public void setBatch(Batch batch) {
        Batch oldValue = this.batch;
        fireOnPreWrite(PROPERTY_BATCH, oldValue, batch);
        this.batch = batch;
        fireOnPostWrite(PROPERTY_BATCH, oldValue, batch);
    }

    @Override
    public Batch getBatch() {
        fireOnPreRead(PROPERTY_BATCH, batch);
        Batch result = this.batch;
        fireOnPostRead(PROPERTY_BATCH, batch);
        return result;
    }

    @Override
    public void setPresentationCode(PresentationCode presentationCode) {
        PresentationCode oldValue = this.presentationCode;
        fireOnPreWrite(PROPERTY_PRESENTATION_CODE, oldValue, presentationCode);
        this.presentationCode = presentationCode;
        fireOnPostWrite(PROPERTY_PRESENTATION_CODE, oldValue, presentationCode);
    }

    @Override
    public PresentationCode getPresentationCode() {
        fireOnPreRead(PROPERTY_PRESENTATION_CODE, presentationCode);
        PresentationCode result = this.presentationCode;
        fireOnPostRead(PROPERTY_PRESENTATION_CODE, presentationCode);
        return result;
    }

    @Override
    public void addInventoryPlaces(Place inventoryPlaces) {
        fireOnPreWrite(PROPERTY_INVENTORY_PLACES, null, inventoryPlaces);
        if (this.inventoryPlaces == null) {
            this.inventoryPlaces = new ArrayList<Place>();
        }

        this.inventoryPlaces.add(inventoryPlaces);
        fireOnPostWrite(PROPERTY_INVENTORY_PLACES, this.inventoryPlaces.size(), null, inventoryPlaces);
    }

    @Override
    public void addAllInventoryPlaces(Collection<Place> inventoryPlaces) {
        if (inventoryPlaces == null) {
            return;
        }
        for (Place item : inventoryPlaces) {
            addInventoryPlaces(item);
        }
    }

    @Override
    public void setInventoryPlaces(Collection<Place> inventoryPlaces) {
        // Copy elements to keep data for fire with new reference
        Collection<Place> oldValue = this.inventoryPlaces != null ? new ArrayList<Place>(this.inventoryPlaces) : null;
        fireOnPreWrite(PROPERTY_INVENTORY_PLACES, oldValue, inventoryPlaces);
        this.inventoryPlaces = inventoryPlaces;
        fireOnPostWrite(PROPERTY_INVENTORY_PLACES, oldValue, inventoryPlaces);
    }

    @Override
    public void removeInventoryPlaces(Place inventoryPlaces) {
        fireOnPreWrite(PROPERTY_INVENTORY_PLACES, inventoryPlaces, null);
        if (this.inventoryPlaces == null || !this.inventoryPlaces.remove(inventoryPlaces)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_INVENTORY_PLACES, this.inventoryPlaces.size() + 1, inventoryPlaces, null);
    }

    @Override
    public void clearInventoryPlaces() {
        if (this.inventoryPlaces == null) {
            return;
        }
        Collection<Place> oldValue = new ArrayList<Place>(this.inventoryPlaces);
        fireOnPreWrite(PROPERTY_INVENTORY_PLACES, oldValue, this.inventoryPlaces);
        this.inventoryPlaces.clear();
        fireOnPostWrite(PROPERTY_INVENTORY_PLACES, oldValue, this.inventoryPlaces);
    }

    @Override
    public Collection<Place> getInventoryPlaces() {
        return inventoryPlaces;
    }

    @Override
    public Place getInventoryPlacesByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(inventoryPlaces, topiaId);
    }

    @Override
    public int sizeInventoryPlaces() {
        if (inventoryPlaces == null) {
            return 0;
        }
        return inventoryPlaces.size();
    }

    @Override
    public boolean isInventoryPlacesEmpty() {
        int size = sizeInventoryPlaces();
        return size == 0;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

} //PresentationAbstract
