/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.t7mp.steps.deployment;

import com.google.common.collect.Lists;
import com.googlecode.t7mp.AbstractArtifact;
import com.googlecode.t7mp.TomcatSetupException;
import com.googlecode.t7mp.WebappArtifact;
import com.googlecode.t7mp.steps.deployment.AbstractDeploymentStep;
import com.googlecode.t7mp.util.ZipUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class WebappsDeploymentStep
extends AbstractDeploymentStep {
    @Override
    protected List<AbstractArtifact> getArtifactList() {
        ArrayList artifactList = Lists.newArrayList();
        artifactList.addAll(this.context.getMojo().getWebapps());
        return artifactList;
    }

    @Override
    protected void deployArtifacts(List<AbstractArtifact> artifactList) {
        for (AbstractArtifact artifact : artifactList) {
            WebappArtifact webappArtifact = (WebappArtifact)artifact;
            if (webappArtifact.isUnpack() || webappArtifact.getTestContextFile() != null) {
                this.unzipWebappArtifact(webappArtifact);
                if (webappArtifact.getTestContextFile() == null) continue;
                File metaInfDirectory = new File(this.createTargetFileName(webappArtifact) + "/META-INF");
                metaInfDirectory.mkdirs();
                try {
                    IOUtils.copy((InputStream)new FileInputStream(webappArtifact.getTestContextFile()), (OutputStream)new FileOutputStream(new File(metaInfDirectory, "context.xml")));
                    continue;
                }
                catch (FileNotFoundException e) {
                    throw new TomcatSetupException(e.getMessage(), e);
                }
                catch (IOException e) {
                    throw new TomcatSetupException(e.getMessage(), e);
                }
            }
            try {
                String targetFileName = this.createTargetFileName(artifact);
                File sourceFile = artifact.getArtifact().getFile();
                File targetFile = new File(this.context.getMojo().getCatalinaBase(), "/webapps/" + targetFileName);
                this.context.getLog().debug((CharSequence)("Copy artifact from " + sourceFile.getAbsolutePath() + " to " + targetFile.getAbsolutePath()));
                this.setupUtil.copy(new FileInputStream(sourceFile), new FileOutputStream(targetFile));
            }
            catch (IOException e) {
                throw new TomcatSetupException(e.getMessage(), e);
            }
        }
    }

    @Override
    protected String createTargetFileName(AbstractArtifact abstractArtifact) {
        return ((WebappArtifact)abstractArtifact).getContextPath() + "." + abstractArtifact.getType();
    }

    protected void unzipWebappArtifact(WebappArtifact webappArtifact) {
        ZipUtil.unzip(webappArtifact.getArtifact().getFile(), new File(this.createTargetFileName(webappArtifact)));
    }
}

