/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.t7mp.steps.deployment;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.googlecode.t7mp.AbstractArtifact;
import com.googlecode.t7mp.AbstractT7Mojo;
import com.googlecode.t7mp.TomcatSetupException;
import com.googlecode.t7mp.steps.Context;
import com.googlecode.t7mp.steps.Step;
import com.googlecode.t7mp.steps.deployment.FindVersionPredicate;
import com.googlecode.t7mp.steps.deployment.NoVersionPredicate;
import java.util.Collection;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.logging.Log;

public class CheckT7ArtifactsStep
implements Step {
    private Predicate<AbstractArtifact> noVersionPredicate;
    private AbstractT7Mojo mojo;
    private Log log;
    private Collection<AbstractArtifact> noVersionArtifacts = Lists.newArrayList();

    @Override
    public void execute(Context context) {
        this.mojo = context.getMojo();
        this.log = this.mojo.getLog();
        this.noVersionPredicate = new NoVersionPredicate(this.log);
        this.log.debug((CharSequence)"Fitler libs");
        this.noVersionArtifacts.addAll(Collections2.filter(this.mojo.getWebapps(), this.noVersionPredicate));
        this.log.debug((CharSequence)"Filter webapps");
        this.noVersionArtifacts.addAll(Collections2.filter(this.mojo.getLibs(), this.noVersionPredicate));
        if (this.noVersionArtifacts.size() > 0) {
            this.log.debug((CharSequence)"artifacts without version found ");
            List projectDependencies = this.mojo.getMavenProject().getDependencies();
            List managedDependencies = this.mojo.getMavenProject().getDependencyManagement().getDependencies();
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("Project-Dependencies : " + projectDependencies.size()));
                this.logDependencies(projectDependencies);
                this.log.debug((CharSequence)("Managed-Dependencies : " + managedDependencies.size()));
                this.logDependencies(managedDependencies);
            }
            FindVersionPredicate depsfilter = new FindVersionPredicate(this.noVersionArtifacts, this.log);
            this.log.debug((CharSequence)"Filter projectArtifacts");
            Collection depsApplied = Collections2.filter((Collection)managedDependencies, (Predicate)depsfilter);
            depsApplied.addAll(Collections2.filter((Collection)projectDependencies, (Predicate)depsfilter));
            this.log.debug((CharSequence)(depsApplied.size() + " dependenciey applied"));
            this.log.debug((CharSequence)"check for noversion-artifacts again ...");
            Collection noVersionsFound = Collections2.filter(this.noVersionArtifacts, this.noVersionPredicate);
            if (noVersionsFound.size() > 0) {
                for (AbstractArtifact artifact : noVersionsFound) {
                    this.mojo.getLog().error((CharSequence)("No version configured for artifact --" + artifact.toString()));
                }
                throw new TomcatSetupException("ConfigurationException");
            }
        }
    }

    protected void logDependencies(List<Dependency> dependencies) {
        for (Dependency dependency : dependencies) {
            this.log.debug((CharSequence)("found dependency : " + dependency.toString() + " groupId:" + dependency.getGroupId() + " artifactId:" + dependency.getArtifactId() + " version:" + dependency.getVersion() + " packaging:" + dependency.getType()));
        }
    }
}

