/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.vm.impl;

import com.google.web.bindery.requestfactory.vm.impl.ClassComparator;
import com.google.web.bindery.requestfactory.vm.impl.OperationData;
import com.google.web.bindery.requestfactory.vm.impl.OperationKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class Deobfuscator {
    private static final String GENERATED_SUFFIX = "DeobfuscatorBuilder";
    private static final String GENERATED_SUFFIX_LITE = "DeobfuscatorBuilderLite";
    private Map<String, List<String>> domainToClientType;
    private Map<OperationKey, OperationData> operationData;
    private Set<String> referencedTypes;
    private Map<String, String> typeTokens;

    Deobfuscator() {
    }

    public List<String> getClientProxies(String binaryTypeName) {
        return this.domainToClientType.get(binaryTypeName);
    }

    public String getDomainMethodDescriptor(String operation) {
        OperationData data = this.getData(operation);
        return data == null ? null : data.getDomainMethodDescriptor();
    }

    public String getRequestContext(String operation) {
        OperationData data = this.getData(operation);
        return data == null ? null : data.getRequestContext();
    }

    public String getRequestContextMethodDescriptor(String operation) {
        OperationData data = this.getData(operation);
        return data == null ? null : data.getClientMethodDescriptor();
    }

    public String getRequestContextMethodName(String operation) {
        OperationData data = this.getData(operation);
        return data == null ? null : data.getMethodName();
    }

    public String getTypeFromToken(String token) {
        return this.typeTokens.get(token);
    }

    public boolean isReferencedType(String name) {
        return this.referencedTypes.contains(name);
    }

    private OperationData getData(String operation) {
        OperationData data = this.operationData.get(new OperationKey(operation));
        return data;
    }

    public static class Builder {
        private ClassLoader resolveClassesWith;
        private Deobfuscator d = new Deobfuscator();

        public Builder() {
            this.d.domainToClientType = new HashMap();
            this.d.operationData = new HashMap();
            this.d.typeTokens = new HashMap();
        }

        public static Builder load(Class<?> clazz, ClassLoader resolveClassesWith) {
            ReflectiveOperationException ex;
            try {
                Class<?> found;
                try {
                    found = Class.forName(clazz.getName() + Deobfuscator.GENERATED_SUFFIX, false, resolveClassesWith);
                }
                catch (ClassNotFoundException ignored) {
                    found = Class.forName(clazz.getName() + Deobfuscator.GENERATED_SUFFIX_LITE, false, resolveClassesWith);
                }
                Class<Builder> builderClass = found.asSubclass(Builder.class);
                Builder builder = builderClass.newInstance();
                builder.resolveClassesWith = resolveClassesWith;
                return builder;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("The RequestFactory ValidationTool must be run for the " + clazz.getCanonicalName() + " RequestFactory type");
            }
            catch (InstantiationException e) {
                ex = e;
            }
            catch (IllegalAccessException e) {
                ex = e;
            }
            throw new RuntimeException(ex);
        }

        public Deobfuscator build() {
            Deobfuscator toReturn = this.d;
            toReturn.domainToClientType = Collections.unmodifiableMap(toReturn.domainToClientType);
            toReturn.operationData = Collections.unmodifiableMap(toReturn.operationData);
            toReturn.referencedTypes = Collections.unmodifiableSet(new HashSet(toReturn.typeTokens.values()));
            toReturn.typeTokens = Collections.unmodifiableMap(toReturn.typeTokens);
            this.d = null;
            return toReturn;
        }

        public Builder merge(Deobfuscator existing) {
            this.d.domainToClientType.putAll(this.merge(this.d.domainToClientType, existing.domainToClientType));
            this.d.operationData.putAll(existing.operationData);
            this.d.typeTokens.putAll(existing.typeTokens);
            return this;
        }

        public Builder withClientToDomainMappings(String domainBinaryName, List<String> value) {
            List<Object> clientBinaryNames;
            switch (value.size()) {
                case 0: {
                    clientBinaryNames = Collections.emptyList();
                    break;
                }
                case 1: {
                    clientBinaryNames = Collections.singletonList(value.get(0));
                    break;
                }
                default: {
                    clientBinaryNames = Collections.unmodifiableList(new ArrayList<String>(value));
                }
            }
            this.d.domainToClientType.put(domainBinaryName, clientBinaryNames);
            return this;
        }

        public Builder withOperation(OperationKey key, OperationData data) {
            this.d.operationData.put(key, data);
            return this;
        }

        public Builder withRawTypeToken(String token, String binaryName) {
            this.d.typeTokens.put(token, binaryName);
            return this;
        }

        private Map<String, List<String>> merge(Map<String, List<String>> domainToClientType1, Map<String, List<String>> domainToClientType2) {
            HashMap<String, List<String>> result = new HashMap<String, List<String>>();
            HashSet<String> domains = new HashSet<String>();
            domains.addAll(domainToClientType1.keySet());
            domains.addAll(domainToClientType2.keySet());
            for (String domain : domains) {
                List<String> clientTypes1 = domainToClientType1.get(domain);
                List<String> clientTypes2 = domainToClientType2.get(domain);
                List<String> clientTypes = this.mergeClientTypes(clientTypes1, clientTypes2);
                result.put(domain, clientTypes);
            }
            return result;
        }

        private List<String> mergeClientTypes(List<String> clientTypes1, List<String> clientTypes2) {
            TreeSet<String> clientTypes = new TreeSet<String>(new ClassComparator(this.resolveClassesWith));
            if (clientTypes1 != null) {
                clientTypes.addAll(clientTypes1);
            }
            if (clientTypes2 != null) {
                clientTypes.addAll(clientTypes2);
            }
            return Collections.unmodifiableList(new ArrayList<String>(clientTypes));
        }
    }
}

