/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.FunctionTypeBuilder;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.EnumType;
import com.google.javascript.rhino.jstype.FunctionParamBuilder;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.Property;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.TemplateTypeMapReplacer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

final class TypedScopeCreator
implements ScopeCreator {
    static final String DELEGATE_PROXY_SUFFIX = ObjectType.createDelegateSuffix("Proxy");
    static final DiagnosticType MALFORMED_TYPEDEF = DiagnosticType.warning("JSC_MALFORMED_TYPEDEF", "Typedef for {0} does not have any type information");
    static final DiagnosticType ENUM_INITIALIZER = DiagnosticType.warning("JSC_ENUM_INITIALIZER_NOT_ENUM", "enum initializer must be an object literal or an enum");
    static final DiagnosticType CTOR_INITIALIZER = DiagnosticType.warning("JSC_CTOR_INITIALIZER_NOT_CTOR", "Constructor {0} must be initialized at declaration");
    static final DiagnosticType IFACE_INITIALIZER = DiagnosticType.warning("JSC_IFACE_INITIALIZER_NOT_IFACE", "Interface {0} must be initialized at declaration");
    static final DiagnosticType CONSTRUCTOR_EXPECTED = DiagnosticType.warning("JSC_REFLECT_CONSTRUCTOR_EXPECTED", "Constructor expected as first argument");
    static final DiagnosticType UNKNOWN_LENDS = DiagnosticType.warning("JSC_UNKNOWN_LENDS", "Variable {0} not declared before @lends annotation.");
    static final DiagnosticType LENDS_ON_NON_OBJECT = DiagnosticType.warning("JSC_LENDS_ON_NON_OBJECT", "May only lend properties to object types. {0} has type {1}.");
    static final DiagnosticType CANNOT_INFER_CONST_TYPE = DiagnosticType.disabled("JSC_CANNOT_INFER_CONST_TYPE", "Unable to infer type of constant.");
    private final AbstractCompiler compiler;
    private final ErrorReporter typeParsingErrorReporter;
    private final TypeValidator validator;
    private final CodingConvention codingConvention;
    private final JSTypeRegistry typeRegistry;
    private final List<ObjectType> delegateProxyPrototypes = Lists.newArrayList();
    private final Map<String, String> delegateCallingConventions = Maps.newHashMap();
    private final Map<Node, FunctionTypeBuilder.AstFunctionContents> functionAnalysisResults = Maps.newHashMap();
    private final ObjectType unknownType;

    TypedScopeCreator(AbstractCompiler compiler) {
        this(compiler, compiler.getCodingConvention());
    }

    TypedScopeCreator(AbstractCompiler compiler, CodingConvention codingConvention) {
        this.compiler = compiler;
        this.validator = compiler.getTypeValidator();
        this.codingConvention = codingConvention;
        this.typeRegistry = compiler.getTypeRegistry();
        this.typeParsingErrorReporter = this.typeRegistry.getErrorReporter();
        this.unknownType = this.typeRegistry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE);
    }

    @Override
    public Scope createScope(Node root, Scope parent) {
        Scope newScope = null;
        AbstractScopeBuilder scopeBuilder = null;
        if (parent == null) {
            ObjectType globalThis = this.typeRegistry.getNativeObjectType(JSTypeNative.GLOBAL_THIS);
            root.setJSType(globalThis);
            root.getFirstChild().setJSType(globalThis);
            root.getLastChild().setJSType(globalThis);
            new FirstOrderFunctionAnalyzer(this.compiler, this.functionAnalysisResults).process(root.getFirstChild(), root.getLastChild());
            newScope = this.createInitialScope(root);
            GlobalScopeBuilder globalScopeBuilder = new GlobalScopeBuilder(newScope);
            scopeBuilder = globalScopeBuilder;
            NodeTraversal.traverse(this.compiler, root, scopeBuilder);
        } else {
            LocalScopeBuilder localScopeBuilder;
            newScope = new Scope(parent, root);
            scopeBuilder = localScopeBuilder = new LocalScopeBuilder(newScope);
            localScopeBuilder.build();
        }
        scopeBuilder.resolveStubDeclarations();
        if (parent == null) {
            this.codingConvention.defineDelegateProxyPrototypeProperties(this.typeRegistry, newScope, this.delegateProxyPrototypes, this.delegateCallingConventions);
        }
        newScope.setTypeResolver(scopeBuilder);
        return newScope;
    }

    void patchGlobalScope(Scope globalScope, Node scriptRoot) {
        Preconditions.checkState((boolean)scriptRoot.isScript());
        Preconditions.checkNotNull((Object)globalScope);
        Preconditions.checkState((boolean)globalScope.isGlobal());
        String scriptName = NodeUtil.getSourceName(scriptRoot);
        Preconditions.checkNotNull((Object)scriptName);
        for (Node node : ImmutableList.copyOf(this.functionAnalysisResults.keySet())) {
            if (!scriptName.equals(NodeUtil.getSourceName(node))) continue;
            this.functionAnalysisResults.remove(node);
        }
        new FirstOrderFunctionAnalyzer(this.compiler, this.functionAnalysisResults).process(null, scriptRoot);
        Iterator<Scope.Var> varIter = globalScope.getVars();
        ArrayList varsToRemove = Lists.newArrayList();
        while (varIter.hasNext()) {
            Scope.Var oldVar = varIter.next();
            if (!scriptName.equals(oldVar.getInputName())) continue;
            varsToRemove.add(oldVar);
        }
        for (Scope.Var var : varsToRemove) {
            globalScope.undeclare(var);
            globalScope.getTypeOfThis().toObjectType().removeProperty(var.getName());
        }
        GlobalScopeBuilder scopeBuilder = new GlobalScopeBuilder(globalScope);
        NodeTraversal.traverse(this.compiler, scriptRoot, scopeBuilder);
    }

    @VisibleForTesting
    Scope createInitialScope(Node root) {
        NodeTraversal.traverse(this.compiler, root, new DiscoverEnumsAndTypedefs(this.typeRegistry));
        Scope s = Scope.createGlobalScope(root);
        this.declareNativeFunctionType(s, JSTypeNative.ARRAY_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.BOOLEAN_OBJECT_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.DATE_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.ERROR_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.EVAL_ERROR_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.FUNCTION_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.NUMBER_OBJECT_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.OBJECT_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.RANGE_ERROR_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.REFERENCE_ERROR_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.REGEXP_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.STRING_OBJECT_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.SYNTAX_ERROR_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.TYPE_ERROR_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.URI_ERROR_FUNCTION_TYPE);
        this.declareNativeValueType(s, "undefined", JSTypeNative.VOID_TYPE);
        this.declareNativeValueType(s, "ActiveXObject", JSTypeNative.FUNCTION_INSTANCE_TYPE);
        return s;
    }

    private void declareNativeFunctionType(Scope scope, JSTypeNative tId) {
        FunctionType t = this.typeRegistry.getNativeFunctionType(tId);
        TypedScopeCreator.declareNativeType(scope, t.getInstanceType().getReferenceName(), t);
        TypedScopeCreator.declareNativeType(scope, t.getPrototype().getReferenceName(), t.getPrototype());
    }

    private void declareNativeValueType(Scope scope, String name, JSTypeNative tId) {
        TypedScopeCreator.declareNativeType(scope, name, this.typeRegistry.getNativeType(tId));
    }

    private static void declareNativeType(Scope scope, String name, JSType t) {
        scope.declare(name, null, t, null, false);
    }

    private JSType getNativeType(JSTypeNative nativeType) {
        return this.typeRegistry.getNativeType(nativeType);
    }

    private FunctionTypeBuilder.AstFunctionContents getFunctionAnalysisResults(@Nullable Node n) {
        if (n == null) {
            return null;
        }
        return this.functionAnalysisResults.get(n);
    }

    @Override
    public boolean hasBlockScope() {
        return false;
    }

    private static class FirstOrderFunctionAnalyzer
    extends NodeTraversal.AbstractScopedCallback
    implements CompilerPass {
        private final AbstractCompiler compiler;
        private final Map<Node, FunctionTypeBuilder.AstFunctionContents> data;

        FirstOrderFunctionAnalyzer(AbstractCompiler compiler, Map<Node, FunctionTypeBuilder.AstFunctionContents> outParam) {
            this.compiler = compiler;
            this.data = outParam;
        }

        @Override
        public void process(Node externs, Node root) {
            if (externs == null) {
                NodeTraversal.traverse(this.compiler, root, this);
            } else {
                NodeTraversal.traverseRoots(this.compiler, (List<Node>)ImmutableList.of((Object)externs, (Object)root), this);
            }
        }

        @Override
        public void enterScope(NodeTraversal t) {
            if (!t.inGlobalScope()) {
                Node n = t.getScopeRoot();
                this.data.put(n, new FunctionTypeBuilder.AstFunctionContents(n));
            }
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (t.inGlobalScope()) {
                return;
            }
            if (n.isReturn() && n.getFirstChild() != null) {
                this.data.get(t.getScopeRoot()).recordNonEmptyReturn();
            }
            if (t.getScopeDepth() <= 1) {
                return;
            }
            if (n.isName() && NodeUtil.isLValue(n) && !NodeUtil.isBleedingFunctionName(n)) {
                String name = n.getString();
                Scope scope = t.getScope();
                Scope.Var var = scope.getVar(name);
                if (var != null) {
                    Scope ownerScope = var.getScope();
                    if (ownerScope.isLocal()) {
                        this.data.get(ownerScope.getRootNode()).recordAssignedName(name);
                    }
                    if (scope != ownerScope && ownerScope.isLocal()) {
                        this.data.get(ownerScope.getRootNode()).recordEscapedVarName(name);
                    }
                }
            } else if (n.isGetProp() && n.isUnscopedQualifiedName() && NodeUtil.isLValue(n)) {
                Scope ownerScope;
                String name = NodeUtil.getRootOfQualifiedName(n).getString();
                Scope scope = t.getScope();
                Scope.Var var = scope.getVar(name);
                if (var != null && scope != (ownerScope = var.getScope()) && ownerScope.isLocal()) {
                    this.data.get(ownerScope.getRootNode()).recordEscapedQualifiedName(n.getQualifiedName());
                }
            }
        }
    }

    private final class LocalScopeBuilder
    extends AbstractScopeBuilder {
        private final ObjectType thisTypeForProperties;

        private LocalScopeBuilder(Scope scope) {
            super(scope);
            this.thisTypeForProperties = this.getThisTypeForCollectingProperties();
        }

        void build() {
            NodeTraversal.traverse(TypedScopeCreator.this.compiler, this.scope.getRootNode(), this);
            FunctionTypeBuilder.AstFunctionContents contents = TypedScopeCreator.this.getFunctionAnalysisResults(this.scope.getRootNode());
            if (contents != null) {
                Scope.Var v;
                for (String varName : contents.getEscapedVarNames()) {
                    v = this.scope.getVar(varName);
                    Preconditions.checkState((v.getScope() == this.scope ? 1 : 0) != 0);
                    v.markEscaped();
                }
                for (Multiset.Entry entry : contents.getAssignedNameCounts().entrySet()) {
                    v = this.scope.getVar((String)entry.getElement());
                    Preconditions.checkState((v.getScope() == this.scope ? 1 : 0) != 0);
                    if (entry.getCount() != 1) continue;
                    v.markAssignedExactlyOnce();
                }
            }
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n == this.scope.getRootNode()) {
                return;
            }
            if (n.isParamList() && parent == this.scope.getRootNode()) {
                this.handleFunctionInputs(parent);
                return;
            }
            if (this.thisTypeForProperties != null && n.getParent().isExprResult()) {
                if (n.isAssign()) {
                    this.maybeCollectMember(n.getFirstChild(), n, n.getLastChild());
                } else if (n.isGetProp()) {
                    this.maybeCollectMember(n, n, null);
                }
            }
            super.visit(t, n, parent);
        }

        private ObjectType getThisTypeForCollectingProperties() {
            Node rootNode = this.scope.getRootNode();
            if (rootNode.isFromExterns()) {
                return null;
            }
            JSType type = rootNode.getJSType();
            if (type == null || !type.isFunctionType()) {
                return null;
            }
            FunctionType fnType = type.toMaybeFunctionType();
            JSType fnThisType = fnType.getTypeOfThis();
            return fnThisType.isUnknownType() ? null : fnThisType.toObjectType();
        }

        private void maybeCollectMember(Node member, Node nodeWithJsDocInfo, @Nullable Node value) {
            JSDocInfo info = nodeWithJsDocInfo.getJSDocInfo();
            if (info == null || !member.isGetProp() || !member.getFirstChild().isThis()) {
                return;
            }
            JSType jsType = this.getDeclaredType(info, member, value);
            Node name = member.getLastChild();
            if (jsType != null) {
                this.thisTypeForProperties.defineDeclaredProperty(name.getString(), jsType, member);
            }
        }

        private void handleFunctionInputs(Node fnNode) {
            Scope.Var fnVar;
            Node fnNameNode = fnNode.getFirstChild();
            String fnName = fnNameNode.getString();
            if (!fnName.isEmpty() && ((fnVar = this.scope.getVar(fnName)) == null || fnVar.getNameNode() != null && fnVar.getInitialValue() != fnNode)) {
                this.defineSlot(fnNameNode, fnNode, fnNode.getJSType(), false);
            }
            this.declareArguments(fnNode);
        }

        private void declareArguments(Node functionNode) {
            Node jsDocParameters;
            FunctionType functionType;
            Node astParameters = functionNode.getFirstChild().getNext();
            Node iifeArgumentNode = null;
            if (NodeUtil.isCallOrNewTarget(functionNode)) {
                iifeArgumentNode = functionNode.getNext();
            }
            if ((functionType = JSType.toMaybeFunctionType(functionNode.getJSType())) != null && (jsDocParameters = functionType.getParametersNode()) != null) {
                Node jsDocParameter = jsDocParameters.getFirstChild();
                for (Node astParameter : astParameters.children()) {
                    boolean inferred;
                    JSType paramType = jsDocParameter == null ? TypedScopeCreator.this.unknownType : jsDocParameter.getJSType();
                    boolean bl = inferred = paramType == null || paramType == TypedScopeCreator.this.unknownType;
                    if (iifeArgumentNode != null && inferred) {
                        Scope.Var argumentVar;
                        String argumentName = iifeArgumentNode.getQualifiedName();
                        Scope.Var var = argumentVar = argumentName == null || this.scope.getParent() == null ? null : this.scope.getParent().getVar(argumentName);
                        if (argumentVar != null && !argumentVar.isTypeInferred()) {
                            paramType = argumentVar.getType();
                        }
                    }
                    if (paramType == null) {
                        paramType = TypedScopeCreator.this.unknownType;
                    }
                    this.defineSlot(astParameter, functionNode, paramType, inferred);
                    if (jsDocParameter != null) {
                        jsDocParameter = jsDocParameter.getNext();
                    }
                    if (iifeArgumentNode == null) continue;
                    iifeArgumentNode = iifeArgumentNode.getNext();
                }
            }
        }
    }

    private final class GlobalScopeBuilder
    extends AbstractScopeBuilder {
        private GlobalScopeBuilder(Scope scope) {
            super(scope);
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            super.visit(t, n, parent);
            switch (n.getType()) {
                case 118: {
                    if (!n.hasOneChild()) break;
                    this.checkForTypedef(n.getFirstChild(), n.getJSDocInfo());
                }
            }
        }

        @Override
        void maybeDeclareQualifiedName(NodeTraversal t, JSDocInfo info, Node n, Node parent, Node rhsValue) {
            this.checkForTypedef(n, info);
            super.maybeDeclareQualifiedName(t, info, n, parent, rhsValue);
        }

        private void checkForTypedef(Node candidate, JSDocInfo info) {
            if (info == null || !info.hasTypedefType()) {
                return;
            }
            String typedef = candidate.getQualifiedName();
            if (typedef == null) {
                return;
            }
            TypedScopeCreator.this.typeRegistry.declareType(typedef, TypedScopeCreator.this.unknownType);
            JSType realType = info.getTypedefType().evaluate(this.scope, TypedScopeCreator.this.typeRegistry);
            if (realType == null) {
                TypedScopeCreator.this.compiler.report(JSError.make(candidate, MALFORMED_TYPEDEF, typedef));
            }
            TypedScopeCreator.this.typeRegistry.overwriteDeclaredType(typedef, realType);
            if (candidate.isGetProp()) {
                this.defineSlot(candidate, candidate.getParent(), TypedScopeCreator.this.getNativeType(JSTypeNative.NO_TYPE), false);
            }
        }
    }

    private static final class StubDeclaration {
        private final Node node;
        private final boolean isExtern;
        private final String ownerName;

        private StubDeclaration(Node node, boolean isExtern, String ownerName) {
            this.node = node;
            this.isExtern = isExtern;
            this.ownerName = ownerName;
        }
    }

    private abstract class AbstractScopeBuilder
    implements NodeTraversal.Callback,
    Scope.TypeResolver {
        final Scope scope;
        private final List<DeferredSetType> deferredSetTypes = Lists.newArrayList();
        private final List<Node> nonExternFunctions = Lists.newArrayList();
        private List<Node> lentObjectLiterals = null;
        private final List<StubDeclaration> stubDeclarations = Lists.newArrayList();
        private String sourceName = null;
        private InputId inputId;

        private AbstractScopeBuilder(Scope scope) {
            this.scope = scope;
        }

        void setDeferredType(Node node, JSType type) {
            this.deferredSetTypes.add(new DeferredSetType(node, type));
        }

        @Override
        public void resolveTypes() {
            for (DeferredSetType deferred : this.deferredSetTypes) {
                deferred.resolve(this.scope);
            }
            Iterator<Scope.Var> vars = this.scope.getVars();
            while (vars.hasNext()) {
                vars.next().resolveType(TypedScopeCreator.this.typeParsingErrorReporter);
            }
            TypedScopeCreator.this.typeRegistry.resolveTypesInScope(this.scope);
        }

        @Override
        public final boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            boolean descend;
            this.inputId = t.getInputId();
            if (n.isFunction() || n.isScript()) {
                Preconditions.checkNotNull((Object)this.inputId);
                this.sourceName = NodeUtil.getSourceName(n);
            }
            boolean bl = descend = parent == null || !parent.isFunction() || n == parent.getFirstChild() || parent == this.scope.getRootNode();
            if (descend && NodeUtil.isStatementParent(n)) {
                for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                    if (!NodeUtil.isHoistedFunctionDeclaration(child)) continue;
                    this.defineFunctionLiteral(child);
                }
            }
            return descend;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            this.inputId = t.getInputId();
            this.attachLiteralTypes(n);
            switch (n.getType()) {
                case 37: {
                    this.checkForClassDefiningCalls(n);
                    this.checkForCallingConventionDefiningCalls(n, TypedScopeCreator.this.delegateCallingConventions);
                    break;
                }
                case 105: {
                    if (t.getInput() == null || !t.getInput().isExtern()) {
                        this.nonExternFunctions.add(n);
                    }
                    if (NodeUtil.isHoistedFunctionDeclaration(n)) break;
                    this.defineFunctionLiteral(n);
                    break;
                }
                case 86: {
                    Node firstChild = n.getFirstChild();
                    if (!firstChild.isGetProp() || !firstChild.isQualifiedName()) break;
                    this.maybeDeclareQualifiedName(t, n.getJSDocInfo(), firstChild, n, firstChild.getNext());
                    break;
                }
                case 120: {
                    this.defineCatch(n);
                    break;
                }
                case 118: {
                    this.defineVar(n);
                    break;
                }
                case 33: {
                    if (!parent.isExprResult() || !n.isQualifiedName()) break;
                    this.maybeDeclareQualifiedName(t, n.getJSDocInfo(), n, parent, null);
                }
            }
            if (n.getParent() != null && NodeUtil.isStatement(n) && this.lentObjectLiterals != null) {
                for (Node objLit : this.lentObjectLiterals) {
                    this.defineObjectLiteral(objLit);
                }
                this.lentObjectLiterals.clear();
            }
        }

        private void attachLiteralTypes(Node n) {
            switch (n.getType()) {
                case 41: {
                    n.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.NULL_TYPE));
                    break;
                }
                case 122: {
                    n.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.VOID_TYPE));
                    break;
                }
                case 40: {
                    n.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.STRING_TYPE));
                    break;
                }
                case 39: {
                    n.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.NUMBER_TYPE));
                    break;
                }
                case 43: 
                case 44: {
                    n.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.BOOLEAN_TYPE));
                    break;
                }
                case 47: {
                    n.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.REGEXP_TYPE));
                    break;
                }
                case 64: {
                    JSDocInfo info = n.getJSDocInfo();
                    if (info != null && info.getLendsName() != null) {
                        if (this.lentObjectLiterals == null) {
                            this.lentObjectLiterals = Lists.newArrayList();
                        }
                        this.lentObjectLiterals.add(n);
                        break;
                    }
                    this.defineObjectLiteral(n);
                }
            }
        }

        private void defineObjectLiteral(Node objectLit) {
            JSType type = null;
            JSDocInfo info = objectLit.getJSDocInfo();
            if (info != null && info.getLendsName() != null) {
                String lendsName = info.getLendsName();
                Scope.Var lendsVar = this.scope.getVar(lendsName);
                if (lendsVar == null) {
                    TypedScopeCreator.this.compiler.report(JSError.make(objectLit, UNKNOWN_LENDS, lendsName));
                } else {
                    type = lendsVar.getType();
                    if (type == null) {
                        type = TypedScopeCreator.this.unknownType;
                    }
                    if (!type.isSubtype(TypedScopeCreator.this.typeRegistry.getNativeType(JSTypeNative.OBJECT_TYPE))) {
                        TypedScopeCreator.this.compiler.report(JSError.make(objectLit, LENDS_ON_NON_OBJECT, lendsName, type.toString()));
                        type = null;
                    } else {
                        objectLit.setJSType(type);
                    }
                }
            }
            info = NodeUtil.getBestJSDocInfo(objectLit);
            Node lValue = NodeUtil.getBestLValue(objectLit);
            String lValueName = NodeUtil.getBestLValueName(lValue);
            boolean createdEnumType = false;
            if (info != null && info.hasEnumParameterType()) {
                type = this.createEnumTypeFromNodes(objectLit, lValueName, info, lValue);
                createdEnumType = true;
            }
            if (type == null) {
                type = TypedScopeCreator.this.typeRegistry.createAnonymousObjectType(info);
            }
            this.setDeferredType(objectLit, type);
            this.processObjectLitProperties(objectLit, ObjectType.cast(objectLit.getJSType()), !createdEnumType);
        }

        void processObjectLitProperties(Node objLit, ObjectType objLitType, boolean declareOnOwner) {
            for (Node keyNode = objLit.getFirstChild(); keyNode != null; keyNode = keyNode.getNext()) {
                Node value = keyNode.getFirstChild();
                String memberName = NodeUtil.getObjectLitKeyName(keyNode);
                JSDocInfo info = keyNode.getJSDocInfo();
                JSType valueType = this.getDeclaredType(info, keyNode, value);
                JSType keyType = objLitType.isEnumType() ? objLitType.toMaybeEnumType().getElementsType() : NodeUtil.getObjectLitKeyTypeFromValueType(keyNode, valueType);
                String qualifiedName = NodeUtil.getBestLValueName(keyNode);
                if (qualifiedName != null) {
                    boolean inferred = keyType == null;
                    this.defineSlot(keyNode, objLit, qualifiedName, keyType, inferred);
                } else if (keyType != null) {
                    this.setDeferredType(keyNode, keyType);
                }
                if (keyType == null || objLitType == null || !declareOnOwner) continue;
                objLitType.defineDeclaredProperty(memberName, keyType, keyNode);
            }
        }

        private JSType getDeclaredTypeInAnnotation(Node node, JSDocInfo info) {
            JSType jsType = null;
            if (info != null) {
                if (info.hasType()) {
                    Scope.Var ownerVar;
                    ImmutableList<TemplateType> ownerTypeKeys = ImmutableList.of();
                    Node ownerNode = NodeUtil.getBestLValueOwner(node);
                    String ownerName = NodeUtil.getBestLValueName(ownerNode);
                    ObjectType ownerType = null;
                    if (ownerName != null && (ownerVar = this.scope.getVar(ownerName)) != null && (ownerType = this.getPrototypeOwnerType(ObjectType.cast(ownerVar.getType()))) != null) {
                        ownerTypeKeys = ownerType.getTemplateTypeMap().getTemplateKeys();
                    }
                    if (!ownerTypeKeys.isEmpty()) {
                        TypedScopeCreator.this.typeRegistry.setTemplateTypeNames((List<TemplateType>)ownerTypeKeys);
                    }
                    jsType = info.getType().evaluate(this.scope, TypedScopeCreator.this.typeRegistry);
                    if (!ownerTypeKeys.isEmpty()) {
                        TypedScopeCreator.this.typeRegistry.clearTemplateTypeNames();
                    }
                } else if (FunctionTypeBuilder.isFunctionTypeDeclaration(info)) {
                    String fnName = node.getQualifiedName();
                    jsType = this.createFunctionTypeFromNodes(null, fnName, info, node);
                }
            }
            return jsType;
        }

        void assertDefinitionNode(Node n, int type) {
            Preconditions.checkState((this.sourceName != null ? 1 : 0) != 0);
            Preconditions.checkState((n.getType() == type ? 1 : 0) != 0);
        }

        void defineCatch(Node n) {
            this.assertDefinitionNode(n, 120);
            Node catchName = n.getFirstChild();
            this.defineSlot(catchName, n, this.getDeclaredType(catchName.getJSDocInfo(), catchName, null));
        }

        void defineVar(Node n) {
            this.assertDefinitionNode(n, 118);
            JSDocInfo info = n.getJSDocInfo();
            if (n.hasMoreThanOneChild()) {
                if (info != null) {
                    TypedScopeCreator.this.compiler.report(JSError.make(n, TypeCheck.MULTIPLE_VAR_DEF, new String[0]));
                }
                for (Node name : n.children()) {
                    this.defineName(name, n, name.getJSDocInfo());
                }
            } else {
                Node name = n.getFirstChild();
                this.defineName(name, n, info != null ? info : name.getJSDocInfo());
            }
        }

        void defineFunctionLiteral(Node n) {
            this.assertDefinitionNode(n, 105);
            Node lValue = NodeUtil.getBestLValue(n);
            JSDocInfo info = NodeUtil.getBestJSDocInfo(n);
            String functionName = NodeUtil.getBestLValueName(lValue);
            FunctionType functionType = this.createFunctionTypeFromNodes(n, functionName, info, lValue);
            this.setDeferredType(n, functionType);
            if (NodeUtil.isFunctionDeclaration(n)) {
                this.defineSlot(n.getFirstChild(), n, functionType);
            }
        }

        private void defineName(Node name, Node var, JSDocInfo info) {
            Node value = name.getFirstChild();
            JSType type = this.getDeclaredType(info, name, value);
            if (type == null) {
                type = name.isFromExterns() ? TypedScopeCreator.this.unknownType : null;
            }
            this.defineSlot(name, var, type);
        }

        private boolean shouldUseFunctionLiteralType(FunctionType type, JSDocInfo info, Node lValue) {
            if (info != null) {
                return true;
            }
            if (lValue != null && NodeUtil.isObjectLitKey(lValue)) {
                return false;
            }
            return this.scope.isGlobal() || !type.isReturnTypeInferred();
        }

        private FunctionType createFunctionTypeFromNodes(@Nullable Node rValue, @Nullable String name, @Nullable JSDocInfo info, @Nullable Node lvalueNode) {
            FunctionType aliasedType;
            Scope.Var var;
            FunctionType functionType = null;
            if (rValue != null && rValue.isQualifiedName() && this.scope.isGlobal() && (var = this.scope.getVar(rValue.getQualifiedName())) != null && var.getType() != null && var.getType().isFunctionType() && ((aliasedType = var.getType().toMaybeFunctionType()).isConstructor() || aliasedType.isInterface()) && !this.isGoogAbstractMethod(rValue)) {
                functionType = aliasedType;
                if (name != null && this.scope.isGlobal()) {
                    TypedScopeCreator.this.typeRegistry.declareType(name, functionType.getInstanceType());
                }
            }
            if (functionType == null) {
                Node parametersNode;
                Node errorRoot = rValue == null ? lvalueNode : rValue;
                boolean isFnLiteral = rValue != null && rValue.isFunction();
                Node fnRoot = isFnLiteral ? rValue : null;
                Node node = parametersNode = isFnLiteral ? rValue.getFirstChild().getNext() : null;
                if (info != null && info.hasType()) {
                    JSType type = info.getType().evaluate(this.scope, TypedScopeCreator.this.typeRegistry);
                    if ((type = type.restrictByNotNullOrUndefined()).isFunctionType()) {
                        functionType = type.toMaybeFunctionType();
                        functionType.setJSDocInfo(info);
                    }
                }
                if (functionType == null) {
                    Node ownerNode = NodeUtil.getBestLValueOwner(lvalueNode);
                    String ownerName = NodeUtil.getBestLValueName(ownerNode);
                    Scope.Var ownerVar = null;
                    String propName = null;
                    ObjectType ownerType = null;
                    if (ownerName != null) {
                        ownerVar = this.scope.getVar(ownerName);
                        if (ownerVar != null) {
                            ownerType = ObjectType.cast(ownerVar.getType());
                        }
                        if (name != null) {
                            propName = name.substring(ownerName.length() + 1);
                        }
                    }
                    ObjectType prototypeOwner = this.getPrototypeOwnerType(ownerType);
                    TemplateTypeMap prototypeOwnerTypeMap = null;
                    if (prototypeOwner != null && prototypeOwner.getTypeOfThis() != null) {
                        prototypeOwnerTypeMap = prototypeOwner.getTypeOfThis().getTemplateTypeMap();
                    }
                    FunctionType overriddenType = null;
                    if (ownerType != null && propName != null) {
                        overriddenType = this.findOverriddenFunction(ownerType, propName, prototypeOwnerTypeMap);
                    }
                    FunctionTypeBuilder builder = new FunctionTypeBuilder(name, TypedScopeCreator.this.compiler, errorRoot, this.sourceName, this.scope).setContents(TypedScopeCreator.this.getFunctionAnalysisResults(fnRoot)).inferFromOverriddenFunction(overriddenType, parametersNode).inferTemplateTypeName(info, prototypeOwner).inferInheritance(info);
                    if (info == null || !info.hasReturnType()) {
                        if (rValue != null && rValue.isFunction() && rValue.getFirstChild() != null) {
                            JSDocInfo nameDocInfo = rValue.getFirstChild().getJSDocInfo();
                            builder.inferReturnType(nameDocInfo, true);
                        }
                    } else {
                        builder.inferReturnType(info, false);
                    }
                    boolean searchedForThisType = false;
                    if (ownerType != null && ownerType.isFunctionPrototypeType() && ownerType.getOwnerFunction().hasInstanceType()) {
                        builder.inferThisType(info, ownerType.getOwnerFunction().getInstanceType());
                        searchedForThisType = true;
                    } else if (ownerNode != null && ownerNode.isThis()) {
                        JSType injectedThisType = ownerNode.getJSType();
                        builder.inferThisType(info, this.scope.getTypeOfThis());
                        searchedForThisType = true;
                    }
                    if (!searchedForThisType) {
                        builder.inferThisType(info);
                    }
                    functionType = builder.inferParameterTypes(parametersNode, info).buildAndRegister();
                }
            }
            return functionType;
        }

        private boolean isGoogAbstractMethod(Node n) {
            return n.matchesQualifiedName("goog.abstractMethod");
        }

        private ObjectType getPrototypeOwnerType(ObjectType ownerType) {
            if (ownerType != null && ownerType.isFunctionPrototypeType()) {
                return ownerType.getOwnerFunction();
            }
            return null;
        }

        private FunctionType findOverriddenFunction(ObjectType ownerType, String propName, TemplateTypeMap typeMap) {
            FunctionType result = null;
            JSType propType = ownerType.getPropertyType(propName);
            if (propType != null && propType.isFunctionType()) {
                result = propType.toMaybeFunctionType();
            } else {
                for (ObjectType iface : ownerType.getCtorImplementedInterfaces()) {
                    propType = iface.getPropertyType(propName);
                    if (propType == null || !propType.isFunctionType()) continue;
                    result = propType.toMaybeFunctionType();
                    break;
                }
            }
            if (result != null && typeMap != null && !typeMap.isEmpty()) {
                result = result.visit(new TemplateTypeMapReplacer(TypedScopeCreator.this.typeRegistry, typeMap)).toMaybeFunctionType();
            }
            return result;
        }

        private EnumType createEnumTypeFromNodes(Node rValue, String name, JSDocInfo info, Node lValueNode) {
            Scope.Var var;
            Preconditions.checkNotNull((Object)info);
            Preconditions.checkState((boolean)info.hasEnumParameterType());
            EnumType enumType = null;
            if (rValue != null && rValue.isQualifiedName() && (var = this.scope.getVar(rValue.getQualifiedName())) != null && var.getType() instanceof EnumType) {
                enumType = (EnumType)var.getType();
            }
            if (enumType == null) {
                JSType elementsType = info.getEnumParameterType().evaluate(this.scope, TypedScopeCreator.this.typeRegistry);
                enumType = TypedScopeCreator.this.typeRegistry.createEnumType(name, rValue, elementsType);
                if (rValue != null && rValue.isObjectLit()) {
                    for (Node key = rValue.getFirstChild(); key != null; key = key.getNext()) {
                        String keyName = NodeUtil.getStringValue(key);
                        if (keyName == null) {
                            TypedScopeCreator.this.compiler.report(JSError.make(key, TypeCheck.ENUM_NOT_CONSTANT, keyName));
                            continue;
                        }
                        if (!TypedScopeCreator.this.codingConvention.isValidEnumKey(keyName)) {
                            TypedScopeCreator.this.compiler.report(JSError.make(key, TypeCheck.ENUM_NOT_CONSTANT, keyName));
                            continue;
                        }
                        enumType.defineElement(keyName, key);
                    }
                }
            }
            if (name != null && this.scope.isGlobal()) {
                TypedScopeCreator.this.typeRegistry.declareType(name, enumType.getElementsType());
            }
            return enumType;
        }

        private void defineSlot(Node name, Node parent, JSType type) {
            this.defineSlot(name, parent, type, type == null);
        }

        void defineSlot(Node n, Node parent, JSType type, boolean inferred) {
            Preconditions.checkArgument((inferred || type != null ? 1 : 0) != 0);
            if (n.isName()) {
                Preconditions.checkArgument((parent.isFunction() || parent.isVar() || parent.isParamList() || parent.isCatch() ? 1 : 0) != 0);
            } else {
                Preconditions.checkArgument((n.isGetProp() && (parent.isAssign() || parent.isExprResult()) ? 1 : 0) != 0);
            }
            this.defineSlot(n, parent, n.getQualifiedName(), type, inferred);
        }

        void defineSlot(Node n, Node parent, String variableName, JSType type, boolean inferred) {
            Scope globalScope;
            Preconditions.checkArgument((!variableName.isEmpty() ? 1 : 0) != 0);
            boolean isGlobalVar = n.isName() && this.scope.isGlobal();
            boolean shouldDeclareOnGlobalThis = isGlobalVar && (parent.isVar() || parent.isFunction());
            Scope scopeToDeclareIn = this.scope;
            if (n.isGetProp() && !this.scope.isGlobal() && this.isQnameRootedInGlobalScope(n) && !(globalScope = this.scope.getGlobalScope()).isDeclared(variableName, false)) {
                scopeToDeclareIn = this.scope.getGlobalScope();
            }
            Scope.Var newVar = null;
            CompilerInput input = TypedScopeCreator.this.compiler.getInput(this.inputId);
            if (scopeToDeclareIn.isDeclared(variableName, false)) {
                Scope.Var oldVar = scopeToDeclareIn.getVar(variableName);
                newVar = TypedScopeCreator.this.validator.expectUndeclaredVariable(this.sourceName, input, n, parent, oldVar, variableName, type);
            } else {
                if (type != null) {
                    this.setDeferredType(n, type);
                }
                newVar = scopeToDeclareIn.declare(variableName, n, type, input, inferred);
                if (type instanceof EnumType) {
                    boolean isValidValue;
                    Node initialValue = newVar.getInitialValue();
                    boolean bl = isValidValue = initialValue != null && (initialValue.isObjectLit() || initialValue.isQualifiedName());
                    if (!isValidValue) {
                        TypedScopeCreator.this.compiler.report(JSError.make(n, ENUM_INITIALIZER, new String[0]));
                    }
                }
            }
            FunctionType fnType = JSType.toMaybeFunctionType(type);
            if (fnType != null && !type.isEmptyType() && (fnType.isConstructor() || fnType.isInterface()) && variableName.equals(fnType.getReferenceName())) {
                this.finishConstructorDefinition(n, variableName, fnType, scopeToDeclareIn, input, newVar);
            }
            if (shouldDeclareOnGlobalThis) {
                ObjectType globalThis = TypedScopeCreator.this.typeRegistry.getNativeObjectType(JSTypeNative.GLOBAL_THIS);
                if (inferred) {
                    globalThis.defineInferredProperty(variableName, type == null ? TypedScopeCreator.this.getNativeType(JSTypeNative.NO_TYPE) : type, n);
                } else {
                    globalThis.defineDeclaredProperty(variableName, type, n);
                }
            }
            if (isGlobalVar && "Window".equals(variableName) && type != null && type.isFunctionType() && type.isConstructor()) {
                FunctionType globalThisCtor = TypedScopeCreator.this.typeRegistry.getNativeObjectType(JSTypeNative.GLOBAL_THIS).getConstructor();
                globalThisCtor.getInstanceType().clearCachedValues();
                globalThisCtor.getPrototype().clearCachedValues();
                globalThisCtor.setPrototypeBasedOn(type.toMaybeFunctionType().getInstanceType());
            }
        }

        private void finishConstructorDefinition(Node n, String variableName, FunctionType fnType, Scope scopeToDeclareIn, CompilerInput input, Scope.Var newVar) {
            FunctionType superClassCtor = fnType.getSuperClassConstructor();
            Property prototypeSlot = fnType.getSlot("prototype");
            prototypeSlot.setNode(n);
            String prototypeName = variableName + ".prototype";
            Scope.Var prototypeVar = scopeToDeclareIn.getVar(prototypeName);
            if (prototypeVar != null && prototypeVar.scope == scopeToDeclareIn) {
                scopeToDeclareIn.undeclare(prototypeVar);
            }
            scopeToDeclareIn.declare(prototypeName, n, prototypeSlot.getType(), input, superClassCtor == null || superClassCtor.getInstanceType().isEquivalentTo(TypedScopeCreator.this.getNativeType(JSTypeNative.OBJECT_TYPE)));
            if (newVar.getInitialValue() == null && !n.isFromExterns()) {
                TypedScopeCreator.this.compiler.report(JSError.make(n, fnType.isConstructor() ? CTOR_INITIALIZER : IFACE_INITIALIZER, variableName));
            }
        }

        private boolean isQnameRootedInGlobalScope(Node n) {
            Scope scope = this.getQnameRootScope(n);
            return scope != null && scope.isGlobal();
        }

        private Scope getQnameRootScope(Node n) {
            Scope.Var var;
            Node root = NodeUtil.getRootOfQualifiedName(n);
            if (root.isName() && (var = this.scope.getVar(root.getString())) != null) {
                return var.getScope();
            }
            return null;
        }

        JSType getDeclaredType(JSDocInfo info, Node lValue, @Nullable Node rValue) {
            if (info != null && info.hasType()) {
                return this.getDeclaredTypeInAnnotation(lValue, info);
            }
            if (rValue != null && rValue.isFunction() && this.shouldUseFunctionLiteralType(JSType.toMaybeFunctionType(rValue.getJSType()), info, lValue)) {
                return rValue.getJSType();
            }
            if (info != null) {
                if (info.hasEnumParameterType()) {
                    if (rValue != null && rValue.isObjectLit()) {
                        return rValue.getJSType();
                    }
                    return this.createEnumTypeFromNodes(rValue, lValue.getQualifiedName(), info, lValue);
                }
                if (info.isConstructor() || info.isInterface()) {
                    return this.createFunctionTypeFromNodes(rValue, lValue.getQualifiedName(), info, lValue);
                }
            }
            if (NodeUtil.isConstantDeclaration(TypedScopeCreator.this.compiler.getCodingConvention(), info, lValue) && rValue != null) {
                JSType rValueType = this.getDeclaredRValueType(lValue, rValue);
                if (rValueType == null) {
                    boolean isTypelessConstDecl;
                    boolean bl = isTypelessConstDecl = info != null && info.isConstant() && !info.hasType();
                    if (isTypelessConstDecl) {
                        TypedScopeCreator.this.compiler.report(JSError.make(lValue, CANNOT_INFER_CONST_TYPE, new String[0]));
                    }
                } else {
                    return rValueType;
                }
            }
            return this.getDeclaredTypeInAnnotation(lValue, info);
        }

        private JSType getDeclaredRValueType(Node lValue, Node rValue) {
            JSDocInfo rValueInfo = rValue.getJSDocInfo();
            if (rValue.isCast() && rValueInfo != null && rValueInfo.hasType()) {
                return rValueInfo.getType().evaluate(this.scope, TypedScopeCreator.this.typeRegistry);
            }
            JSType type = rValue.getJSType();
            if (type != null && !type.isUnknownType()) {
                return type;
            }
            if (rValue.isQualifiedName()) {
                return this.lookupQualifiedName(rValue);
            }
            if (rValue.isOr()) {
                boolean namesMatch;
                Node firstClause = rValue.getFirstChild();
                Node secondClause = firstClause.getNext();
                boolean bl = namesMatch = firstClause.isName() && lValue.isName() && firstClause.getString().equals(lValue.getString());
                if (namesMatch && (type = secondClause.getJSType()) != null && !type.isUnknownType()) {
                    return type;
                }
            }
            return null;
        }

        private JSType lookupQualifiedName(Node n) {
            JSType type;
            String name = n.getQualifiedName();
            Scope.Var slot = this.scope.getVar(name);
            if (slot != null && !slot.isTypeInferred()) {
                JSType type2 = slot.getType();
                if (type2 != null && !type2.isUnknownType()) {
                    return type2;
                }
            } else if (n.isGetProp() && (type = this.lookupQualifiedName(n.getFirstChild())) != null && type.isRecordType()) {
                JSType propType = type.findPropertyType(n.getLastChild().getString());
                return propType;
            }
            return null;
        }

        private void checkForCallingConventionDefiningCalls(Node n, Map<String, String> delegateCallingConventions) {
            TypedScopeCreator.this.codingConvention.checkForCallingConventionDefiningCalls(n, delegateCallingConventions);
        }

        private void checkForClassDefiningCalls(Node n) {
            CodingConvention.ObjectLiteralCast objectLiteralCast;
            CodingConvention.DelegateRelationship delegateRelationship;
            FunctionType functionType;
            ObjectType objectType;
            String singletonGetterClassName;
            CodingConvention.SubclassRelationship relationship = TypedScopeCreator.this.codingConvention.getClassesDefinedByCall(n);
            if (relationship != null) {
                ObjectType superClass = TypeValidator.getInstanceOfCtor(this.scope.getVar(relationship.superclassName));
                ObjectType subClass = TypeValidator.getInstanceOfCtor(this.scope.getVar(relationship.subclassName));
                if (superClass != null && subClass != null) {
                    FunctionType superCtor = superClass.getConstructor();
                    FunctionType subCtor = subClass.getConstructor();
                    if (superCtor != null && subCtor != null) {
                        TypedScopeCreator.this.codingConvention.applySubclassRelationship(superCtor, subCtor, relationship.type);
                    }
                }
            }
            if ((singletonGetterClassName = TypedScopeCreator.this.codingConvention.getSingletonGetterClassName(n)) != null && (objectType = ObjectType.cast(TypedScopeCreator.this.typeRegistry.getType(singletonGetterClassName))) != null && (functionType = objectType.getConstructor()) != null) {
                FunctionType getterType = TypedScopeCreator.this.typeRegistry.createFunctionType((JSType)objectType, new JSType[0]);
                TypedScopeCreator.this.codingConvention.applySingletonGetter(functionType, getterType, objectType);
            }
            if ((delegateRelationship = TypedScopeCreator.this.codingConvention.getDelegateRelationship(n)) != null) {
                this.applyDelegateRelationship(delegateRelationship);
            }
            if ((objectLiteralCast = TypedScopeCreator.this.codingConvention.getObjectLiteralCast(n)) != null) {
                if (objectLiteralCast.diagnosticType == null) {
                    ObjectType type = ObjectType.cast(TypedScopeCreator.this.typeRegistry.getType(objectLiteralCast.typeName));
                    if (type != null && type.getConstructor() != null) {
                        this.setDeferredType(objectLiteralCast.objectNode, type);
                        objectLiteralCast.objectNode.putBooleanProp(57, true);
                    } else {
                        TypedScopeCreator.this.compiler.report(JSError.make(n, CONSTRUCTOR_EXPECTED, new String[0]));
                    }
                } else {
                    TypedScopeCreator.this.compiler.report(JSError.make(n, objectLiteralCast.diagnosticType, new String[0]));
                }
            }
        }

        private void applyDelegateRelationship(CodingConvention.DelegateRelationship delegateRelationship) {
            ObjectType delegatorObject = ObjectType.cast(TypedScopeCreator.this.typeRegistry.getType(delegateRelationship.delegator));
            ObjectType delegateBaseObject = ObjectType.cast(TypedScopeCreator.this.typeRegistry.getType(delegateRelationship.delegateBase));
            ObjectType delegateSuperObject = ObjectType.cast(TypedScopeCreator.this.typeRegistry.getType(TypedScopeCreator.this.codingConvention.getDelegateSuperclassName()));
            if (delegatorObject != null && delegateBaseObject != null && delegateSuperObject != null) {
                FunctionType delegatorCtor = delegatorObject.getConstructor();
                FunctionType delegateBaseCtor = delegateBaseObject.getConstructor();
                FunctionType delegateSuperCtor = delegateSuperObject.getConstructor();
                if (delegatorCtor != null && delegateBaseCtor != null && delegateSuperCtor != null) {
                    FunctionParamBuilder functionParamBuilder = new FunctionParamBuilder(TypedScopeCreator.this.typeRegistry);
                    functionParamBuilder.addRequiredParams(TypedScopeCreator.this.getNativeType(JSTypeNative.U2U_CONSTRUCTOR_TYPE));
                    FunctionType findDelegate = TypedScopeCreator.this.typeRegistry.createFunctionType(TypedScopeCreator.this.typeRegistry.createDefaultObjectUnion(delegateBaseObject), functionParamBuilder.build());
                    FunctionType delegateProxy = TypedScopeCreator.this.typeRegistry.createConstructorType(delegateBaseObject.getReferenceName() + DELEGATE_PROXY_SUFFIX, null, null, null, null);
                    delegateProxy.setPrototypeBasedOn(delegateBaseObject);
                    TypedScopeCreator.this.codingConvention.applyDelegateRelationship(delegateSuperObject, delegateBaseObject, delegatorObject, delegateProxy, findDelegate);
                    TypedScopeCreator.this.delegateProxyPrototypes.add(delegateProxy.getPrototype());
                }
            }
        }

        void maybeDeclareQualifiedName(NodeTraversal t, JSDocInfo info, Node n, Node parent, Node rhsValue) {
            FunctionType ownerFnType;
            ObjectType ownerType;
            Scope.Var qVar;
            Node ownerNode = n.getFirstChild();
            String ownerName = ownerNode.getQualifiedName();
            String qName = n.getQualifiedName();
            String propName = n.getLastChild().getString();
            Preconditions.checkArgument((qName != null && ownerName != null ? 1 : 0) != 0);
            JSType valueType = this.getDeclaredType(info, n, rhsValue);
            if (valueType == null && rhsValue != null) {
                valueType = rhsValue.getJSType();
            }
            if ("prototype".equals(propName) && (qVar = this.scope.getVar(qName)) != null) {
                ObjectType qVarType = ObjectType.cast(qVar.getType());
                if (qVarType != null && rhsValue != null && rhsValue.isObjectLit()) {
                    TypedScopeCreator.this.typeRegistry.resetImplicitPrototype(rhsValue.getJSType(), qVarType.getImplicitPrototype());
                } else if (!qVar.isTypeInferred()) {
                    return;
                }
                qVar.getScope().undeclare(qVar);
            }
            if (valueType == null) {
                if (parent.isExprResult()) {
                    this.stubDeclarations.add(new StubDeclaration(n, t.getInput() != null && t.getInput().isExtern(), ownerName));
                }
                return;
            }
            boolean inferred = this.isQualifiedNameInferred(qName, n, info, rhsValue, valueType);
            if (!inferred) {
                ownerType = this.getObjectSlot(ownerName);
                if (ownerType != null) {
                    boolean isExtern;
                    boolean bl = isExtern = t.getInput() != null && t.getInput().isExtern();
                    if (!(ownerType.hasOwnProperty(propName) && !ownerType.isPropertyTypeInferred(propName) || (!isExtern || ownerType.isNativeObjectType()) && ownerType.isInstanceType())) {
                        ownerType.defineDeclaredProperty(propName, valueType, n);
                    }
                }
                this.defineSlot(n, parent, valueType, inferred);
            } else if (rhsValue != null && rhsValue.isTrue() && (ownerFnType = JSType.toMaybeFunctionType(ownerType = this.getObjectSlot(ownerName))) != null) {
                JSType delegateType;
                JSType ownerTypeOfThis = ownerFnType.getTypeOfThis();
                String delegateName = TypedScopeCreator.this.codingConvention.getDelegateSuperclassName();
                JSType jSType = delegateType = delegateName == null ? null : TypedScopeCreator.this.typeRegistry.getType(delegateName);
                if (delegateType != null && ownerTypeOfThis.isSubtype(delegateType)) {
                    this.defineSlot(n, parent, TypedScopeCreator.this.getNativeType(JSTypeNative.BOOLEAN_TYPE), true);
                }
            }
        }

        private boolean isQualifiedNameInferred(String qName, Node n, JSDocInfo info, Node rhsValue, JSType valueType) {
            if (valueType == null) {
                return true;
            }
            if (qName != null && qName.endsWith(".prototype")) {
                JSType classType;
                String className = qName.substring(0, qName.lastIndexOf(".prototype"));
                Scope.Var slot = this.scope.getSlot(className);
                JSType jSType = classType = slot == null ? null : slot.getType();
                if (classType != null && (classType.isConstructor() || classType.isInterface())) {
                    return false;
                }
            }
            boolean inferred = true;
            if (info != null) {
                boolean bl = inferred = !info.hasType() && !info.hasEnumParameterType() && (!NodeUtil.isConstantDeclaration(TypedScopeCreator.this.compiler.getCodingConvention(), info, n) || valueType == null || valueType.isUnknownType()) && !FunctionTypeBuilder.isFunctionTypeDeclaration(info);
            }
            if (inferred && rhsValue != null && rhsValue.isFunction()) {
                if (info != null) {
                    return false;
                }
                if (!this.scope.isDeclared(qName, false) && n.isUnscopedQualifiedName()) {
                    Node current = n.getParent();
                    while (!current.isScript() && !current.isFunction()) {
                        if (NodeUtil.isControlStructure(current)) {
                            return true;
                        }
                        current = current.getParent();
                    }
                    FunctionTypeBuilder.AstFunctionContents contents = TypedScopeCreator.this.getFunctionAnalysisResults(this.scope.getRootNode());
                    if (contents == null || !contents.getEscapedQualifiedNames().contains(qName)) {
                        return false;
                    }
                }
            }
            return inferred;
        }

        private ObjectType getObjectSlot(String slotName) {
            Scope.Var ownerVar = this.scope.getVar(slotName);
            if (ownerVar != null) {
                JSType ownerVarType = ownerVar.getType();
                return ObjectType.cast(ownerVarType == null ? null : ownerVarType.restrictByNotNullOrUndefined());
            }
            return null;
        }

        void resolveStubDeclarations() {
            for (StubDeclaration stub : this.stubDeclarations) {
                Node n = stub.node;
                Node parent = n.getParent();
                String qName = n.getQualifiedName();
                String propName = n.getLastChild().getString();
                String ownerName = stub.ownerName;
                boolean isExtern = stub.isExtern;
                if (this.scope.isDeclared(qName, false)) continue;
                ObjectType ownerType = this.getObjectSlot(ownerName);
                this.defineSlot(n, parent, TypedScopeCreator.this.unknownType, true);
                if (ownerType != null && (isExtern || ownerType.isFunctionPrototypeType())) {
                    ownerType.defineInferredProperty(propName, TypedScopeCreator.this.unknownType, n);
                    continue;
                }
                TypedScopeCreator.this.typeRegistry.registerPropertyOnType(propName, ownerType == null ? TypedScopeCreator.this.unknownType : ownerType);
            }
        }
    }

    private static class DiscoverEnumsAndTypedefs
    extends NodeTraversal.AbstractShallowStatementCallback {
        private final JSTypeRegistry registry;

        DiscoverEnumsAndTypedefs(JSTypeRegistry registry) {
            this.registry = registry;
        }

        @Override
        public void visit(NodeTraversal t, Node node, Node parent) {
            switch (node.getType()) {
                case 118: {
                    for (Node child = node.getFirstChild(); child != null; child = child.getNext()) {
                        this.identifyNameNode(child, NodeUtil.getBestJSDocInfo(child));
                    }
                    break;
                }
                case 130: {
                    Node firstChild = node.getFirstChild();
                    if (firstChild.isAssign()) {
                        this.identifyNameNode(firstChild.getFirstChild(), firstChild.getJSDocInfo());
                        break;
                    }
                    this.identifyNameNode(firstChild, firstChild.getJSDocInfo());
                }
            }
        }

        private void identifyNameNode(Node nameNode, JSDocInfo info) {
            if (nameNode.isQualifiedName() && info != null) {
                if (info.hasEnumParameterType()) {
                    this.registry.identifyNonNullableName(nameNode.getQualifiedName());
                } else if (info.hasTypedefType()) {
                    this.registry.identifyNonNullableName(nameNode.getQualifiedName());
                }
            }
        }
    }

    private class DeferredSetType {
        final Node node;
        final JSType type;

        DeferredSetType(Node node, JSType type) {
            Preconditions.checkNotNull((Object)node);
            Preconditions.checkNotNull((Object)type);
            this.node = node;
            this.type = type;
            node.setJSType(type);
        }

        void resolve(Scope scope) {
            this.node.setJSType(this.type.resolve(TypedScopeCreator.this.typeParsingErrorReporter, scope));
        }
    }
}

