/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Maps;
import com.google.debugging.sourcemap.Base64;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NameGenerator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.RenamingMap;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class ReplaceIdGenerators
implements CompilerPass {
    static final DiagnosticType NON_GLOBAL_ID_GENERATOR_CALL = DiagnosticType.error("JSC_NON_GLOBAL_ID_GENERATOR_CALL", "Id generator call must be in the global scope");
    static final DiagnosticType CONDITIONAL_ID_GENERATOR_CALL = DiagnosticType.error("JSC_CONDITIONAL_ID_GENERATOR_CALL", "Id generator call must be unconditional");
    static final DiagnosticType CONFLICTING_GENERATOR_TYPE = DiagnosticType.error("JSC_CONFLICTING_ID_GENERATOR_TYPE", "Id generator can only be one of consistent, inconsistent, mapped or stable.");
    static final DiagnosticType INVALID_GENERATOR_ID_MAPPING = DiagnosticType.error("JSC_INVALID_GENERATOR_ID_MAPPING", "Invalid generator id mapping. {0}");
    static final DiagnosticType MISSING_NAME_MAP_FOR_GENERATOR = DiagnosticType.warning("JSC_MISSING_NAME_MAP_FOR_GENERATOR", "The mapped id generator, does not have a renaming map supplied.");
    static final DiagnosticType INVALID_GENERATOR_PARAMETER = DiagnosticType.warning("JSC_INVALID_GENERATOR_PARAMETER", "An id generator must be called with a literal.");
    private final AbstractCompiler compiler;
    private final Map<String, NameSupplier> nameGenerators;
    private final Map<String, Map<String, String>> consistNameMap;
    private final Map<String, Map<String, String>> idGeneratorMaps;
    private final Map<String, BiMap<String, String>> previousMap;
    private final boolean generatePseudoNames;
    public static final RenamingMap UNIQUE = new UniqueRenamingToken();

    public ReplaceIdGenerators(AbstractCompiler compiler, Map<String, RenamingMap> idGens, boolean generatePseudoNames, String previousMapSerialized) {
        this.compiler = compiler;
        this.generatePseudoNames = generatePseudoNames;
        this.nameGenerators = Maps.newLinkedHashMap();
        this.idGeneratorMaps = Maps.newLinkedHashMap();
        this.consistNameMap = Maps.newLinkedHashMap();
        Map<String, BiMap<String, String>> previousMap = this.parsePreviousResults(previousMapSerialized);
        this.previousMap = previousMap;
        if (idGens != null) {
            for (Map.Entry<String, RenamingMap> gen : idGens.entrySet()) {
                String name = gen.getKey();
                RenamingMap map = gen.getValue();
                if (map instanceof UniqueRenamingToken) {
                    this.nameGenerators.put(name, this.createNameSupplier(RenameStrategy.INCONSISTENT, previousMap.get(name)));
                } else {
                    this.nameGenerators.put(name, ReplaceIdGenerators.createNameSupplier(RenameStrategy.MAPPED, map));
                }
                this.idGeneratorMaps.put(name, Maps.newLinkedHashMap());
            }
        }
    }

    private NameSupplier createNameSupplier(RenameStrategy renameStrategy, BiMap<String, String> previousMappings) {
        ImmutableBiMap immutableBiMap = previousMappings = previousMappings != null ? previousMappings : ImmutableBiMap.of();
        if (renameStrategy == RenameStrategy.STABLE) {
            return new StableNameSupplier();
        }
        if (this.generatePseudoNames) {
            return new PseudoNameSuppier(renameStrategy);
        }
        return new ObfuscatedNameSuppier(renameStrategy, (BiMap<String, String>)previousMappings);
    }

    private static NameSupplier createNameSupplier(RenameStrategy renameStrategy, RenamingMap mappings) {
        Preconditions.checkState((renameStrategy == RenameStrategy.MAPPED ? 1 : 0) != 0);
        return new MappedNameSupplier(mappings);
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new GatherGenerators());
        if (!this.nameGenerators.isEmpty()) {
            NodeTraversal.traverse(this.compiler, root, new ReplaceGenerators());
        }
    }

    public String getSerializedIdMappings() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Map<String, String>> replacements : this.idGeneratorMaps.entrySet()) {
            if (replacements.getValue().isEmpty()) continue;
            sb.append("[");
            sb.append(replacements.getKey());
            sb.append("]\n\n");
            for (Map.Entry<String, String> replacement : replacements.getValue().entrySet()) {
                sb.append(replacement.getKey());
                sb.append(':');
                sb.append(replacement.getValue());
                sb.append("\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private Map<String, BiMap<String, String>> parsePreviousResults(String serializedMap) {
        if (serializedMap == null || serializedMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap resultMap = Maps.newHashMap();
        BufferedReader reader = new BufferedReader(new StringReader(serializedMap));
        BiMap currentSectionMap = null;
        int lineIndex = 0;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                ++lineIndex;
                if (line.isEmpty()) continue;
                if (line.charAt(0) == '[') {
                    String currentSection = line.substring(1, line.length() - 1);
                    currentSectionMap = (BiMap)resultMap.get(currentSection);
                    if (currentSectionMap == null) {
                        currentSectionMap = HashBiMap.create();
                        resultMap.put(currentSection, currentSectionMap);
                        continue;
                    }
                    ReplaceIdGenerators.reportInvalidLine(line, lineIndex);
                    return Collections.emptyMap();
                }
                int split = line.indexOf(58);
                if (split != -1) {
                    String name = line.substring(0, split);
                    String location = line.substring(split + 1, line.length());
                    currentSectionMap.put((Object)name, (Object)location);
                    continue;
                }
                ReplaceIdGenerators.reportInvalidLine(line, lineIndex);
                return Collections.emptyMap();
            }
        }
        catch (IOException e) {
            JSError.make(INVALID_GENERATOR_ID_MAPPING, e.getMessage());
        }
        return resultMap;
    }

    private static void reportInvalidLine(String line, int lineIndex) {
        JSError.make(INVALID_GENERATOR_ID_MAPPING, "line(" + line + "): " + lineIndex);
    }

    static String getIdForGeneratorNode(boolean consistent, Node n) {
        Preconditions.checkState((n.isString() || n.isStringKey() ? 1 : 0) != 0);
        if (consistent) {
            return n.getString();
        }
        return n.getSourceFileName() + ':' + n.getLineno() + ":" + n.getCharno();
    }

    private class ReplaceGenerators
    extends NodeTraversal.AbstractPostOrderCallback {
        private ReplaceGenerators() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            Node arg;
            if (!n.isCall()) {
                return;
            }
            String callName = n.getFirstChild().getQualifiedName();
            NameSupplier nameGenerator = (NameSupplier)ReplaceIdGenerators.this.nameGenerators.get(callName);
            if (nameGenerator == null) {
                return;
            }
            if (!t.inGlobalScope() && nameGenerator.getRenameStrategy() == RenameStrategy.INCONSISTENT) {
                ReplaceIdGenerators.this.compiler.report(t.makeError(n, NON_GLOBAL_ID_GENERATOR_CALL, new String[0]));
                return;
            }
            if (nameGenerator.getRenameStrategy() == RenameStrategy.INCONSISTENT) {
                for (Node ancestor : n.getAncestors()) {
                    if (!NodeUtil.isControlStructure(ancestor)) continue;
                    ReplaceIdGenerators.this.compiler.report(t.makeError(n, CONDITIONAL_ID_GENERATOR_CALL, new String[0]));
                    return;
                }
            }
            if ((arg = n.getFirstChild().getNext()) == null) {
                ReplaceIdGenerators.this.compiler.report(t.makeError(n, INVALID_GENERATOR_PARAMETER, new String[0]));
            } else if (arg.isString()) {
                String rename = this.getObfuscatedName(arg, callName, nameGenerator, arg.getString());
                parent.replaceChild(n, IR.string(rename));
                ReplaceIdGenerators.this.compiler.reportCodeChange();
            } else if (arg.isObjectLit()) {
                for (Node key : arg.children()) {
                    String rename = this.getObfuscatedName(key, callName, nameGenerator, key.getString());
                    key.setString(rename);
                    key.putBooleanProp(36, true);
                }
                arg.detachFromParent();
                parent.replaceChild(n, arg);
                ReplaceIdGenerators.this.compiler.reportCodeChange();
            } else {
                ReplaceIdGenerators.this.compiler.report(t.makeError(n, INVALID_GENERATOR_PARAMETER, new String[0]));
            }
        }

        private String getObfuscatedName(Node id, String callName, NameSupplier nameGenerator, String name) {
            String rename = null;
            Map idGeneratorMap = (Map)ReplaceIdGenerators.this.idGeneratorMaps.get(callName);
            String instanceId = ReplaceIdGenerators.getIdForGeneratorNode(nameGenerator.getRenameStrategy() != RenameStrategy.INCONSISTENT, id);
            if (nameGenerator.getRenameStrategy() == RenameStrategy.CONSISTENT) {
                Map entry = (Map)ReplaceIdGenerators.this.consistNameMap.get(callName);
                rename = (String)entry.get(instanceId);
                if (rename == null) {
                    rename = nameGenerator.getName(instanceId, name);
                    entry.put(instanceId, rename);
                }
            } else {
                rename = nameGenerator.getName(instanceId, name);
            }
            idGeneratorMap.put(rename, instanceId);
            return rename;
        }
    }

    private class GatherGenerators
    extends NodeTraversal.AbstractPostOrderCallback {
        private GatherGenerators() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            JSDocInfo doc = n.getJSDocInfo();
            if (doc == null) {
                return;
            }
            int numGeneratorAnnotations = (doc.isConsistentIdGenerator() ? 1 : 0) + (doc.isIdGenerator() ? 1 : 0) + (doc.isStableIdGenerator() ? 1 : 0) + (doc.isMappedIdGenerator() ? 1 : 0);
            if (numGeneratorAnnotations == 0) {
                return;
            }
            if (numGeneratorAnnotations > 1) {
                ReplaceIdGenerators.this.compiler.report(t.makeError(n, CONFLICTING_GENERATOR_TYPE, new String[0]));
            }
            String name = null;
            if (n.isAssign()) {
                name = n.getFirstChild().getQualifiedName();
            } else if (n.isVar()) {
                name = n.getFirstChild().getString();
            } else if (n.isFunction() && (name = n.getFirstChild().getString()).isEmpty()) {
                return;
            }
            if (doc.isConsistentIdGenerator()) {
                ReplaceIdGenerators.this.consistNameMap.put(name, Maps.newLinkedHashMap());
                ReplaceIdGenerators.this.nameGenerators.put(name, ReplaceIdGenerators.this.createNameSupplier(RenameStrategy.CONSISTENT, (BiMap<String, String>)((BiMap)ReplaceIdGenerators.this.previousMap.get(name))));
            } else if (doc.isStableIdGenerator()) {
                ReplaceIdGenerators.this.nameGenerators.put(name, ReplaceIdGenerators.this.createNameSupplier(RenameStrategy.STABLE, (BiMap<String, String>)((BiMap)ReplaceIdGenerators.this.previousMap.get(name))));
            } else if (doc.isIdGenerator()) {
                ReplaceIdGenerators.this.nameGenerators.put(name, ReplaceIdGenerators.this.createNameSupplier(RenameStrategy.INCONSISTENT, (BiMap<String, String>)((BiMap)ReplaceIdGenerators.this.previousMap.get(name))));
            } else if (doc.isMappedIdGenerator()) {
                NameSupplier supplier = (NameSupplier)ReplaceIdGenerators.this.nameGenerators.get(name);
                if (supplier == null || supplier.getRenameStrategy() != RenameStrategy.MAPPED) {
                    ReplaceIdGenerators.this.compiler.report(t.makeError(n, MISSING_NAME_MAP_FOR_GENERATOR, new String[0]));
                    return;
                }
            } else {
                throw new IllegalStateException("unexpected");
            }
            ReplaceIdGenerators.this.idGeneratorMaps.put(name, Maps.newLinkedHashMap());
        }
    }

    private static class MappedNameSupplier
    implements NameSupplier {
        private final RenamingMap map;

        MappedNameSupplier(RenamingMap map) {
            this.map = map;
        }

        @Override
        public String getName(String id, String name) {
            return this.map.get(name);
        }

        @Override
        public RenameStrategy getRenameStrategy() {
            return RenameStrategy.MAPPED;
        }
    }

    private static class StableNameSupplier
    implements NameSupplier {
        private StableNameSupplier() {
        }

        @Override
        public String getName(String id, String name) {
            return Base64.base64EncodeInt(name.hashCode());
        }

        @Override
        public RenameStrategy getRenameStrategy() {
            return RenameStrategy.STABLE;
        }
    }

    private static class PseudoNameSuppier
    implements NameSupplier {
        private int counter = 0;
        private RenameStrategy renameStrategy;

        public PseudoNameSuppier(RenameStrategy renameStrategy) {
            this.renameStrategy = renameStrategy;
        }

        @Override
        public String getName(String id, String name) {
            if (this.renameStrategy == RenameStrategy.INCONSISTENT) {
                return name + "$" + this.counter++;
            }
            return name + "$0";
        }

        @Override
        public RenameStrategy getRenameStrategy() {
            return this.renameStrategy;
        }
    }

    private static class ObfuscatedNameSuppier
    implements NameSupplier {
        private final NameGenerator generator;
        private final Map<String, String> previousMappings;
        private RenameStrategy renameStrategy;

        public ObfuscatedNameSuppier(RenameStrategy renameStrategy, BiMap<String, String> previousMappings) {
            this.previousMappings = previousMappings.inverse();
            this.generator = new NameGenerator(previousMappings.keySet(), "", null);
            this.renameStrategy = renameStrategy;
        }

        @Override
        public String getName(String id, String name) {
            String newName = this.previousMappings.get(id);
            if (newName == null) {
                newName = this.generator.generateNextName();
            }
            return newName;
        }

        @Override
        public RenameStrategy getRenameStrategy() {
            return this.renameStrategy;
        }
    }

    private static interface NameSupplier {
        public String getName(String var1, String var2);

        public RenameStrategy getRenameStrategy();
    }

    static enum RenameStrategy {
        CONSISTENT,
        INCONSISTENT,
        MAPPED,
        STABLE;

    }

    private static class UniqueRenamingToken
    implements RenamingMap {
        private UniqueRenamingToken() {
        }

        @Override
        public String get(String value) {
            return null;
        }
    }
}

