/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DataFlowAnalysis;
import com.google.javascript.jscomp.JoinOp;
import com.google.javascript.jscomp.LatticeElement;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.graph.GraphNode;
import com.google.javascript.rhino.Node;
import java.util.Collection;
import java.util.List;
import java.util.Set;

class MaybeReachingVariableUse
extends DataFlowAnalysis<Node, ReachingUses> {
    private final Scope jsScope;
    private final Set<Scope.Var> escaped;

    MaybeReachingVariableUse(ControlFlowGraph<Node> controlFlowGraph, Scope scope, AbstractCompiler abstractCompiler) {
        super(controlFlowGraph, new ReachingUsesJoinOp());
        this.jsScope = scope;
        this.escaped = Sets.newHashSet();
        MaybeReachingVariableUse.computeEscaped(scope, this.escaped, abstractCompiler);
    }

    @Override
    boolean isForward() {
        return false;
    }

    @Override
    ReachingUses createEntryLattice() {
        return new ReachingUses();
    }

    @Override
    ReachingUses createInitialEstimateLattice() {
        return new ReachingUses();
    }

    @Override
    ReachingUses flowThrough(Node node, ReachingUses reachingUses) {
        ReachingUses reachingUses2 = new ReachingUses(reachingUses);
        this.computeMayUse(node, node, reachingUses2, false);
        return reachingUses2;
    }

    private void computeMayUse(Node node, Node node2, ReachingUses reachingUses, boolean bl) {
        switch (node.getType()) {
            case 105: 
            case 125: {
                return;
            }
            case 38: {
                this.addToUseIfLocal(node.getString(), node2, reachingUses);
                return;
            }
            case 108: 
            case 113: 
            case 114: {
                this.computeMayUse(NodeUtil.getConditionExpression(node), node2, reachingUses, bl);
                return;
            }
            case 115: {
                if (!NodeUtil.isForIn(node)) {
                    this.computeMayUse(NodeUtil.getConditionExpression(node), node2, reachingUses, bl);
                } else {
                    Node node3 = node.getFirstChild();
                    Node node4 = node3.getNext();
                    if (NodeUtil.isVar(node3)) {
                        node3 = node3.getLastChild();
                    }
                    if (NodeUtil.isName(node3) && !bl) {
                        this.removeFromUseIfLocal(node3.getString(), reachingUses);
                    }
                    this.computeMayUse(node4, node2, reachingUses, bl);
                }
                return;
            }
            case 100: 
            case 101: {
                this.computeMayUse(node.getLastChild(), node2, reachingUses, true);
                this.computeMayUse(node.getFirstChild(), node2, reachingUses, bl);
                return;
            }
            case 98: {
                this.computeMayUse(node.getLastChild(), node2, reachingUses, true);
                this.computeMayUse(node.getFirstChild().getNext(), node2, reachingUses, true);
                this.computeMayUse(node.getFirstChild(), node2, reachingUses, bl);
                return;
            }
            case 118: {
                Node node5 = node.getFirstChild();
                Preconditions.checkState((boolean)node.hasChildren(), (Object)"AST should be normalized");
                if (node5.hasChildren()) {
                    this.computeMayUse(node5.getFirstChild(), node2, reachingUses, bl);
                    if (!bl) {
                        this.removeFromUseIfLocal(node5.getString(), reachingUses);
                    }
                }
                return;
            }
        }
        if (NodeUtil.isAssignmentOp(node) && NodeUtil.isName(node.getFirstChild())) {
            Node node6 = node.getFirstChild();
            if (!bl) {
                this.removeFromUseIfLocal(node6.getString(), reachingUses);
            }
            if (!NodeUtil.isAssign(node)) {
                this.addToUseIfLocal(node6.getString(), node2, reachingUses);
            }
            this.computeMayUse(node6.getNext(), node2, reachingUses, bl);
        } else {
            Node node7 = node.getLastChild();
            while (node7 != null) {
                this.computeMayUse(node7, node2, reachingUses, bl);
                node7 = node.getChildBefore(node7);
            }
        }
    }

    private void addToUseIfLocal(String string, Node node, ReachingUses reachingUses) {
        Scope.Var var = this.jsScope.getVar(string);
        if (var == null || var.scope != this.jsScope) {
            return;
        }
        if (!this.escaped.contains(var)) {
            reachingUses.mayUseMap.put((Object)var, (Object)node);
        }
    }

    private void removeFromUseIfLocal(String string, ReachingUses reachingUses) {
        Scope.Var var = this.jsScope.getVar(string);
        if (var == null || var.scope != this.jsScope) {
            return;
        }
        if (!this.escaped.contains(var)) {
            reachingUses.mayUseMap.removeAll((Object)var);
        }
    }

    Collection<Node> getUses(String string, Node node) {
        GraphNode graphNode = this.getCfg().getNode(node);
        Preconditions.checkNotNull(graphNode);
        DataFlowAnalysis.FlowState flowState = (DataFlowAnalysis.FlowState)graphNode.getAnnotation();
        return ((ReachingUses)flowState.getOut()).mayUseMap.get((Object)this.jsScope.getVar(string));
    }

    private static class ReachingUsesJoinOp
    implements JoinOp<ReachingUses> {
        private ReachingUsesJoinOp() {
        }

        public ReachingUses apply(List<ReachingUses> list) {
            ReachingUses reachingUses = new ReachingUses();
            for (ReachingUses reachingUses2 : list) {
                reachingUses.mayUseMap.putAll(reachingUses2.mayUseMap);
            }
            return reachingUses;
        }
    }

    static final class ReachingUses
    implements LatticeElement {
        final Multimap<Scope.Var, Node> mayUseMap;

        public ReachingUses() {
            this.mayUseMap = HashMultimap.create();
        }

        public ReachingUses(ReachingUses reachingUses) {
            this.mayUseMap = HashMultimap.create(reachingUses.mayUseMap);
        }

        public boolean equals(Object object) {
            return object instanceof ReachingUses && ((ReachingUses)object).mayUseMap.equals(this.mayUseMap);
        }

        public int hashCode() {
            return this.mayUseMap.hashCode();
        }
    }
}

