/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.GraphReachability;
import com.google.javascript.rhino.Node;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class UnreachableCodeElimination
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass,
NodeTraversal.ScopedCallback {
    private static final Logger logger = Logger.getLogger(UnreachableCodeElimination.class.getName());
    private final AbstractCompiler compiler;
    private final boolean removeNoOpStatements;

    UnreachableCodeElimination(AbstractCompiler compiler, boolean removeNoOpStatements) {
        this.compiler = compiler;
        this.removeNoOpStatements = removeNoOpStatements;
    }

    @Override
    public void exitScope(NodeTraversal t) {
        Scope scope = t.getScope();
        ControlFlowAnalysis cfa = new ControlFlowAnalysis(this.compiler, false, false);
        cfa.process(null, scope.getRootNode());
        ControlFlowGraph<Node> cfg = cfa.getCfg();
        new GraphReachability(cfg).compute(cfg.getEntry().getValue());
        Node root = scope.getRootNode();
        if (scope.isLocal()) {
            root = root.getLastChild();
        }
        NodeTraversal.traverse(this.compiler, root, new EliminationPass(cfg));
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
    }

    @Override
    public void enterScope(NodeTraversal t) {
    }

    private class EliminationPass
    extends NodeTraversal.AbstractShallowCallback {
        private final ControlFlowGraph<Node> cfg;

        private EliminationPass(ControlFlowGraph<Node> cfg) {
            this.cfg = cfg;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (parent == null) {
                return;
            }
            if (n.isFunction() || n.isScript()) {
                return;
            }
            DiGraph.DiGraphNode gNode = this.cfg.getDirectedGraphNode(n);
            if (gNode == null) {
                return;
            }
            if (gNode.getAnnotation() != GraphReachability.REACHABLE || UnreachableCodeElimination.this.removeNoOpStatements && !NodeUtil.mayHaveSideEffects(n, UnreachableCodeElimination.this.compiler)) {
                this.removeDeadExprStatementSafely(n);
                return;
            }
            this.tryRemoveUnconditionalBranching(n);
        }

        private Node tryRemoveUnconditionalBranching(Node n) {
            if (n == null) {
                return n;
            }
            DiGraph.DiGraphNode gNode = this.cfg.getDirectedGraphNode(n);
            if (gNode == null) {
                return n;
            }
            switch (n.getType()) {
                case 4: {
                    if (n.hasChildren()) break;
                }
                case 116: 
                case 117: {
                    List outEdges = gNode.getOutEdges();
                    if (outEdges.size() != 1 || n.getNext() != null && !n.getNext().isFunction()) break;
                    Preconditions.checkState((outEdges.get(0).getValue() == ControlFlowGraph.Branch.UNCOND ? 1 : 0) != 0);
                    Node fallThrough = this.computeFollowing(n);
                    Node nextCfgNode = (Node)outEdges.get(0).getDestination().getValue();
                    if (nextCfgNode != fallThrough) break;
                    this.removeDeadExprStatementSafely(n);
                    return fallThrough;
                }
            }
            return n;
        }

        private Node computeFollowing(Node n) {
            Node next = ControlFlowAnalysis.computeFollowNode(n);
            while (next != null && next.isBlock()) {
                if (next.hasChildren()) {
                    next = next.getFirstChild();
                    continue;
                }
                next = this.computeFollowing(next);
            }
            return next;
        }

        private void removeDeadExprStatementSafely(Node n) {
            Node parent = n.getParent();
            if (n.isEmpty() || n.isBlock() && !n.hasChildren()) {
                return;
            }
            if (NodeUtil.isForIn(parent)) {
                return;
            }
            switch (n.getType()) {
                case 114: {
                    return;
                }
                case 125: {
                    if (!parent.isTry() || !NodeUtil.isTryCatchNodeContainer(n)) break;
                    return;
                }
                case 120: {
                    Node tryNode = parent.getParent();
                    NodeUtil.maybeAddFinally(tryNode);
                }
            }
            if (n.isVar() && !n.getFirstChild().hasChildren()) {
                return;
            }
            NodeUtil.redeclareVarsInsideBranch(n);
            UnreachableCodeElimination.this.compiler.reportCodeChange();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Removing " + n.toString());
            }
            NodeUtil.removeChild(n.getParent(), n);
        }
    }
}

