/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "kn" locale.
 */
public class LocalizedNamesImpl_kn extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "IN",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AO",
        "AQ",
        "AD",
        "AZ",
        "AF",
        "AS",
        "US",
        "AW",
        "AR",
        "AM",
        "DZ",
        "AL",
        "AC",
        "AI",
        "AG",
        "AX",
        "AT",
        "AU",
        "ID",
        "IT",
        "ET",
        "IQ",
        "IR",
        "IL",
        "GQ",
        "EC",
        "EG",
        "UA",
        "UG",
        "UZ",
        "KP",
        "MP",
        "UY",
        "SV",
        "EE",
        "ER",
        "IE",
        "IM",
        "IS",
        "OM",
        "QO",
        "KZ",
        "QA",
        "CD",
        "CG",
        "KH",
        "KI",
        "KG",
        "KE",
        "CK",
        "CW",
        "KW",
        "CA",
        "BQ",
        "CV",
        "KY",
        "CC",
        "KM",
        "CO",
        "XK",
        "CR",
        "CI",
        "IC",
        "CM",
        "CU",
        "CX",
        "HR",
        "CP",
        "GY",
        "GN",
        "GW",
        "GI",
        "GP",
        "GU",
        "GG",
        "GA",
        "GM",
        "GL",
        "GR",
        "GD",
        "GT",
        "GH",
        "TD",
        "CL",
        "CN",
        "CZ",
        "JP",
        "JM",
        "DE",
        "GE",
        "ZW",
        "DJ",
        "JE",
        "JO",
        "ZM",
        "TR",
        "TC",
        "TN",
        "TV",
        "TO",
        "TK",
        "TG",
        "TT",
        "TA",
        "DK",
        "DG",
        "DM",
        "DO",
        "TJ",
        "TZ",
        "TM",
        "TH",
        "TW",
        "ZA",
        "KR",
        "GS",
        "SS",
        "NA",
        "NF",
        "NO",
        "NI",
        "NU",
        "AN",
        "NL",
        "NP",
        "NE",
        "NG",
        "NR",
        "NC",
        "NZ",
        "PA",
        "PG",
        "PY",
        "PW",
        "EH",
        "PK",
        "PN",
        "TL",
        "PE",
        "PT",
        "PL",
        "PS",
        "PR",
        "FO",
        "FK",
        "FJ",
        "FI",
        "PH",
        "FR",
        "GF",
        "TF",
        "PF",
        "BM",
        "BG",
        "BH",
        "BS",
        "BD",
        "BB",
        "BI",
        "BF",
        "BJ",
        "BY",
        "BZ",
        "BE",
        "BO",
        "BW",
        "BV",
        "BA",
        "GB",
        "VG",
        "IO",
        "BN",
        "BR",
        "IN",
        "BT",
        "MO",
        "MG",
        "CF",
        "MM",
        "YT",
        "MW",
        "MY",
        "MS",
        "MR",
        "MU",
        "MQ",
        "MH",
        "ML",
        "MT",
        "MV",
        "MX",
        "FM",
        "MN",
        "ME",
        "MZ",
        "MC",
        "MA",
        "MD",
        "MK",
        "VI",
        "UM",
        "EU",
        "YE",
        "RU",
        "RE",
        "RW",
        "RO",
        "LU",
        "LV",
        "LA",
        "LI",
        "LT",
        "LY",
        "LR",
        "LB",
        "LS",
        "VU",
        "WF",
        "VN",
        "VE",
        "VA",
        "LK",
        "AE",
        "WS",
        "ST",
        "SG",
        "SX",
        "SL",
        "SY",
        "SC",
        "SR",
        "SD",
        "SN",
        "EA",
        "RS",
        "KN",
        "PM",
        "BL",
        "MF",
        "LC",
        "VC",
        "SH",
        "CY",
        "SO",
        "SB",
        "SA",
        "ES",
        "SM",
        "SK",
        "SI",
        "SZ",
        "SJ",
        "CH",
        "SE",
        "HU",
        "HM",
        "HK",
        "HT",
        "HN",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "ಪ್ರಪಂಚ");
    namesMap.put("002", "ಆಫ್ರಿಕಾ");
    namesMap.put("003", "ಉತ್ತರ ಅಮೇರಿಕಾ");
    namesMap.put("005", "ದಕ್ಷಿಣ ಅಮೇರಿಕಾ");
    namesMap.put("009", "ಓಶಿಯೇನಿಯಾ");
    namesMap.put("011", "ಪಶ್ಚಿಮ ಆಫ್ರಿಕಾ");
    namesMap.put("013", "ಮಧ್ಯ ಅಮೇರಿಕಾ");
    namesMap.put("014", "ಪೂರ್ವ ಆಫ್ರಿಕಾ");
    namesMap.put("015", "ಉತ್ತರ ಆಫ್ರಿಕಾ");
    namesMap.put("017", "ಮಧ್ಯ ಆಫ್ರಿಕಾ");
    namesMap.put("018", "ಆಫ್ರಿಕಾದ ದಕ್ಷಿಣ ಭಾಗ");
    namesMap.put("019", "ಅಮೆರಿಕಾಸ್");
    namesMap.put("021", "ಅಮೇರಿಕಾದ ಉತ್ತರ ಭಾಗ");
    namesMap.put("029", "ಕೆರೀಬಿಯನ್");
    namesMap.put("030", "ಏಷ್ಯಾದ ಪೂರ್ವ ಭಾಗ");
    namesMap.put("034", "ಏಷ್ಯಾದ ದಕ್ಷಿಣ ಭಾಗ");
    namesMap.put("035", "ಆಗ್ನೇಯ ಏಷ್ಯಾ");
    namesMap.put("039", "ದಕ್ಷಿಣ ಯೂರೋಪ್");
    namesMap.put("053", "ಆಸ್ಟ್ರೇಲಿಯೇಷಿಯಾ");
    namesMap.put("054", "ಮೇಲಿನೇಶಿಯಾ");
    namesMap.put("057", "ಮೈಕ್ರೋನೇಶಿಯನ್ ಪ್ರದೇಶ");
    namesMap.put("061", "ಪೋಲಿನೇಶಿಯಾ");
    namesMap.put("142", "ಏಷ್ಯಾ");
    namesMap.put("143", "ಮಧ್ಯ ಏಷ್ಯಾ");
    namesMap.put("145", "ಪಶ್ಚಿಮ ಏಷ್ಯಾ");
    namesMap.put("150", "ಯೂರೋಪ್");
    namesMap.put("151", "ಪೂರ್ವ ಯೂರೋಪ್");
    namesMap.put("154", "ಉತ್ತರ ಯೂರೋಪ್");
    namesMap.put("155", "ಪಶ್ಚಿಮ ಯೂರೋಪ್");
    namesMap.put("419", "ಲ್ಯಾಟಿನ್ ಅಮೇರಿಕಾ");
    namesMap.put("AC", "ಅಸೆನ್ಶನ್ ದ್ವೀಪ");
    namesMap.put("AD", "ಅಂಡೋರಾ");
    namesMap.put("AE", "ಸಂಯುಕ್ತ ಅರಬ್ ಎಮಿರೇಟಸ್");
    namesMap.put("AF", "ಅಫಘಾನಿಸ್ಥಾನ್");
    namesMap.put("AG", "ಆಂಟಿಗುವಾ ಮತ್ತು ಬರ್ಬುಡಾ");
    namesMap.put("AI", "ಆಂಗುಯಿಲ್ಲಾ");
    namesMap.put("AL", "ಅಲ್ಬೇನಿಯಾ");
    namesMap.put("AM", "ಅರ್ಮೇನಿಯಾ");
    namesMap.put("AN", "ನೆದರ್‌ಲ್ಯಾಂಡ್");
    namesMap.put("AO", "ಅಂಗೋಲಾ");
    namesMap.put("AQ", "ಅಂಟಾರ್ಟಿಕಾ");
    namesMap.put("AR", "ಅರ್ಜೆಂಟಿನಾ");
    namesMap.put("AS", "ಅಮೇರಿಕನ್ ಸಮೋವಾ");
    namesMap.put("AT", "ಆಸ್ಟ್ರಿಯಾ");
    namesMap.put("AU", "ಆಸ್ಟ್ರೇಲಿಯ");
    namesMap.put("AW", "ಅರುಬಾ");
    namesMap.put("AX", "ಆಲ್ಯಾಂಡ್ ದ್ವೀಪಗಳು");
    namesMap.put("AZ", "ಅಜರ್ಬೈಜಾನ್");
    namesMap.put("BA", "ಬೋಸ್ನಿಯಾ ಮತ್ತು ಹರ್ಜೆಗೋವಿನಾ");
    namesMap.put("BB", "ಬಾರ್ಬಡೋಸ್");
    namesMap.put("BD", "ಬಾಂಗ್ಲಾದೇಶ್");
    namesMap.put("BE", "ಬೆಲ್ಜಿಯಮ್");
    namesMap.put("BF", "ಬುರ್ಕಿನಾ ಫಾಸೋ");
    namesMap.put("BG", "ಬಲ್ಗೇರಿಯಾ");
    namesMap.put("BH", "ಬಹರೈನ್");
    namesMap.put("BI", "ಬುರುಂಡಿ");
    namesMap.put("BJ", "ಬೆನಿನ್");
    namesMap.put("BL", "ಸೇಂಟ್ ಬಾರ್ಥೆಲೆಮಿ");
    namesMap.put("BM", "ಬರ್ಮುಡಾ");
    namesMap.put("BN", "ಬ್ರೂನಿ");
    namesMap.put("BO", "ಬೊಲಿವಿಯಾ");
    namesMap.put("BQ", "ಕೆರೀಬಿಯನ್ ನೆದರ್‌ಲ್ಯಾಂಡ್ಸ್");
    namesMap.put("BR", "ಬ್ರೆಜಿಲ್");
    namesMap.put("BS", "ಬಹಾಮಾಸ್");
    namesMap.put("BT", "ಭೂತಾನ್");
    namesMap.put("BV", "ಬೋವೆಟ್ ದ್ವೀಪ");
    namesMap.put("BW", "ಬೋಟ್ಸ್‌ವಾನಾ");
    namesMap.put("BY", "ಬೆಲಾರಸ್");
    namesMap.put("BZ", "ಬೆಲಿಜ್");
    namesMap.put("CA", "ಕೆನಡಾ");
    namesMap.put("CC", "ಕೊಕೊಸ್ ದ್ವೀಪಗಳು");
    namesMap.put("CD", "ಕಾಂಗೋ - ಕಿನ್ಶಾಸಾ");
    namesMap.put("CF", "ಮಧ್ಯ ಆಫ್ರಿಕಾ ಗಣರಾಜ್ಯ");
    namesMap.put("CG", "ಕಾಂಗೋ - ಬ್ರಾಜಾವಿಲ್ಲೇ");
    namesMap.put("CH", "ಸ್ವಿಟ್ಜರ್ಲ್ಯಾಂಡ್");
    namesMap.put("CI", "ಕೋತ್‌ ದಿವಾರ್‍");
    namesMap.put("CK", "ಕುಕ್ ದ್ವೀಪಗಳು");
    namesMap.put("CL", "ಚಿಲಿ");
    namesMap.put("CM", "ಕ್ಯಾಮರೋನ್");
    namesMap.put("CN", "ಚೀನಾ");
    namesMap.put("CO", "ಕೊಲಂಬಿಯಾ");
    namesMap.put("CP", "ಕ್ಲಿಪ್ಪರ್‌ಟಾನ್ ದ್ವೀಪಗಳು");
    namesMap.put("CR", "ಕೊಸ್ಟಾ ರಿಕಾ");
    namesMap.put("CU", "ಕ್ಯೂಬಾ");
    namesMap.put("CV", "ಕೇಪ್ ವರ್ಡೆ");
    namesMap.put("CW", "ಕುರಾಕಾವ್");
    namesMap.put("CX", "ಕ್ರಿಸ್ಮಸ್ ದ್ವೀಪ");
    namesMap.put("CY", "ಸೈಪ್ರಸ್");
    namesMap.put("CZ", "ಚೆಕ್ ರಿಪಬ್ಲಿಕ್");
    namesMap.put("DE", "ಜರ್ಮನಿ");
    namesMap.put("DG", "ಡೈಗೋ ಗಾರ್ಸಿಯ");
    namesMap.put("DJ", "ಜಿಬೋಟಿ");
    namesMap.put("DK", "ಡೆನ್ಮಾರ್ಕ್");
    namesMap.put("DM", "ಡೊಮಿನಿಕಾ");
    namesMap.put("DO", "ಡೊಮೆನಿಕನ್ ರಿಪಬ್ಲಿಕ್");
    namesMap.put("DZ", "ಅಲ್ಗೇರಿಯಾ");
    namesMap.put("EA", "ಸೆಯುಟಾ ಹಾಗೂ ಮೆಲಿಲ್ಲಾ");
    namesMap.put("EC", "ಈಕ್ವೆಡಾರ್");
    namesMap.put("EE", "ಎಸ್ಟೋನಿಯಾ");
    namesMap.put("EG", "ಈಜಿಪ್ಟ್");
    namesMap.put("EH", "ಪಶ್ಚಿಮ ಸಹಾರಾ");
    namesMap.put("ER", "ಏರಿಟ್ರಿಯಾ");
    namesMap.put("ES", "ಸ್ಪೇನ್");
    namesMap.put("ET", "ಇಥಿಯೋಪಿಯಾ");
    namesMap.put("EU", "ಯುರೋಪಿಯನ್ ಯೂನಿಯನ್");
    namesMap.put("FI", "ಫಿನ್‌ಲ್ಯಾಂಡ್");
    namesMap.put("FJ", "ಫಿಜಿ");
    namesMap.put("FK", "ಫಾಲ್ಕ್‌ಲ್ಯಾಂಡ್ ದ್ವೀಪಗಳು");
    namesMap.put("FM", "ಮೈಕ್ರೋನೇಶಿಯಾ");
    namesMap.put("FO", "ಫರೋ ದ್ವೀಪಗಳು");
    namesMap.put("FR", "ಫ್ರಾನ್ಸ್");
    namesMap.put("GA", "ಗೆಬೊನ್");
    namesMap.put("GB", "ಬ್ರಿಟನ್/ಇಂಗ್ಲೆಂಡ್");
    namesMap.put("GD", "ಗ್ರೆನೆಡಾ");
    namesMap.put("GE", "ಜಾರ್ಜಿಯಾ");
    namesMap.put("GF", "ಫ್ರೆಂಚ್ ಗಯಾನಾ");
    namesMap.put("GG", "ಗುರ್ನ್‌ಸೆ");
    namesMap.put("GH", "ಘಾನಾ");
    namesMap.put("GI", "ಗಿಬ್ರಾಲ್ಟರ್");
    namesMap.put("GL", "ಗ್ರೀನ್‌ಲ್ಯಾಂಡ್");
    namesMap.put("GM", "ಗ್ಯಾಂಬಿಯಾ");
    namesMap.put("GN", "ಗಿನಿ");
    namesMap.put("GP", "ಗುಡೆಲೋಪ್");
    namesMap.put("GQ", "ಈಕ್ವೆಟೋರಿಯಲ್ ಗಿನಿ");
    namesMap.put("GR", "ಗ್ರೀಸ್");
    namesMap.put("GS", "ದಕ್ಷಿಣ ಜಾರ್ಜಿಯಾ ಮತ್ತು ದಕ್ಷಿಣ ಸ್ಯಾಂಡ್ವಿಚ್ ದ್ವೀಪಗಳು");
    namesMap.put("GT", "ಗ್ವಾಟೆಮಾಲಾ");
    namesMap.put("GU", "ಗುಯಾಮ್");
    namesMap.put("GW", "ಗಿನಿ-ಬಿಸ್ಸಾವ್");
    namesMap.put("GY", "ಗಯಾನಾ");
    namesMap.put("HK", "ಹಾಂಕ್‌ ಕಾಂಗ್ SAR ಚೈನಾ");
    namesMap.put("HM", "ಹರ್ಡ್ ದ್ವೀಪ ಮತ್ತು ಮ್ಯಾಕ್ಡೊನಾಲ್ಡ್ ದ್ವೀಪಗಳು");
    namesMap.put("HN", "ಹೊಂಡುರಾಸ್");
    namesMap.put("HR", "ಕ್ರೊಯೇಶಿಯಾ");
    namesMap.put("HT", "ಹೈಟಿ");
    namesMap.put("HU", "ಹಂಗಾರಿ");
    namesMap.put("IC", "ಕ್ಯಾನರಿ ದ್ವೀಪಗಳು");
    namesMap.put("ID", "ಇಂಡೋನೇಶಿಯಾ");
    namesMap.put("IE", "ಐರ್ಲೆಂಡ್");
    namesMap.put("IL", "ಇಸ್ರೇಲ್");
    namesMap.put("IM", "ಐಲ್ ಆಫ್ ಮ್ಯಾನ್");
    namesMap.put("IN", "ಭಾರತ");
    namesMap.put("IO", "ಬ್ರಿಟೀಶ್ ಇಂಡಿಯನ್ ಮಹಾಸಾಗರ ಪ್ರದೇಶ");
    namesMap.put("IQ", "ಇರಾಕ್");
    namesMap.put("IR", "ಇರಾನ್");
    namesMap.put("IS", "ಐಸ್‌ಲ್ಯಾಂಡ್");
    namesMap.put("IT", "ಇಟಲಿ");
    namesMap.put("JE", "ಜೆರ್ಸಿ");
    namesMap.put("JM", "ಜಮೈಕಾ");
    namesMap.put("JO", "ಜೋರ್ಡಾನ್");
    namesMap.put("JP", "ಜಪಾನ್");
    namesMap.put("KE", "ಕೀನ್ಯಾ");
    namesMap.put("KG", "ಕಿರ್ಗಿಸ್ಥಾನ್");
    namesMap.put("KH", "ಕಾಂಬೋಡಿಯಾ");
    namesMap.put("KI", "ಕಿರಿಬಾತಿ");
    namesMap.put("KM", "ಕೊಮೊರೊಸ್");
    namesMap.put("KN", "ಸೇಂಟ್ ಕಿಟ್ಸ್ ಮತ್ತು ನೆವಿಸ್");
    namesMap.put("KP", "ಉತ್ತರ ಕೋರಿಯಾ");
    namesMap.put("KR", "ದಕ್ಷಿಣ ಕೋರಿಯಾ");
    namesMap.put("KW", "ಕುವೈತ್");
    namesMap.put("KY", "ಕೇಮನ್ ದ್ವೀಪಗಳು");
    namesMap.put("KZ", "ಕಝಾಕಿಸ್ಥಾನ್");
    namesMap.put("LA", "ಲಾವೋಸ್");
    namesMap.put("LB", "ಲೆಬನಾನ್");
    namesMap.put("LC", "ಸೇಂಟ್ ಲೂಸಿಯಾ");
    namesMap.put("LI", "ಲಿಚೆನ್‌ಸ್ಟೈನ್");
    namesMap.put("LK", "ಶ್ರೀಲಂಕಾ");
    namesMap.put("LR", "ಲಿಬೇರಿಯಾ");
    namesMap.put("LS", "ಲೆಸೊಥೋ");
    namesMap.put("LT", "ಲಿಥುವೇನಿಯಾ");
    namesMap.put("LU", "ಲಕ್ಸಂಬರ್ಗ್");
    namesMap.put("LV", "ಲಾಟ್ವಿಯಾ");
    namesMap.put("LY", "ಲಿಬಿಯಾ");
    namesMap.put("MA", "ಮೊರಾಕ್ಕೊ");
    namesMap.put("MC", "ಮೊನಾಕೊ");
    namesMap.put("MD", "ಮೊಲ್ಡೋವಾ");
    namesMap.put("ME", "ಮೊಂಟೆನೆಗ್ರೋ");
    namesMap.put("MF", "ಸೇಂಟ್ ಮಾರ್ಟಿನ್");
    namesMap.put("MG", "ಮಡಗಾಸ್ಕರ್");
    namesMap.put("MH", "ಮಾರ್ಶಲ್ ದ್ವೀಪಗಳು");
    namesMap.put("MK", "ಮ್ಯಾಸಿಡೋನಿಯಾ");
    namesMap.put("ML", "ಮಾಲಿ");
    namesMap.put("MM", "ಮಯನ್ಮಾರ್");
    namesMap.put("MN", "ಮೊಂಗೋಲಿಯಾ");
    namesMap.put("MO", "ಮಖಾವ್ SAR ಚೈನಾ");
    namesMap.put("MP", "ಉತ್ತರ ಮರಿಯಾನಾ ದ್ವೀಪಗಳು");
    namesMap.put("MQ", "ಮಾರ್ಟಿನಿಕ್");
    namesMap.put("MR", "ಮಾರಿಟೇನಿಯಾ");
    namesMap.put("MS", "ಮಾಂಟ್‌ಸೆರೇಟ್");
    namesMap.put("MT", "ಮಾಲ್ಟಾ");
    namesMap.put("MU", "ಮಾರಿಶಿಯಸ್");
    namesMap.put("MV", "ಮಾಲ್ಡಿವ್ಸ್");
    namesMap.put("MW", "ಮಲಾವಿ");
    namesMap.put("MX", "ಮೆಕ್ಸಿಕೊ");
    namesMap.put("MY", "ಮಲೇಶಿಯಾ");
    namesMap.put("MZ", "ಮೊಜಾಂಬಿಕ್");
    namesMap.put("NA", "ನಮೀಬಿಯಾ");
    namesMap.put("NC", "ನ್ಯೂ ಕ್ಯಾಲಿಡೋನಿಯಾ");
    namesMap.put("NE", "ನೈಜರ್");
    namesMap.put("NF", "ನಾರ್ಫೋಕ್ ದ್ವೀಪ");
    namesMap.put("NG", "ನೈಜೀರಿಯಾ");
    namesMap.put("NI", "ನಿಕಾರಾಗುವಾ");
    namesMap.put("NL", "ನೆದರ್‌ಲ್ಯಾಂಡ್ಸ್");
    namesMap.put("NO", "ನಾರ್ವೇ");
    namesMap.put("NP", "ನೇಪಾಳ");
    namesMap.put("NR", "ನೌರು");
    namesMap.put("NU", "ನಿಯು");
    namesMap.put("NZ", "ನ್ಯೂಜಿಲೆಂಡ್");
    namesMap.put("OM", "ಓಮನ್");
    namesMap.put("PA", "ಪನಾಮಾ");
    namesMap.put("PE", "ಪೆರು");
    namesMap.put("PF", "ಫ್ರೆಂಚ್ ಪೋಲಿನೇಶಿಯಾ");
    namesMap.put("PG", "ಪಪುವಾ ನ್ಯೂಗೀನಿಯಾ");
    namesMap.put("PH", "ಫಿಲಿಫೈನ್ಸ್");
    namesMap.put("PK", "ಪಾಕಿಸ್ತಾನ");
    namesMap.put("PL", "ಪೋಲ್ಯಾಂಡ್");
    namesMap.put("PM", "ಸೇಂಟ್ ಪಿಯರೆ ಮತ್ತು ಮಿಕೆಲನ್");
    namesMap.put("PN", "ಪಿಟ್‌ಕೈರ್ನ್ ದ್ವೀಪಗಳು");
    namesMap.put("PR", "ಪ್ಯೂರ್ಟೋ ರಿಕೊ");
    namesMap.put("PS", "ಪ್ಯಾಲಿಸ್ಟೇನಿಯನ್ ಪ್ರದೇಶ");
    namesMap.put("PT", "ಪೋರ್ಚುಗಲ್");
    namesMap.put("PW", "ಪಲಾವು");
    namesMap.put("PY", "ಪರಾಗ್ವೇ");
    namesMap.put("QA", "ಕತಾರ್");
    namesMap.put("QO", "ಔಟ್‌‌ಲೇಯಿಂಗ್ ಓಷಿಯಾನಿಯ");
    namesMap.put("RE", "ರೀಯೂನಿಯನ್");
    namesMap.put("RO", "ರೊಮೇನಿಯಾ");
    namesMap.put("RS", "ಸೆರ್ಬಿಯಾ");
    namesMap.put("RU", "ರಷ್ಯಾ");
    namesMap.put("RW", "ರುವಾಂಡಾ");
    namesMap.put("SA", "ಸೌದಿ ಅರೇಬಿಯಾ");
    namesMap.put("SB", "ಸೊಲೊಮನ್ ದ್ವೀಪಗಳು");
    namesMap.put("SC", "ಸೀಶೆಲ್ಲೆಸ್");
    namesMap.put("SD", "ಸೂಡಾನ್");
    namesMap.put("SE", "ಸ್ವೀಡನ್");
    namesMap.put("SG", "ಸಿಂಗಪುರ");
    namesMap.put("SH", "ಸೇಂಟ್ ಹೆಲೆನಾ");
    namesMap.put("SI", "ಸ್ಲೋವೇನಿಯಾ");
    namesMap.put("SJ", "ಸ್ವಾಲ್ಬಾರ್ಡ್ ಮತ್ತು ಜಾನ್ ಮೆಯನ್");
    namesMap.put("SK", "ಸ್ಲೋವೇಕಿಯಾ");
    namesMap.put("SL", "ಸಿಯೆರ್ರಾ ಲಿಯೋನ್");
    namesMap.put("SM", "ಸ್ಯಾನ್ ಮೆರಿನೋ");
    namesMap.put("SN", "ಸೆನೆಗಲ್");
    namesMap.put("SO", "ಸೊಮಾಲಿಯಾ");
    namesMap.put("SR", "ಸುರಿನಾಮ");
    namesMap.put("SS", "ದಕ್ಷಿಣ ಸೂಡಾನ್");
    namesMap.put("ST", "ಸಾವೋ ಟೋಮ್ ಮತ್ತು ಪ್ರಿನ್ಸಿಪಿ");
    namesMap.put("SV", "ಎಲ್ ಸಾಲ್ವೇಡಾರ್");
    namesMap.put("SX", "ಸಿಂಟ್ ಮಾರ್ಟೆನ್");
    namesMap.put("SY", "ಸಿರಿಯಾ");
    namesMap.put("SZ", "ಸ್ವಾಜಿಲ್ಯಾಂಡ್");
    namesMap.put("TA", "ಟ್ರಿಸ್ತನ್ ಡಾ ಕುನ್ಹಾ");
    namesMap.put("TC", "ಟರ್ಕ್ಸ್ ಮತ್ತು ಕೈಕೋಸ್ ದ್ವೀಪಗಳು");
    namesMap.put("TD", "ಚಾದ್");
    namesMap.put("TF", "ಫ್ರೆಂಚ್ ದಕ್ಷಿಣ ಪ್ರದೇಶಗಳು");
    namesMap.put("TG", "ಟೋಗೋ");
    namesMap.put("TH", "ಥೈಲ್ಯಾಂಡ್");
    namesMap.put("TJ", "ತಜಾಕಿಸ್ಥಾನ್");
    namesMap.put("TK", "ಟೊಕೆಲಾವ್");
    namesMap.put("TL", "ಪೂರ್ವ ತಿಮೋರ್");
    namesMap.put("TM", "ತುರ್ಕ್ಮೇನಿಸ್ಥಾನ್");
    namesMap.put("TN", "ಟುನಿಶಿಯಾ");
    namesMap.put("TO", "ಟೊಂಗ");
    namesMap.put("TR", "ಟರ್ಕಿ");
    namesMap.put("TT", "ಟ್ರಿನಿಡಾಡ್ ಮತ್ತು ಟೊಬಾಗೊ");
    namesMap.put("TV", "ಟುವಾಲು");
    namesMap.put("TW", "ಥೈವಾನ್");
    namesMap.put("TZ", "ತಾಂಜೇನಿಯಾ");
    namesMap.put("UA", "ಉಕ್ರೈನ್");
    namesMap.put("UG", "ಉಗಾಂಡಾ");
    namesMap.put("UM", "ಯುಎಸ್‌. ಔಟ್‌ಲೇಯಿಂಗ್ ದ್ವೀಪಗಳು");
    namesMap.put("US", "ಅಮೇರಿಕಾ ಸಂಯುಕ್ತ ಸಂಸ್ಥಾನ");
    namesMap.put("UY", "ಉರುಗ್ವೇ");
    namesMap.put("UZ", "ಉಜ್ಬೇಕಿಸ್ಥಾನ್");
    namesMap.put("VA", "ವ್ಯಾಟಿಕನ್");
    namesMap.put("VC", "ಸೇಂಟ್ ವಿನ್ಸೆಂಟ್ ಮತ್ತು ಗ್ರೆನೆಡೈನ್ಸ್");
    namesMap.put("VE", "ವೆನೆಜುವೆಲಾ");
    namesMap.put("VG", "ಬ್ರಿಟಿಷ್ ವರ್ಜಿನ್ ದ್ವೀಪಗಳು");
    namesMap.put("VI", "ಯು.ಎಸ್. ವರ್ಜಿನ್ ದ್ವೀಪಗಳು");
    namesMap.put("VN", "ವಿಯೇಟ್ನಾಮ್");
    namesMap.put("VU", "ವನೌಟು");
    namesMap.put("WF", "ವಾಲಿಸ್ ಮತ್ತು ಫುಟುನಾ");
    namesMap.put("WS", "ಸಮೋವಾ");
    namesMap.put("XK", "ಕೊಸೊವೊ");
    namesMap.put("YE", "ಯೆಮನ್");
    namesMap.put("YT", "ಮಯೊಟ್ಟೆ");
    namesMap.put("ZA", "ದಕ್ಷಿಣ ಆಫ್ರಿಕಾ");
    namesMap.put("ZM", "ಝಾಂಬಿಯಾ");
    namesMap.put("ZW", "ಜಿಂಬಾಬ್ವೆ");
    namesMap.put("ZZ", "ಅಮಾನ್ಯ ಪ್ರದೇಶ");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "ಪ್ರಪಂಚ",
        "002": "ಆಫ್ರಿಕಾ",
        "003": "ಉತ್ತರ ಅಮೇರಿಕಾ",
        "005": "ದಕ್ಷಿಣ ಅಮೇರಿಕಾ",
        "009": "ಓಶಿಯೇನಿಯಾ",
        "011": "ಪಶ್ಚಿಮ ಆಫ್ರಿಕಾ",
        "013": "ಮಧ್ಯ ಅಮೇರಿಕಾ",
        "014": "ಪೂರ್ವ ಆಫ್ರಿಕಾ",
        "015": "ಉತ್ತರ ಆಫ್ರಿಕಾ",
        "017": "ಮಧ್ಯ ಆಫ್ರಿಕಾ",
        "018": "ಆಫ್ರಿಕಾದ ದಕ್ಷಿಣ ಭಾಗ",
        "019": "ಅಮೆರಿಕಾಸ್",
        "021": "ಅಮೇರಿಕಾದ ಉತ್ತರ ಭಾಗ",
        "029": "ಕೆರೀಬಿಯನ್",
        "030": "ಏಷ್ಯಾದ ಪೂರ್ವ ಭಾಗ",
        "034": "ಏಷ್ಯಾದ ದಕ್ಷಿಣ ಭಾಗ",
        "035": "ಆಗ್ನೇಯ ಏಷ್ಯಾ",
        "039": "ದಕ್ಷಿಣ ಯೂರೋಪ್",
        "053": "ಆಸ್ಟ್ರೇಲಿಯೇಷಿಯಾ",
        "054": "ಮೇಲಿನೇಶಿಯಾ",
        "057": "ಮೈಕ್ರೋನೇಶಿಯನ್ ಪ್ರದೇಶ",
        "061": "ಪೋಲಿನೇಶಿಯಾ",
        "142": "ಏಷ್ಯಾ",
        "143": "ಮಧ್ಯ ಏಷ್ಯಾ",
        "145": "ಪಶ್ಚಿಮ ಏಷ್ಯಾ",
        "150": "ಯೂರೋಪ್",
        "151": "ಪೂರ್ವ ಯೂರೋಪ್",
        "154": "ಉತ್ತರ ಯೂರೋಪ್",
        "155": "ಪಶ್ಚಿಮ ಯೂರೋಪ್",
        "419": "ಲ್ಯಾಟಿನ್ ಅಮೇರಿಕಾ",
        "AC": "ಅಸೆನ್ಶನ್ ದ್ವೀಪ",
        "AD": "ಅಂಡೋರಾ",
        "AE": "ಸಂಯುಕ್ತ ಅರಬ್ ಎಮಿರೇಟಸ್",
        "AF": "ಅಫಘಾನಿಸ್ಥಾನ್",
        "AG": "ಆಂಟಿಗುವಾ ಮತ್ತು ಬರ್ಬುಡಾ",
        "AI": "ಆಂಗುಯಿಲ್ಲಾ",
        "AL": "ಅಲ್ಬೇನಿಯಾ",
        "AM": "ಅರ್ಮೇನಿಯಾ",
        "AN": "ನೆದರ್‌ಲ್ಯಾಂಡ್",
        "AO": "ಅಂಗೋಲಾ",
        "AQ": "ಅಂಟಾರ್ಟಿಕಾ",
        "AR": "ಅರ್ಜೆಂಟಿನಾ",
        "AS": "ಅಮೇರಿಕನ್ ಸಮೋವಾ",
        "AT": "ಆಸ್ಟ್ರಿಯಾ",
        "AU": "ಆಸ್ಟ್ರೇಲಿಯ",
        "AW": "ಅರುಬಾ",
        "AX": "ಆಲ್ಯಾಂಡ್ ದ್ವೀಪಗಳು",
        "AZ": "ಅಜರ್ಬೈಜಾನ್",
        "BA": "ಬೋಸ್ನಿಯಾ ಮತ್ತು ಹರ್ಜೆಗೋವಿನಾ",
        "BB": "ಬಾರ್ಬಡೋಸ್",
        "BD": "ಬಾಂಗ್ಲಾದೇಶ್",
        "BE": "ಬೆಲ್ಜಿಯಮ್",
        "BF": "ಬುರ್ಕಿನಾ ಫಾಸೋ",
        "BG": "ಬಲ್ಗೇರಿಯಾ",
        "BH": "ಬಹರೈನ್",
        "BI": "ಬುರುಂಡಿ",
        "BJ": "ಬೆನಿನ್",
        "BL": "ಸೇಂಟ್ ಬಾರ್ಥೆಲೆಮಿ",
        "BM": "ಬರ್ಮುಡಾ",
        "BN": "ಬ್ರೂನಿ",
        "BO": "ಬೊಲಿವಿಯಾ",
        "BQ": "ಕೆರೀಬಿಯನ್ ನೆದರ್‌ಲ್ಯಾಂಡ್ಸ್",
        "BR": "ಬ್ರೆಜಿಲ್",
        "BS": "ಬಹಾಮಾಸ್",
        "BT": "ಭೂತಾನ್",
        "BV": "ಬೋವೆಟ್ ದ್ವೀಪ",
        "BW": "ಬೋಟ್ಸ್‌ವಾನಾ",
        "BY": "ಬೆಲಾರಸ್",
        "BZ": "ಬೆಲಿಜ್",
        "CA": "ಕೆನಡಾ",
        "CC": "ಕೊಕೊಸ್ ದ್ವೀಪಗಳು",
        "CD": "ಕಾಂಗೋ - ಕಿನ್ಶಾಸಾ",
        "CF": "ಮಧ್ಯ ಆಫ್ರಿಕಾ ಗಣರಾಜ್ಯ",
        "CG": "ಕಾಂಗೋ - ಬ್ರಾಜಾವಿಲ್ಲೇ",
        "CH": "ಸ್ವಿಟ್ಜರ್ಲ್ಯಾಂಡ್",
        "CI": "ಕೋತ್‌ ದಿವಾರ್‍",
        "CK": "ಕುಕ್ ದ್ವೀಪಗಳು",
        "CL": "ಚಿಲಿ",
        "CM": "ಕ್ಯಾಮರೋನ್",
        "CN": "ಚೀನಾ",
        "CO": "ಕೊಲಂಬಿಯಾ",
        "CP": "ಕ್ಲಿಪ್ಪರ್‌ಟಾನ್ ದ್ವೀಪಗಳು",
        "CR": "ಕೊಸ್ಟಾ ರಿಕಾ",
        "CU": "ಕ್ಯೂಬಾ",
        "CV": "ಕೇಪ್ ವರ್ಡೆ",
        "CW": "ಕುರಾಕಾವ್",
        "CX": "ಕ್ರಿಸ್ಮಸ್ ದ್ವೀಪ",
        "CY": "ಸೈಪ್ರಸ್",
        "CZ": "ಚೆಕ್ ರಿಪಬ್ಲಿಕ್",
        "DE": "ಜರ್ಮನಿ",
        "DG": "ಡೈಗೋ ಗಾರ್ಸಿಯ",
        "DJ": "ಜಿಬೋಟಿ",
        "DK": "ಡೆನ್ಮಾರ್ಕ್",
        "DM": "ಡೊಮಿನಿಕಾ",
        "DO": "ಡೊಮೆನಿಕನ್ ರಿಪಬ್ಲಿಕ್",
        "DZ": "ಅಲ್ಗೇರಿಯಾ",
        "EA": "ಸೆಯುಟಾ ಹಾಗೂ ಮೆಲಿಲ್ಲಾ",
        "EC": "ಈಕ್ವೆಡಾರ್",
        "EE": "ಎಸ್ಟೋನಿಯಾ",
        "EG": "ಈಜಿಪ್ಟ್",
        "EH": "ಪಶ್ಚಿಮ ಸಹಾರಾ",
        "ER": "ಏರಿಟ್ರಿಯಾ",
        "ES": "ಸ್ಪೇನ್",
        "ET": "ಇಥಿಯೋಪಿಯಾ",
        "EU": "ಯುರೋಪಿಯನ್ ಯೂನಿಯನ್",
        "FI": "ಫಿನ್‌ಲ್ಯಾಂಡ್",
        "FJ": "ಫಿಜಿ",
        "FK": "ಫಾಲ್ಕ್‌ಲ್ಯಾಂಡ್ ದ್ವೀಪಗಳು",
        "FM": "ಮೈಕ್ರೋನೇಶಿಯಾ",
        "FO": "ಫರೋ ದ್ವೀಪಗಳು",
        "FR": "ಫ್ರಾನ್ಸ್",
        "GA": "ಗೆಬೊನ್",
        "GB": "ಬ್ರಿಟನ್/ಇಂಗ್ಲೆಂಡ್",
        "GD": "ಗ್ರೆನೆಡಾ",
        "GE": "ಜಾರ್ಜಿಯಾ",
        "GF": "ಫ್ರೆಂಚ್ ಗಯಾನಾ",
        "GG": "ಗುರ್ನ್‌ಸೆ",
        "GH": "ಘಾನಾ",
        "GI": "ಗಿಬ್ರಾಲ್ಟರ್",
        "GL": "ಗ್ರೀನ್‌ಲ್ಯಾಂಡ್",
        "GM": "ಗ್ಯಾಂಬಿಯಾ",
        "GN": "ಗಿನಿ",
        "GP": "ಗುಡೆಲೋಪ್",
        "GQ": "ಈಕ್ವೆಟೋರಿಯಲ್ ಗಿನಿ",
        "GR": "ಗ್ರೀಸ್",
        "GS": "ದಕ್ಷಿಣ ಜಾರ್ಜಿಯಾ ಮತ್ತು ದಕ್ಷಿಣ ಸ್ಯಾಂಡ್ವಿಚ್ ದ್ವೀಪಗಳು",
        "GT": "ಗ್ವಾಟೆಮಾಲಾ",
        "GU": "ಗುಯಾಮ್",
        "GW": "ಗಿನಿ-ಬಿಸ್ಸಾವ್",
        "GY": "ಗಯಾನಾ",
        "HK": "ಹಾಂಕ್‌ ಕಾಂಗ್ SAR ಚೈನಾ",
        "HM": "ಹರ್ಡ್ ದ್ವೀಪ ಮತ್ತು ಮ್ಯಾಕ್ಡೊನಾಲ್ಡ್ ದ್ವೀಪಗಳು",
        "HN": "ಹೊಂಡುರಾಸ್",
        "HR": "ಕ್ರೊಯೇಶಿಯಾ",
        "HT": "ಹೈಟಿ",
        "HU": "ಹಂಗಾರಿ",
        "IC": "ಕ್ಯಾನರಿ ದ್ವೀಪಗಳು",
        "ID": "ಇಂಡೋನೇಶಿಯಾ",
        "IE": "ಐರ್ಲೆಂಡ್",
        "IL": "ಇಸ್ರೇಲ್",
        "IM": "ಐಲ್ ಆಫ್ ಮ್ಯಾನ್",
        "IN": "ಭಾರತ",
        "IO": "ಬ್ರಿಟೀಶ್ ಇಂಡಿಯನ್ ಮಹಾಸಾಗರ ಪ್ರದೇಶ",
        "IQ": "ಇರಾಕ್",
        "IR": "ಇರಾನ್",
        "IS": "ಐಸ್‌ಲ್ಯಾಂಡ್",
        "IT": "ಇಟಲಿ",
        "JE": "ಜೆರ್ಸಿ",
        "JM": "ಜಮೈಕಾ",
        "JO": "ಜೋರ್ಡಾನ್",
        "JP": "ಜಪಾನ್",
        "KE": "ಕೀನ್ಯಾ",
        "KG": "ಕಿರ್ಗಿಸ್ಥಾನ್",
        "KH": "ಕಾಂಬೋಡಿಯಾ",
        "KI": "ಕಿರಿಬಾತಿ",
        "KM": "ಕೊಮೊರೊಸ್",
        "KN": "ಸೇಂಟ್ ಕಿಟ್ಸ್ ಮತ್ತು ನೆವಿಸ್",
        "KP": "ಉತ್ತರ ಕೋರಿಯಾ",
        "KR": "ದಕ್ಷಿಣ ಕೋರಿಯಾ",
        "KW": "ಕುವೈತ್",
        "KY": "ಕೇಮನ್ ದ್ವೀಪಗಳು",
        "KZ": "ಕಝಾಕಿಸ್ಥಾನ್",
        "LA": "ಲಾವೋಸ್",
        "LB": "ಲೆಬನಾನ್",
        "LC": "ಸೇಂಟ್ ಲೂಸಿಯಾ",
        "LI": "ಲಿಚೆನ್‌ಸ್ಟೈನ್",
        "LK": "ಶ್ರೀಲಂಕಾ",
        "LR": "ಲಿಬೇರಿಯಾ",
        "LS": "ಲೆಸೊಥೋ",
        "LT": "ಲಿಥುವೇನಿಯಾ",
        "LU": "ಲಕ್ಸಂಬರ್ಗ್",
        "LV": "ಲಾಟ್ವಿಯಾ",
        "LY": "ಲಿಬಿಯಾ",
        "MA": "ಮೊರಾಕ್ಕೊ",
        "MC": "ಮೊನಾಕೊ",
        "MD": "ಮೊಲ್ಡೋವಾ",
        "ME": "ಮೊಂಟೆನೆಗ್ರೋ",
        "MF": "ಸೇಂಟ್ ಮಾರ್ಟಿನ್",
        "MG": "ಮಡಗಾಸ್ಕರ್",
        "MH": "ಮಾರ್ಶಲ್ ದ್ವೀಪಗಳು",
        "MK": "ಮ್ಯಾಸಿಡೋನಿಯಾ",
        "ML": "ಮಾಲಿ",
        "MM": "ಮಯನ್ಮಾರ್",
        "MN": "ಮೊಂಗೋಲಿಯಾ",
        "MO": "ಮಖಾವ್ SAR ಚೈನಾ",
        "MP": "ಉತ್ತರ ಮರಿಯಾನಾ ದ್ವೀಪಗಳು",
        "MQ": "ಮಾರ್ಟಿನಿಕ್",
        "MR": "ಮಾರಿಟೇನಿಯಾ",
        "MS": "ಮಾಂಟ್‌ಸೆರೇಟ್",
        "MT": "ಮಾಲ್ಟಾ",
        "MU": "ಮಾರಿಶಿಯಸ್",
        "MV": "ಮಾಲ್ಡಿವ್ಸ್",
        "MW": "ಮಲಾವಿ",
        "MX": "ಮೆಕ್ಸಿಕೊ",
        "MY": "ಮಲೇಶಿಯಾ",
        "MZ": "ಮೊಜಾಂಬಿಕ್",
        "NA": "ನಮೀಬಿಯಾ",
        "NC": "ನ್ಯೂ ಕ್ಯಾಲಿಡೋನಿಯಾ",
        "NE": "ನೈಜರ್",
        "NF": "ನಾರ್ಫೋಕ್ ದ್ವೀಪ",
        "NG": "ನೈಜೀರಿಯಾ",
        "NI": "ನಿಕಾರಾಗುವಾ",
        "NL": "ನೆದರ್‌ಲ್ಯಾಂಡ್ಸ್",
        "NO": "ನಾರ್ವೇ",
        "NP": "ನೇಪಾಳ",
        "NR": "ನೌರು",
        "NU": "ನಿಯು",
        "NZ": "ನ್ಯೂಜಿಲೆಂಡ್",
        "OM": "ಓಮನ್",
        "PA": "ಪನಾಮಾ",
        "PE": "ಪೆರು",
        "PF": "ಫ್ರೆಂಚ್ ಪೋಲಿನೇಶಿಯಾ",
        "PG": "ಪಪುವಾ ನ್ಯೂಗೀನಿಯಾ",
        "PH": "ಫಿಲಿಫೈನ್ಸ್",
        "PK": "ಪಾಕಿಸ್ತಾನ",
        "PL": "ಪೋಲ್ಯಾಂಡ್",
        "PM": "ಸೇಂಟ್ ಪಿಯರೆ ಮತ್ತು ಮಿಕೆಲನ್",
        "PN": "ಪಿಟ್‌ಕೈರ್ನ್ ದ್ವೀಪಗಳು",
        "PR": "ಪ್ಯೂರ್ಟೋ ರಿಕೊ",
        "PS": "ಪ್ಯಾಲಿಸ್ಟೇನಿಯನ್ ಪ್ರದೇಶ",
        "PT": "ಪೋರ್ಚುಗಲ್",
        "PW": "ಪಲಾವು",
        "PY": "ಪರಾಗ್ವೇ",
        "QA": "ಕತಾರ್",
        "QO": "ಔಟ್‌‌ಲೇಯಿಂಗ್ ಓಷಿಯಾನಿಯ",
        "RE": "ರೀಯೂನಿಯನ್",
        "RO": "ರೊಮೇನಿಯಾ",
        "RS": "ಸೆರ್ಬಿಯಾ",
        "RU": "ರಷ್ಯಾ",
        "RW": "ರುವಾಂಡಾ",
        "SA": "ಸೌದಿ ಅರೇಬಿಯಾ",
        "SB": "ಸೊಲೊಮನ್ ದ್ವೀಪಗಳು",
        "SC": "ಸೀಶೆಲ್ಲೆಸ್",
        "SD": "ಸೂಡಾನ್",
        "SE": "ಸ್ವೀಡನ್",
        "SG": "ಸಿಂಗಪುರ",
        "SH": "ಸೇಂಟ್ ಹೆಲೆನಾ",
        "SI": "ಸ್ಲೋವೇನಿಯಾ",
        "SJ": "ಸ್ವಾಲ್ಬಾರ್ಡ್ ಮತ್ತು ಜಾನ್ ಮೆಯನ್",
        "SK": "ಸ್ಲೋವೇಕಿಯಾ",
        "SL": "ಸಿಯೆರ್ರಾ ಲಿಯೋನ್",
        "SM": "ಸ್ಯಾನ್ ಮೆರಿನೋ",
        "SN": "ಸೆನೆಗಲ್",
        "SO": "ಸೊಮಾಲಿಯಾ",
        "SR": "ಸುರಿನಾಮ",
        "SS": "ದಕ್ಷಿಣ ಸೂಡಾನ್",
        "ST": "ಸಾವೋ ಟೋಮ್ ಮತ್ತು ಪ್ರಿನ್ಸಿಪಿ",
        "SV": "ಎಲ್ ಸಾಲ್ವೇಡಾರ್",
        "SX": "ಸಿಂಟ್ ಮಾರ್ಟೆನ್",
        "SY": "ಸಿರಿಯಾ",
        "SZ": "ಸ್ವಾಜಿಲ್ಯಾಂಡ್",
        "TA": "ಟ್ರಿಸ್ತನ್ ಡಾ ಕುನ್ಹಾ",
        "TC": "ಟರ್ಕ್ಸ್ ಮತ್ತು ಕೈಕೋಸ್ ದ್ವೀಪಗಳು",
        "TD": "ಚಾದ್",
        "TF": "ಫ್ರೆಂಚ್ ದಕ್ಷಿಣ ಪ್ರದೇಶಗಳು",
        "TG": "ಟೋಗೋ",
        "TH": "ಥೈಲ್ಯಾಂಡ್",
        "TJ": "ತಜಾಕಿಸ್ಥಾನ್",
        "TK": "ಟೊಕೆಲಾವ್",
        "TL": "ಪೂರ್ವ ತಿಮೋರ್",
        "TM": "ತುರ್ಕ್ಮೇನಿಸ್ಥಾನ್",
        "TN": "ಟುನಿಶಿಯಾ",
        "TO": "ಟೊಂಗ",
        "TR": "ಟರ್ಕಿ",
        "TT": "ಟ್ರಿನಿಡಾಡ್ ಮತ್ತು ಟೊಬಾಗೊ",
        "TV": "ಟುವಾಲು",
        "TW": "ಥೈವಾನ್",
        "TZ": "ತಾಂಜೇನಿಯಾ",
        "UA": "ಉಕ್ರೈನ್",
        "UG": "ಉಗಾಂಡಾ",
        "UM": "ಯುಎಸ್‌. ಔಟ್‌ಲೇಯಿಂಗ್ ದ್ವೀಪಗಳು",
        "US": "ಅಮೇರಿಕಾ ಸಂಯುಕ್ತ ಸಂಸ್ಥಾನ",
        "UY": "ಉರುಗ್ವೇ",
        "UZ": "ಉಜ್ಬೇಕಿಸ್ಥಾನ್",
        "VA": "ವ್ಯಾಟಿಕನ್",
        "VC": "ಸೇಂಟ್ ವಿನ್ಸೆಂಟ್ ಮತ್ತು ಗ್ರೆನೆಡೈನ್ಸ್",
        "VE": "ವೆನೆಜುವೆಲಾ",
        "VG": "ಬ್ರಿಟಿಷ್ ವರ್ಜಿನ್ ದ್ವೀಪಗಳು",
        "VI": "ಯು.ಎಸ್. ವರ್ಜಿನ್ ದ್ವೀಪಗಳು",
        "VN": "ವಿಯೇಟ್ನಾಮ್",
        "VU": "ವನೌಟು",
        "WF": "ವಾಲಿಸ್ ಮತ್ತು ಫುಟುನಾ",
        "WS": "ಸಮೋವಾ",
        "XK": "ಕೊಸೊವೊ",
        "YE": "ಯೆಮನ್",
        "YT": "ಮಯೊಟ್ಟೆ",
        "ZA": "ದಕ್ಷಿಣ ಆಫ್ರಿಕಾ",
        "ZM": "ಝಾಂಬಿಯಾ",
        "ZW": "ಜಿಂಬಾಬ್ವೆ",
        "ZZ": "ಅಮಾನ್ಯ ಪ್ರದೇಶ"
    };
  }-*/;
}
