/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "is" locale.
 */
public class LocalizedNamesImpl_is extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AL",
        "DZ",
        "AD",
        "AO",
        "AI",
        "AG",
        "AR",
        "AM",
        "AW",
        "AC",
        "AZ",
        "AT",
        "AX",
        "AU",
        "BS",
        "US",
        "AS",
        "VI",
        "BD",
        "BB",
        "BH",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BA",
        "BW",
        "BV",
        "BO",
        "BR",
        "IO",
        "VG",
        "GB",
        "BN",
        "BG",
        "BF",
        "BI",
        "BT",
        "KY",
        "EA",
        "CP",
        "CK",
        "CW",
        "DK",
        "DG",
        "DJ",
        "DM",
        "DO",
        "EG",
        "EE",
        "EC",
        "SV",
        "ER",
        "EU",
        "ET",
        "FK",
        "PH",
        "FI",
        "FJ",
        "CI",
        "FR",
        "GF",
        "PF",
        "TF",
        "FO",
        "GA",
        "GM",
        "GH",
        "GE",
        "GI",
        "GN",
        "GW",
        "GD",
        "GR",
        "CV",
        "GL",
        "GG",
        "GP",
        "GU",
        "GT",
        "GY",
        "HT",
        "HM",
        "PS",
        "NL",
        "AN",
        "HN",
        "BY",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IL",
        "IT",
        "JM",
        "JP",
        "YE",
        "JE",
        "CX",
        "JO",
        "KH",
        "CM",
        "CA",
        "IC",
        "BQ",
        "KZ",
        "QA",
        "KE",
        "KG",
        "CN",
        "KI",
        "CG",
        "CD",
        "CR",
        "CC",
        "CO",
        "KM",
        "XK",
        "HR",
        "CU",
        "KW",
        "CY",
        "LA",
        "LS",
        "LV",
        "LI",
        "LT",
        "LB",
        "LR",
        "LY",
        "LU",
        "MG",
        "MK",
        "MY",
        "MW",
        "MV",
        "ML",
        "MT",
        "MA",
        "MH",
        "MQ",
        "YT",
        "MR",
        "MU",
        "MX",
        "CF",
        "GQ",
        "FM",
        "MM",
        "MD",
        "MN",
        "MS",
        "MC",
        "MZ",
        "IM",
        "NA",
        "NR",
        "NP",
        "NU",
        "NE",
        "NG",
        "NI",
        "KP",
        "MP",
        "NO",
        "NF",
        "NC",
        "NZ",
        "OM",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "VA",
        "PE",
        "PN",
        "PT",
        "PL",
        "PR",
        "RE",
        "RW",
        "RO",
        "RU",
        "BL",
        "MF",
        "SB",
        "ZM",
        "AE",
        "WS",
        "SH",
        "KN",
        "LC",
        "PM",
        "VC",
        "SM",
        "ST",
        "SA",
        "SN",
        "RS",
        "SC",
        "ZW",
        "SG",
        "SX",
        "SL",
        "CL",
        "HK",
        "MO",
        "SK",
        "SI",
        "UM",
        "SO",
        "ES",
        "LK",
        "ZA",
        "GS",
        "KR",
        "AQ",
        "SS",
        "SD",
        "SR",
        "SJ",
        "ME",
        "SZ",
        "CH",
        "SE",
        "SY",
        "TJ",
        "TH",
        "TW",
        "TZ",
        "CZ",
        "TL",
        "TO",
        "TG",
        "TK",
        "TA",
        "TT",
        "TD",
        "TC",
        "TN",
        "TM",
        "TV",
        "TR",
        "HU",
        "UG",
        "UA",
        "UY",
        "UZ",
        "VU",
        "VE",
        "EH",
        "VN",
        "WF",
        "QO",
        "DE",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Heimurinn");
    namesMap.put("002", "Afríka");
    namesMap.put("003", "Norður-Ameríka");
    namesMap.put("005", "Suður-Ameríka");
    namesMap.put("009", "Eyjaálfa");
    namesMap.put("011", "Vestur-Afríka");
    namesMap.put("013", "Mið-Ameríka");
    namesMap.put("014", "Austur-Afríka");
    namesMap.put("015", "Norður-Afríka");
    namesMap.put("017", "Mið-Afríka");
    namesMap.put("018", "Suðurhluti Afríku");
    namesMap.put("019", "Ameríka");
    namesMap.put("021", "Ameríka norðan Mexikó");
    namesMap.put("029", "Karabíska hafið");
    namesMap.put("030", "Austur-Asía");
    namesMap.put("034", "Suður-Asía");
    namesMap.put("035", "Suðaustur-Asía");
    namesMap.put("039", "Suður-Evrópa");
    namesMap.put("053", "Ástralasía");
    namesMap.put("054", "Melanesía");
    namesMap.put("057", "Míkrónesía");
    namesMap.put("061", "Pólýnesía");
    namesMap.put("142", "Asía");
    namesMap.put("143", "Mið-Asía");
    namesMap.put("145", "Vestur-Asía");
    namesMap.put("150", "Evrópa");
    namesMap.put("151", "Austur-Evrópa");
    namesMap.put("154", "Norður-Evrópa");
    namesMap.put("155", "Vestur-Evrópa");
    namesMap.put("419", "Rómanska Ameríka");
    namesMap.put("AC", "Ascension-eyja");
    namesMap.put("AE", "Sameinuðu arabísku furstadæmin");
    namesMap.put("AF", "Afganistan");
    namesMap.put("AG", "Antígva og Barbúda");
    namesMap.put("AI", "Angvilla");
    namesMap.put("AL", "Albanía");
    namesMap.put("AM", "Armenía");
    namesMap.put("AN", "Hollensku Antillur");
    namesMap.put("AO", "Angóla");
    namesMap.put("AQ", "Suðurskautslandið");
    namesMap.put("AR", "Argentína");
    namesMap.put("AS", "Bandaríska Samóa");
    namesMap.put("AT", "Austurríki");
    namesMap.put("AU", "Ástralía");
    namesMap.put("AW", "Arúba");
    namesMap.put("AX", "Álandseyjar");
    namesMap.put("AZ", "Aserbaídsjan");
    namesMap.put("BA", "Bosnía og Hersegóvína");
    namesMap.put("BD", "Bangladess");
    namesMap.put("BE", "Belgía");
    namesMap.put("BF", "Búrkína Fasó");
    namesMap.put("BG", "Búlgaría");
    namesMap.put("BH", "Barein");
    namesMap.put("BI", "Búrúndí");
    namesMap.put("BJ", "Benín");
    namesMap.put("BM", "Bermúdaeyjar");
    namesMap.put("BN", "Brúnei");
    namesMap.put("BO", "Bólivía");
    namesMap.put("BQ", "Karíbahafshluti Hollands");
    namesMap.put("BR", "Brasilía");
    namesMap.put("BS", "Bahamaeyjar");
    namesMap.put("BT", "Bútan");
    namesMap.put("BV", "Bouveteyja");
    namesMap.put("BW", "Botsvana");
    namesMap.put("BY", "Hvíta-Rússland");
    namesMap.put("BZ", "Belís");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Kókoseyjar (Keeling)");
    namesMap.put("CD", "Kongó-Kinshasa");
    namesMap.put("CF", "Mið-Afríkulýðveldið");
    namesMap.put("CG", "Kongó-Brazzaville");
    namesMap.put("CH", "Sviss");
    namesMap.put("CI", "Fílabeinsströndin");
    namesMap.put("CK", "Cooks-eyjar");
    namesMap.put("CL", "Síle");
    namesMap.put("CM", "Kamerún");
    namesMap.put("CN", "Kína");
    namesMap.put("CO", "Kólumbía");
    namesMap.put("CP", "Clipperton-eyja");
    namesMap.put("CR", "Kostaríka");
    namesMap.put("CU", "Kúba");
    namesMap.put("CV", "Grænhöfðaeyjar");
    namesMap.put("CX", "Jólaey");
    namesMap.put("CY", "Kýpur");
    namesMap.put("CZ", "Tékkland");
    namesMap.put("DE", "Þýskaland");
    namesMap.put("DJ", "Djíbútí");
    namesMap.put("DK", "Danmörk");
    namesMap.put("DM", "Dóminíka");
    namesMap.put("DO", "Dóminíska lýðveldið");
    namesMap.put("DZ", "Alsír");
    namesMap.put("EA", "Ceuta og Melilla");
    namesMap.put("EC", "Ekvador");
    namesMap.put("EE", "Eistland");
    namesMap.put("EG", "Egyptaland");
    namesMap.put("EH", "Vestur-Sahara");
    namesMap.put("ER", "Erítrea");
    namesMap.put("ES", "Spánn");
    namesMap.put("ET", "Eþíópía");
    namesMap.put("EU", "Evrópusambandið");
    namesMap.put("FI", "Finnland");
    namesMap.put("FJ", "Fídjieyjar");
    namesMap.put("FK", "Falklandseyjar");
    namesMap.put("FM", "Míkrónesía (FM)");
    namesMap.put("FO", "Færeyjar");
    namesMap.put("FR", "Frakkland");
    namesMap.put("GB", "Bretland");
    namesMap.put("GE", "Georgía");
    namesMap.put("GF", "Franska Gvæjana");
    namesMap.put("GH", "Gana");
    namesMap.put("GI", "Gíbraltar");
    namesMap.put("GL", "Grænland");
    namesMap.put("GM", "Gambía");
    namesMap.put("GN", "Gínea");
    namesMap.put("GP", "Gvadelúpeyjar");
    namesMap.put("GQ", "Miðbaugs-Gínea");
    namesMap.put("GR", "Grikkland");
    namesMap.put("GS", "Suður-Georgía og Suður-Sandvíkureyjar");
    namesMap.put("GT", "Gvatemala");
    namesMap.put("GU", "Gvam");
    namesMap.put("GW", "Gínea-Bissá");
    namesMap.put("GY", "Gvæjana");
    namesMap.put("HK", "Sjálfstjórnarsvæðið Hong Kong");
    namesMap.put("HM", "Heard og McDonaldseyjar");
    namesMap.put("HN", "Hondúras");
    namesMap.put("HR", "Króatía");
    namesMap.put("HT", "Haítí");
    namesMap.put("HU", "Ungverjaland");
    namesMap.put("IC", "Kanaríeyjar");
    namesMap.put("ID", "Indónesía");
    namesMap.put("IE", "Írland");
    namesMap.put("IL", "Ísrael");
    namesMap.put("IM", "Mön");
    namesMap.put("IN", "Indland");
    namesMap.put("IO", "Bresku Indlandshafseyjar");
    namesMap.put("IQ", "Írak");
    namesMap.put("IR", "Íran");
    namesMap.put("IS", "Ísland");
    namesMap.put("IT", "Ítalía");
    namesMap.put("JM", "Jamaíka");
    namesMap.put("JO", "Jórdanía");
    namesMap.put("KE", "Kenía");
    namesMap.put("KG", "Kirgisistan");
    namesMap.put("KH", "Kambódía");
    namesMap.put("KI", "Kíribatí");
    namesMap.put("KM", "Kómoreyjar");
    namesMap.put("KN", "Sankti Kristófer og Nevis");
    namesMap.put("KP", "Norður-Kórea");
    namesMap.put("KR", "Suður-Kórea");
    namesMap.put("KW", "Kúveit");
    namesMap.put("KY", "Caymaneyjar");
    namesMap.put("KZ", "Kasakstan");
    namesMap.put("LB", "Líbanon");
    namesMap.put("LC", "Sankti Lúsía");
    namesMap.put("LK", "Srí Lanka");
    namesMap.put("LR", "Líbería");
    namesMap.put("LS", "Lesótó");
    namesMap.put("LT", "Litháen");
    namesMap.put("LU", "Lúxemborg");
    namesMap.put("LV", "Lettland");
    namesMap.put("LY", "Líbía");
    namesMap.put("MA", "Marokkó");
    namesMap.put("MC", "Mónakó");
    namesMap.put("MD", "Moldóva");
    namesMap.put("ME", "Svartfjallaland");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Marshalleyjar");
    namesMap.put("MK", "Makedónía");
    namesMap.put("ML", "Malí");
    namesMap.put("MM", "Mjanmar (Búrma)");
    namesMap.put("MN", "Mongólía");
    namesMap.put("MO", "Sjálfstjórnarsvæðið Makaó");
    namesMap.put("MP", "Norður-Maríanaeyjar");
    namesMap.put("MQ", "Martiník");
    namesMap.put("MR", "Máritanía");
    namesMap.put("MU", "Máritíus");
    namesMap.put("MV", "Maldíveyjar");
    namesMap.put("MW", "Malaví");
    namesMap.put("MX", "Mexíkó");
    namesMap.put("MY", "Malasía");
    namesMap.put("MZ", "Mósambík");
    namesMap.put("NA", "Namibía");
    namesMap.put("NC", "Nýja-Kaledónía");
    namesMap.put("NE", "Níger");
    namesMap.put("NF", "Norfolkeyja");
    namesMap.put("NG", "Nígería");
    namesMap.put("NI", "Níkaragva");
    namesMap.put("NL", "Holland");
    namesMap.put("NO", "Noregur");
    namesMap.put("NR", "Nárú");
    namesMap.put("NZ", "Nýja-Sjáland");
    namesMap.put("OM", "Óman");
    namesMap.put("PE", "Perú");
    namesMap.put("PF", "Franska Pólýnesía");
    namesMap.put("PG", "Papúa Nýja-Gínea");
    namesMap.put("PH", "Filippseyjar");
    namesMap.put("PL", "Pólland");
    namesMap.put("PM", "Sankti Pierre og Miquelon");
    namesMap.put("PN", "Pitcairn-eyjar");
    namesMap.put("PR", "Púertó Ríkó");
    namesMap.put("PS", "Heimastjórnarsvæði Palestínumanna");
    namesMap.put("PT", "Portúgal");
    namesMap.put("PW", "Palá");
    namesMap.put("PY", "Paragvæ");
    namesMap.put("QA", "Katar");
    namesMap.put("QO", "Ytri Eyjaálfa");
    namesMap.put("RO", "Rúmenía");
    namesMap.put("RS", "Serbía");
    namesMap.put("RU", "Rússland");
    namesMap.put("RW", "Rúanda");
    namesMap.put("SA", "Sádi-Arabía");
    namesMap.put("SB", "Salómonseyjar");
    namesMap.put("SC", "Seychelles-eyjar");
    namesMap.put("SD", "Súdan");
    namesMap.put("SE", "Svíþjóð");
    namesMap.put("SG", "Singapúr");
    namesMap.put("SH", "Sankti Helena");
    namesMap.put("SI", "Slóvenía");
    namesMap.put("SJ", "Svalbarði og Jan Mayen");
    namesMap.put("SK", "Slóvakía");
    namesMap.put("SL", "Síerra Leóne");
    namesMap.put("SM", "San Marínó");
    namesMap.put("SO", "Sómalía");
    namesMap.put("SR", "Súrínam");
    namesMap.put("SS", "Suður-Súdan");
    namesMap.put("ST", "Saó Tóme og Prinsípe");
    namesMap.put("SY", "Sýrland");
    namesMap.put("SZ", "Svasíland");
    namesMap.put("TC", "Turks- og Caicoseyjar");
    namesMap.put("TD", "Tsjad");
    namesMap.put("TF", "Frönsku suðlægu landsvæðin");
    namesMap.put("TG", "Tógó");
    namesMap.put("TH", "Taíland");
    namesMap.put("TJ", "Tadsjikistan");
    namesMap.put("TK", "Tókelá");
    namesMap.put("TL", "Tímor-Leste");
    namesMap.put("TM", "Túrkmenistan");
    namesMap.put("TN", "Túnis");
    namesMap.put("TR", "Tyrkland");
    namesMap.put("TT", "Trínidad og Tóbagó");
    namesMap.put("TV", "Túvalú");
    namesMap.put("TW", "Taívan");
    namesMap.put("TZ", "Tansanía");
    namesMap.put("UA", "Úkraína");
    namesMap.put("UG", "Úganda");
    namesMap.put("UM", "Smáeyjar Bandaríkjanna");
    namesMap.put("US", "Bandaríkin");
    namesMap.put("UY", "Úrúgvæ");
    namesMap.put("UZ", "Úsbekistan");
    namesMap.put("VA", "Páfastóll");
    namesMap.put("VC", "Sankti Vinsent og Grenadíneyjar");
    namesMap.put("VE", "Venesúela");
    namesMap.put("VG", "Bresku Jómfrúaeyjar");
    namesMap.put("VI", "Bandarísku Jómfrúaeyjar");
    namesMap.put("VN", "Víetnam");
    namesMap.put("VU", "Vanúatú");
    namesMap.put("WF", "Wallis- og Fútúnaeyjar");
    namesMap.put("WS", "Samóa");
    namesMap.put("XK", "Kósóvó");
    namesMap.put("YE", "Jemen");
    namesMap.put("ZA", "Suður-Afríka");
    namesMap.put("ZM", "Sambía");
    namesMap.put("ZW", "Simbabve");
    namesMap.put("ZZ", "Óþekkt svæði");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Heimurinn",
        "002": "Afríka",
        "003": "Norður-Ameríka",
        "005": "Suður-Ameríka",
        "009": "Eyjaálfa",
        "011": "Vestur-Afríka",
        "013": "Mið-Ameríka",
        "014": "Austur-Afríka",
        "015": "Norður-Afríka",
        "017": "Mið-Afríka",
        "018": "Suðurhluti Afríku",
        "019": "Ameríka",
        "021": "Ameríka norðan Mexikó",
        "029": "Karabíska hafið",
        "030": "Austur-Asía",
        "034": "Suður-Asía",
        "035": "Suðaustur-Asía",
        "039": "Suður-Evrópa",
        "053": "Ástralasía",
        "054": "Melanesía",
        "057": "Míkrónesía",
        "061": "Pólýnesía",
        "142": "Asía",
        "143": "Mið-Asía",
        "145": "Vestur-Asía",
        "150": "Evrópa",
        "151": "Austur-Evrópa",
        "154": "Norður-Evrópa",
        "155": "Vestur-Evrópa",
        "419": "Rómanska Ameríka",
        "AC": "Ascension-eyja",
        "AE": "Sameinuðu arabísku furstadæmin",
        "AF": "Afganistan",
        "AG": "Antígva og Barbúda",
        "AI": "Angvilla",
        "AL": "Albanía",
        "AM": "Armenía",
        "AN": "Hollensku Antillur",
        "AO": "Angóla",
        "AQ": "Suðurskautslandið",
        "AR": "Argentína",
        "AS": "Bandaríska Samóa",
        "AT": "Austurríki",
        "AU": "Ástralía",
        "AW": "Arúba",
        "AX": "Álandseyjar",
        "AZ": "Aserbaídsjan",
        "BA": "Bosnía og Hersegóvína",
        "BD": "Bangladess",
        "BE": "Belgía",
        "BF": "Búrkína Fasó",
        "BG": "Búlgaría",
        "BH": "Barein",
        "BI": "Búrúndí",
        "BJ": "Benín",
        "BM": "Bermúdaeyjar",
        "BN": "Brúnei",
        "BO": "Bólivía",
        "BQ": "Karíbahafshluti Hollands",
        "BR": "Brasilía",
        "BS": "Bahamaeyjar",
        "BT": "Bútan",
        "BV": "Bouveteyja",
        "BW": "Botsvana",
        "BY": "Hvíta-Rússland",
        "BZ": "Belís",
        "CA": "Kanada",
        "CC": "Kókoseyjar (Keeling)",
        "CD": "Kongó-Kinshasa",
        "CF": "Mið-Afríkulýðveldið",
        "CG": "Kongó-Brazzaville",
        "CH": "Sviss",
        "CI": "Fílabeinsströndin",
        "CK": "Cooks-eyjar",
        "CL": "Síle",
        "CM": "Kamerún",
        "CN": "Kína",
        "CO": "Kólumbía",
        "CP": "Clipperton-eyja",
        "CR": "Kostaríka",
        "CU": "Kúba",
        "CV": "Grænhöfðaeyjar",
        "CX": "Jólaey",
        "CY": "Kýpur",
        "CZ": "Tékkland",
        "DE": "Þýskaland",
        "DJ": "Djíbútí",
        "DK": "Danmörk",
        "DM": "Dóminíka",
        "DO": "Dóminíska lýðveldið",
        "DZ": "Alsír",
        "EA": "Ceuta og Melilla",
        "EC": "Ekvador",
        "EE": "Eistland",
        "EG": "Egyptaland",
        "EH": "Vestur-Sahara",
        "ER": "Erítrea",
        "ES": "Spánn",
        "ET": "Eþíópía",
        "EU": "Evrópusambandið",
        "FI": "Finnland",
        "FJ": "Fídjieyjar",
        "FK": "Falklandseyjar",
        "FM": "Míkrónesía (FM)",
        "FO": "Færeyjar",
        "FR": "Frakkland",
        "GB": "Bretland",
        "GE": "Georgía",
        "GF": "Franska Gvæjana",
        "GH": "Gana",
        "GI": "Gíbraltar",
        "GL": "Grænland",
        "GM": "Gambía",
        "GN": "Gínea",
        "GP": "Gvadelúpeyjar",
        "GQ": "Miðbaugs-Gínea",
        "GR": "Grikkland",
        "GS": "Suður-Georgía og Suður-Sandvíkureyjar",
        "GT": "Gvatemala",
        "GU": "Gvam",
        "GW": "Gínea-Bissá",
        "GY": "Gvæjana",
        "HK": "Sjálfstjórnarsvæðið Hong Kong",
        "HM": "Heard og McDonaldseyjar",
        "HN": "Hondúras",
        "HR": "Króatía",
        "HT": "Haítí",
        "HU": "Ungverjaland",
        "IC": "Kanaríeyjar",
        "ID": "Indónesía",
        "IE": "Írland",
        "IL": "Ísrael",
        "IM": "Mön",
        "IN": "Indland",
        "IO": "Bresku Indlandshafseyjar",
        "IQ": "Írak",
        "IR": "Íran",
        "IS": "Ísland",
        "IT": "Ítalía",
        "JM": "Jamaíka",
        "JO": "Jórdanía",
        "KE": "Kenía",
        "KG": "Kirgisistan",
        "KH": "Kambódía",
        "KI": "Kíribatí",
        "KM": "Kómoreyjar",
        "KN": "Sankti Kristófer og Nevis",
        "KP": "Norður-Kórea",
        "KR": "Suður-Kórea",
        "KW": "Kúveit",
        "KY": "Caymaneyjar",
        "KZ": "Kasakstan",
        "LB": "Líbanon",
        "LC": "Sankti Lúsía",
        "LK": "Srí Lanka",
        "LR": "Líbería",
        "LS": "Lesótó",
        "LT": "Litháen",
        "LU": "Lúxemborg",
        "LV": "Lettland",
        "LY": "Líbía",
        "MA": "Marokkó",
        "MC": "Mónakó",
        "MD": "Moldóva",
        "ME": "Svartfjallaland",
        "MG": "Madagaskar",
        "MH": "Marshalleyjar",
        "MK": "Makedónía",
        "ML": "Malí",
        "MM": "Mjanmar (Búrma)",
        "MN": "Mongólía",
        "MO": "Sjálfstjórnarsvæðið Makaó",
        "MP": "Norður-Maríanaeyjar",
        "MQ": "Martiník",
        "MR": "Máritanía",
        "MU": "Máritíus",
        "MV": "Maldíveyjar",
        "MW": "Malaví",
        "MX": "Mexíkó",
        "MY": "Malasía",
        "MZ": "Mósambík",
        "NA": "Namibía",
        "NC": "Nýja-Kaledónía",
        "NE": "Níger",
        "NF": "Norfolkeyja",
        "NG": "Nígería",
        "NI": "Níkaragva",
        "NL": "Holland",
        "NO": "Noregur",
        "NR": "Nárú",
        "NZ": "Nýja-Sjáland",
        "OM": "Óman",
        "PE": "Perú",
        "PF": "Franska Pólýnesía",
        "PG": "Papúa Nýja-Gínea",
        "PH": "Filippseyjar",
        "PL": "Pólland",
        "PM": "Sankti Pierre og Miquelon",
        "PN": "Pitcairn-eyjar",
        "PR": "Púertó Ríkó",
        "PS": "Heimastjórnarsvæði Palestínumanna",
        "PT": "Portúgal",
        "PW": "Palá",
        "PY": "Paragvæ",
        "QA": "Katar",
        "QO": "Ytri Eyjaálfa",
        "RO": "Rúmenía",
        "RS": "Serbía",
        "RU": "Rússland",
        "RW": "Rúanda",
        "SA": "Sádi-Arabía",
        "SB": "Salómonseyjar",
        "SC": "Seychelles-eyjar",
        "SD": "Súdan",
        "SE": "Svíþjóð",
        "SG": "Singapúr",
        "SH": "Sankti Helena",
        "SI": "Slóvenía",
        "SJ": "Svalbarði og Jan Mayen",
        "SK": "Slóvakía",
        "SL": "Síerra Leóne",
        "SM": "San Marínó",
        "SO": "Sómalía",
        "SR": "Súrínam",
        "SS": "Suður-Súdan",
        "ST": "Saó Tóme og Prinsípe",
        "SY": "Sýrland",
        "SZ": "Svasíland",
        "TC": "Turks- og Caicoseyjar",
        "TD": "Tsjad",
        "TF": "Frönsku suðlægu landsvæðin",
        "TG": "Tógó",
        "TH": "Taíland",
        "TJ": "Tadsjikistan",
        "TK": "Tókelá",
        "TL": "Tímor-Leste",
        "TM": "Túrkmenistan",
        "TN": "Túnis",
        "TR": "Tyrkland",
        "TT": "Trínidad og Tóbagó",
        "TV": "Túvalú",
        "TW": "Taívan",
        "TZ": "Tansanía",
        "UA": "Úkraína",
        "UG": "Úganda",
        "UM": "Smáeyjar Bandaríkjanna",
        "US": "Bandaríkin",
        "UY": "Úrúgvæ",
        "UZ": "Úsbekistan",
        "VA": "Páfastóll",
        "VC": "Sankti Vinsent og Grenadíneyjar",
        "VE": "Venesúela",
        "VG": "Bresku Jómfrúaeyjar",
        "VI": "Bandarísku Jómfrúaeyjar",
        "VN": "Víetnam",
        "VU": "Vanúatú",
        "WF": "Wallis- og Fútúnaeyjar",
        "WS": "Samóa",
        "XK": "Kósóvó",
        "YE": "Jemen",
        "ZA": "Suður-Afríka",
        "ZM": "Sambía",
        "ZW": "Simbabve",
        "ZZ": "Óþekkt svæði"
    };
  }-*/;
}
