/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.google.gwt.user.client.ui.PrefixTree;
import com.google.gwt.user.client.ui.SuggestOracle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;

public class MultiWordSuggestOracle
extends SuggestOracle {
    private static final char WHITESPACE_CHAR = ' ';
    private static final String WHITESPACE_STRING = " ";
    private static final String NORMALIZE_TO_SINGLE_WHITE_SPACE = "\\s+";
    private final PrefixTree tree = new PrefixTree();
    private HashMap<String, Set<String>> toCandidates = new HashMap();
    private HashMap<String, List<String>> toRealSuggestions = new HashMap();
    private boolean suggestAllMatchingWords = false;
    private char[] whitespaceChars;
    private SuggestOracle.Response defaultResponse;
    private Comparator<String> comparator = null;

    public MultiWordSuggestOracle() {
        this(WHITESPACE_STRING);
    }

    public MultiWordSuggestOracle(String whitespaceChars) {
        this.whitespaceChars = new char[whitespaceChars.length()];
        for (int i = 0; i < whitespaceChars.length(); ++i) {
            this.whitespaceChars[i] = whitespaceChars.charAt(i);
        }
    }

    public void add(String suggestion) {
        String candidate = this.normalizeSuggestion(suggestion);
        List<String> realSuggestions = this.toRealSuggestions.get(candidate);
        if (realSuggestions == null) {
            realSuggestions = new ArrayList<String>();
            this.toRealSuggestions.put(candidate, realSuggestions);
        }
        realSuggestions.add(0, suggestion);
        String[] words = candidate.split(WHITESPACE_STRING);
        for (int i = 0; i < words.length; ++i) {
            String word = words[i];
            this.tree.add(word);
            Set<String> l = this.toCandidates.get(word);
            if (l == null) {
                l = new HashSet<String>();
                this.toCandidates.put(word, l);
            }
            l.add(candidate);
        }
    }

    public final void addAll(Collection<String> collection) {
        for (String suggestion : collection) {
            this.add(suggestion);
        }
    }

    public void clear() {
        this.tree.clear();
        this.toCandidates.clear();
        this.toRealSuggestions.clear();
    }

    @Override
    public boolean isDisplayStringHTML() {
        return true;
    }

    @Override
    public void requestDefaultSuggestions(SuggestOracle.Request request, SuggestOracle.Callback callback) {
        if (this.defaultResponse != null) {
            callback.onSuggestionsReady(request, this.defaultResponse);
        } else {
            super.requestDefaultSuggestions(request, callback);
        }
    }

    @Override
    public void requestSuggestions(SuggestOracle.Request request, SuggestOracle.Callback callback) {
        String query = this.normalizeSearch(request.getQuery());
        int limit = request.getLimit();
        List<String> candidates = this.createCandidatesFromSearch(query);
        int numberTruncated = Math.max(0, candidates.size() - limit);
        for (int i = candidates.size() - 1; i > limit; --i) {
            candidates.remove(i);
        }
        List<MultiWordSuggestion> suggestions = this.convertToFormattedSuggestions(query, candidates);
        SuggestOracle.Response response = new SuggestOracle.Response(suggestions);
        response.setMoreSuggestionsCount(numberTruncated);
        callback.onSuggestionsReady(request, response);
    }

    public void setComparator(Comparator<String> comparator) {
        this.comparator = comparator;
    }

    public void setDefaultSuggestions(Collection<SuggestOracle.Suggestion> suggestionList) {
        this.defaultResponse = new SuggestOracle.Response(suggestionList);
    }

    public final void setDefaultSuggestionsFromText(Collection<String> suggestionList) {
        ArrayList<SuggestOracle.Suggestion> accum = new ArrayList<SuggestOracle.Suggestion>();
        for (String candidate : suggestionList) {
            accum.add(this.createSuggestion(candidate, SafeHtmlUtils.htmlEscape(candidate)));
        }
        this.setDefaultSuggestions(accum);
    }

    public final void setSuggestAllMatchingWords(boolean suggestAllMatchingWords) {
        this.suggestAllMatchingWords = suggestAllMatchingWords;
    }

    protected MultiWordSuggestion createSuggestion(String replacementString, String displayString) {
        return new MultiWordSuggestion(replacementString, displayString);
    }

    private List<MultiWordSuggestion> convertToFormattedSuggestions(String query, List<String> candidates) {
        ArrayList<MultiWordSuggestion> suggestions = new ArrayList<MultiWordSuggestion>();
        for (int i = 0; i < candidates.size(); ++i) {
            String candidate = candidates.get(i);
            List<String> realSuggestions = this.toRealSuggestions.get(candidate);
            TreeSet<String> realSuggestionsSet = new TreeSet<String>();
            if (this.suggestAllMatchingWords) {
                realSuggestionsSet.addAll(realSuggestions);
            } else {
                realSuggestionsSet.add(realSuggestions.get(0));
            }
            Iterator realSuggestionsIterator = realSuggestionsSet.iterator();
            while (realSuggestionsIterator.hasNext()) {
                WordBounds wordBounds;
                int cursor = 0;
                int index = 0;
                String formattedSuggestion = (String)realSuggestionsIterator.next();
                SafeHtmlBuilder accum = new SafeHtmlBuilder();
                String[] searchWords = query.split(WHITESPACE_STRING);
                while ((wordBounds = this.findNextWord(candidate, searchWords, index)) != null) {
                    if (wordBounds.startIndex == 0 || ' ' == candidate.charAt(wordBounds.startIndex - 1)) {
                        String part1 = formattedSuggestion.substring(cursor, wordBounds.startIndex);
                        String part2 = formattedSuggestion.substring(wordBounds.startIndex, wordBounds.endIndex);
                        cursor = wordBounds.endIndex;
                        accum.appendEscaped(part1);
                        accum.appendHtmlConstant("<strong>");
                        accum.appendEscaped(part2);
                        accum.appendHtmlConstant("</strong>");
                    }
                    index = wordBounds.endIndex;
                }
                if (cursor == 0) continue;
                accum.appendEscaped(formattedSuggestion.substring(cursor));
                MultiWordSuggestion suggestion = this.createSuggestion(formattedSuggestion, accum.toSafeHtml().asString());
                suggestions.add(suggestion);
            }
        }
        return suggestions;
    }

    private List<String> createCandidatesFromSearch(String query) {
        ArrayList<String> candidates = new ArrayList<String>();
        if (query.length() == 0) {
            return candidates;
        }
        String[] searchWords = query.split(WHITESPACE_STRING);
        HashSet<String> candidateSet = null;
        for (int i = 0; i < searchWords.length; ++i) {
            String word = searchWords[i];
            if (word.length() == 0 || word.matches(WHITESPACE_STRING)) continue;
            HashSet<String> thisWordChoices = this.createCandidatesFromWord(word);
            if (candidateSet == null) {
                candidateSet = thisWordChoices;
                continue;
            }
            candidateSet.retainAll(thisWordChoices);
            if (candidateSet.size() < 2) break;
        }
        if (candidateSet != null) {
            candidates.addAll(candidateSet);
            Collections.sort(candidates, this.comparator);
        }
        return candidates;
    }

    private HashSet<String> createCandidatesFromWord(String query) {
        HashSet<String> candidateSet = new HashSet<String>();
        List<String> words = this.tree.getSuggestions(query, Integer.MAX_VALUE);
        if (words != null) {
            for (int i = 0; i < words.size(); ++i) {
                Collection belongsTo = this.toCandidates.get(words.get(i));
                if (belongsTo == null) continue;
                candidateSet.addAll(belongsTo);
            }
        }
        return candidateSet;
    }

    private WordBounds findNextWord(String candidate, String[] searchWords, int indexToStartAt) {
        WordBounds firstWord = null;
        for (String word : searchWords) {
            int index = candidate.indexOf(word, indexToStartAt);
            if (index == -1) continue;
            WordBounds newWord = new WordBounds(index, word.length());
            if (firstWord != null && newWord.compareTo(firstWord) >= 0) continue;
            firstWord = newWord;
        }
        return firstWord;
    }

    private String normalizeSearch(String search) {
        search = this.normalizeSuggestion(search);
        search = search.replaceAll(NORMALIZE_TO_SINGLE_WHITE_SPACE, WHITESPACE_STRING);
        return search.trim();
    }

    private String normalizeSuggestion(String formattedSuggestion) {
        formattedSuggestion = formattedSuggestion.toLowerCase(Locale.ROOT);
        if (this.whitespaceChars != null) {
            for (int i = 0; i < this.whitespaceChars.length; ++i) {
                char ignore = this.whitespaceChars[i];
                formattedSuggestion = formattedSuggestion.replace(ignore, ' ');
            }
        }
        return formattedSuggestion;
    }

    private static class WordBounds
    implements Comparable<WordBounds> {
        final int startIndex;
        final int endIndex;

        public WordBounds(int startIndex, int length) {
            this.startIndex = startIndex;
            this.endIndex = startIndex + length;
        }

        @Override
        public int compareTo(WordBounds that) {
            int comparison = this.startIndex - that.startIndex;
            if (comparison == 0) {
                comparison = that.endIndex - this.endIndex;
            }
            return comparison;
        }
    }

    public static class MultiWordSuggestion
    implements SuggestOracle.Suggestion,
    IsSerializable {
        private String displayString;
        private String replacementString;

        public MultiWordSuggestion() {
        }

        public MultiWordSuggestion(String replacementString, String displayString) {
            this.replacementString = replacementString;
            this.displayString = displayString;
        }

        @Override
        public String getDisplayString() {
            return this.displayString;
        }

        @Override
        public String getReplacementString() {
            return this.replacementString;
        }
    }
}

