/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.sjavac.comp;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.openjdk.javax.tools.JavaFileManager;
import org.openjdk.tools.javac.file.JavacFileManager;
import org.openjdk.tools.javac.main.Main;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.sjavac.JavacState;
import org.openjdk.tools.sjavac.Log;
import org.openjdk.tools.sjavac.Module;
import org.openjdk.tools.sjavac.ProblemException;
import org.openjdk.tools.sjavac.Source;
import org.openjdk.tools.sjavac.Transformer;
import org.openjdk.tools.sjavac.Util;
import org.openjdk.tools.sjavac.comp.CompilationService;
import org.openjdk.tools.sjavac.options.Option;
import org.openjdk.tools.sjavac.options.Options;
import org.openjdk.tools.sjavac.options.SourceLocation;
import org.openjdk.tools.sjavac.server.Sjavac;

public class SjavacImpl
implements Sjavac {
    @Override
    public Main.Result compile(String[] stringArray) {
        Options options;
        try {
            options = Options.parseArgs(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.error(illegalArgumentException.getMessage());
            return Main.Result.CMDERR;
        }
        if (!SjavacImpl.validateOptions(options)) {
            return Main.Result.CMDERR;
        }
        if (SjavacImpl.srcDstOverlap(options.getSources(), options.getDestDir())) {
            return Main.Result.CMDERR;
        }
        if (!SjavacImpl.createIfMissing(options.getDestDir())) {
            return Main.Result.ERROR;
        }
        Path path = options.getStateDir();
        if (path != null && !SjavacImpl.createIfMissing(options.getStateDir())) {
            return Main.Result.ERROR;
        }
        Path path2 = options.getGenSrcDir();
        if (path2 != null && !SjavacImpl.createIfMissing(path2)) {
            return Main.Result.ERROR;
        }
        Path path3 = options.getHeaderDir();
        if (path3 != null && !SjavacImpl.createIfMissing(path3)) {
            return Main.Result.ERROR;
        }
        if (path == null) {
            Context context = new Context();
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            org.openjdk.tools.javac.util.Log.preRegister(context, printWriter);
            JavacFileManager.preRegister(context);
            String[] stringArray2 = (String[])Stream.of(stringArray).filter(string -> !string.startsWith(Option.SERVER.arg)).toArray(String[]::new);
            Main.Result result = new Main("javac", printWriter).compile(stringArray2, context);
            printWriter.flush();
            Util.getLines(stringWriter.toString()).forEach(Log::error);
            JavaFileManager javaFileManager = context.get(JavaFileManager.class);
            if (javaFileManager instanceof JavacFileManager) {
                try {
                    ((JavacFileManager)javaFileManager).close();
                }
                catch (IOException iOException) {
                    throw new UncheckedIOException(iOException);
                }
            }
            return result;
        }
        JavacState javacState = JavacState.load(options);
        HashMap<String, Transformer> hashMap = new HashMap<String, Transformer>();
        hashMap.putAll(javacState.getJavaSuffixRule());
        hashMap.putAll(options.getTranslationRules());
        HashMap<String, Module> hashMap2 = new HashMap<String, Module>();
        Module module = new Module("", "");
        hashMap2.put("", module);
        try {
            boolean bl;
            HashMap<String, Source> hashMap3 = new HashMap<String, Source>();
            SjavacImpl.findSourceFiles(options.getSources(), hashMap.keySet(), hashMap3, hashMap2, module, options.isDefaultPackagePermitted(), false);
            if (hashMap3.isEmpty()) {
                Log.error("Found nothing to compile!");
                return Main.Result.ERROR;
            }
            HashMap<String, Source> hashMap4 = new HashMap<String, Source>();
            ArrayList<SourceLocation> arrayList = new ArrayList<SourceLocation>();
            arrayList.addAll(options.getSources());
            arrayList.addAll(options.getSourceSearchPaths());
            SjavacImpl.findSourceFiles(arrayList, Collections.singleton(".java"), hashMap4, hashMap2, module, options.isDefaultPackagePermitted(), true);
            javacState.now().flattenPackagesSourcesAndArtifacts(hashMap2);
            javacState.now().checkInternalState("checking sources", false, hashMap3);
            javacState.now().checkInternalState("checking linked sources", true, hashMap4);
            javacState.setVisibleSources(hashMap4);
            int n = 0;
            SjavacImpl.printRound(n);
            javacState.checkSourceStatus(false);
            javacState.findAllArtifacts();
            if (!options.areUnidentifiedArtifactsPermitted()) {
                javacState.removeUnidentifiedArtifacts();
            }
            javacState.taintPackagesThatMissArtifacts();
            javacState.taintPackagesDependingOnChangedClasspathPackages();
            javacState.deleteClassArtifactsInTaintedPackages();
            javacState.performCopying(Util.pathToFile(options.getDestDir()), hashMap);
            javacState.performTranslation(Util.pathToFile(path2), hashMap);
            HashMap<String, Source> hashMap5 = new HashMap<String, Source>();
            Source.scanRoot(Util.pathToFile(options.getGenSrcDir()), Util.set(".java"), Collections.emptyList(), Collections.emptyList(), hashMap5, hashMap2, module, false, true, false);
            javacState.now().flattenPackagesSourcesAndArtifacts(hashMap2);
            javacState.checkSourceStatus(true);
            javacState.compareWithMakefileList(Util.pathToFile(options.getSourceReferenceList()));
            HashSet<String> hashSet = new HashSet<String>();
            boolean[] blArray = new boolean[1];
            CompilationService compilationService = new CompilationService();
            do {
                if (n > 0) {
                    SjavacImpl.printRound(n);
                }
                javacState.deleteClassArtifactsInTaintedPackages();
                bl = javacState.performJavaCompilations(compilationService, options, hashSet, blArray);
                if (!blArray[0]) {
                    Log.debug("Compilation failed.");
                    break;
                }
                if (!bl) {
                    Log.debug("Nothing left to do.");
                }
                ++n;
            } while (bl);
            Log.debug("No need to do another round.");
            if (blArray[0]) {
                javacState.save();
                javacState.now().flattenArtifacts(hashMap2);
                javacState.removeSuperfluousArtifacts(hashSet);
            }
            return blArray[0] ? Main.Result.OK : Main.Result.ERROR;
        }
        catch (ProblemException problemException) {
            Log.error(problemException.getMessage());
            Log.debug(problemException);
            return Main.Result.ERROR;
        }
        catch (Exception exception) {
            Log.error(exception);
            return Main.Result.ERROR;
        }
    }

    @Override
    public void shutdown() {
    }

    private static boolean validateOptions(Options options) {
        String string = null;
        if (options.getDestDir() == null) {
            string = "Please specify output directory.";
        } else if (options.isJavaFilesAmongJavacArgs()) {
            string = "Sjavac does not handle explicit compilation of single .java files.";
        } else if (!options.getImplicitPolicy().equals("none")) {
            string = "The only allowed setting for sjavac is -implicit:none";
        } else if (options.getSources().isEmpty() && options.getStateDir() != null) {
            string = "You have to specify -src when using --state-dir.";
        } else if (options.getTranslationRules().size() > 1 && options.getGenSrcDir() == null) {
            string = "You have translators but no gensrc dir (-s) specified!";
        }
        if (string != null) {
            Log.error(string);
        }
        return string == null;
    }

    private static boolean srcDstOverlap(List<SourceLocation> list, Path path) {
        for (SourceLocation sourceLocation : list) {
            if (!SjavacImpl.isOverlapping(sourceLocation.getPath(), path)) continue;
            Log.error("Source location " + sourceLocation.getPath() + " overlaps with destination " + path);
            return true;
        }
        return false;
    }

    private static boolean isOverlapping(Path path, Path path2) {
        return (path = path.toAbsolutePath().normalize()).startsWith(path2 = path2.toAbsolutePath().normalize()) || path2.startsWith(path);
    }

    private static boolean createIfMissing(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            return true;
        }
        if (Files.exists(path, new LinkOption[0])) {
            Log.error(path + " is not a directory.");
            return false;
        }
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            Log.error("Could not create directory: " + iOException.getMessage());
            return false;
        }
        return true;
    }

    public static void findSourceFiles(List<SourceLocation> list, Set<String> set, Map<String, Source> map, Map<String, Module> map2, Module module, boolean bl, boolean bl2) throws IOException {
        for (SourceLocation sourceLocation : list) {
            sourceLocation.findSourceFiles(set, map, map2, module, bl, bl2);
        }
    }

    private static void printRound(int n) {
        Log.debug("****************************************");
        Log.debug("* Round " + n + "                              *");
        Log.debug("****************************************");
    }
}

