/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.com.google.common.base.CharEscapers;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.YamlConfig;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.YamlException;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.YamlReader;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.PluginLoader;
import com.google.apphosting.utils.config.YamlUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppYaml {
    private String application;
    private String version;
    private String runtime;
    private List<Handler> handlers;
    private String public_root;
    private List<StaticFile> static_files;
    private List<ResourceFile> resource_files;
    private boolean ssl_enabled = true;
    private boolean precompilation_enabled = true;
    private boolean sessions_enabled = false;
    private Map<String, String> system_properties;
    private Map<String, String> env_variables;
    private Map<String, String> context_params;
    private List<String> welcome_files;
    private List<String> listeners;
    private List<String> inbound_services;
    private AdminConsole admin_console;
    private List<ErrorHandler> error_handlers;
    private String web_xml;
    private static final String REQUIRED_FIELD = "Missing required element '%s'.";

    public String getApplication() {
        if (this.application == null) {
            throw new AppEngineConfigException(String.format(REQUIRED_FIELD, "application"));
        }
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getVersion() {
        if (this.version == null) {
            throw new AppEngineConfigException(String.format(REQUIRED_FIELD, "version"));
        }
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getRuntime() {
        return this.runtime;
    }

    public void setRuntime(String runtime) {
        this.runtime = runtime;
    }

    public List<Handler> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(List<Handler> handlers) {
        this.handlers = handlers;
    }

    public String getPublic_root() {
        return this.public_root;
    }

    public void setPublic_root(String public_root) {
        this.public_root = public_root;
    }

    public List<StaticFile> getStatic_files() {
        return this.static_files;
    }

    public void setStatic_files(List<StaticFile> static_files) {
        this.static_files = static_files;
    }

    public List<ResourceFile> getResource_files() {
        return this.resource_files;
    }

    public void setResource_files(List<ResourceFile> resource_files) {
        this.resource_files = resource_files;
    }

    public String getSsl_enabled() {
        return "" + this.ssl_enabled;
    }

    public void setSsl_enabled(String ssl_enabled) {
        this.ssl_enabled = YamlUtils.parseBoolean(ssl_enabled);
    }

    public boolean isSslEnabled() {
        return this.ssl_enabled;
    }

    public String getPrecompilation_enabled() {
        return "" + this.precompilation_enabled;
    }

    public boolean isPrecompilationEnabled() {
        return this.precompilation_enabled;
    }

    public void setPrecompilation_enabled(String precompilation_enabled) {
        this.precompilation_enabled = YamlUtils.parseBoolean(precompilation_enabled);
    }

    public String getSessions_enabled() {
        return "" + this.sessions_enabled;
    }

    public boolean isSessionsEnabled() {
        return this.sessions_enabled;
    }

    public void setSessions_enabled(String sessions_enabled) {
        this.sessions_enabled = YamlUtils.parseBoolean(sessions_enabled);
    }

    public Map<String, String> getSystem_properties() {
        return this.system_properties;
    }

    public void setSystem_properties(Map<String, String> system_properties) {
        this.system_properties = system_properties;
    }

    public Map<String, String> getEnv_variables() {
        return this.env_variables;
    }

    public void setEnv_variables(Map<String, String> env_variables) {
        this.env_variables = env_variables;
    }

    public List<String> getWelcome_files() {
        return this.welcome_files;
    }

    public void setWelcome_files(List<String> welcome_files) {
        this.welcome_files = welcome_files;
    }

    public Map<String, String> getContext_params() {
        return this.context_params;
    }

    public void setContext_params(Map<String, String> context_params) {
        this.context_params = context_params;
    }

    public List<String> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<String> listeners) {
        this.listeners = listeners;
    }

    public String getWeb_xml() {
        return this.web_xml;
    }

    public void setWeb_xml(String web_xml) {
        this.web_xml = web_xml;
    }

    public List<String> getInbound_services() {
        return this.inbound_services;
    }

    public void setInbound_services(List<String> inbound_services) {
        this.inbound_services = inbound_services;
    }

    public AdminConsole getAdmin_console() {
        return this.admin_console;
    }

    public void setAdmin_console(AdminConsole admin_console) {
        this.admin_console = admin_console;
    }

    public List<ErrorHandler> getError_handlers() {
        return this.error_handlers;
    }

    public void setError_handlers(List<ErrorHandler> error_handlers) {
        this.error_handlers = error_handlers;
    }

    public AppYaml applyPlugins() {
        Iterator<Plugin> it = PluginLoader.loadPlugins(Plugin.class);
        AppYaml yaml = this;
        while (it.hasNext()) {
            Plugin plugin = it.next();
            AppYaml modified = plugin.process(yaml);
            if (modified == null) continue;
            yaml = modified;
        }
        return yaml;
    }

    public void generateAppEngineWebXml(Writer writer) {
        String path;
        String name;
        XmlWriter xml = new XmlWriter(writer);
        xml.startElement("appengine-web-app", "xmlns", "http://appengine.google.com/ns/1.0");
        xml.simpleElement("application", this.getApplication(), new String[0]);
        xml.simpleElement("version", this.getVersion(), new String[0]);
        if (this.public_root != null) {
            xml.simpleElement("public-root", this.public_root, new String[0]);
        }
        xml.startElement("static-files", new String[0]);
        if (this.static_files != null) {
            for (StaticFile staticFile : this.static_files) {
                if (staticFile.getInclude() != null) {
                    name = "include";
                    path = staticFile.getInclude();
                } else {
                    name = "exclude";
                    path = staticFile.getExclude();
                }
                xml.emptyElement(name, "path", path, "expiration", staticFile.getExpiration());
            }
        }
        xml.endElement("static-files");
        xml.startElement("resource-files", new String[0]);
        if (this.resource_files != null) {
            for (ResourceFile resourceFile : this.resource_files) {
                if (resourceFile.getInclude() != null) {
                    name = "include";
                    path = resourceFile.getInclude();
                } else {
                    name = "exclude";
                    path = resourceFile.getExclude();
                }
                xml.emptyElement(name, "path", path);
            }
        }
        xml.endElement("resource-files");
        xml.simpleElement("ssl-enabled", this.getSsl_enabled(), new String[0]);
        xml.simpleElement("precompilation-enabled", this.getPrecompilation_enabled(), new String[0]);
        xml.simpleElement("sessions-enabled", this.getSessions_enabled(), new String[0]);
        if (this.system_properties != null) {
            xml.startElement("system-properties", new String[0]);
            for (Map.Entry entry : this.system_properties.entrySet()) {
                xml.emptyElement("property", "name", (String)entry.getKey(), "value", (String)entry.getValue());
            }
            xml.endElement("system-properties");
        }
        if (this.env_variables != null) {
            xml.startElement("env-variables", new String[0]);
            for (Map.Entry entry : this.env_variables.entrySet()) {
                xml.emptyElement("env-var", "name", (String)entry.getKey(), "value", (String)entry.getValue());
            }
            xml.endElement("env-variables");
        }
        boolean warmupService = false;
        if (this.inbound_services != null) {
            xml.startElement("inbound-services", new String[0]);
            for (String service : this.inbound_services) {
                if ("warmup".equals(service)) {
                    warmupService = true;
                    continue;
                }
                xml.simpleElement("service", service, new String[0]);
            }
            xml.endElement("inbound-services");
        }
        xml.simpleElement("warmup-requests-enabled", Boolean.toString(warmupService), new String[0]);
        if (this.admin_console != null && this.admin_console.getPages() != null) {
            xml.startElement("admin-console", new String[0]);
            for (AdminPage page : this.admin_console.getPages()) {
                xml.emptyElement("page", "name", page.getName(), "url", page.getUrl());
            }
            xml.endElement("admin-console");
        }
        if (this.error_handlers != null) {
            xml.startElement("static-error-handlers", new String[0]);
            for (ErrorHandler handler : this.error_handlers) {
                xml.emptyElement("handler", "file", handler.getFile(), "error-code", handler.getError_code());
            }
            xml.endElement("static-error-handlers");
        }
        xml.endElement("appengine-web-app");
    }

    public void generateWebXml(Writer writer) {
        XmlWriter xml = new XmlWriter(writer);
        xml.startElement("web-app", "version", "2.5", "xmlns", "http://java.sun.com/xml/ns/javaee");
        if (this.handlers != null) {
            for (Handler handler : this.handlers) {
                handler.generateXml(xml);
            }
        }
        if (this.context_params != null) {
            for (Map.Entry entry : this.context_params.entrySet()) {
                xml.startElement("context-param", new String[0]);
                xml.simpleElement("param-name", (String)entry.getKey(), new String[0]);
                xml.simpleElement("param-value", (String)entry.getValue(), new String[0]);
                xml.endElement("context-param");
            }
        }
        if (this.welcome_files != null) {
            xml.startElement("welcome-file-list", new String[0]);
            for (String string : this.welcome_files) {
                xml.simpleElement("welcome-file", string, new String[0]);
            }
            xml.endElement("welcome-file-list");
        }
        if (this.listeners != null) {
            for (String string : this.listeners) {
                xml.startElement("listener", new String[0]);
                xml.simpleElement("listener-class", string, new String[0]);
                xml.endElement("listener");
            }
        }
        if (this.web_xml != null) {
            xml.writeUnescaped(this.web_xml);
        }
        xml.endElement("web-app");
    }

    public static void convert(File baseDir, String aewebPath, String webXmlPath) {
        File appYamlFile = new File(baseDir, "app.yaml");
        if (!appYamlFile.exists()) {
            return;
        }
        File aeweb = new File(aewebPath);
        File webXml = new File(webXmlPath);
        if (aeweb.exists() && webXml.exists() && aeweb.lastModified() >= appYamlFile.lastModified() && webXml.lastModified() >= appYamlFile.lastModified()) {
            return;
        }
        AppYaml appYaml = null;
        try {
            appYaml = AppYaml.parse(new FileReader(appYamlFile));
        }
        catch (FileNotFoundException ex) {
            throw new AppEngineConfigException("Unable to parse " + appYamlFile, ex);
        }
        try {
            FileWriter aewebWriter = new FileWriter(aeweb);
            appYaml.generateAppEngineWebXml(aewebWriter);
            aewebWriter.close();
            aeweb.setLastModified(appYamlFile.lastModified());
        }
        catch (IOException ex) {
            throw new AppEngineConfigException("Unable to generate appengine-web.xml", ex);
        }
        try {
            FileWriter webXmlWriter = new FileWriter(webXml);
            appYaml.generateWebXml(webXmlWriter);
            webXmlWriter.close();
            webXml.setLastModified(appYamlFile.lastModified());
        }
        catch (IOException ex) {
            throw new AppEngineConfigException("Unable to generate web.xml", ex);
        }
    }

    public static AppYaml parse(Reader reader) {
        YamlReader yaml = new YamlReader(reader);
        AppYaml.prepareParser(yaml.getConfig());
        try {
            return yaml.read(AppYaml.class).applyPlugins();
        }
        catch (YamlException e) {
            throw new AppEngineConfigException(e.getMessage(), e);
        }
    }

    public static AppYaml parse(String yaml) {
        return AppYaml.parse(new StringReader(yaml));
    }

    public static void prepareParser(YamlConfig config) {
        config.setPropertyElementType(AppYaml.class, "handlers", Handler.class);
        config.setPropertyElementType(AppYaml.class, "static_files", StaticFile.class);
        config.setPropertyElementType(AppYaml.class, "resource_files", ResourceFile.class);
        config.setPropertyElementType(AppYaml.class, "system_properties", String.class);
        config.setPropertyElementType(AppYaml.class, "context_params", String.class);
        config.setPropertyElementType(AppYaml.class, "env_variables", String.class);
        config.setPropertyElementType(AppYaml.class, "welcome_files", String.class);
        config.setPropertyElementType(AppYaml.class, "listeners", String.class);
        config.setPropertyElementType(AppYaml.class, "inbound_services", String.class);
        config.setPropertyElementType(Handler.class, "init_params", String.class);
        config.setPropertyElementType(AdminConsole.class, "pages", AdminPage.class);
        config.setPropertyElementType(AppYaml.class, "error_handlers", ErrorHandler.class);
    }

    private class XmlWriter {
        private static final String XML_HEADER = "<!-- Generated from app.yaml. Do not edit. -->";
        private PrintWriter writer;
        private int indent = 0;

        public XmlWriter(Writer w) {
            this.writer = new PrintWriter(w);
            this.writer.println(XML_HEADER);
        }

        public void startElement(String name, String ... attributes) {
            this.startElement(name, false, attributes);
            this.writer.println();
        }

        public void startElement(String name, boolean empty, String ... attributes) {
            this.indent();
            this.writer.print("<");
            this.writer.print(name);
            for (int i = 0; i < attributes.length; i += 2) {
                String attributeName = attributes[i];
                String value = attributes[i + 1];
                if (value == null) continue;
                this.writer.print(" ");
                this.writer.print(attributeName);
                this.writer.print("='");
                this.writer.print(this.escape(value));
                this.writer.print("'");
            }
            if (empty) {
                this.writer.println("/>");
            } else {
                this.writer.print(">");
                this.indent += 2;
            }
        }

        public void endElement(String name) {
            this.endElement(name, true);
        }

        public void endElement(String name, boolean needIndent) {
            this.indent -= 2;
            if (needIndent) {
                this.indent();
            }
            this.writer.print("</");
            this.writer.print(name);
            this.writer.println(">");
        }

        public void emptyElement(String name, String ... attributes) {
            this.startElement(name, true, attributes);
        }

        public void simpleElement(String name, String value, String ... attributes) {
            this.startElement(name, false, attributes);
            this.writer.print(this.escape(value));
            this.endElement(name, false);
        }

        public void writeUnescaped(String xmlContent) {
            this.writer.println(xmlContent);
        }

        private void indent() {
            for (int i = 0; i < this.indent; ++i) {
                this.writer.print(" ");
            }
        }

        private String escape(String value) {
            if (value == null) {
                return null;
            }
            return CharEscapers.xmlEscaper().escape(value);
        }
    }

    public static class ErrorHandler {
        private String file;
        private String errorCode;

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public String getError_code() {
            return this.errorCode;
        }

        public void setError_code(String errorCode) {
            this.errorCode = errorCode;
        }
    }

    public static class AdminPage {
        private String name;
        private String url;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AdminConsole {
        private List<AdminPage> pages;

        public List<AdminPage> getPages() {
            return this.pages;
        }

        public void setPages(List<AdminPage> pages) {
            this.pages = pages;
        }
    }

    public static class StaticFile
    extends ResourceFile {
        private static final String NO_INCLUDE = "Missing include.";
        private static final String INCLUDE_ONLY = "Expiration can only be specified with include.";
        private String expiration;

        public String getExpiration() {
            if (this.expiration != null && this.include == null) {
                throw new AppEngineConfigException(NO_INCLUDE);
            }
            return this.expiration;
        }

        public void setExpiration(String expiration) {
            if (this.exclude != null) {
                throw new AppEngineConfigException(INCLUDE_ONLY);
            }
            this.expiration = expiration;
        }

        public void setExclude(String exclude) {
            if (this.expiration != null) {
                throw new AppEngineConfigException(INCLUDE_ONLY);
            }
            super.setExclude(exclude);
        }
    }

    public static class ResourceFile {
        private static final String EMPTY_MESSAGE = "Missing include or exclude.";
        private static final String BOTH_MESSAGE = "Cannot specify both include and exclude.";
        protected String include;
        protected String exclude;

        public String getInclude() {
            if (this.exclude == null && this.include == null) {
                throw new AppEngineConfigException(EMPTY_MESSAGE);
            }
            return this.include;
        }

        public void setInclude(String include) {
            if (this.exclude != null) {
                throw new AppEngineConfigException(BOTH_MESSAGE);
            }
            this.include = include;
        }

        public String getExclude() {
            if (this.exclude == null && this.include == null) {
                throw new AppEngineConfigException(EMPTY_MESSAGE);
            }
            return this.exclude;
        }

        public void setExclude(String exclude) {
            if (this.include != null) {
                throw new AppEngineConfigException(BOTH_MESSAGE);
            }
            this.exclude = exclude;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Handler {
        private String url;
        private String jsp;
        private String servlet;
        private String filter;
        private LoginType login;
        private Security secure;
        private Map<String, String> init_params;
        private String name;
        private static final String MULTIPLE_HANDLERS = "Cannot set both %s and %s for the same url.";

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getJsp() {
            return this.jsp;
        }

        public void setJsp(String jsp) {
            this.jsp = jsp;
            this.checkHandlers();
        }

        public String getServlet() {
            return this.servlet;
        }

        public void setServlet(String servlet) {
            this.servlet = servlet;
            this.checkHandlers();
        }

        public String getFilter() {
            return this.filter;
        }

        public void setFilter(String filter) {
            this.filter = filter;
            this.checkHandlers();
        }

        public LoginType getLogin() {
            return this.login;
        }

        public void setLogin(LoginType login) {
            this.login = login;
        }

        public Security getSecure() {
            return this.secure;
        }

        public void setSecure(Security secure) {
            if (secure == Security.never) {
                throw new AppEngineConfigException("Java does not support secure: never");
            }
            this.secure = secure;
        }

        public Map<String, String> getInit_params() {
            return this.init_params;
        }

        public void setInit_params(Map<String, String> init_params) {
            this.init_params = init_params;
        }

        public String getName() {
            if (this.name == null) {
                if (this.jsp != null) {
                    return this.jsp;
                }
                if (this.servlet != null) {
                    return this.servlet;
                }
                if (this.filter != null) {
                    return this.filter;
                }
            }
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        private void checkHandlers() {
            if (this.jsp != null && this.servlet != null) {
                throw new AppEngineConfigException(String.format(MULTIPLE_HANDLERS, "jsp", "servlet"));
            }
            if (this.jsp != null && this.filter != null) {
                throw new AppEngineConfigException(String.format(MULTIPLE_HANDLERS, "jsp", "filter"));
            }
            if (this.filter != null && this.servlet != null) {
                throw new AppEngineConfigException(String.format(MULTIPLE_HANDLERS, "filter", "servlet"));
            }
        }

        private void generateXml(XmlWriter xml) {
            if (this.getServlet() != null || this.getJsp() != null) {
                this.generateServlet(xml);
            } else if (this.getFilter() != null) {
                this.generateFilter(xml);
            }
            this.generateSecurityConstraints(xml);
        }

        private void generateSecurityConstraints(XmlWriter xml) {
            if (this.secure == Security.always) {
                this.securityConstraint(xml, "user-data", "transport-guarantee", "CONFIDENTIAL");
            }
            if (this.login == LoginType.required) {
                this.securityConstraint(xml, "auth", "role-name", "*");
            } else if (this.login == LoginType.admin) {
                this.securityConstraint(xml, "auth", "role-name", "admin");
            }
        }

        private void securityConstraint(XmlWriter xml, String type, String name, String value) {
            type = type + "-constraint";
            xml.startElement("security-constraint", new String[0]);
            xml.startElement("web-resource-collection", new String[0]);
            xml.simpleElement("url-pattern", this.getUrl(), new String[0]);
            xml.endElement("web-resource-collection");
            xml.startElement(type, new String[0]);
            xml.simpleElement(name, value, new String[0]);
            xml.endElement(type);
            xml.endElement("security-constraint");
        }

        private void generateFilter(XmlWriter xml) {
            xml.startElement("filter", new String[0]);
            xml.simpleElement("filter-name", this.getName(), new String[0]);
            xml.simpleElement("filter-class", this.getFilter(), new String[0]);
            this.generateInitParams(xml);
            xml.endElement("filter");
            xml.startElement("filter-mapping", new String[0]);
            xml.simpleElement("filter-name", this.getName(), new String[0]);
            xml.simpleElement("url-pattern", this.getUrl(), new String[0]);
            xml.endElement("filter-mapping");
        }

        private void generateServlet(XmlWriter xml) {
            xml.startElement("servlet", new String[0]);
            xml.simpleElement("servlet-name", this.getName(), new String[0]);
            if (this.getJsp() == null) {
                xml.simpleElement("servlet-class", this.getServlet(), new String[0]);
            } else {
                xml.simpleElement("jsp-file", this.getJsp(), new String[0]);
            }
            this.generateInitParams(xml);
            xml.endElement("servlet");
            xml.startElement("servlet-mapping", new String[0]);
            xml.simpleElement("servlet-name", this.getName(), new String[0]);
            xml.simpleElement("url-pattern", this.getUrl(), new String[0]);
            xml.endElement("servlet-mapping");
        }

        private void generateInitParams(XmlWriter xml) {
            if (this.init_params != null) {
                for (Map.Entry<String, String> param : this.init_params.entrySet()) {
                    xml.startElement("init-param", new String[0]);
                    xml.simpleElement("param-name", param.getKey(), new String[0]);
                    xml.simpleElement("param-value", param.getValue(), new String[0]);
                    xml.endElement("init-param");
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Security {
            always,
            optional,
            never;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum LoginType {
            admin,
            required;

        }
    }

    public static interface Plugin {
        public AppYaml process(AppYaml var1);
    }
}

