/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgooddatepicker.ysandbox;

import java.time.LocalDate;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TestParsingMatchFunction {
    public static void main(String[] args) {
        TestParsingMatchFunction.testDoesParsedDateMatchTextFunction();
    }

    public static void testDoesParsedDateMatchTextFunction() {
        String nonExistantDateString2;
        LocalDate nonExistantDate2;
        LocalDate nonExistantDate;
        int year;
        DateTimeFormatter parseFormat = new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().appendPattern("M d, u").toFormatter(Locale.getDefault());
        DateTimeFormatter parseFormat2 = new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().appendPattern("MMMM d, u").toFormatter(Locale.getDefault());
        DateTimeFormatter parseFormatBC = new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().appendPattern("MMMM d, yyyy G").toFormatter(Locale.getDefault());
        Month[] shortMonths = new Month[]{Month.FEBRUARY, Month.APRIL, Month.JUNE, Month.SEPTEMBER, Month.NOVEMBER};
        for (year = -10000; year < 10001; ++year) {
            for (int monthIndex = 0; monthIndex < shortMonths.length; ++monthIndex) {
                String nonExistantDateString22;
                LocalDate nonExistantDate22;
                String nonExistantDateString = shortMonths[monthIndex].getValue() + " 31, " + year;
                LocalDate nonExistantDate3 = LocalDate.parse(nonExistantDateString, parseFormat);
                if (TestParsingMatchFunction.doesParsedDateMatchText(nonExistantDate3, nonExistantDateString, Locale.getDefault())) {
                    System.out.println("invalid match at " + nonExistantDateString);
                }
                if (!TestParsingMatchFunction.doesParsedDateMatchText(nonExistantDate22 = LocalDate.parse(nonExistantDateString22 = shortMonths[monthIndex].name() + " 31, " + year, parseFormat2), nonExistantDateString22, Locale.getDefault())) continue;
                System.out.println("invalid match at " + nonExistantDateString22);
            }
        }
        for (year = -10000; year < 10001; ++year) {
            String nonExistantDateString = Month.FEBRUARY.getValue() + " 30, " + year;
            nonExistantDate = LocalDate.parse(nonExistantDateString, parseFormat);
            if (TestParsingMatchFunction.doesParsedDateMatchText(nonExistantDate, nonExistantDateString, Locale.getDefault())) {
                System.out.println("invalid match at " + nonExistantDateString);
            }
            if (!TestParsingMatchFunction.doesParsedDateMatchText(nonExistantDate2 = LocalDate.parse(nonExistantDateString2 = Month.FEBRUARY.name() + " 30, " + year, parseFormat2), nonExistantDateString2, Locale.getDefault())) continue;
            System.out.println("invalid match at " + nonExistantDateString2);
        }
        for (year = -10000; year < 10001; ++year) {
            if (TestParsingMatchFunction.isLeapYear(year)) continue;
            String nonExistantDateString = Month.FEBRUARY.getValue() + " 29, " + year;
            nonExistantDate = LocalDate.parse(nonExistantDateString, parseFormat);
            if (TestParsingMatchFunction.doesParsedDateMatchText(nonExistantDate, nonExistantDateString, Locale.getDefault())) {
                System.out.println("invalid match at " + nonExistantDateString);
            }
            if (!TestParsingMatchFunction.doesParsedDateMatchText(nonExistantDate2 = LocalDate.parse(nonExistantDateString2 = Month.FEBRUARY.name() + " 29, " + year, parseFormat2), nonExistantDateString2, Locale.getDefault())) continue;
            System.out.println("invalid match at " + nonExistantDateString2);
        }
        LocalDate validDate = LocalDate.of(-10000, 1, 1);
        while (validDate.getYear() < 10001) {
            String alphabeticDate;
            if (!TestParsingMatchFunction.doesParsedDateMatchText(validDate, validDate.toString(), Locale.getDefault())) {
                System.out.println("invalid mismatch at " + validDate.toString());
            }
            if (!TestParsingMatchFunction.doesParsedDateMatchText(validDate, alphabeticDate = validDate.format(parseFormat2), Locale.getDefault())) {
                System.out.println("invalid mismatch at " + validDate.toString());
            }
            validDate = validDate.plusDays(1L);
        }
        LocalDate validDateBC = LocalDate.of(-10000, 1, 1);
        while (validDateBC.getYear() < 5) {
            String alphabeticDateBC = validDateBC.format(parseFormatBC);
            if (!TestParsingMatchFunction.doesParsedDateMatchText(validDateBC, alphabeticDateBC, Locale.getDefault())) {
                System.out.println("invalid mismatch at " + validDateBC.toString());
            }
            validDateBC = validDateBC.plusDays(1L);
        }
        System.out.println("done.");
    }

    private static boolean isLeapYear(int year) {
        if (year % 4 != 0) {
            return false;
        }
        if (year % 400 == 0) {
            return true;
        }
        return year % 100 != 0;
    }

    private static boolean doesParsedDateMatchText(LocalDate parsedDate, String text, Locale formatLocale) {
        if (parsedDate == null || text == null) {
            return false;
        }
        text = text.toLowerCase();
        Pattern pattern = Pattern.compile("\\d+");
        Matcher matcher = pattern.matcher(text);
        ArrayList<String> unsignedNumbersFound = new ArrayList<String>();
        while (matcher.find()) {
            String foundString = matcher.group();
            foundString = TestParsingMatchFunction.forceTwoDigitNumberString(foundString);
            unsignedNumbersFound.add(foundString);
        }
        String parsedDayOfMonth = "" + parsedDate.getDayOfMonth();
        parsedDayOfMonth = TestParsingMatchFunction.forceTwoDigitNumberString(parsedDayOfMonth);
        boolean dayOfMonthFound = unsignedNumbersFound.remove(parsedDayOfMonth);
        DateTimeFormatter formatBC = DateTimeFormatter.ofPattern("G", formatLocale);
        String eraBCString = LocalDate.of(-100, 1, 1).format(formatBC).toLowerCase();
        if (parsedDate.getYear() < 1 && text.contains(eraBCString)) {
            String parsedYearForBC = "" + (parsedDate.getYear() - 1);
            parsedYearForBC = parsedYearForBC.replace("-", "");
            boolean yearFoundForBC = unsignedNumbersFound.remove(parsedYearForBC = TestParsingMatchFunction.forceTwoDigitNumberString(parsedYearForBC));
            return yearFoundForBC && dayOfMonthFound;
        }
        String parsedYear = "" + parsedDate.getYear();
        parsedYear = parsedYear.replace("-", "");
        boolean yearFound = unsignedNumbersFound.remove(parsedYear = TestParsingMatchFunction.forceTwoDigitNumberString(parsedYear));
        return yearFound && dayOfMonthFound;
    }

    private static String forceTwoDigitNumberString(String text) {
        while (text.length() < 2) {
            text = "0" + text;
        }
        if (text.length() > 2) {
            text = text.substring(text.length() - 2, text.length());
        }
        return text;
    }
}

