/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.web.action.admin;

import com.franciaflex.faxtomail.persistence.entities.MailLock;
import com.franciaflex.faxtomail.services.service.EmailService;
import com.franciaflex.faxtomail.web.FaxToMailActionSupport;
import com.opensymphony.xwork2.Preparable;
import java.util.List;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.InterceptorRefs;
import org.apache.struts2.convention.annotation.Result;

@InterceptorRefs(value={@InterceptorRef(value="faxToMailInterceptor"), @InterceptorRef(value="loginInterceptor"), @InterceptorRef(value="paramsPrepareParamsStack")})
public class LockAction
extends FaxToMailActionSupport
implements Preparable {
    protected EmailService emailService;
    protected List<MailLock> activeLocks;
    protected List<String> mailLockIds;

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }

    public void prepare() throws Exception {
        if (!this.getSession().isAdmin()) {
            throw new RuntimeException("Not authorized");
        }
    }

    @Action(value="lock-input")
    public String input() throws Exception {
        this.activeLocks = this.emailService.getAllMailLocks();
        return "input";
    }

    @Action(results={@Result(type="redirectAction", params={"actionName", "lock-input"})})
    public String execute() throws Exception {
        if (this.mailLockIds != null) {
            this.emailService.unlockMails(this.mailLockIds);
        }
        return "success";
    }

    public List<MailLock> getActiveLocks() {
        return this.activeLocks;
    }

    public void setMailLockIds(List<String> mailLockIds) {
        this.mailLockIds = mailLockIds;
    }
}

