/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.web.job;

import com.franciaflex.faxtomail.FaxToMailApplicationContext;
import com.franciaflex.faxtomail.FaxToMailConfiguration;
import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.persistence.entities.AttachmentImpl;
import com.franciaflex.faxtomail.persistence.entities.Client;
import com.franciaflex.faxtomail.persistence.entities.DemandStatus;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.EmailAccount;
import com.franciaflex.faxtomail.persistence.entities.EmailImpl;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailTopiaPersistenceContext;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.MailFilter;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.persistence.entities.OriginalEmail;
import com.franciaflex.faxtomail.services.DecoratorService;
import com.franciaflex.faxtomail.services.FaxToMailServiceContext;
import com.franciaflex.faxtomail.services.FaxToMailServiceUtils;
import com.franciaflex.faxtomail.services.service.ClientService;
import com.franciaflex.faxtomail.services.service.ConfigurationService;
import com.franciaflex.faxtomail.services.service.EmailService;
import com.franciaflex.faxtomail.services.service.MailFolderService;
import com.franciaflex.faxtomail.web.job.AbstractFaxToMailJob;
import com.franciaflex.faxtomail.web.job.MailFilterJob;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class MailFilterJob
extends AbstractFaxToMailJob {
    private static final Log log = LogFactory.getLog(MailFilterJob.class);
    protected FaxToMailApplicationContext applicationContext;
    protected FaxToMailConfiguration config;
    protected ConfigurationService configurationService;
    protected EmailService emailService;
    protected MailFolderService mailFolderService;
    protected ClientService clientService;
    protected DecoratorService decoratorService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        this.applicationContext = this.getApplicationContext(jobExecutionContext);
        try (FaxToMailTopiaPersistenceContext persistenceContext = null;){
            persistenceContext = this.applicationContext.newPersistenceContext();
            FaxToMailServiceContext serviceContext = this.applicationContext.newServiceContext(persistenceContext);
            this.config = serviceContext.getApplicationConfig();
            if (log.isInfoEnabled()) {
                log.info((Object)("Running MailFilterJob at " + serviceContext.getNow()));
            }
            this.emailService = serviceContext.getEmailService();
            this.mailFolderService = serviceContext.getMailFolderService();
            this.configurationService = serviceContext.getConfigurationService();
            this.clientService = serviceContext.getClientService();
            this.decoratorService = serviceContext.getDecoratorService();
            List emailAccounts = this.configurationService.getEmailAccounts();
            for (EmailAccount account : emailAccounts) {
                this.checkEmails(account);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("MailFilterJob ended at " + serviceContext.getNow()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void checkEmails(EmailAccount account) {
        block19: {
            Properties properties = new Properties();
            properties.setProperty("mail.mime.address.strict", "false");
            switch (2.$SwitchMap$com$franciaflex$faxtomail$persistence$entities$EmailProtocol[account.getProtocol().ordinal()]) {
                case 1: {
                    properties.setProperty("mail.imap.ssl.enable", "true");
                }
                case 2: {
                    properties.setProperty("mail.store.protocol", "imap");
                    properties.setProperty("mail.imap.host", account.getHost());
                    properties.setProperty("mail.imap.port", String.valueOf(account.getPort()));
                    properties.setProperty("mail.imap.connectiontimeout", "2000");
                    break;
                }
                case 3: {
                    properties.setProperty("mail.pop3.ssl.enable", "true");
                }
                case 4: {
                    properties.setProperty("mail.store.protocol", "pop3");
                    properties.setProperty("mail.pop3.host", account.getHost());
                    properties.setProperty("mail.pop3.port", String.valueOf(account.getPort()));
                    properties.setProperty("mail.pop3.connectiontimeout", "2000");
                }
            }
            Session session = Session.getInstance((Properties)properties);
            Store store = null;
            Folder defaultFolder = null;
            Folder inbox = null;
            store = session.getStore();
            store.connect(account.getLogin(), account.getPassword());
            defaultFolder = store.getDefaultFolder();
            inbox = defaultFolder.getFolder("INBOX");
            this.checkEmailsOfFolder(account, inbox);
            this.close(inbox);
            this.close(defaultFolder);
            try {
                if (store != null && store.isConnected()) {
                    store.close();
                }
                break block19;
            }
            catch (MessagingException e) {
                log.error((Object)"Error while closing the store", (Throwable)e);
            }
            break block19;
            catch (Exception e) {
                try {
                    log.error((Object)("Error while getting emails from the mailbox " + account.getLogin() + "@" + account.getHost()), (Throwable)e);
                }
                catch (Throwable throwable) {
                    this.close(inbox);
                    this.close(defaultFolder);
                    try {
                        if (store != null && store.isConnected()) {
                            store.close();
                        }
                    }
                    catch (MessagingException e2) {
                        log.error((Object)"Error while closing the store", (Throwable)e2);
                    }
                    throw throwable;
                }
                this.close(inbox);
                this.close(defaultFolder);
                try {
                    if (store != null && store.isConnected()) {
                        store.close();
                    }
                }
                catch (MessagingException e3) {
                    log.error((Object)"Error while closing the store", (Throwable)e3);
                }
            }
        }
    }

    protected void close(Folder folder) {
        if (folder != null && folder.isOpen()) {
            try {
                boolean expunge = this.config.isMailExpunge();
                folder.close(expunge);
            }
            catch (Exception e) {
                log.error((Object)"Error while closing the folder", (Throwable)e);
            }
        }
    }

    protected void checkEmailsOfFolder(EmailAccount emailAccount, Folder folder) {
        int importedCount = 0;
        try {
            folder.open(2);
            int count = folder.getMessageCount();
            int unread = folder.getUnreadMessageCount();
            if (log.isDebugEnabled()) {
                log.debug((Object)(emailAccount.getLogin() + "@" + emailAccount.getHost() + " : " + count + " messages, " + unread + " unread"));
            }
            for (int i = 0; i < count; ++i) {
                try {
                    Address[] addresses;
                    EmailImpl email = new EmailImpl();
                    email.setFax(emailAccount.isFaxAccountType());
                    int messageNumber = count - i;
                    Message message = folder.getMessage(messageNumber);
                    Charset charset = FaxToMailServiceUtils.getCharset((Part)message);
                    HashSet<String> modifiedProperties = new HashSet<String>();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Message %d/%d : %s", i, count, message.getSubject()));
                    }
                    ArrayList<Address> recipientAddresses = new ArrayList<Address>();
                    Address[] allRecipients = message.getAllRecipients();
                    if (allRecipients != null) {
                        recipientAddresses.addAll(Arrays.asList(allRecipients));
                    }
                    HashSet<String> recipients = new HashSet<String>(Collections2.transform(recipientAddresses, (Function)new /* Unavailable Anonymous Inner Class!! */));
                    Enumeration allHeaders = message.getAllHeaders();
                    String regex = "^.*for<(.*)>.*$";
                    while (allHeaders.hasMoreElements()) {
                        String forRecipient;
                        Header header = (Header)allHeaders.nextElement();
                        if (!"Received".equals(header.getName()) || (forRecipient = StringUtils.removePattern((String)header.getValue(), (String)"\\s")) == null || !forRecipient.matches(regex) || !StringUtils.isNotBlank((CharSequence)(forRecipient = forRecipient.replaceFirst(regex, "$1"))) || !recipients.add(forRecipient)) continue;
                        if (!log.isDebugEnabled()) break;
                        log.debug((Object)("recipient found in \"Received\" header: " + forRecipient));
                        break;
                    }
                    MailFilter filter = null;
                    for (String recipient : recipients) {
                        List filters = this.mailFolderService.getFiltersForRecipient(recipient);
                        if (!CollectionUtils.isNotEmpty((Collection)filters)) continue;
                        MailFilter mailFilter = (MailFilter)filters.get(0);
                        if (filter != null && mailFilter.getPosition() >= filter.getPosition()) continue;
                        filter = mailFilter;
                        email.setRecipient(recipient);
                        modifiedProperties.add("recipient");
                    }
                    if (filter == null) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)" ==> No filter found for this message");
                        if (!log.isTraceEnabled()) continue;
                        for (String recipient : recipients) {
                            log.trace((Object)(" - for recipient " + recipient));
                        }
                        continue;
                    }
                    MailFolder filterFolder = filter.getMailFolder();
                    while (!filterFolder.isUseCurrentLevelCompany() && filterFolder.getParent() != null) {
                        filterFolder = filterFolder.getParent();
                    }
                    String company = filterFolder.getCompany();
                    String brand = null;
                    if ("@groupecreal.com".equals(email.getRecipient().substring(email.getRecipient().lastIndexOf("@")))) {
                        brand = "creal";
                    }
                    if ((addresses = message.getFrom()) != null && addresses.length > 0) {
                        FaxToMailUser personInCharge;
                        String object;
                        String sender = addresses[0].toString();
                        sender = sender.replaceFirst("^.*<(.*)>$", "$1");
                        sender = sender.toLowerCase();
                        Client client = this.clientService.getClientForEmailAddress(sender, (Email)email, company, brand);
                        modifiedProperties.add("sender");
                        if (client != null) {
                            String faxNumber;
                            String contact = sender;
                            if (email.isFax() && StringUtils.isNumeric((CharSequence)(faxNumber = contact.substring(0, contact.indexOf(64)).replaceAll(" ", "")))) {
                                contact = StringUtils.leftPad((String)faxNumber, (int)10, (char)'0');
                            }
                            ArrayList<String> objectItems = new ArrayList<String>();
                            if (StringUtils.isNotEmpty((CharSequence)client.getCaracteristic1())) {
                                objectItems.add(client.getCaracteristic1());
                            }
                            if (StringUtils.isNotEmpty((CharSequence)client.getCaracteristic2())) {
                                objectItems.add(client.getCaracteristic2());
                            }
                            if (StringUtils.isNotEmpty((CharSequence)client.getCaracteristic3())) {
                                objectItems.add(client.getCaracteristic3());
                            }
                            if (StringUtils.isNotEmpty((CharSequence)client.getCode())) {
                                objectItems.add(client.getCode());
                            }
                            if (StringUtils.isNotEmpty((CharSequence)client.getName())) {
                                objectItems.add(client.getName());
                            }
                            objectItems.add(contact);
                            objectItems.add(DateFormat.getDateInstance(2).format(new Date()));
                            object = StringUtils.join(objectItems, (String)" / ");
                            modifiedProperties.add("client");
                        } else {
                            object = I18n.t((String)"faxtomail.email.object.noClient", (Object[])new Object[0]);
                        }
                        email.setObject(object);
                        email.setClient(client);
                        modifiedProperties.add("object");
                        MailFolder mailFolder = null;
                        if (!filter.isFilterFolderPriority() && client != null && (personInCharge = client.getPersonInCharge()) != null) {
                            mailFolder = this.mailFolderService.getFolderForFaxToMailUser(personInCharge);
                        }
                        if (mailFolder == null) {
                            mailFolder = filter.getMailFolder();
                        }
                        email.setMailFolder(mailFolder);
                        modifiedProperties.add("mailFolder");
                        if (client == null && emailAccount.isRejectAllowed()) {
                            Boolean reject = null;
                            String rejectMessage = null;
                            String senderEmail = null;
                            for (MailFolder rejectMailFolder = mailFolder; !(Boolean.FALSE.equals(reject) || rejectMailFolder == null || reject != null && rejectMailFolder.isUseCurrentLevelRejectResponseMessage() && rejectMailFolder.isUseCurrentLevelRejectResponseMailAddress()); rejectMailFolder = rejectMailFolder.getParent()) {
                                if (reject == null) {
                                    reject = rejectMailFolder.getRejectUnknownSender();
                                }
                                if (rejectMessage == null && rejectMailFolder.isUseCurrentLevelRejectResponseMessage()) {
                                    rejectMessage = rejectMailFolder.getRejectResponseMessage();
                                }
                                if (senderEmail != null || !rejectMailFolder.isUseCurrentLevelRejectResponseMailAddress()) continue;
                                senderEmail = rejectMailFolder.getRejectResponseMailAddress();
                            }
                            if (Boolean.TRUE.equals(reject)) {
                                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{senderEmail, rejectMessage})) {
                                    if (!log.isWarnEnabled()) continue;
                                    log.warn((Object)"Can't send reject message due to invalid configuration");
                                    continue;
                                }
                                String recipient = email.getSender();
                                if (email.isFax()) {
                                    recipient = FaxToMailServiceUtils.addFaxDomainToFaxNumber((String)recipient, (MailFolder)mailFolder);
                                }
                                this.emailService.rejectEmail(senderEmail, recipient, I18n.t((String)"faxtomail.email.subject.re", (Object[])new Object[]{message.getSubject()}), rejectMessage);
                                this.deleteMail(message);
                                continue;
                            }
                        }
                    }
                    Date receivedDate = new Date();
                    email.setReceptionDate(receivedDate);
                    modifiedProperties.add("receptionDate");
                    Date now = new Date();
                    Decorator dateDecorator = this.decoratorService.getDecoratorByType(Date.class, "date");
                    String projectRef = I18n.t((String)"faxtomail.email.projectReference.default", (Object[])new Object[]{dateDecorator.toString((Object)now)});
                    email.setProjectReference(projectRef);
                    modifiedProperties.add("projectReference");
                    email.setDemandStatus(DemandStatus.UNTREATED);
                    modifiedProperties.add("demandStatus");
                    OriginalEmail originalEmail = this.emailService.originalEmailFromMessage((MimeMessage)message, charset);
                    email.setOriginalEmail(originalEmail);
                    ArrayList<Object> attachments = new ArrayList<Object>();
                    if (message.isMimeType("multipart/*")) {
                        String htmlContent = this.emailService.decomposeMultipartEmail(attachments, (Part)message);
                        if (htmlContent != null) {
                            Attachment attachment;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Converting html content to pdf : " + message.getSubject()));
                            }
                            if ((attachment = this.emailService.convertHTMLToPdf(attachments, htmlContent, I18n.t((String)"faxtomail.email.content.attachment.htmlFileName", (Object[])new Object[0]))) != null) {
                                String plainTextFileName = I18n.t((String)"faxtomail.email.content.attachment.plainFileName", (Object[])new Object[0]) + ".pdf";
                                for (Attachment attachment2 : attachments) {
                                    if (!plainTextFileName.equals(attachment2.getOriginalFileName())) continue;
                                    attachments.remove(attachment2);
                                    break;
                                }
                                attachments.add(attachment);
                            }
                        }
                    } else if (message.isMimeType("text/*")) {
                        String content = IOUtils.toString((InputStream)message.getInputStream(), (Charset)charset);
                        if (StringUtils.isNotBlank((CharSequence)content)) {
                            Attachment attachment2 = this.emailService.convertTextToPdf(content, I18n.t((String)"faxtomail.email.content.attachment.plainFileName", (Object[])new Object[0]));
                            attachments.add(0, attachment2);
                        }
                    } else {
                        String fileName = message.getFileName();
                        try {
                            fileName = MimeUtility.decodeText((String)fileName);
                        }
                        catch (UnsupportedEncodingException attachment2) {
                            // empty catch block
                        }
                        DataHandler dh = message.getDataHandler();
                        AttachmentImpl attachment3 = new AttachmentImpl();
                        attachment3.setAddedByUser(false);
                        AttachmentFile attachmentFile = this.emailService.getAttachmentFileFromStream(dh.getInputStream());
                        attachmentFile.setFilename(fileName);
                        attachment3.setOriginalFile(attachmentFile);
                        this.emailService.convertIfNecessary((Attachment)attachment3);
                        attachments.add(attachment3);
                    }
                    this.emailService.saveEmail((Email)email, attachments, null, email.getClient() != null ? email.getClient().getCode() : null, null, modifiedProperties.toArray(new String[modifiedProperties.size()]));
                    ++importedCount;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(" ==> Message plac\u00e9 dans le dossier " + email.getMailFolder().getName()));
                    }
                    this.deleteMail(message);
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)"Error while reading the email", (Throwable)e);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"End of emails");
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while reading the emails", (Throwable)e);
        }
        if (importedCount > 0 && log.isInfoEnabled()) {
            log.info((Object)String.format("Imported %d mail for account %s@%s", importedCount, emailAccount.getLogin(), emailAccount.getHost()));
        }
    }

    protected void deleteMail(Message message) throws MessagingException {
        if (this.config.isMailDelete()) {
            message.setFlag(Flags.Flag.DELETED, true);
        }
    }
}

