package com.franciaflex.faxtomail.web.action.admin;

/*
 * #%L
 * FaxToMail :: Web
 * $Id: UserFolderAction.java 156 2014-06-09 15:26:32Z echatellier $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.2/faxtomail-ui-web/src/main/java/com/franciaflex/faxtomail/web/action/admin/UserFolderAction.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.InterceptorRefs;
import org.apache.struts2.convention.annotation.Result;

import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.services.service.ConfigurationService;
import com.franciaflex.faxtomail.services.service.MailFolderService;
import com.franciaflex.faxtomail.web.FaxToMailActionSupport;
import com.google.gson.reflect.TypeToken;

@InterceptorRefs({
    @InterceptorRef("loginInterceptor"),
    @InterceptorRef("faxToMailStack")
})
public class UserFolderAction extends FaxToMailActionSupport {

    private static final Log log = LogFactory.getLog(UserFolderAction.class);

    protected ConfigurationService configurationService;

    protected MailFolderService mailFolderService;

    protected List<MailFolder> mailFolders;

    protected List<FaxToMailUser> users;

    protected Map<String, Collection<MailFolder>> userFolders;

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setMailFolderService(MailFolderService mailFolderService) {
        this.mailFolderService = mailFolderService;
    }

    @Override
    @Action("user-folder-input")
    public String input() throws Exception {
        mailFolders = mailFolderService.getAllMailFolders();
        users = configurationService.getUserManagedUsers(getSession().getAuthenticatedFaxToMailUser());
        
        // build display map
        userFolders = new HashMap<>();
        for (FaxToMailUser user : users) {
            userFolders.put(user.getTopiaId(), CollectionUtils.emptyIfNull(user.getAffectedFolders()));
        }
        return INPUT;
    }

    @Override
    @Action(results = {@Result(type = "redirectAction", params = {"actionName", "user-folder-input"})})
    public String execute() throws Exception {

        configurationService.saveUserFolders(userFolders);
        return SUCCESS;
    }

    public List<MailFolder> getMailFolders() {
        return mailFolders;
    }

    public List<FaxToMailUser> getUsers() {
        return users;
    }

    public Map<String, Collection<MailFolder>> getUserFolders() {
        return userFolders;
    }
    
    public void setUserFoldersJson(String json) {
        Type type = new TypeToken<Map<String, Collection<MailFolder>>>() {}.getType();
        this.userFolders = getGson().fromJson(json, type);
    }
}
