package com.franciaflex.faxtomail.web;

/*
 * #%L
 * FaxToMail :: Web
 * $Id: FaxToMailApplicationListener.java 184 2014-06-10 18:57:47Z kmorin $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.2/faxtomail-ui-web/src/main/java/com/franciaflex/faxtomail/web/FaxToMailApplicationListener.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import com.franciaflex.faxtomail.web.job.EDIManagementJob;
import com.franciaflex.faxtomail.web.job.MailFilterJob;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

import com.franciaflex.faxtomail.FaxToMailApplicationContext;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailTopiaPersistenceContext;
import com.franciaflex.faxtomail.services.FaxToMailServiceContext;
import com.franciaflex.faxtomail.services.service.InitFaxToMailService;

public class FaxToMailApplicationListener implements ServletContextListener {

    private static final Log log = LogFactory.getLog(FaxToMailApplicationListener.class);

    protected FaxToMailApplicationContext applicationContext;

    protected Scheduler scheduler;

    @Override
    public void contextInitialized(ServletContextEvent sce) {

        if (log.isInfoEnabled()) {
            log.info("init FaxToMail web ui");
        }

        log.debug("scheduler launched");

        applicationContext = new FaxToMailApplicationContext();

        applicationContext.init();

        sce.getServletContext().setAttribute(
                FaxToMailApplicationContext.APPLICATION_CONTEXT_PARAMETER,
                applicationContext);

        JobDataMap data = new JobDataMap();

        FaxToMailTopiaPersistenceContext persistenceContext = applicationContext.newPersistenceContext();
        FaxToMailServiceContext serviceContext = applicationContext.newServiceContext(persistenceContext);
        
        serviceContext.newService(InitFaxToMailService.class).init();
        
        data.put(MailFilterJob.SERVICE_CONTEXT, serviceContext);

        JobDetail mailFilteringJob = JobBuilder.newJob(MailFilterJob.class)
                                      .usingJobData(data)
                                      .withIdentity("faxToMailJobs", "mailFilteringJob")
                                      .build();

        JobDetail ediManagementJob = JobBuilder.newJob(EDIManagementJob.class)
                                    .usingJobData(data)
                                    .withIdentity("faxToMailJobs", "ediManagementJob")
                                    .build();

        try {
            
            // schedule mail job (toutes les 5 minutes)
            Trigger trigger = TriggerBuilder
                            .newTrigger()
                            .withIdentity("mailFiltering", "mailFilteringTrigger")
                            .withSchedule(CronScheduleBuilder.cronSchedule("0 0/5 * * * ?"))
                            .build();

            Scheduler scheduler = new StdSchedulerFactory().getScheduler();
            scheduler.start();
            scheduler.scheduleJob(mailFilteringJob, trigger);

            // schedule EDI job (toutes les 5 minutes)
            trigger = TriggerBuilder
                    .newTrigger()
                    .withIdentity("ediManagement", "ediManagementTrigger")
                    .withSchedule(CronScheduleBuilder.cronSchedule("0 0/5 * * * ?"))
                    .build();

            scheduler = new StdSchedulerFactory().getScheduler();
            scheduler.start();
            scheduler.scheduleJob(ediManagementJob, trigger);

            log.debug("schedulers launched");

        } catch (SchedulerException e) {
            log.error("Error while launching the mail filter job", e);
        }

    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {

        if (scheduler != null) {
            if (log.isInfoEnabled()) {
                if (log.isInfoEnabled()) {
                    log.info("Stopping quartz sheduler");
                }
            }
    
            try {
                scheduler.shutdown();
            } catch (SchedulerException e) {
                if (log.isWarnEnabled()) {
                    log.warn("Can't stop quartz", e);
                }
            }
        }

        if (log.isInfoEnabled()) {
            log.info("Closing web ui application context");
        }

        applicationContext.close();

    }

}
