package com.franciaflex.faxtomail.web.action.admin;

/*
 * #%L
 * FaxToMail :: Web
 * $Id: UserFolderAction.java 121 2014-06-02 15:45:55Z echatellier $
 * $HeadURL: https://svn.codelutin.com/faxtomail/trunk/faxtomail-ui-web/src/main/java/com/franciaflex/faxtomail/web/action/admin/UserFolderAction.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.InterceptorRefs;
import org.apache.struts2.convention.annotation.Result;

import com.franciaflex.faxtomail.services.service.LdapService;
import com.franciaflex.faxtomail.web.FaxToMailActionSupport;

@InterceptorRefs({
    @InterceptorRef("loginInterceptor"),
    @InterceptorRef("faxToMailStack")
})
public class LdapAction extends FaxToMailActionSupport {

    private static final Log log = LogFactory.getLog(LdapAction.class);

    protected LdapService ldapService;

    public void setLdapService(LdapService ldapService) {
        this.ldapService = ldapService;
    }

    @Override
    @Action("ldap-input")
    public String input() throws Exception {
        return INPUT;
    }

    @Override
    @Action(results = {@Result(type = "redirectAction", params = {"actionName", "ldap-input"})})
    public String execute() throws Exception {
        ldapService.updateLdapData();
        return SUCCESS;
    }
}
