package com.franciaflex.faxtomail.web.action.admin;

/*
 * #%L
 * FaxToMail :: Web
 * $Id: ImportAction.java 153 2014-06-09 14:38:49Z echatellier $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.1/faxtomail-ui-web/src/main/java/com/franciaflex/faxtomail/web/action/admin/ImportAction.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.InterceptorRefs;
import org.apache.struts2.convention.annotation.Result;

import com.franciaflex.faxtomail.services.service.ReferentielService;
import com.franciaflex.faxtomail.web.FaxToMailActionSupport;

@InterceptorRefs({
    @InterceptorRef("loginInterceptor"),
    @InterceptorRef("faxToMailStack")
})
public class ImportAction extends FaxToMailActionSupport {

    private static final Log log = LogFactory.getLog(ImportAction.class);

    protected ReferentielService referentielService;

    protected File clientFile;
    protected File demandTypeFile;
    protected File rangeFile;
    protected File priorityFile;
    protected File etatAttenteFile;

    public void setReferentielService(ReferentielService referentielService) {
        this.referentielService = referentielService;
    }

    public void setClientFile(File clientFile) {
        this.clientFile = clientFile;
    }

    public void setDemandTypeFile(File demandTypeFile) {
        this.demandTypeFile = demandTypeFile;
    }

    public void setRangeFile(File rangeFile) {
        this.rangeFile = rangeFile;
    }

    public void setPriorityFile(File priorityFile) {
        this.priorityFile = priorityFile;
    }

    public void setEtatAttenteFile(File etatAttenteFile) {
        this.etatAttenteFile = etatAttenteFile;
    }

    @Override
    @Action("import-input")
    public String input() throws Exception {
        return INPUT;
    }

    @Override
    @Action(results = {@Result(type = "redirectAction", params = {"actionName", "import-input"})})
    public String execute() throws Exception {
        String result = super.execute();

        // clientFile
        if (clientFile != null) {
            try (InputStream is = new FileInputStream(clientFile)) {
                referentielService.importClients(is);
            }
        }

        // demandTypeFile
        if (demandTypeFile != null) {
            try (InputStream is = new FileInputStream(demandTypeFile)) {
                referentielService.importDemandTypes(is);
            }
        }

        // rangeFile
        if (rangeFile != null) {
            try (InputStream is = new FileInputStream(rangeFile)) {
                referentielService.importRanges(is);
            }
        }

        // priorityFile
        if (priorityFile != null) {
            try (InputStream is = new FileInputStream(priorityFile)) {
                referentielService.importPriorities(is);
            }
        }

        // etatAttenteFile
        if (etatAttenteFile != null) {
            try (InputStream is = new FileInputStream(etatAttenteFile)) {
                referentielService.importEtatAttentes(is);
            }
        }

        return result;
    }
}
