/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.extra;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.util.List;

public class CustomFocusTraversalPolicy
extends FocusTraversalPolicy {
    protected List<?> order = null;

    public CustomFocusTraversalPolicy(List<?> order) {
        this.order = order;
    }

    @Override
    public Component getFirstComponent(Container focusCycleRoot) {
        if (this.order.size() != 0) {
            return (Component)this.order.get(0);
        }
        return null;
    }

    @Override
    public Component getLastComponent(Container focusCycleRoot) {
        if (this.order.size() > 0) {
            return (Component)this.order.get(this.order.size() - 1);
        }
        return null;
    }

    @Override
    public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
        int index = this.order.indexOf(aComponent);
        if (index != -1) {
            Component nextC = (Component)this.order.get((index + 1) % this.order.size());
            if (nextC.isEnabled()) {
                return nextC;
            }
            return this.getComponentAfter(focusCycleRoot, nextC);
        }
        return null;
    }

    @Override
    public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
        int index = this.order.indexOf(aComponent);
        if (index != -1) {
            Component nextC = (Component)this.order.get((index - 1 + this.order.size()) % this.order.size());
            if (nextC.isEnabled()) {
                return nextC;
            }
            return this.getComponentBefore(focusCycleRoot, nextC);
        }
        return null;
    }

    @Override
    public Component getDefaultComponent(Container focusCycleRoot) {
        if (this.order.size() > 0) {
            return (Component)this.order.get(0);
        }
        return null;
    }
}

