package com.franciaflex.faxtomail.ui.swing.content.pdfeditor;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.ui.swing.util.JImagePanel;
import com.itextpdf.text.pdf.BaseFont;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class PDFEditorStampImageUI extends JImagePanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1Tz08TQRQeFlpowR8IEoxoVr1oQrbqzWAUWmwEqxKqCbEXZ3enZXB2Z5iZhSVE45/gn6B3LybePBkPnj14Mf4LxnjwanyzXboU1uAeJps3733zve997+0PVFASXdjAcezIKNQ0IM7ywtraQ3eDeHqRKE9SoblE3W/AQlYLjfq9uNLoUqthyitpeaXGA8FDEu6rnmugstI7jKh1QrRG5/orPKUqzd71XCwiuYfaI5WH+vrXT+uV//KNhVAsgJ0FrdhHVWWdDDWQRX2NTsFLW7jCcNgBGpKGHeB7zMRqDCv1AAdkE71Aww1UFFgCmEYX/7/lBCOpj4U2MRyIFRwSptGyxwOnLXHoUdxmJHbaONY8wJQ5EXXUNjBxPB5qAHaE3yY+BWBnZbF+J/lrGqilAHfI4yUhkjeKGo1JEvAtUo20hlI0YfqIU7DlbtRklgSIdbZPLBiDk40h02mghQoygrBG063Dk1uFq+7Mpg/MzAAmt3+mJr5++P6+vjeoIXj7dG7qPp+BgEJyQaSm5ukT3SlFmrLKfSzmWqikCAOTJiacySHWTK+BHLw3bsodU+7cxWodIArD3z5+mnr6ZRBZdVRmHPt1bPKXUEmvS1CBMz8Wt+cTRmPbI3CeNNyAS4BjGkTBKt+u8cgYwrp+NQYFZnIU6NFwS59/TzTfze+365l/pmdKFJ6gIg0ZDUli2NSLuQYdFYpEPs88l+dCBD6cqhIc1inTRGIXrnng8iqPUxudNyljJuXAxWRyTudpMqk8zEhix0e8TnXq8SEtIxJHpmzGJKb4fZsgjkAvGhgSg8yD9poNzNrci9QKprAasL+FNmYKDFvkAm9GJAuUXew960iYEGSN7NphxJj9HBJdLn3wFbqxa1eT3+7gdxxPEqxJA6Tuxi/XOIOVqzYWavdm7WuzdoJ8xYCMp5u5ACUgJMuY5HXbt5VH9QtqFhne4ZCMjt/0sca2S0MfNvjWIewBc5YB8S8sfOruywUAAA==";
    private static final Log log = LogFactory.getLog(PDFEditorStampImageUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton removeButton;
    protected PDFEditorStampImageUI stampPanel = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void removeStamp() {
            JPanel container = getParentContainer(JPanel.class);
            container.remove(this);
            container.updateUI();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PDFEditorStampImageUI() {
        $initialize();
    }

    public PDFEditorStampImageUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__removeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        removeStamp();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getRemoveButton() {
        return removeButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToStampPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(removeButton);
    }

    protected void createRemoveButton() {
        $objectMap.put("removeButton", removeButton = new JButton());
        
        removeButton.setName("removeButton");
        removeButton.setText(t(" X "));
        removeButton.setOpaque(false);
        removeButton.setFocusPainted(false);
        removeButton.setContentAreaFilled(false);
        removeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToStampPanel();
        
        // apply 3 property setters
        removeButton.setBackground( null );
        removeButton.setBorder( BorderFactory.createLineBorder(Color.BLACK, 1, false) );
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("stampPanel", stampPanel);
        createRemoveButton();
        // inline creation of stampPanel
        setName("stampPanel");
        setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.TRAILING, 0, 0));
        setScaleImageToFitPanel(true);
        
        $completeSetup();
    }

}