package com.franciaflex.faxtomail.ui.swing.content.demande;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.content.demande.demandgroup.ButtonEmailGroup;
import com.franciaflex.faxtomail.ui.swing.content.demande.demandgroup.DemandGroupHighlightDialog;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.validator.swing.SwingValidatorMessageWidget;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n.t;

public class DemandesUI extends JPanel implements FaxToMailUI<DemandesUIModel, DemandesUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ARCHIVE_BUTTON_ENABLED = "archiveButton.enabled";
    public static final String BINDING_GROUP_BUTTON_ENABLED = "groupButton.enabled";
    public static final String BINDING_PRINT_BUTTON_ENABLED = "printButton.enabled";
    public static final String BINDING_REPLY_BUTTON_ENABLED = "replyButton.enabled";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_TRANSMIT_BUTTON_ENABLED = "transmitButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWz08kRRQuZmGAgQUXVmSR1WF3o5CYGtzExIRVWX65EHAJjIpysXq6Zii2u6u3qhqaEIx/gn+C3r2YePPixoNnD16M/4Ixe/BqfFXdMz3N9AwDEOgO9d773vdeV32vfvgb9UmBZg5JGGIReIq5FG883tt7ah3SilqhsiKYr7hA0U9PDuX20ZDdWJcK3d/f1OGlOLy0zF2fe9Rril7YRAWpThwqDyhVCt1NR1SkLO02zAuhH4g6aoNUFup3L//JfWt/830OodAHdmNQSvGiqKSS3k2UY7ZCY5DpiJQc4tWAhmBeDfje1GvLDpHyE+LS5+hr1L+J8j4RAKbQve5LNhgmPvQVGniwsU086swr9EGFu7gqiFdhpOrQEFdJqLhLmIMDhuUx8MAV7imAxTZ1iWdTvBK95afrvm9A8wr1udymjkJL18Lb0iAJ6HDkIQ1ZhWa4qOFDcHymuB9hhXhjr8yUQ23jo+MGG+EFcCtz7iwRodBt3cowZrARL2vH0Yb/rSjdx4IH/lKgFNBET69QT/SuaRgc4azqAIOrU401MtY/xLvw/VP8GtUk7EbiZpSJpa0KvZauiFhW1AXtP9mS4qH+fyptK1ik8qxe6XgKLlrVfm8k7pIc0cRwL20dUdAl6TLV1mPIh23d3nyTiMoB65BhSFDfOWlvriUfLgve4mBxm7787fR2mTgiDrMJHJstKiWp0c+ZXdNC8X7qNDe84lbt6udnmaEauNTAn2raXk9Y7cCBP7XCiMNrCn1xzX220hYbjpNAr6dKAKnDidQlWtSzj/pEAMsKTe63quMOmCJdnDynixrQWP+bGP/j579+WquL4SuQ+9VM1yYtB5HyBfepUEynHo2UMFDMKW0Rf2EfDUrqwCAwQj+dQWw3NgM5yHdLh2Mdjp8QeQAQff1/vvh14qvfb6DcGio4nNhrRPuvo0F1IKAL3LFD/6NFw2j4eEAT19yAi0tC5gbuDj9e5oEW3dzD+RA6MJ3RgQYNa/C3f8d3f1ysdyEHrO60dU860fclyjPPYR41QyHW+8whMORLGtg80fUspUeg9RNLlHhrzFFUEAvM3LX4Eg9jkV3TLsPa5ZzhkXkutvQkB1KvtOACcrJFo52IY8OoMLuPVrggimltGT5NpPgsDDT0ii455nBO6f0LONxQaLAKX1HpgoBPlTgS3nnuk+dB0wKceGFTsU1AdahdX89K3zQpukjeq2gIO+H++fop1nqKLaNA2CGWHloF2GnQg3V9eFG+Agdcrw4pyFZmftkgzSZIkTeuccWxL+gR44HcrQhKPeiun8k9EfEuuPdTT3cNujF3WjQzG4NQLQdCmIuDLmN2DjO5ajPT3tm54lmnivVI6FRxr3bIpJ0Mk0vRvlunzWQ5HjirkS1F9e1WqvX51InuQN0pi/K5CXcp2lMJ7W09BbM4P2jlbCZmJ8J9xiOLbfO0vRTV6YTq42giZ5F9q5VsPL870e2PfbIIp+f/Vbu7o+8IXXbX3Cc6dtd4ZHa36S5yVapmWndJNZrynagaj0yqTfeiq0qrS0QNdhOaOfXocdEMWHKs8LoHVjk7/04x+n1v7uwyspu+kl3EDcbxcJVXAtkFcpu7XBcp8g454dArNPII4knRYp4Nl68PW7L06GfhQkS9/It+vMhGuHNthDevjTAPCP8DNzKYRIUPAAA=";
    private static final Log log = LogFactory.getLog(DemandesUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton archiveButton;
    protected JButton backButton;
    protected JToolBar bottomToolBar;
    protected ButtonEmailGroup demandGroupButton;
    protected DemandGroupHighlightDialog demandGroupHighlightDialog;
    protected JXTitledPanel demandsPanel;
    protected JTabbedPane demandsTabPane;
    protected JButton groupButton;
    protected final DemandesUIHandler handler = createHandler();
    protected DemandesUIModel model;
    protected JButton printButton;
    protected JButton replyButton;
    protected JButton saveButton;
    protected JToolBar topToolBar;
    protected JButton transmitButton;
    protected SwingValidatorMessageWidget validatorMessageWidget;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private DemandesUI $JPanel0 = this;
    private JPanel $JPanel1;
    private JPanel $JPanel2;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DemandesUI(FaxToMailUI parentUI) {
        FaxToMailUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public DemandesUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandesUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemandesUI() {
        $initialize();
    }

    public DemandesUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemandesUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public DemandesUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemandesUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public DemandesUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__archiveButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.archive();
    }

    public void doActionPerformed__on__backButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.closeFrame();
    }

    public void doActionPerformed__on__groupButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.group();
    }

    public void doActionPerformed__on__printButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.print();
    }

    public void doActionPerformed__on__replyButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.reply();
    }

    public void doActionPerformed__on__saveButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.save();
    }

    public void doActionPerformed__on__transmitButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.transmitDemande();
    }

    public void doAncestorAdded__on__$JPanel0(AncestorEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.showDemandGroupHighlightDialog();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getArchiveButton() {
        return archiveButton;
    }

    public JButton getBackButton() {
        return backButton;
    }

    public JToolBar getBottomToolBar() {
        return bottomToolBar;
    }

    public ButtonEmailGroup getDemandGroupButton() {
        return demandGroupButton;
    }

    public DemandGroupHighlightDialog getDemandGroupHighlightDialog() {
        return demandGroupHighlightDialog;
    }

    public JXTitledPanel getDemandsPanel() {
        return demandsPanel;
    }

    public JTabbedPane getDemandsTabPane() {
        return demandsTabPane;
    }

    public JButton getGroupButton() {
        return groupButton;
    }

    public DemandesUIHandler getHandler() {
        return handler;
    }

    public DemandesUIModel getModel() {
        return model;
    }

    public JButton getPrintButton() {
        return printButton;
    }

    public JButton getReplyButton() {
        return replyButton;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public JToolBar getTopToolBar() {
        return topToolBar;
    }

    public JButton getTransmitButton() {
        return transmitButton;
    }

    public SwingValidatorMessageWidget getValidatorMessageWidget() {
        return validatorMessageWidget;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBottomToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        bottomToolBar.add(validatorMessageWidget);
    }

    protected void addChildrenToDemandsPanel() {
        if (!allComponentsCreated) {
            return;
        }
        demandsPanel.add(topToolBar);
        demandsPanel.add($JPanel1);
    }

    protected void addChildrenToTopToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        topToolBar.add(demandGroupButton);
    }

    protected void createArchiveButton() {
        $objectMap.put("archiveButton", archiveButton = new JButton());
        
        archiveButton.setName("archiveButton");
        archiveButton.setText(t("faxtomail.demande.archive.button.label"));
        archiveButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__archiveButton"));
    }

    protected void createBackButton() {
        $objectMap.put("backButton", backButton = new JButton());
        
        backButton.setName("backButton");
        backButton.setText(t("faxtomail.demande.back.button.label"));
        backButton.setToolTipText(t("faxtomail.action.goto.previousScreen.tip"));
        backButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__backButton"));
    }

    protected void createBottomToolBar() {
        $objectMap.put("bottomToolBar", bottomToolBar = new JToolBar());
        
        bottomToolBar.setName("bottomToolBar");
        bottomToolBar.setLayout( new FlowLayout(FlowLayout.TRAILING, 0, 0) );
        bottomToolBar.setFloatable(false);
        bottomToolBar.setBorderPainted(false);
    }

    protected void createDemandGroupButton() {
        $objectMap.put("demandGroupButton", demandGroupButton = new ButtonEmailGroup());
        
        demandGroupButton.setName("demandGroupButton");
    }

    protected void createDemandGroupHighlightDialog() {
        $objectMap.put("demandGroupHighlightDialog", demandGroupHighlightDialog = new DemandGroupHighlightDialog(getHandler().getContext(), demandGroupButton));
        
        demandGroupHighlightDialog.setName("demandGroupHighlightDialog");
    }

    protected void createDemandsPanel() {
        $objectMap.put("demandsPanel", demandsPanel = new JXTitledPanel());
        
        demandsPanel.setName("demandsPanel");
        demandsPanel.setTitle(t("faxtomail.demand.title"));
    }

    protected void createDemandsTabPane() {
        $objectMap.put("demandsTabPane", demandsTabPane = new JTabbedPane());
        
        demandsTabPane.setName("demandsTabPane");
    }

    protected void createGroupButton() {
        $objectMap.put("groupButton", groupButton = new JButton());
        
        groupButton.setName("groupButton");
        groupButton.setText(t("faxtomail.demande.group.button.label"));
        groupButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__groupButton"));
    }

    protected DemandesUIHandler createHandler() {
        return new DemandesUIHandler();
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(DemandesUIModel.class));
    }

    protected void createPrintButton() {
        $objectMap.put("printButton", printButton = new JButton());
        
        printButton.setName("printButton");
        printButton.setText(t("faxtomail.demande.print.button.label"));
        printButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__printButton"));
    }

    protected void createReplyButton() {
        $objectMap.put("replyButton", replyButton = new JButton());
        
        replyButton.setName("replyButton");
        replyButton.setText(t("faxtomail.demande.reply.button.label"));
        replyButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__replyButton"));
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(t("faxtomail.demande.save.button.label"));
        saveButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveButton"));
    }

    protected void createTopToolBar() {
        $objectMap.put("topToolBar", topToolBar = new JToolBar());
        
        topToolBar.setName("topToolBar");
        topToolBar.setFloatable(false);
        topToolBar.setOpaque(false);
        topToolBar.setBorderPainted(false);
    }

    protected void createTransmitButton() {
        $objectMap.put("transmitButton", transmitButton = new JButton());
        
        transmitButton.setName("transmitButton");
        transmitButton.setText(t("faxtomail.demande.transmit.button.label"));
        transmitButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__transmitButton"));
    }

    protected void createValidatorMessageWidget() {
        $objectMap.put("validatorMessageWidget", validatorMessageWidget = new SwingValidatorMessageWidget());
        
        validatorMessageWidget.setName("validatorMessageWidget");
        validatorMessageWidget.setFocusPainted(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(SwingUtil.boxComponentWithJxLayer(demandsPanel), BorderLayout.CENTER);
        add(bottomToolBar, BorderLayout.SOUTH);
        addChildrenToDemandsPanel();
        addChildrenToTopToolBar();
        // inline complete setup of $JPanel1
        $JPanel1.add(demandsTabPane, BorderLayout.CENTER);
        $JPanel1.add($JPanel2, BorderLayout.SOUTH);
        // inline complete setup of $JPanel2
        $JPanel2.add(backButton);
        $JPanel2.add(saveButton);
        $JPanel2.add(transmitButton);
        $JPanel2.add(printButton);
        $JPanel2.add(archiveButton);
        $JPanel2.add(replyButton);
        $JPanel2.add(groupButton);
        addChildrenToBottomToolBar();
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 13 property setters
        demandsPanel.setRightDecoration(topToolBar);
        backButton.setIcon(SwingUtil.createActionIcon("cancel"));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        transmitButton.setIcon(SwingUtil.createActionIcon("transmit"));
        printButton.setIcon(SwingUtil.createActionIcon("print"));
        archiveButton.setIcon(SwingUtil.createActionIcon("archive"));
        replyButton.setIcon(SwingUtil.createActionIcon("reply"));
        groupButton.setIcon(SwingUtil.createActionIcon("group"));
        bottomToolBar.setMargin(new java.awt.Insets(0, 0, 0, 5));
        // late initializer
        demandGroupHighlightDialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$JPanel0", $JPanel0);
        createModel();
        createDemandsPanel();
        createTopToolBar();
        createDemandGroupButton();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout( new BorderLayout() );
        createDemandsTabPane();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1,0));
        createBackButton();
        createSaveButton();
        createTransmitButton();
        createPrintButton();
        createArchiveButton();
        createReplyButton();
        createGroupButton();
        createBottomToolBar();
        createValidatorMessageWidget();
        createDemandGroupHighlightDialog();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout( new BorderLayout() );
        $JPanel0.addAncestorListener(JAXXUtil.getEventListener(AncestorListener.class, "ancestorAdded", this, "doAncestorAdded__on__$JPanel0"));
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("currentDemand", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getCurrentDemand() != null) {
                    saveButton.setEnabled( model.getCurrentDemand().isEditable() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("currentDemand", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRANSMIT_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("transmitEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    transmitButton.setEnabled( model.isTransmitEnabled() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("transmitEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PRINT_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("printEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    printButton.setEnabled( model.isPrintEnabled() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("printEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ARCHIVE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("archiveEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    archiveButton.setEnabled( model.isArchiveEnabled() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("archiveEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REPLY_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("replyEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    replyButton.setEnabled( model.isReplyEnabled() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("replyEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GROUP_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("groupEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    groupButton.setEnabled( model.isGroupEnabled() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("groupEnabled", this);
                }
            }
        });
    }

}