/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.filter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.filter.DecodeResult;
import org.apache.pdfbox.filter.Filter;
import org.apache.pdfbox.filter.ccitt.CCITTFaxG31DDecodeInputStream;
import org.apache.pdfbox.filter.ccitt.FillOrderChangeInputStream;
import org.apache.pdfbox.filter.ccitt.TIFFFaxDecoder;
import org.apache.pdfbox.io.IOUtils;

final class CCITTFaxFilter
extends Filter {
    private static final Log LOG = LogFactory.getLog(CCITTFaxFilter.class);

    CCITTFaxFilter() {
    }

    @Override
    public DecodeResult decode(InputStream encoded, OutputStream decoded, COSDictionary parameters, int index) throws IOException {
        byte[] decompressed;
        DecodeResult result = new DecodeResult(new COSDictionary());
        result.getParameters().addAll(parameters);
        COSDictionary decodeParms = this.getDecodeParams(parameters, index);
        int cols = decodeParms.getInt(COSName.COLUMNS, 1728);
        int rows = decodeParms.getInt(COSName.ROWS, 0);
        int height = parameters.getInt(COSName.HEIGHT, COSName.H, 0);
        rows = rows > 0 && height > 0 ? Math.min(rows, height) : Math.max(rows, height);
        int k = decodeParms.getInt(COSName.K, 0);
        boolean encodedByteAlign = decodeParms.getBoolean(COSName.ENCODED_BYTE_ALIGN, false);
        int arraySize = (cols + 7) / 8 * rows;
        long tiffOptions = 0L;
        if (k == 0) {
            InputStream in = new CCITTFaxG31DDecodeInputStream(encoded, cols, rows, encodedByteAlign);
            in = new FillOrderChangeInputStream(in);
            decompressed = IOUtils.toByteArray(in);
            in.close();
        } else {
            TIFFFaxDecoder faxDecoder = new TIFFFaxDecoder(1, cols, rows);
            byte[] compressed = IOUtils.toByteArray(encoded);
            decompressed = new byte[arraySize];
            if (k > 0) {
                faxDecoder.decode2D(decompressed, compressed, 0, rows, tiffOptions);
            } else {
                faxDecoder.decodeT6(decompressed, compressed, 0, rows, tiffOptions, encodedByteAlign);
            }
        }
        boolean blackIsOne = decodeParms.getBoolean(COSName.BLACK_IS_1, false);
        if (!blackIsOne) {
            this.invertBitmap(decompressed);
        }
        if (!parameters.containsKey(COSName.COLORSPACE)) {
            result.getParameters().setName(COSName.COLORSPACE, COSName.DEVICEGRAY.getName());
        }
        decoded.write(decompressed);
        return new DecodeResult(parameters);
    }

    private void invertBitmap(byte[] bufferData) {
        int c = bufferData.length;
        for (int i = 0; i < c; ++i) {
            bufferData[i] = (byte)(~bufferData[i] & 0xFF);
        }
    }

    @Override
    protected void encode(InputStream input, OutputStream encoded, COSDictionary parameters) throws IOException {
        LOG.warn((Object)"CCITTFaxDecode.encode is not implemented yet, skipping this stream.");
    }
}

