package com.franciaflex.faxtomail.ui.swing.content.attachment;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.util.AbstractToolbarPopupUI;
import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.HidorButton;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.FileEditor;
import jaxx.runtime.swing.model.JaxxDefaultListModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n.t;

public class AttachmentEditorUI extends AbstractToolbarPopupUI<AttachmentEditorUIModel, AttachmentEditorUIHandler> {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_BUTTON_ENABLED = "addButton.enabled";
    public static final String BINDING_ATTACHMENTS_VISIBLE = "attachments.visible";
    public static final String BINDING_FORM_PANEL_VISIBLE = "formPanel.visible";
    public static final String BINDING_INLINE_ATTACHMENTS_HIDOR_HIDE_TEXT = "inlineAttachmentsHidor.hideText";
    public static final String BINDING_INLINE_ATTACHMENTS_HIDOR_HIDE_TIP = "inlineAttachmentsHidor.hideTip";
    public static final String BINDING_INLINE_ATTACHMENTS_HIDOR_SHOW_TEXT = "inlineAttachmentsHidor.showText";
    public static final String BINDING_INLINE_ATTACHMENTS_HIDOR_SHOW_TIP = "inlineAttachmentsHidor.showTip";
    public static final String BINDING_INLINE_ATTACHMENTS_HIDOR_TEXT = "inlineAttachmentsHidor.text";
    public static final String BINDING_INLINE_ATTACHMENTS_HIDOR_VISIBLE = "inlineAttachmentsHidor.visible";
    public static final String BINDING_MARK_ITEM_AS_LESS_IMPORTANT_MENU_VISIBLE = "markItemAsLessImportantMenu.visible";
    public static final String BINDING_NO_ATTACHMENTS_LABEL_VISIBLE = "noAttachmentsLabel.visible";
    public static final String BINDING_UNMARK_ITEM_AS_LESS_IMPORTANT_MENU_VISIBLE = "unmarkItemAsLessImportantMenu.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAL1YS28bVRS+ceM8mj5Tmhb60CRNhSPSm6iFBQrQJmlCHDltVQdUkUW59lwnt52ZO8wcNxMsED+BnwB7NkjsWCEWrFmwQfwFhFiwRZx7ZzwPe/xoixpFjjXn/Z1zv3Mn3/1Jir5HZp+wIKBe0wFhc7q9+ujR/doTXoe73K97wgXpkfBnpEAKe2TKjJ/7QK7tVZT5UmS+tC5tVzrcSVmvVMhxH44s7h9wDkCuZC3qvr9UjcUrgdv02l7jpPK8fvP3X4Wvza++LRASuJjdNJZiDLJKKhmtkIIwgUxjpGdsyWLOPqbhCWcf8z2pnq1bzPfvMZt/Rr4k4xUy5jIPnQGZG75k7UPbBy6QMwyA1Q9spSuYJfeBbNWlTRsec+qCNSwe0AYLQNpMWLQpqH+I+dC6dABNaGJNV+OvG6bAgB+VXVfHGQNStKXJLSA7/5frHeUv8Z+qwn8g3SYWNqPwCiKf2/rhDneaic0lm3lPy8DtVb/Cfb+MiHnAHFBaQM5nzNUzpapMT8cerjSdPj6U0mtZg9GaNI+AzEpvnz7BmX0K0g1DBHT70a4Ai5sPmJOu7GJS2RoaV+uetCylA+RCJsVEoiwvxA4mEV1HO8XBymKiHiqtN2LlaUcmWPsVVuu20g+V+pXYanx+l9UsvozZZoY9tNCyrMFUql3YiB5wtO2uxXYzwrGEw1MpbgkTESdXc+Jq0VoTQDpZL2e7vChBKas02ZCeHSN0PZv/ifntKsejx3AWlztHLZYoZZpyKCwegzeXFY4qIZD5nDK4nni6iQrh8He4ZaYZFgnkXCaPpHTU9siljG9kOJowXEJBI3uk6DXxMfZyr5sUH6IopMOLHXSoHGrpvzPnfvvxjx822xx4CmOfz1VNUThyk+tJl3sgVOjTIQE2QVhLO8xd2SOTPreQ/zW/X85JrBqJMTmMd1aZU2VOt5h/gC6K47//9PPMp78eI4VNctySzNxkSr9MJuHAQxSkZQbu7Ts6oxOHE/h5RuWGudgsEHbTfigP12VTcW3h5nKACFzOQSBOozb5yz/nqt/faaNQwKxe76meIFH8hIyF46l3QUTzudw/5fq8acqEzvMInigmXOPMwfkB7qkjhbuhJtdkEHHMtlI5oVQ6BHf05908TKZs4ShMquJzHJ65luHwQ0Njzg6B3sXyHF9Ip3TzneVFY3nB+CLQbLilrKOgOZvHHRB4FM8J8AA78G6yNljHaqDYVgxNexAzktUz4YuaOm1vt4xZvZfoPoewFdxMWKG0QEXWuISVADkeRiirPUVOOhJuiMT7FEhp7Qp3V+f5/gvnSUG4eaD1W1rD47cyOK+eqy2N4K2W8bIATvYE7/ZLJNkLvv4bexCAOPlFUEsaiNEnOa2SF12v/+G7tNgPgGR5UW67cJRuy7VUWzrasaF0ozY0EP8bmjEASQeYJer4pSY9E3mYrLSM9DpZ049D0jyidY8z4NpZKCjdWjSi3x7HPedqMQiKY3i+Qt7HZqsbH5A3W0ZF+NGwRU8tWi3f+7Cy8bi6UdlY3y3fv6fKS+CYT5/z3nhMqE3LtMUoeM3cDqYvLoOyn8AccK8c4kADOWgZUJrr09CuOwk9UPcXGnmYW0xaWu5UxUp8ZOLSQlgHGvLwCPEXjaoG8DlCRgP7qsIlrX0r3do8q0yHx4B5++p173zL6EpFO9bQvVS/Ig/PUc3JMKuP2zUVG8zy8e+Ebv0rBDZv4HvcuF/RyY2hGOJodt/qh6DzJNRMmzNxYqJgpR6YJK8GgyIUMHVLMd2mekmZaBnqmp86MNf7tLQhuGVSZZCfQ/ttYogcppTyhqNqMiME8fplCk9fPo9iSQh37uZSHobYXOO87asHnh3b/xi+veBqeMxcF7cPU4JVLQay1zJe7J8FoX+frpqpu0joldbV1Vhlkb1qLAy+amCivS4VySvYEBM3ZrEjicrk1HsmA2bUhGNiIR90OR5Rn1fR43/VD/NSExMAAA==";
    private static final Log log = LogFactory.getLog(AttachmentEditorUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addButton;
    protected JScrollPane attachmentBodyScrollPane;
    protected AttachmentEditorUI attachmentDialog = this;
    protected JXTable attachments;
    protected JPopupMenu attachmentsPopup;
    protected FileEditor file;
    protected JLabel fileLabel;
    protected Table formPanel;
    protected final AttachmentEditorUIHandler handler = createHandler();
    protected JXTable inlineAttachments;
    protected HidorButton inlineAttachmentsHidor;
    protected JPanel mainPanel;
    protected JMenuItem markItemAsLessImportantMenu;
    protected AttachmentEditorUIModel model;
    protected JLabel noAttachmentsLabel;
    protected JMenuItem unmarkItemAsLessImportantMenu;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSeparator $JSeparator0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AttachmentEditorUI(FaxToMailUIContext context, JFrame owner) {
        super(context, owner);
            $initialize();
    }

    public AttachmentEditorUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public AttachmentEditorUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Dialog param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Frame param1, String param2, boolean param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AttachmentEditorUI() {
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public AttachmentEditorUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Frame param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Frame param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AttachmentEditorUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Frame param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AttachmentEditorUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public AttachmentEditorUI(Window param0) {
        super(param0);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Window param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Window param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AttachmentEditorUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Window param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AttachmentEditorUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Window param1, String param2, ModalityType param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AttachmentEditorUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Dialog param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AttachmentEditorUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Dialog param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AttachmentEditorUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public AttachmentEditorUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Dialog param1, String param2, boolean param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__markItemAsLessImportantMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.markItemAsLessImportant();
    }

    public void doActionPerformed__on__unmarkItemAsLessImportantMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.unmarkItemAsLessImportant();
    }

    public void doMouseClicked__on__attachments(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, attachmentsPopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddButton() {
        return addButton;
    }

    public JScrollPane getAttachmentBodyScrollPane() {
        return attachmentBodyScrollPane;
    }

    public JXTable getAttachments() {
        return attachments;
    }

    public JPopupMenu getAttachmentsPopup() {
        return attachmentsPopup;
    }

    public FileEditor getFile() {
        return file;
    }

    public JLabel getFileLabel() {
        return fileLabel;
    }

    public Table getFormPanel() {
        return formPanel;
    }

    public AttachmentEditorUIHandler getHandler() {
        return handler;
    }

    public JXTable getInlineAttachments() {
        return inlineAttachments;
    }

    public HidorButton getInlineAttachmentsHidor() {
        return inlineAttachmentsHidor;
    }

    public JPanel getMainPanel() {
        return mainPanel;
    }

    public JMenuItem getMarkItemAsLessImportantMenu() {
        return markItemAsLessImportantMenu;
    }

    public AttachmentEditorUIModel getModel() {
        return model;
    }

    public JLabel getNoAttachmentsLabel() {
        return noAttachmentsLabel;
    }

    public JMenuItem getUnmarkItemAsLessImportantMenu() {
        return unmarkItemAsLessImportantMenu;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAttachmentBodyScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        attachmentBodyScrollPane.getViewport().add(mainPanel);
    }

    protected void addChildrenToAttachmentsPopup() {
        if (!allComponentsCreated) {
            return;
        }
        attachmentsPopup.add(markItemAsLessImportantMenu);
        attachmentsPopup.add(unmarkItemAsLessImportantMenu);
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(attachmentBodyScrollPane);
    }

    protected void addChildrenToFormPanel() {
        if (!allComponentsCreated) {
            return;
        }
        formPanel.add($JSeparator0, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        formPanel.add(fileLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        formPanel.add(file, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        formPanel.add(addButton, new GridBagConstraints(2, 1, 1, 3, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToMainPanel() {
        if (!allComponentsCreated) {
            return;
        }
        mainPanel.add(noAttachmentsLabel, BorderLayout.NORTH);
        mainPanel.add($Table0, BorderLayout.CENTER);
        mainPanel.add(formPanel, BorderLayout.SOUTH);
    }

    protected void createAddButton() {
        $objectMap.put("addButton", addButton = new JButton());
        
        addButton.setName("addButton");
        addButton.setToolTipText(t("faxtomail.attachmentEditor.action.add.tip"));
        addButton.putClientProperty("applicationAction",  com.franciaflex.faxtomail.ui.swing.content.attachment.actions.AddAttachmentAction.class );
    }

    protected void createAttachmentBodyScrollPane() {
        $objectMap.put("attachmentBodyScrollPane", attachmentBodyScrollPane = new JScrollPane());
        
        attachmentBodyScrollPane.setName("attachmentBodyScrollPane");
    }

    protected void createAttachments() {
        $objectMap.put("attachments", attachments = new JXTable());
        
        attachments.setName("attachments");
        attachments.setEditable(true);
        attachments.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__attachments"));
    }

    protected void createAttachmentsPopup() {
        $objectMap.put("attachmentsPopup", attachmentsPopup = new JPopupMenu());
        
        attachmentsPopup.setName("attachmentsPopup");
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
        body.setTitle(t("faxtomail.attachmentEditor.title"));
    }

    protected void createFile() {
        $objectMap.put("file", file = new FileEditor());
        
        file.setName("file");
        file.setFileEnabled(true);
        file.setDirectoryEnabled(false);
    }

    protected void createFileLabel() {
        $objectMap.put("fileLabel", fileLabel = new JLabel());
        
        fileLabel.setName("fileLabel");
        fileLabel.setText(t("faxtomail.attachmentEditor.field.file"));
    }

    protected void createFormPanel() {
        $objectMap.put("formPanel", formPanel = new Table());
        
        formPanel.setName("formPanel");
    }

    protected AttachmentEditorUIHandler createHandler() {
        return new AttachmentEditorUIHandler();
    }

    protected void createInlineAttachments() {
        $objectMap.put("inlineAttachments", inlineAttachments = new JXTable());
        
        inlineAttachments.setName("inlineAttachments");
        inlineAttachments.setVisible(false);
        inlineAttachments.setEditable(true);
    }

    protected void createInlineAttachmentsHidor() {
        $objectMap.put("inlineAttachmentsHidor", inlineAttachmentsHidor = new HidorButton());
        
        inlineAttachmentsHidor.setName("inlineAttachmentsHidor");
        inlineAttachmentsHidor.setTargetVisible(false);
    }

    protected void createMainPanel() {
        $objectMap.put("mainPanel", mainPanel = new JPanel());
        
        mainPanel.setName("mainPanel");
        mainPanel.setLayout(new BorderLayout());
    }

    protected void createMarkItemAsLessImportantMenu() {
        $objectMap.put("markItemAsLessImportantMenu", markItemAsLessImportantMenu = new JMenuItem());
        
        markItemAsLessImportantMenu.setName("markItemAsLessImportantMenu");
        markItemAsLessImportantMenu.setText(t("faxtomail.attachmentEditor.action.markItemAsLessImportant"));
        markItemAsLessImportantMenu.setToolTipText(t("faxtomail.attachmentEditor.action.markItemAsLessImportant.tip"));
        markItemAsLessImportantMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__markItemAsLessImportantMenu"));
    }

    protected void createModel() {
        $objectMap.put("model", model = new AttachmentEditorUIModel());
    }

    protected void createNoAttachmentsLabel() {
        $objectMap.put("noAttachmentsLabel", noAttachmentsLabel = new JLabel());
        
        noAttachmentsLabel.setName("noAttachmentsLabel");
        noAttachmentsLabel.setText(t("faxtomail.attachmentEditor.attachments.empty"));
        if (noAttachmentsLabel.getFont() != null) {
            noAttachmentsLabel.setFont(noAttachmentsLabel.getFont().deriveFont(noAttachmentsLabel.getFont().getStyle() | Font.ITALIC));
        }
    }

    protected void createUnmarkItemAsLessImportantMenu() {
        $objectMap.put("unmarkItemAsLessImportantMenu", unmarkItemAsLessImportantMenu = new JMenuItem());
        
        unmarkItemAsLessImportantMenu.setName("unmarkItemAsLessImportantMenu");
        unmarkItemAsLessImportantMenu.setText(t("faxtomail.attachmentEditor.action.unmarkItemAsLessImportant"));
        unmarkItemAsLessImportantMenu.setToolTipText(t("faxtomail.attachmentEditor.action.unmarkItemAsLessImportant.tip"));
        unmarkItemAsLessImportantMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__unmarkItemAsLessImportantMenu"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToAttachmentsPopup();
        addChildrenToBody();
        addChildrenToAttachmentBodyScrollPane();
        addChildrenToMainPanel();
        // inline complete setup of $Table0
        $Table0.add(attachments, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(inlineAttachmentsHidor, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(inlineAttachments, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToFormPanel();
        
        // apply 12 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        setMinimumSize( new java.awt.Dimension(250, 0) );
        markItemAsLessImportantMenu.setIcon(SwingUtil.createActionIcon("not-important"));
        unmarkItemAsLessImportantMenu.setIcon(SwingUtil.createActionIcon("important"));
        noAttachmentsLabel.setBorder( javax.swing.BorderFactory.createEmptyBorder(3, 3, 3, 3) );
        attachments.setSelectionMode( ListSelectionModel.SINGLE_SELECTION );
        inlineAttachmentsHidor.setTarget( inlineAttachments );
        inlineAttachments.setSelectionMode( ListSelectionModel.SINGLE_SELECTION );
        fileLabel.setLabelFor( file );
        addButton.setIcon(SwingUtil.createActionIcon("add"));
        // late initializer
        attachmentDialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("attachmentDialog", attachmentDialog);
        createModel();
        createAttachmentsPopup();
        createMarkItemAsLessImportantMenu();
        createUnmarkItemAsLessImportantMenu();
        createAttachmentBodyScrollPane();
        createMainPanel();
        createNoAttachmentsLabel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createAttachments();
        createInlineAttachmentsHidor();
        createInlineAttachments();
        createFormPanel();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createFileLabel();
        createFile();
        createAddButton();
        // inline creation of attachmentDialog
        setName("attachmentDialog");
        
        // registers 12 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 12 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MARK_ITEM_AS_LESS_IMPORTANT_MENU_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedAttachment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getSelectedAttachment() != null) {
                    markItemAsLessImportantMenu.setVisible( !model.getSelectedAttachment().isLessImportant() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedAttachment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_UNMARK_ITEM_AS_LESS_IMPORTANT_MENU_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedAttachment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getSelectedAttachment() != null) {
                    unmarkItemAsLessImportantMenu.setVisible( model.getSelectedAttachment().isLessImportant() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedAttachment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NO_ATTACHMENTS_LABEL_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("attachment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getAttachment() != null) {
                    noAttachmentsLabel.setVisible( model.getAttachment().isEmpty() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("attachment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ATTACHMENTS_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("attachment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getAttachment() != null) {
                    attachments.setVisible( !model.getAttachment().isEmpty() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("attachment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INLINE_ATTACHMENTS_HIDOR_SHOW_TIP, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("inlineAttachments", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getInlineAttachments() != null) {
                    inlineAttachmentsHidor.setShowTip( t("faxtomail.attachmentEditor.inlineAttachments.hidor.showTip", model.getInlineAttachments().size()) );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("inlineAttachments", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INLINE_ATTACHMENTS_HIDOR_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("inlineAttachments", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getInlineAttachments() != null) {
                    inlineAttachmentsHidor.setText(t( t("faxtomail.attachmentEditor.inlineAttachments.hidor.text", model.getInlineAttachments().size()) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("inlineAttachments", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INLINE_ATTACHMENTS_HIDOR_HIDE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("inlineAttachments", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getInlineAttachments() != null) {
                    inlineAttachmentsHidor.setHideText( t("faxtomail.attachmentEditor.inlineAttachments.hidor.text", model.getInlineAttachments().size()) );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("inlineAttachments", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INLINE_ATTACHMENTS_HIDOR_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("inlineAttachments", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getInlineAttachments() != null) {
                    inlineAttachmentsHidor.setVisible( !model.getInlineAttachments().isEmpty() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("inlineAttachments", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INLINE_ATTACHMENTS_HIDOR_HIDE_TIP, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("inlineAttachments", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getInlineAttachments() != null) {
                    inlineAttachmentsHidor.setHideTip( t("faxtomail.attachmentEditor.inlineAttachments.hidor.hideTip", model.getInlineAttachments().size()) );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("inlineAttachments", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INLINE_ATTACHMENTS_HIDOR_SHOW_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("inlineAttachments", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getInlineAttachments() != null) {
                    inlineAttachmentsHidor.setShowText( t("faxtomail.attachmentEditor.inlineAttachments.hidor.text", model.getInlineAttachments().size()) );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("inlineAttachments", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FORM_PANEL_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("editable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    formPanel.setVisible( model.isEditable() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("editable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("editable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    addButton.setEnabled( model.isEditable() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("editable", this);
                }
            }
        });
    }

}