package com.franciaflex.faxtomail.ui.swing.content.reply;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.Stamp;
import com.franciaflex.faxtomail.services.service.ldap.Contact;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class ReplyFormUI extends JPanel implements FaxToMailUI<ReplyFormUIModel, ReplyFormUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_ATTACHMENT_BUTTON_ENABLED = "addAttachmentButton.enabled";
    public static final String BINDING_ADD_ATTACHMENT_FORM_VISIBLE = "addAttachmentForm.visible";
    public static final String BINDING_ADD_CCI_BUTTON_ENABLED = "addCciButton.enabled";
    public static final String BINDING_ADD_CCI_BUTTON_VISIBLE = "addCciButton.visible";
    public static final String BINDING_ADD_CC_BUTTON_ENABLED = "addCcButton.enabled";
    public static final String BINDING_ADD_CC_BUTTON_VISIBLE = "addCcButton.visible";
    public static final String BINDING_ADD_TO_BUTTON_ENABLED = "addToButton.enabled";
    public static final String BINDING_ADD_TO_BUTTON_VISIBLE = "addToButton.visible";
    public static final String BINDING_ATTACHMENTS_LABEL_FOREGROUND = "attachmentsLabel.foreground";
    public static final String BINDING_ATTACHMENTS_LABEL_TEXT = "attachmentsLabel.text";
    public static final String BINDING_BUTTON_PANEL_LAYOUT_SELECTED = "buttonPanelLayout.selected";
    public static final String BINDING_CCI_FIELD_EDITABLE = "cciField.editable";
    public static final String BINDING_CCI_FIELD_TEXT = "cciField.text";
    public static final String BINDING_CC_FIELD_EDITABLE = "ccField.editable";
    public static final String BINDING_CC_FIELD_TEXT = "ccField.text";
    public static final String BINDING_CONTACT_FIELD_SELECTED_ITEM = "contactField.selectedItem";
    public static final String BINDING_CONTACT_FIELD_VISIBLE = "contactField.visible";
    public static final String BINDING_CONTACT_LABEL_VISIBLE = "contactLabel.visible";
    public static final String BINDING_FORWARD_BUTTON_VISIBLE = "forwardButton.visible";
    public static final String BINDING_FROM_COMBO_BOX_SELECTED_ITEM = "fromComboBox.selectedItem";
    public static final String BINDING_FROM_FIELD_TEXT = "fromField.text";
    public static final String BINDING_FROM_PANEL_LAYOUT_SELECTED = "fromPanelLayout.selected";
    public static final String BINDING_MESSAGE_EDITABLE = "message.editable";
    public static final String BINDING_MESSAGE_TEXT = "message.text";
    public static final String BINDING_SIGNING_PANEL_VISIBLE = "signingPanel.visible";
    public static final String BINDING_SIGNING_SCROLL_PANEL_VISIBLE = "signingScrollPanel.visible";
    public static final String BINDING_SIGNING_SPLIT_PANE_DIVIDER_SIZE = "signingSplitPane.dividerSize";
    public static final String BINDING_SIGNING_SPLIT_PANE_NAME = "signingSplitPane.name";
    public static final String BINDING_SIGNING_TEXT_PANEL_TEXT = "signingTextPanel.text";
    public static final String BINDING_STAMP_COMBO_BOX_SELECTED_ITEM = "stampComboBox.selectedItem";
    public static final String BINDING_SUBJECT_FIELD_EDITABLE = "subjectField.editable";
    public static final String BINDING_SUBJECT_FIELD_TEXT = "subjectField.text";
    public static final String BINDING_TO_FIELD_EDITABLE = "toField.editable";
    public static final String BINDING_TO_FIELD_TEXT = "toField.text";
    public static final String BINDING_VALIDATE_BUTTON_ENABLED = "validateButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(ReplyFormUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addAttachmentButton;
    protected JComboBox addAttachmentFile;
    protected Table addAttachmentForm;
    protected JLabel addAttachmentLabel;
    protected JButton addCcButton;
    protected JButton addCciButton;
    protected JButton addToButton;
    protected JScrollPane attachmentsContainer;
    protected JLabel attachmentsLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "totalAttachmentLength",  editorName = "attachmentsPanel")
    protected JPanel attachmentsPanel;
    protected JPanel buttonPanel;
    protected CardLayout2Ext buttonPanelLayout;
    protected JButton cancelButton;
    protected JTextField ccField;
    protected JLabel ccLabel;
    protected JTextField cciField;
    protected JLabel cciLabel;
    protected JButton chooseFileButton;
    protected JButton closeButton;
    protected JButton configureSigningButton;
    protected BeanFilterableComboBox<Contact> contactField;
    protected JLabel contactLabel;
    protected JButton forwardButton;
    @ValidatorField( validatorId = "validator",  propertyName = "from",  editorName = "fromComboBox")
    protected JComboBox fromComboBox;
    protected JTextField fromField;
    protected JLabel fromLabel;
    protected JPanel fromPanel;
    protected CardLayout2Ext fromPanelLayout;
    protected final ReplyFormUIHandler handler = createHandler();
    protected JTextPane message;
    protected JSplitPane messageSplitPane;
    protected ReplyFormUIModel model;
    protected ReplyFormUI replyPanel = this;
    protected JLabel signingLabel;
    protected JPanel signingPanel;
    protected JScrollPane signingScrollPanel;
    protected JSplitPane signingSplitPane;
    protected JTextPane signingTextPanel;
    protected BeanComboBox<Stamp> stampComboBox;
    @ValidatorField( validatorId = "validator",  propertyName = "subject",  editorName = "subjectField")
    protected JTextField subjectField;
    protected JLabel subjectLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "to",  editorName = "toField")
    protected JTextField toField;
    protected JLabel toLabel;
    protected JButton validateButton;
    @Validator( validatorId = "validator")
    protected SwingValidator<ReplyFormUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JPanel $JPanel3;
    private JScrollPane $JScrollPane0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ReplyFormUI(FaxToMailUI parentUI) {
        FaxToMailUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public ReplyFormUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplyFormUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ReplyFormUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public ReplyFormUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ReplyFormUI() {
        $initialize();
    }

    public ReplyFormUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ReplyFormUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ReplyFormUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addAttachmentButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addAttachment();
    }

    public void doActionPerformed__on__addCcButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addCc();
    }

    public void doActionPerformed__on__addCciButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addCci();
    }

    public void doActionPerformed__on__addToButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addTo();
    }

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__chooseFileButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openLocation();
    }

    public void doActionPerformed__on__closeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__forwardButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.forward();
    }

    public void doItemStateChanged__on__fromComboBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "from");
    }

    public void doKeyReleased__on__ccField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "cc");
    }

    public void doKeyReleased__on__cciField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "cci");
    }

    public void doKeyReleased__on__message(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "message");
    }

    public void doKeyReleased__on__subjectField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "subject");
    }

    public void doKeyReleased__on__toField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "to");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddAttachmentButton() {
        return addAttachmentButton;
    }

    public JComboBox getAddAttachmentFile() {
        return addAttachmentFile;
    }

    public Table getAddAttachmentForm() {
        return addAttachmentForm;
    }

    public JLabel getAddAttachmentLabel() {
        return addAttachmentLabel;
    }

    public JButton getAddCcButton() {
        return addCcButton;
    }

    public JButton getAddCciButton() {
        return addCciButton;
    }

    public JButton getAddToButton() {
        return addToButton;
    }

    public JScrollPane getAttachmentsContainer() {
        return attachmentsContainer;
    }

    public JLabel getAttachmentsLabel() {
        return attachmentsLabel;
    }

    public JPanel getAttachmentsPanel() {
        return attachmentsPanel;
    }

    public JPanel getButtonPanel() {
        return buttonPanel;
    }

    public CardLayout2Ext getButtonPanelLayout() {
        return buttonPanelLayout;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JTextField getCcField() {
        return ccField;
    }

    public JLabel getCcLabel() {
        return ccLabel;
    }

    public JTextField getCciField() {
        return cciField;
    }

    public JLabel getCciLabel() {
        return cciLabel;
    }

    public JButton getChooseFileButton() {
        return chooseFileButton;
    }

    public JButton getCloseButton() {
        return closeButton;
    }

    public JButton getConfigureSigningButton() {
        return configureSigningButton;
    }

    public BeanFilterableComboBox<Contact> getContactField() {
        return contactField;
    }

    public JLabel getContactLabel() {
        return contactLabel;
    }

    public JButton getForwardButton() {
        return forwardButton;
    }

    public JComboBox getFromComboBox() {
        return fromComboBox;
    }

    public JTextField getFromField() {
        return fromField;
    }

    public JLabel getFromLabel() {
        return fromLabel;
    }

    public JPanel getFromPanel() {
        return fromPanel;
    }

    public CardLayout2Ext getFromPanelLayout() {
        return fromPanelLayout;
    }

    public ReplyFormUIHandler getHandler() {
        return handler;
    }

    public JTextPane getMessage() {
        return message;
    }

    public JSplitPane getMessageSplitPane() {
        return messageSplitPane;
    }

    public ReplyFormUIModel getModel() {
        return model;
    }

    public JLabel getSigningLabel() {
        return signingLabel;
    }

    public JPanel getSigningPanel() {
        return signingPanel;
    }

    public JScrollPane getSigningScrollPanel() {
        return signingScrollPanel;
    }

    public JSplitPane getSigningSplitPane() {
        return signingSplitPane;
    }

    public JTextPane getSigningTextPanel() {
        return signingTextPanel;
    }

    public BeanComboBox<Stamp> getStampComboBox() {
        return stampComboBox;
    }

    public JTextField getSubjectField() {
        return subjectField;
    }

    public JLabel getSubjectLabel() {
        return subjectLabel;
    }

    public JTextField getToField() {
        return toField;
    }

    public JLabel getToLabel() {
        return toLabel;
    }

    public JButton getValidateButton() {
        return validateButton;
    }

    public SwingValidator<ReplyFormUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JPanel get$JPanel3() {
        return $JPanel3;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAddAttachmentForm() {
        if (!allComponentsCreated) {
            return;
        }
        addAttachmentForm.add(addAttachmentLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addAttachmentForm.add(addAttachmentFile, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addAttachmentForm.add(chooseFileButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addAttachmentForm.add(addAttachmentButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToAttachmentsContainer() {
        if (!allComponentsCreated) {
            return;
        }
        attachmentsContainer.getViewport().add(SwingUtil.boxComponentWithJxLayer(attachmentsPanel));
    }

    protected void addChildrenToButtonPanel() {
        if (!allComponentsCreated) {
            return;
        }
        buttonPanel.add($JPanel2, "true");
        buttonPanel.add($JPanel3, "false");
    }

    protected void addChildrenToFromPanel() {
        if (!allComponentsCreated) {
            return;
        }
        fromPanel.add(fromField, "true");
        fromPanel.add(SwingUtil.boxComponentWithJxLayer(fromComboBox), "false");
    }

    protected void addChildrenToMessageSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        messageSplitPane.add(signingSplitPane, JSplitPane.LEFT);
        messageSplitPane.add($JPanel1, JSplitPane.RIGHT);
    }

    protected void addChildrenToReplyPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.NORTH);
        add(messageSplitPane, BorderLayout.CENTER);
        add(buttonPanel, BorderLayout.SOUTH);
    }

    protected void addChildrenToSigningPanel() {
        if (!allComponentsCreated) {
            return;
        }
        signingPanel.add($JPanel0, BorderLayout.NORTH);
        signingPanel.add(signingScrollPanel, BorderLayout.CENTER);
    }

    protected void addChildrenToSigningScrollPanel() {
        if (!allComponentsCreated) {
            return;
        }
        signingScrollPanel.getViewport().add(signingTextPanel);
    }

    protected void addChildrenToSigningSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        signingSplitPane.add($JScrollPane0, JSplitPane.LEFT);
        signingSplitPane.add(signingPanel, JSplitPane.RIGHT);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAddAttachmentButton() {
        $objectMap.put("addAttachmentButton", addAttachmentButton = new JButton());
        
        addAttachmentButton.setName("addAttachmentButton");
        addAttachmentButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addAttachmentButton"));
    }

    protected void createAddAttachmentFile() {
        $objectMap.put("addAttachmentFile", addAttachmentFile = new JComboBox());
        
        addAttachmentFile.setName("addAttachmentFile");
        addAttachmentFile.setEditable(true);
    }

    protected void createAddAttachmentForm() {
        $objectMap.put("addAttachmentForm", addAttachmentForm = new Table());
        
        addAttachmentForm.setName("addAttachmentForm");
    }

    protected void createAddAttachmentLabel() {
        $objectMap.put("addAttachmentLabel", addAttachmentLabel = new JLabel());
        
        addAttachmentLabel.setName("addAttachmentLabel");
        addAttachmentLabel.setText(t("faxtomail.reply.attachments.add.label"));
    }

    protected void createAddCcButton() {
        $objectMap.put("addCcButton", addCcButton = new JButton());
        
        addCcButton.setName("addCcButton");
        addCcButton.setText(t("faxtomail.reply.action.addCc"));
        addCcButton.setToolTipText(t("faxtomail.reply.action.addCc.tip"));
        addCcButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addCcButton"));
    }

    protected void createAddCciButton() {
        $objectMap.put("addCciButton", addCciButton = new JButton());
        
        addCciButton.setName("addCciButton");
        addCciButton.setText(t("faxtomail.reply.action.addCci"));
        addCciButton.setToolTipText(t("faxtomail.reply.action.addCci.tip"));
        addCciButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addCciButton"));
    }

    protected void createAddToButton() {
        $objectMap.put("addToButton", addToButton = new JButton());
        
        addToButton.setName("addToButton");
        addToButton.setText(t("faxtomail.reply.action.addTo"));
        addToButton.setToolTipText(t("faxtomail.reply.action.addTo.tip"));
        addToButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addToButton"));
    }

    protected void createAttachmentsContainer() {
        $objectMap.put("attachmentsContainer", attachmentsContainer = new JScrollPane());
        
        attachmentsContainer.setName("attachmentsContainer");
    }

    protected void createAttachmentsLabel() {
        $objectMap.put("attachmentsLabel", attachmentsLabel = new JLabel());
        
        attachmentsLabel.setName("attachmentsLabel");
    }

    protected void createAttachmentsPanel() {
        $objectMap.put("attachmentsPanel", attachmentsPanel = new JPanel());
        
        attachmentsPanel.setName("attachmentsPanel");
        attachmentsPanel.setLayout(new FlowLayout(FlowLayout.LEADING));
    }

    protected void createButtonPanel() {
        $objectMap.put("buttonPanel", buttonPanel = new JPanel());
        
        buttonPanel.setName("buttonPanel");
        buttonPanel.setLayout( buttonPanelLayout );
    }

    protected void createButtonPanelLayout() {
        $objectMap.put("buttonPanelLayout", buttonPanelLayout = new CardLayout2Ext(this, "buttonPanel"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("faxtomail.reply.action.cancel"));
        cancelButton.setToolTipText(t("faxtomail.reply.action.cancel.tip"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createCcField() {
        $objectMap.put("ccField", ccField = new JTextField());
        
        ccField.setName("ccField");
        ccField.setColumns(15);
        ccField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__ccField"));
    }

    protected void createCcLabel() {
        $objectMap.put("ccLabel", ccLabel = new JLabel());
        
        ccLabel.setName("ccLabel");
        ccLabel.setText(t("faxtomail.reply.label.cc"));
    }

    protected void createCciField() {
        $objectMap.put("cciField", cciField = new JTextField());
        
        cciField.setName("cciField");
        cciField.setColumns(15);
        cciField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__cciField"));
    }

    protected void createCciLabel() {
        $objectMap.put("cciLabel", cciLabel = new JLabel());
        
        cciLabel.setName("cciLabel");
        cciLabel.setText(t("faxtomail.reply.label.cci"));
    }

    protected void createChooseFileButton() {
        $objectMap.put("chooseFileButton", chooseFileButton = new JButton());
        
        chooseFileButton.setName("chooseFileButton");
        chooseFileButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__chooseFileButton"));
    }

    protected void createCloseButton() {
        $objectMap.put("closeButton", closeButton = new JButton());
        
        closeButton.setName("closeButton");
        closeButton.setText(t("faxtomail.reply.action.close"));
        closeButton.setToolTipText(t("faxtomail.reply.action.close.tip"));
        closeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__closeButton"));
    }

    protected void createConfigureSigningButton() {
        $objectMap.put("configureSigningButton", configureSigningButton = new JButton());
        
        configureSigningButton.setName("configureSigningButton");
        configureSigningButton.setToolTipText(t("faxtomail.reply.action.signing.configure.tip"));
        configureSigningButton.putClientProperty("applicationAction",  com.franciaflex.faxtomail.ui.swing.content.reply.actions.OpenSigningSettingsAction.class );
    }

    protected void createContactField() {
        $objectMap.put("contactField", contactField = new BeanFilterableComboBox<Contact>(this));
        
        contactField.setName("contactField");
        contactField.setMaximumRowCount(20);
        contactField.setShowDecorator(false);
        contactField.setProperty("contact");
        contactField.setShowReset(true);
    }

    protected void createContactLabel() {
        $objectMap.put("contactLabel", contactLabel = new JLabel());
        
        contactLabel.setName("contactLabel");
        contactLabel.setText(t("faxtomail.reply.label.contact"));
    }

    protected void createForwardButton() {
        $objectMap.put("forwardButton", forwardButton = new JButton());
        
        forwardButton.setName("forwardButton");
        forwardButton.setText(t("faxtomail.reply.action.forward"));
        forwardButton.setToolTipText(t("faxtomail.reply.action.forward.tip"));
        forwardButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__forwardButton"));
    }

    protected void createFromComboBox() {
        $objectMap.put("fromComboBox", fromComboBox = new JComboBox());
        
        fromComboBox.setName("fromComboBox");
        fromComboBox.setEditable(true);
        fromComboBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fromComboBox"));
    }

    protected void createFromField() {
        $objectMap.put("fromField", fromField = new JTextField());
        
        fromField.setName("fromField");
        fromField.setColumns(15);
        fromField.setEditable(false);
    }

    protected void createFromLabel() {
        $objectMap.put("fromLabel", fromLabel = new JLabel());
        
        fromLabel.setName("fromLabel");
        fromLabel.setText(t("faxtomail.reply.label.from"));
    }

    protected void createFromPanel() {
        $objectMap.put("fromPanel", fromPanel = new JPanel());
        
        fromPanel.setName("fromPanel");
        fromPanel.setLayout( fromPanelLayout );
    }

    protected void createFromPanelLayout() {
        $objectMap.put("fromPanelLayout", fromPanelLayout = new CardLayout2Ext(this, "fromPanel"));
    }

    protected ReplyFormUIHandler createHandler() {
        return new ReplyFormUIHandler();
    }

    protected void createMessage() {
        $objectMap.put("message", message = new JTextPane());
        
        message.setName("message");
        message.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__message"));
    }

    protected void createMessageSplitPane() {
        $objectMap.put("messageSplitPane", messageSplitPane = new JSplitPane());
        
        messageSplitPane.setName("messageSplitPane");
        messageSplitPane.setDividerLocation(270);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(ReplyFormUIModel.class));
    }

    protected void createSigningLabel() {
        $objectMap.put("signingLabel", signingLabel = new JLabel());
        
        signingLabel.setName("signingLabel");
        signingLabel.setText(t("faxtomail.reply.label.signing"));
    }

    protected void createSigningPanel() {
        $objectMap.put("signingPanel", signingPanel = new JPanel());
        
        signingPanel.setName("signingPanel");
        signingPanel.setLayout(new BorderLayout());
    }

    protected void createSigningScrollPanel() {
        $objectMap.put("signingScrollPanel", signingScrollPanel = new JScrollPane());
        
        signingScrollPanel.setName("signingScrollPanel");
    }

    protected void createSigningSplitPane() {
        $objectMap.put("signingSplitPane", signingSplitPane = new JSplitPane());
        
        signingSplitPane.setName("signingSplitPane");
        signingSplitPane.setResizeWeight(1.0);
    }

    protected void createSigningTextPanel() {
        $objectMap.put("signingTextPanel", signingTextPanel = new JTextPane());
        
        signingTextPanel.setName("signingTextPanel");
        signingTextPanel.setEditable(false);
    }

    protected void createStampComboBox() {
        $objectMap.put("stampComboBox", stampComboBox = new BeanComboBox<Stamp>(this));
        
        stampComboBox.setName("stampComboBox");
        stampComboBox.setMaximumRowCount(20);
        stampComboBox.setShowDecorator(false);
        stampComboBox.setProperty("stamp");
        stampComboBox.setShowReset(true);
    }

    protected void createSubjectField() {
        $objectMap.put("subjectField", subjectField = new JTextField());
        
        subjectField.setName("subjectField");
        subjectField.setColumns(15);
        subjectField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__subjectField"));
    }

    protected void createSubjectLabel() {
        $objectMap.put("subjectLabel", subjectLabel = new JLabel());
        
        subjectLabel.setName("subjectLabel");
        subjectLabel.setText(t("faxtomail.reply.label.subject"));
    }

    protected void createToField() {
        $objectMap.put("toField", toField = new JTextField());
        
        toField.setName("toField");
        toField.setColumns(15);
        toField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__toField"));
    }

    protected void createToLabel() {
        $objectMap.put("toLabel", toLabel = new JLabel());
        
        toLabel.setName("toLabel");
        toLabel.setText(t("faxtomail.reply.label.to"));
    }

    protected void createValidateButton() {
        $objectMap.put("validateButton", validateButton = new JButton());
        
        validateButton.setName("validateButton");
        validateButton.setText(t("faxtomail.reply.action.validate"));
        validateButton.setToolTipText(t("faxtomail.reply.action.validate.tip"));
        validateButton.putClientProperty("applicationAction",  com.franciaflex.faxtomail.ui.swing.content.reply.actions.ReplyAction.class );
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(ReplyFormUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToReplyPanel();
        addChildrenToValidator();
        // inline complete setup of $Table0
        $Table0.add(fromLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(fromPanel, new GridBagConstraints(1, 0, 4, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(contactLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(contactField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(addToButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(addCcButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(addCciButton, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(toLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(toField), new GridBagConstraints(1, 2, 4, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(ccLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(ccField, new GridBagConstraints(1, 3, 4, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(cciLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(cciField, new GridBagConstraints(1, 4, 4, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(subjectLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(subjectField), new GridBagConstraints(1, 5, 4, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToFromPanel();
        addChildrenToMessageSplitPane();
        addChildrenToSigningSplitPane();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(message);
        addChildrenToSigningPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(signingLabel, BorderLayout.WEST);
        $JPanel0.add(stampComboBox, BorderLayout.CENTER);
        $JPanel0.add(configureSigningButton, BorderLayout.EAST);
        addChildrenToSigningScrollPanel();
        // inline complete setup of $JPanel1
        $JPanel1.add(attachmentsLabel, BorderLayout.NORTH);
        $JPanel1.add(attachmentsContainer, BorderLayout.CENTER);
        $JPanel1.add(addAttachmentForm, BorderLayout.SOUTH);
        addChildrenToAttachmentsContainer();
        addChildrenToAddAttachmentForm();
        addChildrenToButtonPanel();
        // inline complete setup of $JPanel2
        $JPanel2.add(forwardButton);
        $JPanel2.add(closeButton);
        // inline complete setup of $JPanel3
        $JPanel3.add(cancelButton);
        $JPanel3.add(validateButton);
        
        // apply 35 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 26 property setters
        contactField.setBeanType(Contact.class);
        messageSplitPane.setOrientation(JSplitPane.VERTICAL_SPLIT);
        signingSplitPane.setOrientation(JSplitPane.VERTICAL_SPLIT);
        stampComboBox.setBeanType(Stamp.class);
        contactField.setBean(model);
        addToButton.setIcon(SwingUtil.createActionIcon("add"));
        addCcButton.setIcon(SwingUtil.createActionIcon("add"));
        addCciButton.setIcon(SwingUtil.createActionIcon("add"));
        stampComboBox.setBean(model);
        configureSigningButton.setIcon(SwingUtil.createActionIcon("settings"));
        attachmentsPanel.setBackground( Color.WHITE );
        chooseFileButton.setIcon(SwingUtil.createActionIcon("open"));
        addAttachmentButton.setIcon(SwingUtil.createActionIcon("add"));
        forwardButton.setIcon(SwingUtil.createActionIcon("transmit"));
        closeButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        validateButton.setIcon(SwingUtil.createActionIcon("reply"));
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("replyPanel", replyPanel);
        createModel();
        createValidator();
        createFromPanelLayout();
        createButtonPanelLayout();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createFromLabel();
        createFromPanel();
        createFromField();
        createFromComboBox();
        createContactLabel();
        createContactField();
        createAddToButton();
        createAddCcButton();
        createAddCciButton();
        createToLabel();
        createToField();
        createCcLabel();
        createCcField();
        createCciLabel();
        createCciField();
        createSubjectLabel();
        createSubjectField();
        createMessageSplitPane();
        createSigningSplitPane();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createMessage();
        createSigningPanel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createSigningLabel();
        createStampComboBox();
        createConfigureSigningButton();
        createSigningScrollPanel();
        createSigningTextPanel();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        createAttachmentsLabel();
        createAttachmentsContainer();
        createAttachmentsPanel();
        createAddAttachmentForm();
        createAddAttachmentLabel();
        createAddAttachmentFile();
        createChooseFileButton();
        createAddAttachmentButton();
        createButtonPanel();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1, 0));
        createForwardButton();
        createCloseButton();
        // inline creation of $JPanel3
        $objectMap.put("$JPanel3", $JPanel3 = new JPanel());
        
        $JPanel3.setName("$JPanel3");
        $JPanel3.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createValidateButton();
        // inline creation of replyPanel
        setName("replyPanel");
        setLayout(new BorderLayout());
        
        // registers 35 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 35 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FROM_PANEL_LAYOUT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("readonly", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fromPanelLayout.setSelected( String.valueOf(model.isReadonly()) );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("readonly", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BUTTON_PANEL_LAYOUT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("readonly", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    buttonPanelLayout.setSelected( String.valueOf(model.isReadonly()) );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("readonly", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FROM_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("from", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(fromField,  model.getFrom() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("from", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FROM_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("from", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fromComboBox.setSelectedItem( model.getFrom() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("from", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CONTACT_LABEL_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("readonly", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    contactLabel.setVisible( !model.isReadonly() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("readonly", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CONTACT_FIELD_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("readonly", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    contactField.setVisible( !model.isReadonly() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("readonly", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CONTACT_FIELD_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("contact", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    contactField.setSelectedItem( model.getContact() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("contact", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_TO_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("contact", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    addToButton.setEnabled( model.getContact() != null );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("contact", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_TO_BUTTON_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("readonly", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    addToButton.setVisible( !model.isReadonly() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("readonly", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_CC_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("contact", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    addCcButton.setEnabled( model.getContact() != null );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("contact", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_CC_BUTTON_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("readonly", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    addCcButton.setVisible( !model.isReadonly() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("readonly", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_CCI_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("contact", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    addCciButton.setEnabled( model.getContact() != null );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("contact", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_CCI_BUTTON_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("readonly", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    addCciButton.setVisible( !model.isReadonly() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("readonly", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TO_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("to", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(toField,  model.getTo() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("to", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TO_FIELD_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("readonly", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    toField.setEditable( !model.isReadonly() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("readonly", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CC_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("cc", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(ccField,  model.getCc() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("cc", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CC_FIELD_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("readonly", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    ccField.setEditable( !model.isReadonly() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("readonly", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CCI_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("cci", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(cciField,  model.getCci() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("cci", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CCI_FIELD_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("readonly", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    cciField.setEditable( !model.isReadonly() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("readonly", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SUBJECT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("subject", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(subjectField,  model.getSubject() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("subject", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SUBJECT_FIELD_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("readonly", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    subjectField.setEditable( !model.isReadonly() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("readonly", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SIGNING_SPLIT_PANE_NAME, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("readonly", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    signingSplitPane.setName( "signingSplitPane" + model.isReadonly() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("readonly", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SIGNING_SPLIT_PANE_DIVIDER_SIZE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("readonly", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    signingSplitPane.setDividerSize( model.isReadonly() ? 0 : 10 );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("readonly", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MESSAGE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("message", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(message,  model.getMessage() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("message", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MESSAGE_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("readonly", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    message.setEditable( !model.isReadonly() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("readonly", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SIGNING_PANEL_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("readonly", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    signingPanel.setVisible( !model.isReadonly() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("readonly", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STAMP_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("stamp", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    stampComboBox.setSelectedItem( model.getStamp() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("stamp", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SIGNING_SCROLL_PANEL_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("stamp", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    signingScrollPanel.setVisible( model.getStamp() != null );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("stamp", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SIGNING_TEXT_PANEL_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("stamp", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getStamp() != null) {
                    SwingUtil.setText(signingTextPanel,  model.getStamp().getText() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("stamp", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ATTACHMENTS_LABEL_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("totalAttachmentLength", this);
                }
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("maxAttachmentLength", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel() != null) {
                    attachmentsLabel.setText(t( t("faxtomail.reply.attachments.title",
                                getModel().getTotalAttachmentLength(),
                                getModel().getMaxAttachmentLength()) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("totalAttachmentLength", this);
                }
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("maxAttachmentLength", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ATTACHMENTS_LABEL_FOREGROUND, true) {
        
            @Override
            public void applyDataBinding() {
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("totalAttachmentLength", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel() != null) {
                    attachmentsLabel.setForeground( getModel().isAttachmentSizeValid(getModel().getTotalAttachmentLength()) ? Color.BLACK : Color.RED );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("totalAttachmentLength", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_ATTACHMENT_FORM_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("readonly", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    addAttachmentForm.setVisible( !model.isReadonly() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("readonly", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_ATTACHMENT_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (addAttachmentFile != null) {
                    $bindingSources.put("addAttachmentFile", addAttachmentFile);
                    addAttachmentFile.addItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u0"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (addAttachmentFile != null) {
                    addAttachmentButton.setEnabled( addAttachmentFile.getSelectedItem() != null );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (addAttachmentFile != null) {
                    JComboBox $target = (JComboBox) $bindingSources.remove("addAttachmentFile");
                    if ($target != null) {
                        $target.removeItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u0"));
                    }
                }
            }
        
            public void $pr$u0(ItemEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FORWARD_BUTTON_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("editable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel() != null) {
                    forwardButton.setVisible( getModel().isEditable() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("editable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VALIDATE_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("valid", this);
                }
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("totalAttachmentLength", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel() != null) {
                    validateButton.setEnabled( getModel().isValid() && getModel().isAttachmentSizeValid(getModel().getTotalAttachmentLength()) );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("valid", this);
                }
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("totalAttachmentLength", this);
                }
            }
        });
    }

}