/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.annotation;

import java.io.IOException;
import java.util.Calendar;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDTextStream;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationPopup;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDExternalDataDictionary;

public class PDAnnotationMarkup
extends PDAnnotation {
    public static final String SUB_TYPE_FREETEXT = "FreeText";
    public static final String SUB_TYPE_POLYGON = "Polygon";
    public static final String SUB_TYPE_POLYLINE = "PolyLine";
    public static final String SUB_TYPE_CARET = "Caret";
    public static final String SUB_TYPE_INK = "Ink";
    public static final String SUB_TYPE_SOUND = "Sound";
    public static final String RT_REPLY = "R";
    public static final String RT_GROUP = "Group";

    public PDAnnotationMarkup() {
    }

    public PDAnnotationMarkup(COSDictionary dict) {
        super(dict);
    }

    public String getTitlePopup() {
        return this.getCOSObject().getString("T");
    }

    public void setTitlePopup(String t) {
        this.getCOSObject().setString("T", t);
    }

    public PDAnnotationPopup getPopup() {
        COSDictionary popup = (COSDictionary)this.getCOSObject().getDictionaryObject("Popup");
        if (popup != null) {
            return new PDAnnotationPopup(popup);
        }
        return null;
    }

    public void setPopup(PDAnnotationPopup popup) {
        this.getCOSObject().setItem("Popup", (COSObjectable)popup);
    }

    public float getConstantOpacity() {
        return this.getCOSObject().getFloat("CA", 1.0f);
    }

    public void setConstantOpacity(float ca) {
        this.getCOSObject().setFloat("CA", ca);
    }

    public PDTextStream getRichContents() {
        COSBase rc = this.getCOSObject().getDictionaryObject("RC");
        if (rc != null) {
            return PDTextStream.createTextStream(rc);
        }
        return null;
    }

    public void setRichContents(PDTextStream rc) {
        this.getCOSObject().setItem("RC", (COSObjectable)rc);
    }

    public Calendar getCreationDate() throws IOException {
        return this.getCOSObject().getDate("CreationDate");
    }

    public void setCreationDate(Calendar creationDate) {
        this.getCOSObject().setDate("CreationDate", creationDate);
    }

    public PDAnnotation getInReplyTo() throws IOException {
        COSBase irt = this.getCOSObject().getDictionaryObject("IRT");
        return PDAnnotation.createAnnotation(irt);
    }

    public void setInReplyTo(PDAnnotation irt) {
        this.getCOSObject().setItem("IRT", (COSObjectable)irt);
    }

    public String getSubject() {
        return this.getCOSObject().getString("Subj");
    }

    public void setSubject(String subj) {
        this.getCOSObject().setString("Subj", subj);
    }

    public String getReplyType() {
        return this.getCOSObject().getNameAsString("RT", RT_REPLY);
    }

    public void setReplyType(String rt) {
        this.getCOSObject().setName("RT", rt);
    }

    public String getIntent() {
        return this.getCOSObject().getNameAsString("IT");
    }

    public void setIntent(String it) {
        this.getCOSObject().setName("IT", it);
    }

    public PDExternalDataDictionary getExternalData() {
        COSBase exData = this.getCOSObject().getDictionaryObject("ExData");
        if (exData instanceof COSDictionary) {
            return new PDExternalDataDictionary((COSDictionary)exData);
        }
        return null;
    }

    public void setExternalData(PDExternalDataDictionary externalData) {
        this.getCOSObject().setItem("ExData", (COSObjectable)externalData);
    }
}

