/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc4;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.sql.SQLXML;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.postgresql.core.BaseConnection;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class Jdbc4SQLXML
implements SQLXML {
    private final BaseConnection _conn;
    private String _data;
    private boolean _initialized;
    private boolean _active;
    private boolean _freed;
    private ByteArrayOutputStream _byteArrayOutputStream;
    private StringWriter _stringWriter;
    private DOMResult _domResult;

    public Jdbc4SQLXML(BaseConnection conn) {
        this(conn, null, false);
    }

    public Jdbc4SQLXML(BaseConnection conn, String data) {
        this(conn, data, true);
    }

    private Jdbc4SQLXML(BaseConnection conn, String data, boolean initialized) {
        this._conn = conn;
        this._data = data;
        this._initialized = initialized;
        this._active = false;
        this._freed = false;
    }

    @Override
    public synchronized void free() {
        this._freed = true;
        this._data = null;
    }

    @Override
    public synchronized InputStream getBinaryStream() throws SQLException {
        this.checkFreed();
        this.ensureInitialized();
        if (this._data == null) {
            return null;
        }
        try {
            return new ByteArrayInputStream(this._conn.getEncoding().encode(this._data));
        }
        catch (IOException ioe) {
            throw new PSQLException("Failed to re-encode xml data.", PSQLState.DATA_ERROR, (Throwable)ioe);
        }
    }

    @Override
    public synchronized Reader getCharacterStream() throws SQLException {
        this.checkFreed();
        this.ensureInitialized();
        if (this._data == null) {
            return null;
        }
        return new StringReader(this._data);
    }

    public synchronized Source getSource(Class sourceClass) throws SQLException {
        this.checkFreed();
        this.ensureInitialized();
        if (this._data == null) {
            return null;
        }
        try {
            if (sourceClass == null || DOMSource.class.equals((Object)sourceClass)) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                builder.setErrorHandler(new NonPrintingErrorHandler());
                InputSource input = new InputSource(new StringReader(this._data));
                return new DOMSource(builder.parse(input));
            }
            if (SAXSource.class.equals((Object)sourceClass)) {
                InputSource is = new InputSource(new StringReader(this._data));
                return new SAXSource(is);
            }
            if (StreamSource.class.equals((Object)sourceClass)) {
                return new StreamSource(new StringReader(this._data));
            }
            if (StAXSource.class.equals((Object)sourceClass)) {
                XMLInputFactory xif = XMLInputFactory.newInstance();
                XMLStreamReader xsr = xif.createXMLStreamReader(new StringReader(this._data));
                return new StAXSource(xsr);
            }
        }
        catch (Exception e) {
            throw new PSQLException(GT.tr("Unable to decode xml data."), PSQLState.DATA_ERROR, (Throwable)e);
        }
        throw new PSQLException(GT.tr("Unknown XML Source class: {0}", sourceClass), PSQLState.INVALID_PARAMETER_TYPE);
    }

    @Override
    public synchronized String getString() throws SQLException {
        this.checkFreed();
        this.ensureInitialized();
        return this._data;
    }

    @Override
    public synchronized OutputStream setBinaryStream() throws SQLException {
        this.checkFreed();
        this.initialize();
        this._active = true;
        this._byteArrayOutputStream = new ByteArrayOutputStream();
        return this._byteArrayOutputStream;
    }

    @Override
    public synchronized Writer setCharacterStream() throws SQLException {
        this.checkFreed();
        this.initialize();
        this._stringWriter = new StringWriter();
        return this._stringWriter;
    }

    public synchronized Result setResult(Class resultClass) throws SQLException {
        this.checkFreed();
        this.initialize();
        if (resultClass == null || DOMResult.class.equals((Object)resultClass)) {
            this._domResult = new DOMResult();
            this._active = true;
            return this._domResult;
        }
        if (SAXResult.class.equals((Object)resultClass)) {
            try {
                SAXTransformerFactory transformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
                TransformerHandler transformerHandler = transformerFactory.newTransformerHandler();
                this._stringWriter = new StringWriter();
                transformerHandler.setResult(new StreamResult(this._stringWriter));
                this._active = true;
                return new SAXResult(transformerHandler);
            }
            catch (TransformerException te) {
                throw new PSQLException(GT.tr("Unable to create SAXResult for SQLXML."), PSQLState.UNEXPECTED_ERROR, (Throwable)te);
            }
        }
        if (StreamResult.class.equals((Object)resultClass)) {
            this._stringWriter = new StringWriter();
            this._active = true;
            return new StreamResult(this._stringWriter);
        }
        if (StAXResult.class.equals((Object)resultClass)) {
            this._stringWriter = new StringWriter();
            try {
                XMLOutputFactory xof = XMLOutputFactory.newInstance();
                XMLStreamWriter xsw = xof.createXMLStreamWriter(this._stringWriter);
                this._active = true;
                return new StAXResult(xsw);
            }
            catch (XMLStreamException xse) {
                throw new PSQLException(GT.tr("Unable to create StAXResult for SQLXML"), PSQLState.UNEXPECTED_ERROR, (Throwable)xse);
            }
        }
        throw new PSQLException(GT.tr("Unknown XML Result class: {0}", resultClass), PSQLState.INVALID_PARAMETER_TYPE);
    }

    @Override
    public synchronized void setString(String value) throws SQLException {
        this.checkFreed();
        this.initialize();
        this._data = value;
    }

    private void checkFreed() throws SQLException {
        if (this._freed) {
            throw new PSQLException(GT.tr("This SQLXML object has already been freed."), PSQLState.OBJECT_NOT_IN_STATE);
        }
    }

    private void ensureInitialized() throws SQLException {
        if (!this._initialized) {
            throw new PSQLException(GT.tr("This SQLXML object has not been initialized, so you cannot retrieve data from it."), PSQLState.OBJECT_NOT_IN_STATE);
        }
        if (!this._active) {
            return;
        }
        if (this._byteArrayOutputStream != null) {
            try {
                this._data = this._conn.getEncoding().decode(this._byteArrayOutputStream.toByteArray());
            }
            catch (IOException ioe) {
                throw new PSQLException(GT.tr("Failed to convert binary xml data to encoding: {0}.", this._conn.getEncoding().name()), PSQLState.DATA_ERROR, (Throwable)ioe);
            }
            finally {
                this._byteArrayOutputStream = null;
                this._active = false;
            }
        }
        if (this._stringWriter != null) {
            this._data = this._stringWriter.toString();
            this._stringWriter = null;
            this._active = false;
        } else if (this._domResult != null) {
            try {
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer transformer = factory.newTransformer();
                DOMSource domSource = new DOMSource(this._domResult.getNode());
                StringWriter stringWriter = new StringWriter();
                StreamResult streamResult = new StreamResult(stringWriter);
                transformer.transform(domSource, streamResult);
                this._data = stringWriter.toString();
            }
            catch (TransformerException te) {
                throw new PSQLException(GT.tr("Unable to convert DOMResult SQLXML data to a string."), PSQLState.DATA_ERROR, (Throwable)te);
            }
            finally {
                this._domResult = null;
                this._active = false;
            }
        }
    }

    private void initialize() throws SQLException {
        if (this._initialized) {
            throw new PSQLException(GT.tr("This SQLXML object has already been initialized, so you cannot manipulate it further."), PSQLState.OBJECT_NOT_IN_STATE);
        }
        this._initialized = true;
    }

    static class NonPrintingErrorHandler
    implements ErrorHandler {
        NonPrintingErrorHandler() {
        }

        @Override
        public void error(SAXParseException e) {
        }

        @Override
        public void fatalError(SAXParseException e) {
        }

        @Override
        public void warning(SAXParseException e) {
        }
    }
}

