/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.renderer;

import java.awt.Component;
import java.util.EnumSet;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class EnumTableCellRenderer<E extends Enum<E>>
implements TableCellRenderer {
    private TableCellRenderer delegate;
    private EnumSet<E> enumValues;

    public EnumTableCellRenderer(TableCellRenderer delegate, Class<E> enumClass) {
        this.delegate = delegate;
        this.enumValues = EnumSet.allOf(enumClass);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value != null) {
            Integer ordinal = Integer.valueOf(value + "");
            if (ordinal == -1) {
                value = null;
            } else {
                for (Enum enumValue : this.enumValues) {
                    if (ordinal.intValue() != enumValue.ordinal()) continue;
                    value = enumValue;
                    break;
                }
            }
        }
        return this.delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }
}

